/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.weblogic;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.weblogic.GenericClassLoaderCBP;

public class GenericClassLoaderCBP
extends JavassistClassBytecodeProcessor {
    private static final boolean INCLUDE_SPECIAL = ConfigurationFactory.getInstance().getBoolean("rebel.weblogic_classloader_special");
    static Class class$org$zeroturnaround$javarebel$ClassResourceSource;
    static Class class$java$lang$String;
    static Class class$java$util$jar$Manifest;
    static Class class$java$net$URL;
    static Class class$org$zeroturnaround$javarebel$ClassBytecodeProcessor;
    static Class class$org$zeroturnaround$javarebel$integration$util$WeakUtil;
    static Class class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor;

    public GenericClassLoaderCBP() {
    }

    private boolean isSpecialConstructor(CtConstructor ctConstructor) {
        if (INCLUDE_SPECIAL) {
            return false;
        }
        try {
            return a.arrayLength((Object[])ctConstructor.getParameterTypes()) == 1 && ((CtClass)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructor.getParameterTypes(), (int)0), CtClass.class))).getName().equals("java.lang.ClassLoader");
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("java.util");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.util");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.weblogic");
        classPool.importPackage("weblogic.utils.classloaders");
        ctClass.addField(CtField.make("private static final Logger jrLogger = LoggerFactory.getLogger(\"Weblogic\");", ctClass));
        ctClass.addField(CtField.make("private static final Integration integration = IntegrationFactory.getInstance();", ctClass));
        if (INCLUDE_SPECIAL) {
            LoggerFactory.getLogger("WebLogic").debug("Patching special constructors is enabled: rebel.weblogic_classloader_special=true");
        }
        ctClass.addInterface(classPool.get(x.getName((Class)(class$org$zeroturnaround$javarebel$ClassResourceSource == null ? (class$org$zeroturnaround$javarebel$ClassResourceSource = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.ClassResourceSource")) : class$org$zeroturnaround$javarebel$ClassResourceSource))));
        CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
        for (int i = 0; i < a.arrayLength((Object[])ctConstructorArray); ++i) {
            if (this.isSpecialConstructor((CtConstructor)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructorArray, (int)i), CtConstructor.class))) || !((CtConstructor)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructorArray, (int)i), CtConstructor.class))).callsSuper()) continue;
            ((CtConstructor)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructorArray, (int)i), CtConstructor.class))).insertAfter("if (!getClass().getName().startsWith(\"weblogic.servlet.jsp\"))  integration.registerClassLoader(this, this);");
        }
        this.processFinding(classPool, ctClass);
        this.processUpdating(ctClass);
        this.processInstrumentation(classPool, ctClass);
        this.processClasspath(classPool, ctClass);
        if (ConfigurationFactory.getInstance().getBoolean("rebel.enable_test_hacks")) {
            CtMethod ctMethod;
            try {
                ctMethod = ctClass.getDeclaredMethod("definePackage", classPool.get(new String[]{x.getName((Class)(class$java$lang$String == null ? (class$java$lang$String = GenericClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String)), x.getName((Class)(class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = GenericClassLoaderCBP.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest)), x.getName((Class)(class$java$net$URL == null ? (class$java$net$URL = GenericClassLoaderCBP.class$("java.net.URL")) : class$java$net$URL))}));
            }
            catch (NotFoundException notFoundException) {
                return;
            }
            CtMethod ctMethod2 = CtNewMethod.copy(ctMethod, "__definePackage", ctClass, null);
            ctClass.addMethod(ctMethod2);
            ctMethod.setBody("{  try {    __definePackage($1, $2, $3);  }  catch (IllegalArgumentException e) {    int i = $1.lastIndexOf('.');    if (i >= 0) {      if (getPackage($1.substring(0, i)) == null) {        throw e;      }    }  }}");
        }
    }

    private void processFinding(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        ctClass.getMethod("findLocalClass", "(Ljava/lang/String;)Ljava/lang/Class;").insertBefore("Class result = findLoadedClass($1);if (result != null)  return result;try {  result = integration.findReloadableClass($0, $1);  if (result != null)    return result;}catch (LinkageError e) {  result = findLoadedClass($1);  if (result != null)    return result;  throw e;}");
        try {
            ctClass.getDeclaredMethod("findResource", classPool.get(new String[]{x.getName((Class)(class$java$lang$String == null ? (class$java$lang$String = GenericClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String))})).insertBefore("{  if (integration.isResourceReplaced($0, $1)) {    return integration.findResource($0, $1);  }}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("findResources", classPool.get(new String[]{x.getName((Class)(class$java$lang$String == null ? (class$java$lang$String = GenericClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String))})).insertBefore("{  if (integration.isResourceReplaced($0, $1))    return integration.findResources($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ctClass.addMethod(CtNewMethod.make("public Resource getClassResource(String className) {  Source src = this.finder.getSource(className.replace('.','/') +\".class\");  if (src == null) {    return null;  }  if (src instanceof ByteArraySource) {    return new WebLogicBytecodeResource(src, className);   }  Resource resource = ResourceUtil.asResource(src.getURL());  if (resource != null && \".class\".equals(resource.toURL().getFile())) {    return null;  }  return resource;}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource getLocalResource(String name) {  return ResourceUtil.asResource(findResource(name));}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource[] getLocalResources(String name) {  return ResourceUtil.asResources(findResources(name));}", ctClass));
    }

    private void processUpdating(CtClass ctClass) throws CannotCompileException, NotFoundException {
        ctClass.addField(CtField.make("private final Set jrFinders = new HashSet();", ctClass));
        try {
            ctClass.getDeclaredMethod("addClassFinder").insertAfter("{   jrLogger.info(\"Add class finder '{}' to '{}'\", MiscUtil.identityToString($1), MiscUtil.identityToString($0));  if (jrFinders.add($1)) {    integration.reinitializeClassLoader($0);  }}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("addClassFinderFirst").insertAfter("{   jrLogger.info(\"Add first class finder '{}' to '{}'\", MiscUtil.identityToString($1), MiscUtil.identityToString($0));  if (jrFinders.add($1)) {    integration.reinitializeClassLoader($0);  }}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("close").insertAfter("{   integration.unregisterClassLoader($0);  jrFinders.clear();}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processInstrumentation(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        try {
            ctClass.getDeclaredMethod("doPreProcess");
            ctClass.addInterface(classPool.get(x.getName((Class)(class$org$zeroturnaround$javarebel$ClassBytecodeProcessor == null ? (class$org$zeroturnaround$javarebel$ClassBytecodeProcessor = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.ClassBytecodeProcessor")) : class$org$zeroturnaround$javarebel$ClassBytecodeProcessor))));
            CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
            for (int i = 0; i < a.arrayLength((Object[])ctConstructorArray); ++i) {
                if (this.isSpecialConstructor((CtConstructor)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructorArray, (int)i), CtConstructor.class))) || !((CtConstructor)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructorArray, (int)i), CtConstructor.class))).callsSuper()) continue;
                ((CtConstructor)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctConstructorArray, (int)i), CtConstructor.class))).insertAfter(new StringBuffer().append("integration.addIntegrationProcessor($0, ").append(x.getName((Class)(class$org$zeroturnaround$javarebel$integration$util$WeakUtil == null ? GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.integration.util.WeakUtil") : class$org$zeroturnaround$javarebel$integration$util$WeakUtil))).append(".weakCBP($0), true);").append("").toString());
            }
            CtMethod ctMethod = ctClass.getDeclaredMethod("findClass");
            ctMethod.insertBefore(new StringBuffer().append("{").append(x.getName((Class)(class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor == null ? (class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.util.ClassLoaderBytecodeProcessorMonitor")) : class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor))).append(".exit(this, $1);").append("}").toString());
            ctMethod = ctClass.getDeclaredMethod("defineClass");
            ctMethod.instrument((ExprEditor)new 1(this));
            ctMethod.insertAfter(new StringBuffer().append("").append(x.getName((Class)(class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor == null ? (class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.util.ClassLoaderBytecodeProcessorMonitor")) : class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor))).append(".exit(this, $1);").append("").toString(), true);
            ctClass.addMethod(CtNewMethod.make(new StringBuffer().append("public byte[] process(ClassLoader cl, String classname, byte[] bytecode) {  if (").append(x.getName((Class)(class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor == null ? (class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.util.ClassLoaderBytecodeProcessorMonitor")) : class$org$zeroturnaround$javarebel$util$ClassLoaderBytecodeProcessorMonitor))).append(".isActive(cl, classname)) {").append("    return bytecode;").append("  }").append("  return doPreProcess(bytecode, classname.replace('/', '.'));").append("}").toString(), ctClass));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processClasspath(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        CtMethod ctMethod;
        classPool.importPackage("java.net");
        try {
            ctMethod = ctClass.getDeclaredMethod("getFinderClassPath");
            this.processClasspathMethod(ctMethod);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctMethod = ctClass.getDeclaredMethod("getClassPath");
            if (!this.callsMethod(ctMethod, "getFinderClassPath")) {
                this.processClasspathMethod(ctMethod);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processClasspathMethod(CtMethod ctMethod) throws CannotCompileException {
        ctMethod.insertAfter("{   try {    URL[] urls = integration.getRebelURLs($0, false);    if (urls != null) {      $_ = ResourceUtil.concatClassPath(ResourceUtil.toClassPath(urls), $_);    }  } catch (Throwable t) {    jrLogger.error(\"\", t);  }}");
    }

    private boolean callsMethod(CtMethod ctMethod, String string) throws CannotCompileException {
        boolean[] blArray = new boolean[]{false};
        ctMethod.instrument((ExprEditor)new 2(this, string, blArray));
        return blArray[0];
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoClassDefFoundError().initCause(classNotFoundException));
        }
    }

    protected /* synthetic */ GenericClassLoaderCBP(h h2) {
        super(h2);
    }
}

