/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.zeroturnaround.javarebel.RebelServletContext;

public abstract class ResourceUtils
extends h {
    private static final String FILE_UNC_PREFIX = "\\\\";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    private static final String URL_PROTOCOL_VFS = "vfs";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    private static final String URL_PROTOCOL_JAR = "jar";
    private static final String URL_PROTOCOL_ZIP = "zip";
    private static final String URL_PROTOCOL_JNDI = "jndi";
    private static final String URL_PROTOCOL_WSJAR = "wsjar";
    private static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    private static final String JAR_URL_SEPARATOR = "!/";

    public ResourceUtils() {
    }

    public static boolean isUrl(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static File getFile(URL uRL, RebelServletContext rebelServletContext) {
        if (uRL == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Resource URL must not be null"));
        }
        String string = uRL.getProtocol();
        if (URL_PROTOCOL_JNDI.equals(string)) {
            try {
                String string2 = rebelServletContext.getRealPath(uRL.getFile().replaceFirst(rebelServletContext.getResource("/").getFile(), "/"));
                if (string2 == null) {
                    return null;
                }
                return new File(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(malformedURLException));
            }
        }
        return ResourceUtils.getFile(uRL);
    }

    public static File getFile(URL uRL) {
        return ResourceUtils.getFile(uRL, "URL");
    }

    public static File[] getFiles(URL[] uRLArray) {
        if (uRLArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Resource URLs must not be null"));
        }
        ArrayList<File> arrayList = new ArrayList<File>(uRLArray.length);
        for (URL uRL : uRLArray) {
            arrayList.add(ResourceUtils.getFile(uRL));
        }
        return (File[])g.convertForCast((Object)arrayList.toArray(new File[arrayList.size()]), File[].class);
    }

    public static File getFile(URL uRL, String string) {
        if (uRL == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Resource URL must not be null"));
        }
        return ResourceUtils.normalizeUNCLocalPath(new File(ResourceUtils.getSchemeSpecificPart(uRL)));
    }

    private static File normalizeUNCLocalPath(File file) {
        String string;
        int n2;
        int n3;
        String string2 = file.getPath();
        if (string2.startsWith(FILE_UNC_PREFIX) && (n3 = string2.indexOf(92, n2 = FILE_UNC_PREFIX.length())) != -1 && ResourceUtils.isProbablyLocalhost(string = string2.substring(n2, n3))) {
            string2 = string2.substring(n3);
            return new File(string2);
        }
        return file;
    }

    private static boolean isProbablyLocalhost(String string) {
        if ("localhost".equals(string)) {
            return true;
        }
        return string.startsWith("127.0.0.");
    }

    private static String getSchemeSpecificPart(URL uRL) {
        try {
            return ResourceUtils.toURI(uRL).getSchemeSpecificPart();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.getFile();
        }
    }

    public static boolean isFileURL(URL uRL) {
        if (uRL == null) {
            return false;
        }
        String string = uRL.getProtocol();
        return URL_PROTOCOL_FILE.equals(string) || URL_PROTOCOL_VFSFILE.equals(string) && ResourceUtils.getFile(uRL).exists() || URL_PROTOCOL_VFS.equals(string) && ResourceUtils.getFile(uRL).exists();
    }

    public static boolean isJarURL(URL uRL) {
        if (uRL == null) {
            return false;
        }
        String string = uRL.getProtocol();
        return URL_PROTOCOL_JAR.equals(string) || URL_PROTOCOL_ZIP.equals(string) || URL_PROTOCOL_WSJAR.equals(string) || URL_PROTOCOL_CODE_SOURCE.equals(string) && uRL.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }

    public static boolean isVirtualJarURL(URL uRL) {
        if (uRL == null) {
            return false;
        }
        String string = uRL.getProtocol();
        return URL_PROTOCOL_VFSZIP.equals(string);
    }

    public static boolean isNestedJarEntry(String string) {
        return string != null && string.contains(JAR_URL_SEPARATOR);
    }

    public static URL extractJarFileURL(URL uRL) {
        if (uRL == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("JAR URL must not be null"));
        }
        String string = uRL.getFile();
        int n2 = string.indexOf(JAR_URL_SEPARATOR);
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            String string3 = uRL.getProtocol();
            if (!string2.startsWith(FILE_URL_PREFIX) && (URL_PROTOCOL_ZIP.equals(string3) || URL_PROTOCOL_CODE_SOURCE.equals(string3))) {
                try {
                    return new URL("file://" + string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(malformedURLException));
                }
            }
            try {
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                try {
                    return new URL(FILE_URL_PREFIX + string2);
                }
                catch (MalformedURLException malformedURLException2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(malformedURLException2));
                }
            }
        }
        return uRL;
    }

    public static String extractJarEntryPath(URL uRL) {
        if (uRL == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("JAR URL must not be null"));
        }
        String string = ResourceUtils.getSchemeSpecificPart(uRL);
        int n2 = string.indexOf(JAR_URL_SEPARATOR);
        if (n2 != -1) {
            return string.substring(n2 + JAR_URL_SEPARATOR.length());
        }
        return null;
    }

    public static URI toURI(URL uRL) throws URISyntaxException {
        if (uRL == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("URL must not be null"));
        }
        return ResourceUtils.toURI(uRL.toString());
    }

    public static URI toURI(String string) throws URISyntaxException {
        return new URI(ResourceUtils.replace(string, " ", "%20"));
    }

    private static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string3 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        int n4 = string2.length();
        while (n3 >= 0) {
            stringBuilder.append(string.substring(n2, n3));
            stringBuilder.append(string3);
            n2 = n3 + n4;
            n3 = string.indexOf(string2, n2);
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    protected /* synthetic */ ResourceUtils(h h2) {
        super(h2);
    }
}

