/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import sun.invoke.util.Wrapper;

public class ValueConversions {
    private static final Class<?> THIS_CLASS;
    private static final int MAX_ARITY;
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final EnumMap<Wrapper, MethodHandle>[] UNBOX_CONVERSIONS;
    private static final Integer ZERO_INT;
    private static final Integer ONE_INT;
    private static final EnumMap<Wrapper, MethodHandle>[] BOX_CONVERSIONS;
    private static final EnumMap<Wrapper, MethodHandle>[] CONSTANT_FUNCTIONS;
    private static final MethodHandle IDENTITY;
    private static final MethodHandle CAST_REFERENCE;
    private static final MethodHandle ZERO_OBJECT;
    private static final MethodHandle IGNORE;
    private static final MethodHandle EMPTY;
    private static final MethodHandle ARRAY_IDENTITY;
    private static final MethodHandle FILL_NEW_TYPED_ARRAY;
    private static final MethodHandle FILL_NEW_ARRAY;
    private static final MethodHandle COLLECT_ARGUMENTS;
    private static final EnumMap<Wrapper, MethodHandle>[] WRAPPER_CASTS;
    private static final EnumMap<Wrapper, MethodHandle>[] CONVERT_PRIMITIVE_FUNCTIONS;
    private static final Object[] NO_ARGS_ARRAY;
    private static final MethodHandle[] ARRAYS;
    private static final MethodHandle[] FILL_ARRAYS;
    private static final int LEFT_ARGS;
    private static final MethodHandle[] FILL_ARRAY_TO_RIGHT;
    private static final ClassValue<MethodHandle[]> TYPED_COLLECTORS;
    static final int MAX_JVM_ARITY = 255;
    private static final List<Object> NO_ARGS_LIST;
    private static final MethodHandle[] LISTS;

    public ValueConversions() {
    }

    private static EnumMap<Wrapper, MethodHandle>[] newWrapperCaches(int n2) {
        EnumMap[] enumMapArray = (EnumMap[])g.convertForCast((Object)new EnumMap[n2], EnumMap[].class);
        for (int i = 0; i < n2; ++i) {
            enumMapArray[i] = new EnumMap(Wrapper.class);
        }
        return enumMapArray;
    }

    static int unboxInteger(Object object, boolean bl) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.INT, object, bl).intValue();
    }

    static byte unboxByte(Object object, boolean bl) {
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.BYTE, object, bl).byteValue();
    }

    static short unboxShort(Object object, boolean bl) {
        if (g.convertForInstanceOf((Object)object, Short.class) instanceof Short) {
            return (Short)g.convertForCast((Object)object, Short.class);
        }
        return ValueConversions.primitiveConversion(Wrapper.SHORT, object, bl).shortValue();
    }

    static boolean unboxBoolean(Object object, boolean bl) {
        if (g.convertForInstanceOf((Object)object, Boolean.class) instanceof Boolean) {
            return (Boolean)g.convertForCast((Object)object, Boolean.class);
        }
        return (ValueConversions.primitiveConversion(Wrapper.BOOLEAN, object, bl).intValue() & 1) != 0;
    }

    static char unboxCharacter(Object object, boolean bl) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return (char)ValueConversions.primitiveConversion(Wrapper.CHAR, object, bl).intValue();
    }

    static long unboxLong(Object object, boolean bl) {
        if (object instanceof Long) {
            return (Long)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.LONG, object, bl).longValue();
    }

    static float unboxFloat(Object object, boolean bl) {
        if (g.convertForInstanceOf((Object)object, Float.class) instanceof Float) {
            return ((Float)g.convertForCast((Object)object, Float.class)).floatValue();
        }
        return ValueConversions.primitiveConversion(Wrapper.FLOAT, object, bl).floatValue();
    }

    static double unboxDouble(Object object, boolean bl) {
        if (object instanceof Double) {
            return (Double)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.DOUBLE, object, bl).doubleValue();
    }

    private static MethodType unboxType(Wrapper wrapper) {
        return MethodType.methodType(wrapper.primitiveType(), Object.class, Boolean.TYPE);
    }

    private static MethodHandle unbox(Wrapper wrapper, boolean bl) {
        EnumMap<Wrapper, MethodHandle> enumMap = UNBOX_CONVERSIONS[bl ? 1 : 0];
        MethodHandle methodHandle = (MethodHandle)((Object)g.convertForCast((Object)((Object)enumMap.get((Object)wrapper)), MethodHandle.class));
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                methodHandle = IGNORE;
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "unbox" + wrapper.wrapperSimpleName();
        MethodType methodType = ValueConversions.unboxType(wrapper);
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle != null) {
            methodHandle = MethodHandles.insertArguments(methodHandle, 1, bl);
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find unbox adapter for " + (Object)((Object)wrapper) + (bl ? " (cast)" : ""));
    }

    public static MethodHandle unboxCast(Wrapper wrapper) {
        return ValueConversions.unbox(wrapper, true);
    }

    public static MethodHandle unbox(Class<?> clazz) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), false);
    }

    public static MethodHandle unboxCast(Class<?> clazz) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), true);
    }

    public static Number primitiveConversion(Wrapper wrapper, Object object, boolean bl) {
        if (object == null) {
            if (!bl) {
                return null;
            }
            return ZERO_INT;
        }
        Number number = g.convertForInstanceOf((Object)object, Number.class) instanceof Number ? (Number)((Number)g.convertForCast((Object)object, Number.class)) : (Number)(g.convertForInstanceOf((Object)object, Boolean.class) instanceof Boolean ? (Number)((Boolean)g.convertForCast((Object)object, Boolean.class) != false ? ONE_INT : ZERO_INT) : (Number)(object instanceof Character ? (Number)Integer.valueOf(((Character)object).charValue()) : (Number)((Number)g.convertForCast((Object)object, Number.class))));
        Wrapper wrapper2 = Wrapper.findWrapperType(object.getClass());
        if (wrapper2 == null || !bl && !wrapper.isConvertibleFrom(wrapper2)) {
            return (Number)g.convertForCast((Object)x.cast(wrapper.wrapperType(), (Object)object), Number.class);
        }
        return number;
    }

    public static int widenSubword(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (g.convertForInstanceOf((Object)object, Boolean.class) instanceof Boolean) {
            return ValueConversions.fromBoolean((Boolean)g.convertForCast((Object)object, Boolean.class));
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (g.convertForInstanceOf((Object)object, Short.class) instanceof Short) {
            return ((Short)g.convertForCast((Object)object, Short.class)).shortValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        return (Integer)object;
    }

    static Integer boxInteger(int n2) {
        return n2;
    }

    static Byte boxByte(byte by) {
        return by;
    }

    static Short boxShort(short s) {
        return s;
    }

    static Boolean boxBoolean(boolean bl) {
        return bl;
    }

    static Character boxCharacter(char c) {
        return Character.valueOf(c);
    }

    static Long boxLong(long l) {
        return l;
    }

    static Float boxFloat(float f2) {
        return Float.valueOf(f2);
    }

    static Double boxDouble(double d) {
        return d;
    }

    private static MethodType boxType(Wrapper wrapper) {
        Class<?> clazz = wrapper.wrapperType();
        return MethodType.methodType(clazz, wrapper.primitiveType());
    }

    private static MethodHandle box(Wrapper wrapper, boolean bl) {
        EnumMap<Wrapper, MethodHandle> enumMap = BOX_CONVERSIONS[bl ? 1 : 0];
        MethodHandle methodHandle = (MethodHandle)((Object)g.convertForCast((Object)((Object)enumMap.get((Object)wrapper)), MethodHandle.class));
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                methodHandle = ZERO_OBJECT;
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "box" + wrapper.wrapperSimpleName();
        MethodType methodType = ValueConversions.boxType(wrapper);
        if (bl) {
            try {
                methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                methodHandle = null;
            }
        } else {
            methodHandle = ValueConversions.box(wrapper, !bl).asType(methodType.erase());
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find box adapter for " + (Object)((Object)wrapper) + (bl ? " (exact)" : ""));
    }

    public static MethodHandle box(Class<?> clazz) {
        boolean bl = false;
        return ValueConversions.box(Wrapper.forPrimitiveType(clazz), bl);
    }

    public static MethodHandle box(Wrapper wrapper) {
        boolean bl = false;
        return ValueConversions.box(wrapper, bl);
    }

    static void ignore(Object object) {
    }

    static void empty() {
    }

    static Object zeroObject() {
        return null;
    }

    static int zeroInteger() {
        return 0;
    }

    static long zeroLong() {
        return 0L;
    }

    static float zeroFloat() {
        return 0.0f;
    }

    static double zeroDouble() {
        return 0.0;
    }

    public static MethodHandle zeroConstantFunction(Wrapper wrapper) {
        EnumMap<Wrapper, MethodHandle> enumMap = CONSTANT_FUNCTIONS[0];
        MethodHandle methodHandle = (MethodHandle)((Object)g.convertForCast((Object)((Object)enumMap.get((Object)wrapper)), MethodHandle.class));
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = MethodType.methodType(wrapper.primitiveType());
        switch (wrapper) {
            case VOID: {
                methodHandle = EMPTY;
                break;
            }
            case OBJECT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                try {
                    methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, "zero" + wrapper.wrapperSimpleName(), methodType);
                    break;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    methodHandle = null;
                }
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        if (wrapper.isSubwordOrInt() && wrapper != Wrapper.INT) {
            methodHandle = MethodHandles.explicitCastArguments(ValueConversions.zeroConstantFunction(Wrapper.INT), methodType);
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find zero constant for " + (Object)((Object)wrapper));
    }

    static <T> T identity(T t) {
        return t;
    }

    static <T> T[] identity(T[] TArray) {
        return TArray;
    }

    static int identity(int n2) {
        return n2;
    }

    static byte identity(byte by) {
        return by;
    }

    static short identity(short s) {
        return s;
    }

    static boolean identity(boolean bl) {
        return bl;
    }

    static char identity(char c) {
        return c;
    }

    static long identity(long l) {
        return l;
    }

    static float identity(float f2) {
        return f2;
    }

    static double identity(double d) {
        return d;
    }

    static <T, U> T castReference(Class<? extends T> clazz, U u) {
        if (u != null && !x.isInstance(clazz, u)) {
            throw ValueConversions.newClassCastException(clazz, u);
        }
        return (T)u;
    }

    private static ClassCastException newClassCastException(Class<?> clazz, Object object) {
        return new ClassCastException("Cannot cast " + object.getClass().getName() + " to " + clazz.getName());
    }

    static MethodHandle collectArguments(MethodHandle methodHandle, int n2, MethodHandle methodHandle2) {
        if (COLLECT_ARGUMENTS != null) {
            try {
                return COLLECT_ARGUMENTS.invokeExact(methodHandle, n2, methodHandle2);
            }
            catch (Throwable throwable) {
                if (g.convertForInstanceOf((Object)throwable, RuntimeException.class) instanceof RuntimeException) {
                    throw (RuntimeException)g.convertForCast((Object)throwable, RuntimeException.class);
                }
                if (g.convertForInstanceOf((Object)throwable, Error.class) instanceof Error) {
                    throw (Error)g.convertForCast((Object)throwable, Error.class);
                }
                throw new Error(throwable.getMessage(), throwable);
            }
        }
        methodHandle = MethodHandles.dropArguments(methodHandle, 1, methodHandle2.type().parameterList());
        methodHandle = MethodHandles.foldArguments(methodHandle, methodHandle2);
        return methodHandle;
    }

    public static MethodHandle cast(Class<?> clazz) {
        MethodHandle methodHandle;
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("cannot cast primitive type " + clazz);
        }
        Wrapper wrapper = null;
        EnumMap<Wrapper, MethodHandle> enumMap = null;
        if (Wrapper.isWrapperType(clazz) && (methodHandle = (MethodHandle)((Object)g.convertForCast((Object)((Object)(enumMap = WRAPPER_CASTS[0]).get((Object)(wrapper = Wrapper.forWrapperType(clazz)))), MethodHandle.class))) != null) {
            return methodHandle;
        }
        methodHandle = MethodHandles.insertArguments(CAST_REFERENCE, 0, clazz);
        if (enumMap != null) {
            enumMap.put(wrapper, methodHandle);
        }
        return methodHandle;
    }

    public static MethodHandle identity() {
        return IDENTITY;
    }

    public static MethodHandle identity(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return MethodHandles.identity(clazz);
        }
        return ValueConversions.identity(Wrapper.findPrimitiveType(clazz));
    }

    public static MethodHandle identity(Wrapper wrapper) {
        EnumMap<Wrapper, MethodHandle> enumMap = CONSTANT_FUNCTIONS[1];
        MethodHandle methodHandle = (MethodHandle)((Object)g.convertForCast((Object)((Object)enumMap.get((Object)wrapper)), MethodHandle.class));
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = MethodType.methodType(wrapper.primitiveType());
        if (wrapper != Wrapper.VOID) {
            methodType = methodType.appendParameterTypes(wrapper.primitiveType());
        }
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle == null && wrapper == Wrapper.VOID) {
            methodHandle = EMPTY;
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find identity for " + (Object)((Object)wrapper));
    }

    static float doubleToFloat(double d) {
        return (float)d;
    }

    static long doubleToLong(double d) {
        return (long)d;
    }

    static int doubleToInt(double d) {
        return (int)d;
    }

    static short doubleToShort(double d) {
        return (short)d;
    }

    static char doubleToChar(double d) {
        return (char)d;
    }

    static byte doubleToByte(double d) {
        return (byte)d;
    }

    static boolean doubleToBoolean(double d) {
        return ValueConversions.toBoolean((byte)d);
    }

    static double floatToDouble(float f2) {
        return f2;
    }

    static long floatToLong(float f2) {
        return (long)f2;
    }

    static int floatToInt(float f2) {
        return (int)f2;
    }

    static short floatToShort(float f2) {
        return (short)f2;
    }

    static char floatToChar(float f2) {
        return (char)f2;
    }

    static byte floatToByte(float f2) {
        return (byte)f2;
    }

    static boolean floatToBoolean(float f2) {
        return ValueConversions.toBoolean((byte)f2);
    }

    static double longToDouble(long l) {
        return l;
    }

    static float longToFloat(long l) {
        return l;
    }

    static int longToInt(long l) {
        return (int)l;
    }

    static short longToShort(long l) {
        return (short)l;
    }

    static char longToChar(long l) {
        return (char)l;
    }

    static byte longToByte(long l) {
        return (byte)l;
    }

    static boolean longToBoolean(long l) {
        return ValueConversions.toBoolean((byte)l);
    }

    static double intToDouble(int n2) {
        return n2;
    }

    static float intToFloat(int n2) {
        return n2;
    }

    static long intToLong(int n2) {
        return n2;
    }

    static short intToShort(int n2) {
        return (short)n2;
    }

    static char intToChar(int n2) {
        return (char)n2;
    }

    static byte intToByte(int n2) {
        return (byte)n2;
    }

    static boolean intToBoolean(int n2) {
        return ValueConversions.toBoolean((byte)n2);
    }

    static double shortToDouble(short s) {
        return s;
    }

    static float shortToFloat(short s) {
        return s;
    }

    static long shortToLong(short s) {
        return s;
    }

    static int shortToInt(short s) {
        return s;
    }

    static char shortToChar(short s) {
        return (char)s;
    }

    static byte shortToByte(short s) {
        return (byte)s;
    }

    static boolean shortToBoolean(short s) {
        return ValueConversions.toBoolean((byte)s);
    }

    static double charToDouble(char c) {
        return c;
    }

    static float charToFloat(char c) {
        return c;
    }

    static long charToLong(char c) {
        return c;
    }

    static int charToInt(char c) {
        return c;
    }

    static short charToShort(char c) {
        return (short)c;
    }

    static byte charToByte(char c) {
        return (byte)c;
    }

    static boolean charToBoolean(char c) {
        return ValueConversions.toBoolean((byte)c);
    }

    static double byteToDouble(byte by) {
        return by;
    }

    static float byteToFloat(byte by) {
        return by;
    }

    static long byteToLong(byte by) {
        return by;
    }

    static int byteToInt(byte by) {
        return by;
    }

    static short byteToShort(byte by) {
        return by;
    }

    static char byteToChar(byte by) {
        return (char)by;
    }

    static boolean byteToBoolean(byte by) {
        return ValueConversions.toBoolean(by);
    }

    static double booleanToDouble(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static float booleanToFloat(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static long booleanToLong(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static int booleanToInt(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static short booleanToShort(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static char booleanToChar(boolean bl) {
        return (char)ValueConversions.fromBoolean(bl);
    }

    static byte booleanToByte(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static boolean toBoolean(byte by) {
        return (by & 1) != 0;
    }

    static byte fromBoolean(boolean bl) {
        return bl ? (byte)1 : 0;
    }

    public static MethodHandle convertPrimitive(Wrapper wrapper, Wrapper wrapper2) {
        MethodType methodType;
        EnumMap<Wrapper, MethodHandle> enumMap = CONVERT_PRIMITIVE_FUNCTIONS[wrapper.ordinal()];
        MethodHandle methodHandle = (MethodHandle)((Object)g.convertForCast((Object)((Object)enumMap.get((Object)wrapper2)), MethodHandle.class));
        if (methodHandle != null) {
            return methodHandle;
        }
        Class<?> clazz = wrapper.primitiveType();
        Class<?> clazz2 = wrapper2.primitiveType();
        MethodType methodType2 = methodType = clazz == Void.TYPE ? MethodType.methodType(clazz2) : MethodType.methodType(clazz2, clazz);
        if (wrapper == wrapper2) {
            methodHandle = ValueConversions.identity(clazz);
        } else if (wrapper == Wrapper.VOID) {
            methodHandle = ValueConversions.zeroConstantFunction(wrapper2);
        } else if (wrapper2 == Wrapper.VOID) {
            methodHandle = MethodHandles.dropArguments(EMPTY, 0, clazz);
        } else if (wrapper == Wrapper.OBJECT) {
            methodHandle = ValueConversions.unboxCast(clazz2);
        } else if (wrapper2 == Wrapper.OBJECT) {
            methodHandle = ValueConversions.box(clazz);
        } else {
            assert (clazz.isPrimitive() && clazz2.isPrimitive());
            try {
                methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, clazz.getSimpleName() + "To" + ValueConversions.capitalize(clazz2.getSimpleName()), methodType);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                methodHandle = null;
            }
        }
        if (methodHandle != null) {
            assert (methodHandle.type() == methodType) : methodHandle;
            enumMap.put(wrapper2, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find primitive conversion function for " + clazz.getSimpleName() + " -> " + clazz2.getSimpleName());
    }

    public static MethodHandle convertPrimitive(Class<?> clazz, Class<?> clazz2) {
        return ValueConversions.convertPrimitive(Wrapper.forPrimitiveType(clazz), Wrapper.forPrimitiveType(clazz2));
    }

    private static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static Object convertArrayElements(Class<?> clazz, Object object) {
        Wrapper wrapper;
        Class<?> clazz2 = object.getClass().getComponentType();
        Class<?> clazz3 = clazz.getComponentType();
        if (clazz2 == null || clazz3 == null) {
            throw new IllegalArgumentException("not array type");
        }
        Wrapper wrapper2 = clazz2.isPrimitive() ? Wrapper.forPrimitiveType(clazz2) : null;
        Wrapper wrapper3 = wrapper = clazz3.isPrimitive() ? Wrapper.forPrimitiveType(clazz3) : null;
        if (wrapper2 == null) {
            Object[] objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class);
            int n2 = objectArray.length;
            if (wrapper == null) {
                return Arrays.copyOf(objectArray, n2, clazz.asSubclass(Object[].class));
            }
            Object object2 = wrapper.makeArray(n2);
            wrapper.copyArrayUnboxing(objectArray, 0, object2, 0, n2);
            return object2;
        }
        int n3 = Array.getLength(object);
        Object[] objectArray = wrapper == null ? Arrays.copyOf(NO_ARGS_ARRAY, n3, clazz.asSubclass(Object[].class)) : new Object[n3];
        wrapper2.copyArrayBoxing(object, 0, objectArray, 0, n3);
        if (wrapper == null) {
            return objectArray;
        }
        Object object3 = wrapper.makeArray(n3);
        wrapper.copyArrayUnboxing(objectArray, 0, object3, 0, n3);
        return object3;
    }

    private static MethodHandle findCollector(String string, int n2, Class<?> clazz, Class<?> ... classArray) {
        MethodType methodType = MethodType.genericMethodType(n2).changeReturnType(clazz).insertParameterTypes(0, classArray);
        try {
            return IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    private static Object[] makeArray(Object ... objectArray) {
        return objectArray;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object object) {
        return ValueConversions.makeArray(object);
    }

    private static Object[] array(Object object, Object object2) {
        return ValueConversions.makeArray(object, object2);
    }

    private static Object[] array(Object object, Object object2, Object object3) {
        return ValueConversions.makeArray(object, object2, object3);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4) {
        return ValueConversions.makeArray(object, object2, object3, object4);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static MethodHandle[] makeArrays() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        while ((methodHandle = ValueConversions.findCollector("array", arrayList.size(), Object[].class, new Class[0])) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return (MethodHandle[])g.convertForCast((Object)arrayList.toArray(new MethodHandle[MAX_ARITY + 1]), MethodHandle[].class);
    }

    private static Object[] fillNewArray(Integer n2, Object[] objectArray) {
        Object[] objectArray2 = new Object[n2.intValue()];
        ValueConversions.fillWithArguments(objectArray2, 0, objectArray);
        return objectArray2;
    }

    private static Object[] fillNewTypedArray(Object[] objectArray, Integer n2, Object[] objectArray2) {
        Object[] objectArray3 = Arrays.copyOf(objectArray, (int)n2);
        ValueConversions.fillWithArguments(objectArray3, 0, objectArray2);
        return objectArray3;
    }

    private static void fillWithArguments(Object[] objectArray, int n2, Object ... objectArray2) {
        System.arraycopy(objectArray2, 0, objectArray, n2, objectArray2.length);
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object) {
        ValueConversions.fillWithArguments(objectArray, n2, object);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4, object5);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4, object5, object6);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4, object5, object6, object7);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4, object5, object6, object7, object8);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4, object5, object6, object7, object8, object9);
        return objectArray;
    }

    private static Object[] fillArray(Integer n2, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        ValueConversions.fillWithArguments(objectArray, n2, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
        return objectArray;
    }

    private static MethodHandle[] makeFillArrays() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        arrayList.add(null);
        while ((methodHandle = ValueConversions.findCollector("fillArray", arrayList.size(), Object[].class, Integer.class, Object[].class)) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return (MethodHandle[])g.convertForCast((Object)arrayList.toArray(new MethodHandle[0]), MethodHandle[].class);
    }

    private static Object[] copyAsReferenceArray(Class<? extends Object[]> clazz, Object ... objectArray) {
        return Arrays.copyOf(objectArray, objectArray.length, clazz);
    }

    private static Object copyAsPrimitiveArray(Wrapper wrapper, Object ... objectArray) {
        Object object = wrapper.makeArray(objectArray.length);
        wrapper.copyArrayUnboxing(objectArray, 0, object, 0, objectArray.length);
        return object;
    }

    public static MethodHandle varargsArray(int n2) {
        MethodHandle methodHandle = ARRAYS[n2];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = ValueConversions.findCollector("array", n2, Object[].class, new Class[0]);
        if (methodHandle != null) {
            ValueConversions.ARRAYS[n2] = methodHandle;
            return ValueConversions.ARRAYS[n2];
        }
        methodHandle = ValueConversions.buildVarargsArray(FILL_NEW_ARRAY, ARRAY_IDENTITY, n2);
        assert (ValueConversions.assertCorrectArity(methodHandle, n2));
        ValueConversions.ARRAYS[n2] = methodHandle;
        return ValueConversions.ARRAYS[n2];
    }

    private static boolean assertCorrectArity(MethodHandle methodHandle, int n2) {
        assert (methodHandle.type().parameterCount() == n2) : "arity != " + n2 + ": " + (Object)((Object)methodHandle);
        return true;
    }

    private static MethodHandle buildVarargsArray(MethodHandle methodHandle, MethodHandle methodHandle2, int n2) {
        int n3 = Math.min(n2, LEFT_ARGS);
        int n4 = n2 - n3;
        MethodHandle methodHandle3 = methodHandle.bindTo(n2);
        methodHandle3 = methodHandle3.asCollector(Object[].class, n3);
        MethodHandle methodHandle4 = methodHandle2;
        if (n4 > 0) {
            MethodHandle methodHandle5 = ValueConversions.fillToRight(LEFT_ARGS + n4);
            methodHandle4 = methodHandle4 == ARRAY_IDENTITY ? methodHandle5 : ValueConversions.collectArguments(methodHandle4, 0, methodHandle5);
        }
        methodHandle4 = methodHandle4 == ARRAY_IDENTITY ? methodHandle3 : ValueConversions.collectArguments(methodHandle4, 0, methodHandle3);
        return methodHandle4;
    }

    private static MethodHandle fillToRight(int n2) {
        MethodHandle methodHandle = FILL_ARRAY_TO_RIGHT[n2];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = ValueConversions.buildFiller(n2);
        assert (ValueConversions.assertCorrectArity(methodHandle, n2 - LEFT_ARGS + 1));
        ValueConversions.FILL_ARRAY_TO_RIGHT[n2] = methodHandle;
        return ValueConversions.FILL_ARRAY_TO_RIGHT[n2];
    }

    private static MethodHandle buildFiller(int n2) {
        if (n2 <= LEFT_ARGS) {
            return ARRAY_IDENTITY;
        }
        int n3 = LEFT_ARGS;
        int n4 = n2 % n3;
        int n5 = n2 - n4;
        if (n4 == 0 && FILL_ARRAY_TO_RIGHT[n5 = n2 - (n4 = n3)] == null) {
            for (int i = LEFT_ARGS % n3; i < n5; i += n3) {
                if (i <= LEFT_ARGS) continue;
                ValueConversions.fillToRight(i);
            }
        }
        if (n5 < LEFT_ARGS) {
            n5 = LEFT_ARGS;
            n4 = n2 - n5;
        }
        assert (n4 > 0);
        MethodHandle methodHandle = ValueConversions.fillToRight(n5);
        MethodHandle methodHandle2 = FILL_ARRAYS[n4].bindTo(n5);
        assert (methodHandle.type().parameterCount() == 1 + n5 - LEFT_ARGS);
        assert (methodHandle2.type().parameterCount() == 1 + n4);
        if (n5 == LEFT_ARGS) {
            return methodHandle2;
        }
        return ValueConversions.collectArguments(methodHandle2, 0, methodHandle);
    }

    public static MethodHandle varargsArray(Class<?> clazz, int n2) {
        MethodHandle methodHandle;
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new IllegalArgumentException("not an array: " + clazz);
        }
        if (n2 >= 126) {
            int n3 = n2;
            if (clazz == double[].class || clazz == long[].class) {
                n3 *= 2;
            }
            if (n3 > 254) {
                throw new IllegalArgumentException("too many arguments: " + clazz.getSimpleName() + ", length " + n2);
            }
        }
        if (clazz2 == Object.class) {
            return ValueConversions.varargsArray(n2);
        }
        MethodHandle[] methodHandleArray = (MethodHandle[])g.convertForCast(TYPED_COLLECTORS.get(clazz2), MethodHandle[].class);
        MethodHandle methodHandle2 = methodHandle = n2 < methodHandleArray.length ? methodHandleArray[n2] : null;
        if (methodHandle != null) {
            return methodHandle;
        }
        if (clazz2.isPrimitive()) {
            MethodHandle methodHandle3 = FILL_NEW_ARRAY;
            MethodHandle methodHandle4 = ValueConversions.buildArrayProducer(clazz);
            methodHandle = ValueConversions.buildVarargsArray(methodHandle3, methodHandle4, n2);
        } else {
            Class<?> clazz3 = clazz;
            T[] TArray = Arrays.copyOf(NO_ARGS_ARRAY, 0, clazz3);
            MethodHandle methodHandle5 = FILL_NEW_TYPED_ARRAY.bindTo(TArray);
            MethodHandle methodHandle6 = ARRAY_IDENTITY;
            methodHandle = ValueConversions.buildVarargsArray(methodHandle5, methodHandle6, n2);
        }
        methodHandle = methodHandle.asType(MethodType.methodType(clazz, Collections.nCopies(n2, clazz2)));
        assert (ValueConversions.assertCorrectArity(methodHandle, n2));
        if (n2 < methodHandleArray.length) {
            methodHandleArray[n2] = methodHandle;
        }
        return methodHandle;
    }

    private static MethodHandle buildArrayProducer(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            return LazyStatics.COPY_AS_PRIMITIVE_ARRAY.bindTo((Object)Wrapper.forPrimitiveType(clazz2));
        }
        return LazyStatics.COPY_AS_REFERENCE_ARRAY.bindTo(clazz);
    }

    private static List<Object> makeList(Object ... objectArray) {
        return Arrays.asList(objectArray);
    }

    private static List<Object> list() {
        return NO_ARGS_LIST;
    }

    private static List<Object> list(Object object) {
        return ValueConversions.makeList(object);
    }

    private static List<Object> list(Object object, Object object2) {
        return ValueConversions.makeList(object, object2);
    }

    private static List<Object> list(Object object, Object object2, Object object3) {
        return ValueConversions.makeList(object, object2, object3);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4) {
        return ValueConversions.makeList(object, object2, object3, object4);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5) {
        return ValueConversions.makeList(object, object2, object3, object4, object5);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static MethodHandle[] makeLists() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        while ((methodHandle = ValueConversions.findCollector("list", arrayList.size(), List.class, new Class[0])) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return (MethodHandle[])g.convertForCast((Object)arrayList.toArray(new MethodHandle[MAX_ARITY + 1]), MethodHandle[].class);
    }

    public static MethodHandle varargsList(int n2) {
        MethodHandle methodHandle = LISTS[n2];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = ValueConversions.findCollector("list", n2, List.class, new Class[0]);
        if (methodHandle != null) {
            ValueConversions.LISTS[n2] = methodHandle;
            return ValueConversions.LISTS[n2];
        }
        ValueConversions.LISTS[n2] = ValueConversions.buildVarargsList(n2);
        return ValueConversions.LISTS[n2];
    }

    private static MethodHandle buildVarargsList(int n2) {
        return MethodHandles.filterReturnValue(ValueConversions.varargsArray(n2), LazyStatics.MAKE_LIST);
    }

    private static InternalError newInternalError(String string, Throwable throwable) {
        InternalError internalError = new InternalError(string);
        internalError.initCause(throwable);
        return internalError;
    }

    private static InternalError newInternalError(Throwable throwable) {
        InternalError internalError = new InternalError();
        internalError.initCause(throwable);
        return internalError;
    }

    static {
        Object object;
        THIS_CLASS = ValueConversions.class;
        Object object2 = new Object[]{255};
        AccessController.doPrivileged(new Object(object2){
            static final /* synthetic */ int[] $SwitchMap$sun$invoke$util$Wrapper;

            static {
                $SwitchMap$sun$invoke$util$Wrapper = new int[Wrapper.values().length];
                try {
                    1.$SwitchMap$sun$invoke$util$Wrapper[Wrapper.OBJECT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    1.$SwitchMap$sun$invoke$util$Wrapper[Wrapper.VOID.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
        });
        MAX_ARITY = (Integer)object2[0];
        IMPL_LOOKUP = MethodHandles.lookup();
        UNBOX_CONVERSIONS = ValueConversions.newWrapperCaches(2);
        ZERO_INT = 0;
        ONE_INT = 1;
        BOX_CONVERSIONS = ValueConversions.newWrapperCaches(2);
        CONSTANT_FUNCTIONS = ValueConversions.newWrapperCaches(2);
        try {
            object2 = MethodType.genericMethodType(1);
            object = object2.insertParameterTypes(0, Class.class);
            MethodType methodType = object2.changeReturnType(Void.TYPE);
            MethodType methodType2 = MethodType.genericMethodType(0);
            IDENTITY = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", (MethodType)object2);
            CAST_REFERENCE = IMPL_LOOKUP.findStatic(THIS_CLASS, "castReference", (MethodType)object);
            ZERO_OBJECT = IMPL_LOOKUP.findStatic(THIS_CLASS, "zeroObject", methodType2);
            IGNORE = IMPL_LOOKUP.findStatic(THIS_CLASS, "ignore", methodType);
            EMPTY = IMPL_LOOKUP.findStatic(THIS_CLASS, "empty", methodType.dropParameterTypes(0, 1));
            ARRAY_IDENTITY = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", MethodType.methodType(Object[].class, Object[].class));
            FILL_NEW_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "fillNewArray", MethodType.methodType(Object[].class, Integer.class, Object[].class));
            FILL_NEW_TYPED_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "fillNewTypedArray", MethodType.methodType(Object[].class, Object[].class, Integer.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw ValueConversions.newInternalError("uncaught exception", reflectiveOperationException);
        }
        object2 = null;
        try {
            object = MethodHandles.class.getDeclaredMethod("collectArguments", new Class[]{MethodHandle.class, Integer.TYPE, MethodHandle.class});
            AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
            object2 = IMPL_LOOKUP.unreflect((Method)object);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw ValueConversions.newInternalError(reflectiveOperationException);
        }
        COLLECT_ARGUMENTS = object2;
        WRAPPER_CASTS = ValueConversions.newWrapperCaches(1);
        CONVERT_PRIMITIVE_FUNCTIONS = ValueConversions.newWrapperCaches(Wrapper.values().length);
        NO_ARGS_ARRAY = new Object[0];
        ARRAYS = ValueConversions.makeArrays();
        FILL_ARRAYS = ValueConversions.makeFillArrays();
        LEFT_ARGS = FILL_ARRAYS.length - 1;
        FILL_ARRAY_TO_RIGHT = new MethodHandle[MAX_ARITY + 1];
        TYPED_COLLECTORS = new /* Unavailable Anonymous Inner Class!! */;
        NO_ARGS_LIST = Arrays.asList(NO_ARGS_ARRAY);
        LISTS = ValueConversions.makeLists();
    }

    protected /* synthetic */ ValueConversions(h h2) {
    }

    static class LazyStatics {
        private static final MethodHandle COPY_AS_REFERENCE_ARRAY;
        private static final MethodHandle COPY_AS_PRIMITIVE_ARRAY;
        private static final MethodHandle MAKE_LIST;

        LazyStatics() {
        }

        static {
            try {
                COPY_AS_REFERENCE_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "copyAsReferenceArray", MethodType.methodType(Object[].class, Class.class, Object[].class));
                COPY_AS_PRIMITIVE_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "copyAsPrimitiveArray", MethodType.methodType(Object.class, Wrapper.class, Object[].class));
                MAKE_LIST = IMPL_LOOKUP.findStatic(THIS_CLASS, "makeList", MethodType.methodType(List.class, Object[].class));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw ValueConversions.newInternalError("uncaught exception", reflectiveOperationException);
            }
        }

        protected /* synthetic */ LazyStatics(h h2) {
        }
    }
}

