/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class Wrapper
extends Enum<Wrapper> {
    public static final /* enum */ Wrapper BOOLEAN = new Wrapper(Boolean.class, Boolean.TYPE, 'Z', false, new boolean[0], Format.unsigned(1));
    public static final /* enum */ Wrapper BYTE = new Wrapper(Byte.class, Byte.TYPE, 'B', (byte)0, new byte[0], Format.signed(8));
    public static final /* enum */ Wrapper SHORT = new Wrapper(Short.class, Short.TYPE, 'S', (short)0, new short[0], Format.signed(16));
    public static final /* enum */ Wrapper CHAR = new Wrapper(Character.class, Character.TYPE, 'C', Character.valueOf('\u0000'), new char[0], Format.unsigned(16));
    public static final /* enum */ Wrapper INT = new Wrapper(Integer.class, Integer.TYPE, 'I', 0, new int[0], Format.signed(32));
    public static final /* enum */ Wrapper LONG = new Wrapper(Long.class, Long.TYPE, 'J', 0L, new long[0], Format.signed(64));
    public static final /* enum */ Wrapper FLOAT = new Wrapper(Float.class, Float.TYPE, 'F', Float.valueOf(0.0f), new float[0], Format.floating(32));
    public static final /* enum */ Wrapper DOUBLE = new Wrapper(Double.class, Double.TYPE, 'D', 0.0, new double[0], Format.floating(64));
    public static final /* enum */ Wrapper OBJECT = new Wrapper(Object.class, Object.class, 'L', null, new Object[0], Format.other(1));
    public static final /* enum */ Wrapper VOID = new Wrapper(Void.class, Void.TYPE, 'V', null, null, Format.other(0));
    private final Class<?> wrapperType;
    private final Class<?> primitiveType;
    private final char basicTypeChar;
    private final Object zero;
    private final Object emptyArray;
    private final int format;
    private final String wrapperSimpleName;
    private final String primitiveSimpleName;
    private static final Wrapper[] FROM_PRIM;
    private static final Wrapper[] FROM_WRAP;
    private static final Wrapper[] FROM_CHAR;
    private static final /* synthetic */ Wrapper[] $VALUES;

    public static Wrapper[] values() {
        return (Wrapper[])$VALUES.clone();
    }

    public static Wrapper valueOf(String string) {
        return Enum.valueOf(Wrapper.class, string);
    }

    private Wrapper(Class<?> clazz, Class<?> clazz2, char c2, Object object, Object object2, int n3) {
        this.wrapperType = clazz;
        this.primitiveType = clazz2;
        this.basicTypeChar = c2;
        this.zero = object;
        this.emptyArray = object2;
        this.format = n3;
        this.wrapperSimpleName = clazz.getSimpleName();
        this.primitiveSimpleName = clazz2.getSimpleName();
    }

    public String detailString() {
        return this.wrapperSimpleName + Arrays.asList(this.wrapperType, this.primitiveType, Character.valueOf(this.basicTypeChar), this.zero, "0x" + Integer.toHexString(this.format));
    }

    public int bitWidth() {
        return this.format >> 2 & 0x3FF;
    }

    public int stackSlots() {
        return this.format >> 0 & 3;
    }

    public boolean isSingleWord() {
        return (this.format & 1) != 0;
    }

    public boolean isDoubleWord() {
        return (this.format & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.format & 0xFFFFFFFC) != 0;
    }

    public boolean isIntegral() {
        return this.isNumeric() && this.format < 4225;
    }

    public boolean isSubwordOrInt() {
        return this.isIntegral() && this.isSingleWord();
    }

    public boolean isSigned() {
        return this.format < 0;
    }

    public boolean isUnsigned() {
        return this.format >= 5 && this.format < 4225;
    }

    public boolean isFloating() {
        return this.format >= 4225;
    }

    public boolean isOther() {
        return (this.format & 0xFFFFFFFC) == 0;
    }

    public boolean isConvertibleFrom(Wrapper wrapper) {
        boolean bl;
        if (this == wrapper) {
            return true;
        }
        if (this.compareTo(wrapper) < 0) {
            return false;
        }
        boolean bl2 = bl = (this.format & wrapper.format & 0xFFFFF000) != 0;
        if (!bl) {
            if (this.isOther()) {
                return true;
            }
            return wrapper.format == 65;
        }
        assert (this.isFloating() || this.isSigned());
        assert (wrapper.isFloating() || wrapper.isSigned());
        return true;
    }

    private static boolean checkConvertibleFrom() {
        for (Wrapper wrapper : Wrapper.values()) {
            assert (wrapper.isConvertibleFrom(wrapper));
            assert (VOID.isConvertibleFrom(wrapper));
            if (wrapper != VOID) {
                assert (OBJECT.isConvertibleFrom(wrapper));
                assert (!wrapper.isConvertibleFrom(VOID));
            }
            if (wrapper != CHAR) {
                assert (!CHAR.isConvertibleFrom(wrapper));
                if (!wrapper.isConvertibleFrom(INT)) assert (!wrapper.isConvertibleFrom(CHAR));
            }
            if (wrapper != BOOLEAN) {
                assert (!BOOLEAN.isConvertibleFrom(wrapper));
                if (wrapper != VOID && wrapper != OBJECT) assert (!wrapper.isConvertibleFrom(BOOLEAN));
            }
            if (wrapper.isSigned()) {
                for (Wrapper wrapper2 : Wrapper.values()) {
                    if (wrapper != wrapper2 && (wrapper2.isFloating() ? !$assertionsDisabled && wrapper.isConvertibleFrom(wrapper2) : wrapper2.isSigned() && (wrapper.compareTo(wrapper2) < 0 ? !$assertionsDisabled && wrapper.isConvertibleFrom(wrapper2) : !$assertionsDisabled && !wrapper.isConvertibleFrom(wrapper2)))) {
                        throw new AssertionError();
                    }
                }
            }
            if (!wrapper.isFloating()) continue;
            for (Wrapper wrapper2 : Wrapper.values()) {
                if (wrapper != wrapper2 && (wrapper2.isSigned() ? !$assertionsDisabled && !wrapper.isConvertibleFrom(wrapper2) : wrapper2.isFloating() && (wrapper.compareTo(wrapper2) < 0 ? !$assertionsDisabled && wrapper.isConvertibleFrom(wrapper2) : !$assertionsDisabled && !wrapper.isConvertibleFrom(wrapper2)))) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    public Object zero() {
        return this.zero;
    }

    public <T> T zero(Class<T> clazz) {
        return this.convert(this.zero, clazz);
    }

    public static Wrapper forPrimitiveType(Class<?> clazz) {
        Wrapper wrapper = Wrapper.findPrimitiveType(clazz);
        if (wrapper != null) {
            return wrapper;
        }
        if (clazz.isPrimitive()) {
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not primitive: " + clazz);
    }

    static Wrapper findPrimitiveType(Class<?> clazz) {
        Wrapper wrapper = FROM_PRIM[Wrapper.hashPrim(clazz)];
        if (wrapper != null && wrapper.primitiveType == clazz) {
            return wrapper;
        }
        return null;
    }

    public static Wrapper forWrapperType(Class<?> clazz) {
        Wrapper wrapper = Wrapper.findWrapperType(clazz);
        if (wrapper != null) {
            return wrapper;
        }
        for (Wrapper wrapper2 : Wrapper.values()) {
            if (wrapper2.wrapperType != clazz) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not wrapper: " + clazz);
    }

    static Wrapper findWrapperType(Class<?> clazz) {
        Wrapper wrapper = FROM_WRAP[Wrapper.hashWrap(clazz)];
        if (wrapper != null && wrapper.wrapperType == clazz) {
            return wrapper;
        }
        return null;
    }

    public static Wrapper forBasicType(char c2) {
        Wrapper wrapper = FROM_CHAR[Wrapper.hashChar(c2)];
        if (wrapper != null && wrapper.basicTypeChar == c2) {
            return wrapper;
        }
        for (Wrapper wrapper2 : Wrapper.values()) {
            if (wrapper.basicTypeChar != c2) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not basic type char: " + c2);
    }

    public static Wrapper forBasicType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz);
        }
        return OBJECT;
    }

    private static int hashPrim(Class<?> clazz) {
        String string = clazz.getName();
        if (string.length() < 3) {
            return 0;
        }
        return (string.charAt(0) + string.charAt(2)) % 16;
    }

    private static int hashWrap(Class<?> clazz) {
        String string = clazz.getName();
        assert (10 == "java.lang.".length());
        if (string.length() < 13) {
            return 0;
        }
        return (3 * string.charAt(11) + string.charAt(12)) % 16;
    }

    private static int hashChar(char c2) {
        return (c2 + (c2 >> 1)) % 16;
    }

    public Class<?> primitiveType() {
        return this.primitiveType;
    }

    public Class<?> wrapperType() {
        return this.wrapperType;
    }

    public <T> Class<T> wrapperType(Class<T> clazz) {
        if (clazz == this.wrapperType) {
            return clazz;
        }
        if (clazz == this.primitiveType || this.wrapperType == Object.class || clazz.isInterface()) {
            return Wrapper.forceType(this.wrapperType, clazz);
        }
        throw Wrapper.newClassCastException(clazz, this.primitiveType);
    }

    private static ClassCastException newClassCastException(Class<?> clazz, Class<?> clazz2) {
        return new ClassCastException(clazz + " is not compatible with " + clazz2);
    }

    public static <T> Class<T> asWrapperType(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz).wrapperType(clazz);
        }
        return clazz;
    }

    public static <T> Class<T> asPrimitiveType(Class<T> clazz) {
        Wrapper wrapper = Wrapper.findWrapperType(clazz);
        if (wrapper != null) {
            return Wrapper.forceType(wrapper.primitiveType(), clazz);
        }
        return clazz;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return Wrapper.findWrapperType(clazz) != null;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static char basicTypeChar(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return 'L';
        }
        return Wrapper.forPrimitiveType(clazz).basicTypeChar();
    }

    public char basicTypeChar() {
        return this.basicTypeChar;
    }

    public String wrapperSimpleName() {
        return this.wrapperSimpleName;
    }

    public String primitiveSimpleName() {
        return this.primitiveSimpleName;
    }

    public <T> T cast(Object object, Class<T> clazz) {
        return this.convert(object, clazz, true);
    }

    public <T> T convert(Object object, Class<T> clazz) {
        return this.convert(object, clazz, false);
    }

    private <T> T convert(Object object, Class<T> clazz, boolean bl) {
        Class<?> clazz2;
        if (this == OBJECT) {
            assert (!clazz.isPrimitive());
            if (!clazz.isInterface()) {
                x.cast(clazz, (Object)object);
            }
            Object object2 = object;
            return (T)object2;
        }
        Class<T> clazz3 = this.wrapperType(clazz);
        if (x.isInstance(clazz3, (Object)object)) {
            return (T)x.cast(clazz3, (Object)object);
        }
        if (!bl) {
            clazz2 = object.getClass();
            Wrapper wrapper = Wrapper.findWrapperType(clazz2);
            if (wrapper == null || !this.isConvertibleFrom(wrapper)) {
                throw Wrapper.newClassCastException(clazz3, clazz2);
            }
        } else if (object == null) {
            Object object3 = this.zero;
            return (T)object3;
        }
        clazz2 = this.wrap(object);
        assert ((clazz2 == null ? Void.class : clazz2.getClass()) == clazz3);
        return (T)clazz2;
    }

    static <T> Class<T> forceType(Class<?> clazz, Class<T> clazz2) {
        boolean bl;
        boolean bl2 = bl = clazz == clazz2 || clazz.isPrimitive() && Wrapper.forPrimitiveType(clazz) == Wrapper.findWrapperType(clazz2) || clazz2.isPrimitive() && Wrapper.forPrimitiveType(clazz2) == Wrapper.findWrapperType(clazz) || clazz == Object.class && !clazz2.isPrimitive();
        if (!bl) {
            System.out.println(clazz + " <= " + clazz2);
        }
        assert (clazz == clazz2 || clazz.isPrimitive() && Wrapper.forPrimitiveType(clazz) == Wrapper.findWrapperType(clazz2) || clazz2.isPrimitive() && Wrapper.forPrimitiveType(clazz2) == Wrapper.findWrapperType(clazz) || clazz == Object.class && !clazz2.isPrimitive());
        Class<?> clazz3 = clazz;
        return clazz3;
    }

    public Object wrap(Object object) {
        switch (this.basicTypeChar) {
            case 'L': {
                return object;
            }
            case 'V': {
                return null;
            }
        }
        Number number = Wrapper.numberValue(object);
        switch (this.basicTypeChar) {
            case 'I': {
                return number.intValue();
            }
            case 'J': {
                return number.longValue();
            }
            case 'F': {
                return Float.valueOf(number.floatValue());
            }
            case 'D': {
                return number.doubleValue();
            }
            case 'S': {
                return (short)number.intValue();
            }
            case 'B': {
                return (byte)number.intValue();
            }
            case 'C': {
                return Character.valueOf((char)number.intValue());
            }
            case 'Z': {
                return Wrapper.boolValue(number.byteValue());
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrap(int n2) {
        if (this.basicTypeChar == 'L') {
            return n2;
        }
        switch (this.basicTypeChar) {
            case 'L': {
                throw Wrapper.newIllegalArgumentException("cannot wrap to object type");
            }
            case 'V': {
                return null;
            }
            case 'I': {
                return n2;
            }
            case 'J': {
                return (long)n2;
            }
            case 'F': {
                return Float.valueOf(n2);
            }
            case 'D': {
                return (double)n2;
            }
            case 'S': {
                return (short)n2;
            }
            case 'B': {
                return (byte)n2;
            }
            case 'C': {
                return Character.valueOf((char)n2);
            }
            case 'Z': {
                return Wrapper.boolValue((byte)n2);
            }
        }
        throw new InternalError("bad wrapper");
    }

    private static Number numberValue(Object object) {
        if (g.convertForInstanceOf((Object)object, Number.class) instanceof Number) {
            return (Number)g.convertForCast((Object)object, Number.class);
        }
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return (Number)g.convertForCast((Object)object, Number.class);
    }

    private static boolean boolValue(byte by) {
        return (by = (byte)(by & 1)) != 0;
    }

    private static RuntimeException newIllegalArgumentException(String string, Object object) {
        return Wrapper.newIllegalArgumentException(string + object);
    }

    private static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    public Object makeArray(int n2) {
        return Array.newInstance(this.primitiveType, n2);
    }

    public Class<?> arrayType() {
        return this.emptyArray.getClass();
    }

    public void copyArrayUnboxing(Object[] objectArray, int n2, Object object, int n3, int n4) {
        if (object.getClass() != this.arrayType()) {
            x.cast(this.arrayType(), (Object)object);
        }
        for (int i = 0; i < n4; ++i) {
            Object object2 = objectArray[i + n2];
            object2 = this.convert(object2, this.primitiveType);
            Array.set(object, i + n3, object2);
        }
    }

    public void copyArrayBoxing(Object object, int n2, Object[] objectArray, int n3, int n4) {
        if (object.getClass() != this.arrayType()) {
            x.cast(this.arrayType(), (Object)object);
        }
        for (int i = 0; i < n4; ++i) {
            Object object2 = Array.get(object, i + n2);
            assert (object2.getClass() == this.wrapperType);
            objectArray[i + n3] = object2;
        }
    }

    static {
        $VALUES = new Wrapper[]{BOOLEAN, BYTE, SHORT, CHAR, INT, LONG, FLOAT, DOUBLE, OBJECT, VOID};
        assert (Wrapper.checkConvertibleFrom());
        FROM_PRIM = new Wrapper[16];
        FROM_WRAP = new Wrapper[16];
        FROM_CHAR = new Wrapper[16];
        for (Wrapper wrapper : Wrapper.values()) {
            int n2 = Wrapper.hashPrim(wrapper.primitiveType);
            int n3 = Wrapper.hashWrap(wrapper.wrapperType);
            int n4 = Wrapper.hashChar(wrapper.basicTypeChar);
            assert (FROM_PRIM[n2] == null);
            assert (FROM_WRAP[n3] == null);
            assert (FROM_CHAR[n4] == null);
            Wrapper.FROM_PRIM[n2] = wrapper;
            Wrapper.FROM_WRAP[n3] = wrapper;
            Wrapper.FROM_CHAR[n4] = wrapper;
        }
    }

    private static /* synthetic */ Class _jr$ig$wrapperType(Wrapper wrapper) {
        return wrapper.wrapperType;
    }

    private static /* synthetic */ void _jr$ip$wrapperType(Wrapper wrapper, Class clazz) {
        wrapper.wrapperType = clazz;
    }

    private static /* synthetic */ Class _jr$ig$primitiveType(Wrapper wrapper) {
        return wrapper.primitiveType;
    }

    private static /* synthetic */ void _jr$ip$primitiveType(Wrapper wrapper, Class clazz) {
        wrapper.primitiveType = clazz;
    }

    private static /* synthetic */ char _jr$ig$basicTypeChar(Wrapper wrapper) {
        return wrapper.basicTypeChar;
    }

    private static /* synthetic */ void _jr$ip$basicTypeChar(Wrapper wrapper, char c2) {
        wrapper.basicTypeChar = c2;
    }

    private static /* synthetic */ Object _jr$ig$zero(Wrapper wrapper) {
        return wrapper.zero;
    }

    private static /* synthetic */ void _jr$ip$zero(Wrapper wrapper, Object object) {
        wrapper.zero = object;
    }

    private static /* synthetic */ Object _jr$ig$emptyArray(Wrapper wrapper) {
        return wrapper.emptyArray;
    }

    private static /* synthetic */ void _jr$ip$emptyArray(Wrapper wrapper, Object object) {
        wrapper.emptyArray = object;
    }

    private static /* synthetic */ int _jr$ig$format(Wrapper wrapper) {
        return wrapper.format;
    }

    private static /* synthetic */ void _jr$ip$format(Wrapper wrapper, int n2) {
        wrapper.format = n2;
    }

    private static /* synthetic */ String _jr$ig$wrapperSimpleName(Wrapper wrapper) {
        return wrapper.wrapperSimpleName;
    }

    private static /* synthetic */ void _jr$ip$wrapperSimpleName(Wrapper wrapper, String string) {
        wrapper.wrapperSimpleName = string;
    }

    private static /* synthetic */ String _jr$ig$primitiveSimpleName(Wrapper wrapper) {
        return wrapper.primitiveSimpleName;
    }

    private static /* synthetic */ void _jr$ip$primitiveSimpleName(Wrapper wrapper, String string) {
        wrapper.primitiveSimpleName = string;
    }

    private static abstract class Format {
        static final int SLOT_SHIFT = 0;
        static final int SIZE_SHIFT = 2;
        static final int KIND_SHIFT = 12;
        static final int SIGNED = -4096;
        static final int UNSIGNED = 0;
        static final int FLOATING = 4096;
        static final int SLOT_MASK = 3;
        static final int SIZE_MASK = 1023;
        static final int INT = -3967;
        static final int SHORT = -4031;
        static final int BOOLEAN = 5;
        static final int CHAR = 65;
        static final int FLOAT = 4225;
        static final int VOID = 0;
        static final int NUM_MASK = -4;

        private Format() {
        }

        static int format(int n2, int n3, int n4) {
            assert (n2 >> 12 << 12 == n2);
            assert ((n3 & n3 - 1) == 0);
            assert (n2 == -4096 ? n3 > 0 : (n2 == 0 ? n3 > 0 : n2 == 4096 && (n3 == 32 || n3 == 64)));
            assert (n4 == 2 ? n3 == 64 : n4 == 1 && n3 <= 32);
            return n2 | n3 << 2 | n4 << 0;
        }

        static int signed(int n2) {
            return Format.format(-4096, n2, n2 > 32 ? 2 : 1);
        }

        static int unsigned(int n2) {
            return Format.format(0, n2, n2 > 32 ? 2 : 1);
        }

        static int floating(int n2) {
            return Format.format(4096, n2, n2 > 32 ? 2 : 1);
        }

        static int other(int n2) {
            return n2 << 0;
        }

        protected /* synthetic */ Format(h h2) {
        }
    }
}

