/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import com.zeroturnaround.javarebel.eul;
import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.VM;

public enum LauncherHelper {
    INSTANCE;

    private static final String MAIN_CLASS = "Main-Class";
    private static StringBuilder outBuf;
    private static final String INDENT = "    ";
    private static final String VM_SETTINGS = "VM settings:";
    private static final String PROP_SETTINGS = "Property settings:";
    private static final String LOCALE_SETTINGS = "Locale settings:";
    private static final String diagprop = "sun.java.launcher.diag";
    static final boolean trace;
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static final int LM_UNKNOWN = 0;
    private static final int LM_CLASS = 1;
    private static final int LM_JAR = 2;
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding;
    private static boolean isCharsetSupported;

    static void showSettings(boolean bl, String string, long l2, long l3, long l4, boolean bl2) {
        String string2;
        PrintStream printStream = bl ? System.err : System.out;
        String[] stringArray = string.split(":");
        switch (string2 = stringArray.length > 1 && stringArray[1] != null ? stringArray[1].trim() : "all") {
            case "vm": {
                LauncherHelper.printVmSettings(printStream, l2, l3, l4, bl2);
                break;
            }
            case "properties": {
                LauncherHelper.printProperties(printStream);
                break;
            }
            case "locale": {
                LauncherHelper.printLocale(printStream);
                break;
            }
            default: {
                LauncherHelper.printVmSettings(printStream, l2, l3, l4, bl2);
                LauncherHelper.printProperties(printStream);
                LauncherHelper.printLocale(printStream);
            }
        }
    }

    private static void printVmSettings(PrintStream printStream, long l2, long l3, long l4, boolean bl) {
        printStream.println(VM_SETTINGS);
        if (l4 != 0L) {
            printStream.println("    Stack Size: " + SizePrefix.scaleValue(l4));
        }
        if (l2 != 0L) {
            printStream.println("    Min. Heap Size: " + SizePrefix.scaleValue(l2));
        }
        if (l3 != 0L) {
            printStream.println("    Max. Heap Size: " + SizePrefix.scaleValue(l3));
        } else {
            printStream.println("    Max. Heap Size (Estimated): " + SizePrefix.scaleValue(Runtime.getRuntime().maxMemory()));
        }
        printStream.println("    Ergonomics Machine Class: " + (bl ? "server" : "client"));
        printStream.println("    Using VM: " + System.getProperty("java.vm.name"));
        printStream.println();
    }

    private static void printProperties(PrintStream printStream) {
        Properties properties = System.getProperties();
        printStream.println(PROP_SETTINGS);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(properties.stringPropertyNames());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            LauncherHelper.printPropertyValue(printStream, string, properties.getProperty(string));
        }
        printStream.println();
    }

    private static boolean isPath(String string) {
        return string.endsWith(".dirs") || string.endsWith(".path");
    }

    private static void printPropertyValue(PrintStream printStream, String string, String string2) {
        printStream.print(INDENT + string + " = ");
        if (string.equals("line.separator")) {
            block4: for (byte by : string2.getBytes()) {
                switch (by) {
                    case 13: {
                        printStream.print("\\r ");
                        continue block4;
                    }
                    case 10: {
                        printStream.print("\\n ");
                        continue block4;
                    }
                    default: {
                        Object[] objectArray = new Object[1];
                        a.arrayStore((Object[])objectArray, (int)0, (Object)(by & 0xFF));
                        printStream.printf("0x%02X", objectArray);
                    }
                }
            }
            printStream.println();
            return;
        }
        if (!LauncherHelper.isPath(string)) {
            printStream.println(string2);
            return;
        }
        String[] stringArray = string2.split(System.getProperty("path.separator"));
        boolean bl = true;
        for (String string3 : stringArray) {
            if (bl) {
                printStream.println(string3);
                bl = false;
                continue;
            }
            printStream.println("        " + string3);
        }
    }

    private static void printLocale(PrintStream printStream) {
        Locale locale = Locale.getDefault();
        printStream.println(LOCALE_SETTINGS);
        printStream.println("    default locale = " + locale.getDisplayLanguage());
        printStream.println("    default display locale = " + Locale.getDefault(Locale.Category.DISPLAY).getDisplayName());
        printStream.println("    default format locale = " + Locale.getDefault(Locale.Category.FORMAT).getDisplayName());
        LauncherHelper.printLocales(printStream);
        printStream.println();
    }

    private static void printLocales(PrintStream printStream) {
        int n2;
        Locale[] localeArray = Locale.getAvailableLocales();
        int n3 = n2 = localeArray == null ? 0 : localeArray.length;
        if (n2 < 1) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Locale object : localeArray) {
            treeSet.add(object.toString());
        }
        printStream.print("    available locales = ");
        Iterator iterator = treeSet.iterator();
        int n4 = n2 - 1;
        int n5 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            printStream.print(string);
            if (n5 != n4) {
                printStream.print(", ");
            }
            if ((n5 + 1) % 8 == 0) {
                printStream.println();
                printStream.print("        ");
            }
            ++n5;
        }
    }

    private static String getLocalizedMessage(String string, Object ... objectArray) {
        String string2 = ResourceBundleHolder.RB.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    static void initHelpMessage(String string) {
        Object[] objectArray = new Object[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)(string == null ? "java" : string));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.header", objectArray));
        Object[] objectArray2 = new Object[1];
        a.arrayStore((Object[])objectArray2, (int)0, (Object)32);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", objectArray2));
        Object[] objectArray3 = new Object[1];
        a.arrayStore((Object[])objectArray3, (int)0, (Object)64);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", objectArray3));
    }

    static void appendVmSelectMessage(String string, String string2) {
        Object[] objectArray = new Object[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string);
        a.arrayStore((Object[])objectArray, (int)1, (Object)string2);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.vmselect", objectArray));
    }

    static void appendVmSynonymMessage(String string, String string2) {
        Object[] objectArray = new Object[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string);
        a.arrayStore((Object[])objectArray, (int)1, (Object)string2);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.hotspot", objectArray));
    }

    static void appendVmErgoMessage(boolean bl, String string) {
        Object[] objectArray = new Object[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.ergo.message1", objectArray));
        outBuf = bl ? outBuf.append(",\n" + LauncherHelper.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        Object[] objectArray = new Object[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)File.pathSeparator);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.footer", objectArray));
        printStream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        Object[] objectArray = new Object[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)File.pathSeparator);
        printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.usage", objectArray));
        if (System.getProperty("os.name").contains("OS X")) {
            Object[] objectArray2 = new Object[1];
            a.arrayStore((Object[])objectArray2, (int)0, (Object)File.pathSeparator);
            printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.macosx.usage", objectArray2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassFromJar(PrintStream printStream, String string) {
        String string2;
        block9: {
            JarFile jarFile = null;
            try {
                String string3;
                Attributes attributes;
                jarFile = new JarFile(string);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string);
                    LauncherHelper.abort(printStream, null, "java.launcher.jar.error2", objectArray);
                }
                if ((attributes = manifest.getMainAttributes()) == null) {
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string);
                    LauncherHelper.abort(printStream, null, "java.launcher.jar.error3", objectArray);
                }
                if ((string3 = attributes.getValue(MAIN_CLASS)) == null) {
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string);
                    LauncherHelper.abort(printStream, null, "java.launcher.jar.error3", objectArray);
                }
                string2 = string3.trim();
                if (jarFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                catch (IOException iOException) {
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string);
                    LauncherHelper.abort(printStream, iOException, "java.launcher.jar.error1", objectArray);
                    return null;
                }
            }
            jarFile.close();
        }
        return string2;
    }

    static void abort(PrintStream printStream, Throwable throwable, String string, Object ... objectArray) {
        if (string != null) {
            printStream.println(LauncherHelper.getLocalizedMessage(string, objectArray));
        }
        if (trace) {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                Thread.dumpStack();
            }
        }
        System.exit(1);
    }

    public static Class<?> checkAndLoadMain(boolean bl, int n2, String string) {
        eul.deferredInitHook();
        PrintStream printStream = bl ? System.err : System.out;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        String string2 = null;
        switch (n2) {
            case 1: {
                string2 = string;
                break;
            }
            case 2: {
                string2 = LauncherHelper.getMainClassFromJar(printStream, string);
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("" + n2 + ": Unknown launch mode"));
            }
        }
        string2 = string2.replace('/', '.');
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
            LauncherHelper.abort(printStream, classNotFoundException, "java.launcher.cls.error1", objectArray);
        }
        LauncherHelper.getMainMethod(printStream, clazz);
        return clazz;
    }

    static Method getMainMethod(PrintStream printStream, Class<?> clazz) {
        String string = x.getName(clazz);
        Method method = null;
        try {
            Object[] objectArray = new Class[1];
            a.arrayStore((Object[])objectArray, (int)0, String[].class);
            aj aj2 = ai.convertArgsAndName(clazz, (String)"main", (Class[])objectArray);
            method = aj2.clazz.getMethod(aj2.name, aj2.args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)string);
            LauncherHelper.abort(printStream, null, "java.launcher.cls.error4", objectArray);
        }
        int n2 = method.getModifiers();
        if (!Modifier.isStatic(n2)) {
            Object[] objectArray = new Object[2];
            a.arrayStore((Object[])objectArray, (int)0, (Object)"static");
            a.arrayStore((Object[])objectArray, (int)1, (Object)string);
            LauncherHelper.abort(printStream, null, "java.launcher.cls.error2", objectArray);
        }
        if (f.ifAcmp(method.getReturnType(), Void.TYPE)) {
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)string);
            LauncherHelper.abort(printStream, null, "java.launcher.cls.error3", objectArray);
        }
        return method;
    }

    static String makePlatformString(boolean bl, byte[] byArray) {
        PrintStream printStream;
        PrintStream printStream2 = printStream = bl ? System.err : System.out;
        if (encoding == null) {
            encoding = System.getProperty(encprop);
            isCharsetSupported = Charset.isSupported(encoding);
        }
        try {
            String string = isCharsetSupported ? new String(byArray, encoding) : new String(byArray);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LauncherHelper.abort(printStream, unsupportedEncodingException, null, new Object[0]);
            return null;
        }
    }

    static String[] expandArgs(String[] stringArray) {
        ArrayList<StdArg> arrayList = new ArrayList<StdArg>();
        for (String string : stringArray) {
            arrayList.add(new StdArg(string));
        }
        return LauncherHelper.expandArgs(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] expandArgs(List<StdArg> list) {
        String string;
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (trace) {
            System.err.println("Incoming arguments:");
        }
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            stringArray2 = (String[])g.convertForCast((Object)((Object)stringArray.next()), StdArg.class);
            if (trace) {
                System.err.println(stringArray2);
            }
            if (((StdArg)((Object)stringArray2)).needsExpansion) {
                File file = new File(((StdArg)((Object)stringArray2)).arg);
                File file2 = file.getParentFile();
                string = file.getName();
                if (file2 == null) {
                    file2 = new File(".");
                }
                try {
                    DirectoryStream<Path> directoryStream;
                    block19: {
                        directoryStream = Files.newDirectoryStream(file2.toPath(), string);
                        Throwable throwable = null;
                        try {
                            int n2 = 0;
                            Iterator<Path> iterator = directoryStream.iterator();
                            while (iterator.hasNext()) {
                                Path path = (Path)g.convertForCast((Object)iterator.next(), Path.class);
                                arrayList.add(path.normalize().toString());
                                ++n2;
                            }
                            if (n2 == 0) {
                                arrayList.add(((StdArg)((Object)stringArray2)).arg);
                            }
                            if (directoryStream == null) continue;
                            if (throwable == null) break block19;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                            }
                            catch (Throwable throwable4) {
                                if (directoryStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                if (throwable == null) {
                                    directoryStream.close();
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                }
                                try {
                                    directoryStream.close();
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                }
                            }
                        }
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    directoryStream.close();
                }
                catch (Exception exception) {
                    arrayList.add(((StdArg)((Object)stringArray2)).arg);
                    if (!trace) continue;
                    System.err.println("Warning: passing argument as-is " + stringArray2);
                    System.err.print(exception);
                }
                continue;
            }
            arrayList.add(((StdArg)((Object)stringArray2)).arg);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (!trace) return stringArray;
        System.err.println("Expanded arguments:");
        stringArray2 = stringArray;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            string = stringArray2[n3];
            System.err.println(string);
            ++n3;
        }
        return stringArray;
    }

    static {
        outBuf = new StringBuilder();
        trace = VM.getSavedProperty(diagprop) != null;
        encoding = null;
        isCharsetSupported = false;
    }

    private static class ResourceBundleHolder
    extends h {
        private static final ResourceBundle RB = ResourceBundle.getBundle("sun.launcher.resources.launcher");

        private ResourceBundleHolder() {
        }

        protected /* synthetic */ ResourceBundleHolder(h h2) {
            super(h2);
        }
    }

    private static enum SizePrefix {
        KILO(1024L, "K"),
        MEGA(0x100000L, "M"),
        GIGA(0x40000000L, "G"),
        TERA(0x10000000000L, "T");

        long size;
        String abbrev;

        private SizePrefix(long l2, String string2) {
            this.size = l2;
            this.abbrev = string2;
        }

        private static String scale(long l2, SizePrefix sizePrefix) {
            return BigDecimal.valueOf(l2).divide(BigDecimal.valueOf(sizePrefix.size), 2, RoundingMode.HALF_EVEN).toPlainString() + sizePrefix.abbrev;
        }

        static String scaleValue(long l2) {
            if (l2 < SizePrefix.MEGA.size) {
                return SizePrefix.scale(l2, KILO);
            }
            if (l2 < SizePrefix.GIGA.size) {
                return SizePrefix.scale(l2, MEGA);
            }
            if (l2 < SizePrefix.TERA.size) {
                return SizePrefix.scale(l2, GIGA);
            }
            return SizePrefix.scale(l2, TERA);
        }

        static /* synthetic */ long _jr$ig$size(Object object) {
            return ((SizePrefix)((Object)object)).size;
        }

        static /* synthetic */ void _jr$ip$size(Object object, long l2) {
            ((SizePrefix)((Object)object)).size = l2;
        }

        static /* synthetic */ String _jr$ig$abbrev(Object object) {
            return ((SizePrefix)((Object)object)).abbrev;
        }

        static /* synthetic */ void _jr$ip$abbrev(Object object, String string) {
            ((SizePrefix)((Object)object)).abbrev = string;
        }
    }

    private static class StdArg
    extends h {
        final String arg;
        final boolean needsExpansion;

        StdArg(String string, boolean bl) {
            this.arg = string;
            this.needsExpansion = bl;
        }

        StdArg(String string) {
            this.arg = string.substring(1);
            this.needsExpansion = string.charAt(0) == 'T';
        }

        public String toString() {
            return "StdArg{arg=" + ((StdArg)((Object)((Object)this))).arg + ", needsExpansion=" + ((StdArg)((Object)((Object)this))).needsExpansion + '}';
        }

        static /* synthetic */ void _jr$ip$arg(Object object, String string) {
            ((StdArg)((Object)object)).arg = string;
        }

        static /* synthetic */ void _jr$ip$needsExpansion(Object object, boolean bl) {
            ((StdArg)((Object)object)).needsExpansion = bl;
        }

        protected /* synthetic */ StdArg(h h2) {
            super(h2);
        }
    }
}

