/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import com.zeroturnaround.jrebelbase.h;

public class FpUtils
extends h {
    static double twoToTheDoubleScaleUp = FpUtils.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = FpUtils.powerOfTwoD(-512);

    private FpUtils() {
    }

    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static int getExponent(float f2) {
        return ((Float.floatToRawIntBits(f2) & 0x7F800000) >> 23) - 127;
    }

    static double powerOfTwoD(int n2) {
        if (!($assertionsDisabled || n2 >= -1022 && n2 <= 1023)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return Double.longBitsToDouble((long)n2 + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n2) {
        if (!($assertionsDisabled || n2 >= -126 && n2 <= 127)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return Float.intBitsToFloat(n2 + 127 << 23 & 0x7F800000);
    }

    public static double rawCopySign(double d, double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & Long.MIN_VALUE | Double.doubleToRawLongBits(d) & Long.MAX_VALUE);
    }

    public static float rawCopySign(float f2, float f3) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(f3) & Integer.MIN_VALUE | Float.floatToRawIntBits(f2) & Integer.MAX_VALUE);
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f2) {
        return Math.abs(f2) <= Float.MAX_VALUE;
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public static boolean isInfinite(float f2) {
        return Float.isInfinite(f2);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float f2) {
        return Float.isNaN(f2);
    }

    public static boolean isUnordered(double d, double d2) {
        return FpUtils.isNaN(d) || FpUtils.isNaN(d2);
    }

    public static boolean isUnordered(float f2, float f3) {
        return FpUtils.isNaN(f2) || FpUtils.isNaN(f3);
    }

    public static int ilogb(double d) {
        int n2 = FpUtils.getExponent(d);
        switch (n2) {
            case 1024: {
                if (FpUtils.isNaN(d)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -1023: {
                if (d == 0.0) {
                    return -268435456;
                }
                long l = Double.doubleToRawLongBits(d);
                if (!$assertionsDisabled && (l &= 0xFFFFFFFFFFFFFL) == 0L) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                while (l < 0x10000000000000L) {
                    l *= 2L;
                    --n2;
                }
                if (!($assertionsDisabled || ++n2 >= -1074 && n2 < -1022)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return n2;
            }
        }
        if (!($assertionsDisabled || n2 >= -1022 && n2 <= 1023)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return n2;
    }

    public static int ilogb(float f2) {
        int n2 = FpUtils.getExponent(f2);
        switch (n2) {
            case 128: {
                if (FpUtils.isNaN(f2)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -127: {
                if (f2 == 0.0f) {
                    return -268435456;
                }
                int n3 = Float.floatToRawIntBits(f2);
                if (!$assertionsDisabled && (n3 &= 0x7FFFFF) == 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                while (n3 < 0x800000) {
                    n3 *= 2;
                    --n2;
                }
                if (!($assertionsDisabled || ++n2 >= -149 && n2 < -126)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return n2;
            }
        }
        if (!($assertionsDisabled || n2 >= -126 && n2 <= 127)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return n2;
    }

    public static double scalb(double d, int n2) {
        int n3 = 0;
        int n4 = 0;
        double d2 = Double.NaN;
        if (n2 < 0) {
            n2 = Math.max(n2, -2099);
            n4 = -512;
            d2 = twoToTheDoubleScaleDown;
        } else {
            n2 = Math.min(n2, 2099);
            n4 = 512;
            d2 = twoToTheDoubleScaleUp;
        }
        int n5 = n2 >> 8 >>> 23;
        n3 = (n2 + n5 & 0x1FF) - n5;
        d *= FpUtils.powerOfTwoD(n3);
        n2 -= n3;
        while (n2 != 0) {
            d *= d2;
            n2 -= n4;
        }
        return d;
    }

    public static float scalb(float f2, int n2) {
        n2 = Math.max(Math.min(n2, 278), -278);
        return (float)((double)f2 * FpUtils.powerOfTwoD(n2));
    }

    public static double nextAfter(double d, double d2) {
        if (FpUtils.isNaN(d) || FpUtils.isNaN(d2)) {
            return d + d2;
        }
        if (d == d2) {
            return d2;
        }
        long l = Double.doubleToRawLongBits(d + 0.0);
        if (d2 > d) {
            l += l >= 0L ? 1L : -1L;
        } else {
            if (!$assertionsDisabled && !(d2 < d)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            l = l > 0L ? --l : (l < 0L ? ++l : -9223372036854775807L);
        }
        return Double.longBitsToDouble(l);
    }

    public static float nextAfter(float f2, double d) {
        if (FpUtils.isNaN(f2) || FpUtils.isNaN(d)) {
            return f2 + (float)d;
        }
        if ((double)f2 == d) {
            return (float)d;
        }
        int n2 = Float.floatToRawIntBits(f2 + 0.0f);
        if (d > (double)f2) {
            n2 += n2 >= 0 ? 1 : -1;
        } else {
            if (!$assertionsDisabled && !(d < (double)f2)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            n2 = n2 > 0 ? --n2 : (n2 < 0 ? ++n2 : -2147483647);
        }
        return Float.intBitsToFloat(n2);
    }

    public static double nextUp(double d) {
        if (FpUtils.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static float nextUp(float f2) {
        if (FpUtils.isNaN(f2) || f2 == Float.POSITIVE_INFINITY) {
            return f2;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2 += 0.0f) + (f2 >= 0.0f ? 1 : -1));
    }

    public static double nextDown(double d) {
        if (FpUtils.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (d > 0.0 ? -1L : 1L));
    }

    public static double nextDown(float f2) {
        if (FpUtils.isNaN(f2) || f2 == Float.NEGATIVE_INFINITY) {
            return f2;
        }
        if (f2 == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2) + (f2 > 0.0f ? -1 : 1));
    }

    public static double copySign(double d, double d2) {
        return FpUtils.rawCopySign(d, FpUtils.isNaN(d2) ? 1.0 : d2);
    }

    public static float copySign(float f2, float f3) {
        return FpUtils.rawCopySign(f2, FpUtils.isNaN(f3) ? 1.0f : f3);
    }

    public static double ulp(double d) {
        int n2 = FpUtils.getExponent(d);
        switch (n2) {
            case 1024: {
                return Math.abs(d);
            }
            case -1023: {
                return Double.MIN_VALUE;
            }
        }
        if (!($assertionsDisabled || n2 <= 1023 && n2 >= -1022)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if ((n2 -= 52) >= -1022) {
            return FpUtils.powerOfTwoD(n2);
        }
        return Double.longBitsToDouble(1L << n2 - -1074);
    }

    public static float ulp(float f2) {
        int n2 = FpUtils.getExponent(f2);
        switch (n2) {
            case 128: {
                return Math.abs(f2);
            }
            case -127: {
                return Float.MIN_VALUE;
            }
        }
        if (!($assertionsDisabled || n2 <= 127 && n2 >= -126)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if ((n2 -= 23) >= -126) {
            return FpUtils.powerOfTwoF(n2);
        }
        return Float.intBitsToFloat(1 << n2 - -149);
    }

    public static double signum(double d) {
        return d == 0.0 || FpUtils.isNaN(d) ? d : FpUtils.copySign(1.0, d);
    }

    public static float signum(float f2) {
        return f2 == 0.0f || FpUtils.isNaN(f2) ? f2 : FpUtils.copySign(1.0f, f2);
    }

    protected /* synthetic */ FpUtils(h h2) {
        super(h2);
    }
}

