/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.MetaIndex;

public class JarIndex
extends h {
    private HashMap indexMap;
    private HashMap jarMap;
    private String[] jarFiles;
    public static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final boolean metaInfFilenames = "true".equals(System.getProperty("sun.misc.JarIndex.metaInfFilenames"));

    public JarIndex() {
        this.indexMap = new HashMap();
        this.jarMap = new HashMap();
    }

    public JarIndex(InputStream inputStream) throws IOException {
        this();
        this.read(inputStream);
    }

    public JarIndex(String[] stringArray) throws IOException {
        this();
        this.jarFiles = stringArray;
        this.parseJars(stringArray);
    }

    public static JarIndex getJarIndex(JarFile jarFile) throws IOException {
        return JarIndex.getJarIndex(jarFile, null);
    }

    public static JarIndex getJarIndex(JarFile jarFile, MetaIndex metaIndex) throws IOException {
        JarIndex jarIndex = null;
        if (metaIndex != null && !metaIndex.mayContain(INDEX_NAME)) {
            return null;
        }
        JarEntry jarEntry = jarFile.getJarEntry(INDEX_NAME);
        if (jarEntry != null) {
            jarIndex = new JarIndex(jarFile.getInputStream(jarEntry));
        }
        return jarIndex;
    }

    public String[] getJarFiles() {
        return this.jarFiles;
    }

    private void addToList(String string, String string2, HashMap hashMap) {
        LinkedList<String> linkedList = (LinkedList<String>)g.convertForCast(hashMap.get(string), LinkedList.class);
        if (linkedList == null) {
            linkedList = new LinkedList<String>();
            linkedList.add(string2);
            hashMap.put(string, linkedList);
        } else if (!linkedList.contains(string2)) {
            linkedList.add(string2);
        }
    }

    public LinkedList get(String string) {
        int n;
        LinkedList linkedList = null;
        linkedList = (LinkedList)g.convertForCast(this.indexMap.get(string), LinkedList.class);
        if (linkedList == null && (n = string.lastIndexOf("/")) != -1) {
            linkedList = (LinkedList)g.convertForCast(this.indexMap.get(string.substring(0, n)), LinkedList.class);
        }
        return linkedList;
    }

    public void add(String string, String string2) {
        int n = string.lastIndexOf("/");
        String string3 = n != -1 ? string.substring(0, n) : string;
        this.addToList(string3, string2, this.indexMap);
        this.addToList(string2, string3, this.jarMap);
    }

    private void addExplicit(String string, String string2) {
        this.addToList(string, string2, this.indexMap);
        this.addToList(string2, string, this.jarMap);
    }

    private void parseJars(String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        String string = null;
        for (int i = 0; i < a.arrayLength((Object[])stringArray); ++i) {
            string = (String)a.arrayLoad((Object[])stringArray, (int)i);
            ZipFile zipFile = new ZipFile(string.replace('/', File.separatorChar));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)g.convertForCast((Object)enumeration.nextElement(), ZipEntry.class);
                String string2 = zipEntry.getName();
                if (string2.equals("META-INF/") || string2.equals(INDEX_NAME) || string2.equals("META-INF/MANIFEST.MF")) continue;
                if (!metaInfFilenames) {
                    this.add(string2, string);
                    continue;
                }
                if (!string2.startsWith("META-INF/")) {
                    this.add(string2, string);
                    continue;
                }
                if (zipEntry.isDirectory()) continue;
                this.addExplicit(string2, string);
            }
            zipFile.close();
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        bufferedWriter.write("JarIndex-Version: 1.0\n\n");
        if (this.jarFiles != null) {
            for (int i = 0; i < a.arrayLength((Object[])this.jarFiles); ++i) {
                String string = (String)a.arrayLoad((Object[])this.jarFiles, (int)i);
                bufferedWriter.write(string + "\n");
                LinkedList linkedList = (LinkedList)g.convertForCast(this.jarMap.get(string), LinkedList.class);
                if (linkedList != null) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        bufferedWriter.write((String)iterator.next() + "\n");
                    }
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
        }
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        String string = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        while ((string = bufferedReader.readLine()) != null && !string.endsWith(".jar")) {
        }
        while (string != null) {
            if (string.length() != 0) {
                if (string.endsWith(".jar")) {
                    string2 = string;
                    vector.add(string2);
                } else {
                    String string3 = string;
                    this.addToList(string3, string2, this.indexMap);
                    this.addToList(string2, string3, this.jarMap);
                }
            }
            string = bufferedReader.readLine();
        }
        this.jarFiles = vector.toArray(new String[vector.size()]);
    }

    public void merge(JarIndex jarIndex, String string) {
        Iterator iterator = this.indexMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            String string2 = (String)entry.getKey();
            LinkedList linkedList = (LinkedList)g.convertForCast(entry.getValue(), LinkedList.class);
            for (String string3 : linkedList) {
                if (string != null) {
                    string3 = string.concat(string3);
                }
                jarIndex.add(string2, string3);
            }
        }
    }

    private static /* synthetic */ void _jr$ip$indexMap(JarIndex jarIndex, HashMap hashMap) {
        jarIndex.indexMap = hashMap;
    }

    private static /* synthetic */ void _jr$ip$jarMap(JarIndex jarIndex, HashMap hashMap) {
        jarIndex.jarMap = hashMap;
    }

    protected /* synthetic */ JarIndex(h h2) {
        super(h2);
    }
}

