/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.ExtensionDependency;
import sun.misc.FileURLMapper;
import sun.misc.InvalidJarIndexException;
import sun.misc.JarIndex;
import sun.misc.JavaUtilZipFileAccess;
import sun.misc.MetaIndex;
import sun.misc.Resource;
import sun.misc.SharedSecrets;
import sun.net.util.URLUtil;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class URLClassPath
extends h {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private static final boolean DEBUG = AccessController.doPrivileged(new GetPropertyAction("sun.misc.URLClassPath.debug")) != null;
    private static final boolean DISABLE_JAR_CHECKING;
    private ArrayList<URL> path;
    Stack<URL> urls;
    ArrayList<Loader> loaders;
    HashMap<String, Loader> lmap;
    private URLStreamHandler jarHandler;
    private boolean closed;

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        this.path = new ArrayList();
        this.urls = new Stack();
        this.loaders = new ArrayList();
        this.lmap = new HashMap();
        this.closed = false;
        for (int i = 0; i < a.arrayLength((Object[])uRLArray); ++i) {
            this.path.add((URL)g.convertForCast((Object)a.arrayLoad((Object[])uRLArray, (int)i), URL.class));
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    @af(modifiers=33)
    public List<IOException> closeLoaders() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.closed) {
                    return Collections.emptyList();
                }
                LinkedList<IOException> linkedList = new LinkedList<IOException>();
                Iterator iterator = ((URLClassPath)((Object)((Object)this))).loaders.iterator();
                while (iterator.hasNext()) {
                    Loader loader = (Loader)g.convertForCast(iterator.next(), Loader.class);
                    try {
                        loader.close();
                    }
                    catch (IOException iOException) {
                        linkedList.add(iOException);
                    }
                }
                this.closed = true;
                return linkedList;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @af(modifiers=33)
    public void addURL(URL uRL) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.closed) {
                    return;
                }
                Object object2 = ah.getMonitor((Object)((URLClassPath)((Object)((Object)this))).urls);
                synchronized (object2) {
                    try {
                        if (uRL == null || this.path.contains(uRL)) {
                            return;
                        }
                        ((URLClassPath)((Object)((Object)this))).urls.add(0, uRL);
                        this.path.add(uRL);
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Object object = ah.getMonitor((Object)((URLClassPath)((Object)((Object)this))).urls);
        synchronized (object) {
            try {
                return (URL[])g.convertForCast((Object)this.path.toArray(new URL[this.path.size()]), URL[].class);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public URL findResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            URL uRL = loader.findResource(string, bl);
            if (uRL != null) {
                return uRL;
            }
            ++n;
        }
        return null;
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        if (DEBUG) {
            System.err.println("URLClassPath.getResource(\"" + string + "\")");
        }
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Enumeration<URL> findResources(String string, boolean bl) {
        return new Enumeration(this, string, bl){
            private int index;
            private URL url;
            final /* synthetic */ String val$name;
            final /* synthetic */ boolean val$check;
            final /* synthetic */ URLClassPath this$0;
            {
                this.this$0 = uRLClassPath;
                this.val$name = string;
                this.val$check = bl;
                this.index = 0;
                this.url = null;
            }

            private boolean next() {
                block2: {
                    if (this.url != null) {
                        return true;
                    }
                    do {
                        1 v0 = this;
                        int n = v0.index;
                        v0.index = n + 1;
                        Loader loader = this.this$0.getLoader(n);
                        if (loader == null) break block2;
                        this.url = loader.findResource((this).val$name, (this).val$check);
                    } while (this.url == null);
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            public URL nextElement() {
                if (!this.next()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            static /* synthetic */ void _jr$ip$val$name(Object object, String string) {
                (object).val$name = string;
            }

            static /* synthetic */ void _jr$ip$val$check(Object object, boolean bl) {
                (object).val$check = bl;
            }

            static /* synthetic */ URLClassPath _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, URLClassPath uRLClassPath) {
                (object).this$0 = uRLClassPath;
            }
        };
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Enumeration<Resource> getResources(String string, boolean bl) {
        return new Enumeration(this, string, bl){
            private int index;
            private Resource res;
            final /* synthetic */ String val$name;
            final /* synthetic */ boolean val$check;
            final /* synthetic */ URLClassPath this$0;
            {
                this.this$0 = uRLClassPath;
                this.val$name = string;
                this.val$check = bl;
                this.index = 0;
                this.res = null;
            }

            private boolean next() {
                block2: {
                    if (this.res != null) {
                        return true;
                    }
                    do {
                        2 v0 = this;
                        int n = v0.index;
                        v0.index = n + 1;
                        Loader loader = this.this$0.getLoader(n);
                        if (loader == null) break block2;
                        this.res = loader.getResource((this).val$name, (this).val$check);
                    } while (this.res == null);
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            public Resource nextElement() {
                if (!this.next()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }

            static /* synthetic */ void _jr$ip$val$name(Object object, String string) {
                (object).val$name = string;
            }

            static /* synthetic */ void _jr$ip$val$check(Object object, boolean bl) {
                (object).val$check = bl;
            }

            static /* synthetic */ URLClassPath _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, URLClassPath uRLClassPath) {
                (object).this$0 = uRLClassPath;
            }
        };
    }

    public Enumeration<Resource> getResources(String string) {
        return this.getResources(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @af(modifiers=34)
    private Loader getLoader(int n) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.closed) {
                    return null;
                }
                while (((URLClassPath)((Object)((Object)this))).loaders.size() < n + 1) {
                    Loader loader;
                    Object object2;
                    block11: {
                        URL uRL;
                        object2 = ah.getMonitor((Object)((URLClassPath)((Object)((Object)this))).urls);
                        synchronized (object2) {
                            try {
                                if (((URLClassPath)((Object)((Object)this))).urls.empty()) {
                                    return null;
                                }
                                uRL = (URL)g.convertForCast(((URLClassPath)((Object)((Object)this))).urls.pop(), URL.class);
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                        object2 = URLUtil.urlNoFragString(uRL);
                        if (((URLClassPath)((Object)((Object)this))).lmap.containsKey(object2)) continue;
                        try {
                            loader = this.getLoader(uRL);
                            URL[] uRLArray = loader.getClassPath();
                            if (uRLArray == null) break block11;
                            this.push(uRLArray);
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    ((URLClassPath)((Object)((Object)this))).loaders.add(loader);
                    ((URLClassPath)((Object)((Object)this))).lmap.put(object2, loader);
                }
                return (Loader)g.convertForCast(((URLClassPath)((Object)((Object)this))).loaders.get(n), Loader.class);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private Loader getLoader(URL uRL) throws IOException {
        try {
            return (Loader)g.convertForCast(AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                final /* synthetic */ URL val$url;
                final /* synthetic */ URLClassPath this$0;
                {
                    this.this$0 = uRLClassPath;
                    this.val$url = uRL;
                }

                public Loader run() throws IOException {
                    String string = (this).val$url.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals((this).val$url.getProtocol())) {
                            return new FileLoader((this).val$url);
                        }
                        return new Loader((this).val$url);
                    }
                    return new JarLoader((this).val$url, this.this$0.jarHandler, ((URLClassPath)((Object)((Object)this.this$0))).lmap);
                }

                static /* synthetic */ void _jr$ip$val$url(Object object, URL uRL) {
                    (object).val$url = uRL;
                }

                static /* synthetic */ URLClassPath _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, URLClassPath uRLClassPath) {
                    (object).this$0 = uRLClassPath;
                }
            }), Loader.class);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] uRLArray) {
        Object object = ah.getMonitor((Object)((URLClassPath)((Object)((Object)this))).urls);
        synchronized (object) {
            try {
                for (int i = a.arrayLength((Object[])uRLArray) - 1; i >= 0; --i) {
                    ((URLClassPath)((Object)((Object)this))).urls.push((URL)g.convertForCast((Object)a.arrayLoad((Object[])uRLArray, (int)i), URL.class));
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        Object[] objectArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            try {
                object = new File(object.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                a.arrayStore((Object[])objectArray, (int)n++, (Object)ParseUtil.fileToEncodedURL((File)object));
            }
            catch (IOException iOException) {}
        }
        if (objectArray.length != n) {
            object = new URL[n];
            a.arraycopy((Object)objectArray, (int)0, (Object)object, (int)0, (int)n);
            objectArray = object;
        }
        return objectArray;
    }

    public URL checkURL(URL uRL) {
        try {
            URLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static void check(URL uRL) throws IOException {
        URLConnection uRLConnection;
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = (uRLConnection = uRL.openConnection()).getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (g.convertForInstanceOf((Object)permission, SocketPermission.class) instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    URL uRL2 = uRL;
                    if (g.convertForInstanceOf((Object)((Object)uRLConnection), JarURLConnection.class) instanceof JarURLConnection) {
                        uRL2 = ((JarURLConnection)((Object)g.convertForCast((Object)((Object)uRLConnection), JarURLConnection.class))).getJarFileURL();
                    }
                    securityManager.checkConnect(uRL2.getHost(), uRL2.getPort());
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
            }
        }
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.misc.URLClassPath.disableJarChecking"));
        DISABLE_JAR_CHECKING = string != null ? string.equals("true") || string.equals("") : false;
    }

    private static /* synthetic */ void _jr$ip$path(URLClassPath uRLClassPath, ArrayList arrayList) {
        uRLClassPath.path = arrayList;
    }

    static /* synthetic */ void _jr$ip$urls(Object object, Stack stack) {
        ((URLClassPath)((Object)object)).urls = stack;
    }

    static /* synthetic */ void _jr$ip$loaders(Object object, ArrayList arrayList) {
        ((URLClassPath)((Object)object)).loaders = arrayList;
    }

    static /* synthetic */ void _jr$ip$lmap(Object object, HashMap hashMap) {
        ((URLClassPath)((Object)object)).lmap = hashMap;
    }

    private static /* synthetic */ void _jr$ip$jarHandler(URLClassPath uRLClassPath, URLStreamHandler uRLStreamHandler) {
        uRLClassPath.jarHandler = uRLStreamHandler;
    }

    protected /* synthetic */ URLClassPath(h h2) {
        super(h2);
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("url"));
            }
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            this.dir = new File(string).getCanonicalFile();
        }

        @Override
        URL findResource(String string, boolean bl) {
            Resource resource = this.getResource(string, bl);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), ".");
                URL uRL2 = new URL(this.getBaseURL(), ParseUtil.encodePath(string, false));
                if (!uRL2.getFile().startsWith(uRL.getFile())) {
                    return null;
                }
                if (bl) {
                    URLClassPath.check(uRL2);
                }
                if (string.indexOf("..") != -1) {
                    file = new File(this.dir, string.replace('/', File.separatorChar)).getCanonicalFile();
                    if (!file.getPath().startsWith(this.dir.getPath())) {
                        return null;
                    }
                } else {
                    file = new File(this.dir, string.replace('/', File.separatorChar));
                }
                if (file.exists()) {
                    return new /* Unavailable Anonymous Inner Class!! */;
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }

        private static /* synthetic */ void _jr$ip$dir(FileLoader fileLoader, File file) {
            fileLoader.dir = file;
        }

        protected /* synthetic */ FileLoader(h h2) {
            super(h2);
        }
    }

    static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private JarIndex index;
        private MetaIndex metaIndex;
        private URLStreamHandler handler;
        private HashMap<String, Loader> lmap;
        private boolean closed;
        private static final JavaUtilZipFileAccess zipAccess = SharedSecrets.getJavaUtilZipFileAccess();

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler, HashMap<String, Loader> hashMap) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/", uRLStreamHandler));
            this.closed = false;
            this.csu = uRL;
            this.handler = uRLStreamHandler;
            this.lmap = hashMap;
            if (!this.isOptimizable(uRL)) {
                this.ensureOpen();
            } else {
                String string = uRL.getFile();
                if (string != null) {
                    string = ParseUtil.decode(string);
                    File file = new File(string);
                    this.metaIndex = MetaIndex.forJar(file);
                    if (this.metaIndex != null && !file.exists()) {
                        this.metaIndex = null;
                    }
                }
                if (this.metaIndex == null) {
                    this.ensureOpen();
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ensureOpen();
                this.jar.close();
            }
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private boolean isOptimizable(URL uRL) {
            return "file".equals(uRL.getProtocol());
        }

        private void ensureOpen() throws IOException {
            if (this.jar == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                        final /* synthetic */ JarLoader this$0;
                        {
                            this.this$0 = jarLoader;
                        }

                        public Void run() throws IOException {
                            if (DEBUG) {
                                System.err.println("Opening " + this.this$0.csu);
                                Thread.dumpStack();
                            }
                            JarLoader.access$502(this.this$0, this.this$0.getJarFile(this.this$0.csu));
                            JarLoader.access$702(this.this$0, JarIndex.getJarIndex(this.this$0.jar, this.this$0.metaIndex));
                            if (this.this$0.index != null) {
                                Object[] objectArray = this.this$0.index.getJarFiles();
                                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                                    try {
                                        URL uRL = new URL(this.this$0.csu, (String)a.arrayLoad((Object[])objectArray, (int)i));
                                        String string = URLUtil.urlNoFragString(uRL);
                                        if (this.this$0.lmap.containsKey(string)) continue;
                                        this.this$0.lmap.put(string, null);
                                        continue;
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }

                        static /* synthetic */ JarLoader _jr$ig$this$0(Object object) {
                            return (object).this$0;
                        }

                        static /* synthetic */ void _jr$ip$this$0(Object object, JarLoader jarLoader) {
                            (object).this$0 = jarLoader;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
                }
            }
            Object var3_2 = null;
            this.index = null;
        }

        static JarFile checkJar(JarFile jarFile) throws IOException {
            if (System.getSecurityManager() != null && !DISABLE_JAR_CHECKING && !zipAccess.startsWithLocHeader((ZipFile)jarFile)) {
                IOException iOException = new IOException("Invalid Jar file");
                try {
                    jarFile.close();
                }
                catch (IOException iOException2) {
                    iOException.addSuppressed(iOException2);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
            }
            return jarFile;
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if (this.isOptimizable(uRL)) {
                FileURLMapper fileURLMapper = new FileURLMapper(uRL);
                if (!fileURLMapper.exists()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException(fileURLMapper.getPath()));
                }
                return JarLoader.checkJar(new JarFile(fileURLMapper.getPath()));
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            JarFile jarFile = ((JarURLConnection)((Object)g.convertForCast((Object)((Object)uRLConnection), JarURLConnection.class))).getJarFile();
            return JarLoader.checkJar(jarFile);
        }

        JarIndex getIndex() {
            try {
                this.ensureOpen();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InternalError)g.convertForCast((Object)new InternalError().initCause(iOException), InternalError.class)));
            }
            return this.index;
        }

        Resource checkResource(String string, boolean bl, JarEntry jarEntry) {
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), ParseUtil.encodePath(string, false));
                if (bl) {
                    URLClassPath.check(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (AccessControlException accessControlException) {
                return null;
            }
            return new Resource(this, string, uRL, jarEntry){
                final /* synthetic */ String val$name;
                final /* synthetic */ URL val$url;
                final /* synthetic */ JarEntry val$entry;
                final /* synthetic */ JarLoader this$0;
                {
                    this.this$0 = jarLoader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$entry = jarEntry;
                }

                @Override
                public String getName() {
                    return ((Object)((Object)this)).val$name;
                }

                @Override
                public URL getURL() {
                    return ((Object)((Object)this)).val$url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return this.this$0.csu;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return this.this$0.jar.getInputStream(((Object)((Object)this)).val$entry);
                }

                @Override
                public int getContentLength() {
                    return (int)((Object)((Object)this)).val$entry.getSize();
                }

                @Override
                public Manifest getManifest() throws IOException {
                    return this.this$0.jar.getManifest();
                }

                @Override
                public Certificate[] getCertificates() {
                    return ((Object)((Object)this)).val$entry.getCertificates();
                }

                @Override
                public CodeSigner[] getCodeSigners() {
                    return ((Object)((Object)this)).val$entry.getCodeSigners();
                }

                static /* synthetic */ void _jr$ip$val$name(Object object, String string) {
                    ((Object)object).val$name = string;
                }

                static /* synthetic */ void _jr$ip$val$url(Object object, URL uRL) {
                    ((Object)object).val$url = uRL;
                }

                static /* synthetic */ void _jr$ip$val$entry(Object object, JarEntry jarEntry) {
                    ((Object)object).val$entry = jarEntry;
                }

                static /* synthetic */ JarLoader _jr$ig$this$0(Object object) {
                    return ((Object)object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, JarLoader jarLoader) {
                    ((Object)object).this$0 = jarLoader;
                }
            };
        }

        boolean validIndex(String string) {
            String string2 = string;
            int n = string.lastIndexOf("/");
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            Enumeration<JarEntry> enumeration = this.jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)g.convertForCast((Object)enumeration.nextElement(), ZipEntry.class);
                String string3 = zipEntry.getName();
                n = string3.lastIndexOf("/");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if (!string3.equals(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        URL findResource(String string, boolean bl) {
            Resource resource = this.getResource(string, bl);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(String string, boolean bl) {
            if (this.metaIndex != null && !this.metaIndex.mayContain(string)) {
                return null;
            }
            try {
                this.ensureOpen();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InternalError)g.convertForCast((Object)new InternalError().initCause(iOException), InternalError.class)));
            }
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                return this.checkResource(string, bl, jarEntry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return this.getResource(string, bl, hashSet);
        }

        Resource getResource(String string, boolean bl, Set<String> set) {
            boolean bl2 = false;
            int n = 0;
            LinkedList linkedList = null;
            linkedList = this.index.get(string);
            if (linkedList == null) {
                return null;
            }
            do {
                Object[] objectArray = linkedList.toArray();
                int n2 = linkedList.size();
                while (n < n2) {
                    Resource resource;
                    boolean bl3;
                    h h2;
                    JarLoader jarLoader;
                    URL uRL;
                    block12: {
                        String string2 = (String)a.arrayLoad((Object[])objectArray, (int)n++);
                        try {
                            uRL = new URL(this.csu, string2);
                            String string3 = URLUtil.urlNoFragString(uRL);
                            jarLoader = (JarLoader)g.convertForCast(this.lmap.get(string3), JarLoader.class);
                            if (jarLoader != null) break block12;
                            jarLoader = (JarLoader)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), JarLoader.class);
                            h2 = jarLoader.getIndex();
                            if (h2 != null) {
                                int n3 = string2.lastIndexOf("/");
                                h2.merge(this.index, n3 == -1 ? null : string2.substring(0, n3 + 1));
                            }
                            this.lmap.put(string3, jarLoader);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            continue;
                        }
                    }
                    boolean bl4 = bl3 = !set.add(URLUtil.urlNoFragString(uRL));
                    if (!bl3) {
                        try {
                            jarLoader.ensureOpen();
                        }
                        catch (IOException iOException) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InternalError)g.convertForCast((Object)new InternalError().initCause(iOException), InternalError.class)));
                        }
                        h2 = jarLoader.jar.getJarEntry(string);
                        if (h2 != null) {
                            return jarLoader.checkResource(string, bl, (JarEntry)h2);
                        }
                        if (!jarLoader.validIndex(string)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidJarIndexException("Invalid index"));
                        }
                    }
                    if (bl3 || !f.ifAcmp((Object)jarLoader, (Object)this) || jarLoader.getIndex() == null || (resource = jarLoader.getResource(string, bl, set)) == null) continue;
                    return resource;
                }
            } while (n < (linkedList = this.index.get(string)).size());
            return null;
        }

        @Override
        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            Manifest manifest;
            if (this.index != null) {
                return null;
            }
            if (this.metaIndex != null) {
                return null;
            }
            this.ensureOpen();
            this.parseExtensionsDependencies();
            if (SharedSecrets.javaUtilJarAccess().jarFileHasClassPathAttribute(this.jar) && (manifest = this.jar.getManifest()) != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        private void parseExtensionsDependencies() throws IOException {
            ExtensionDependency.checkExtensionsDependencies(this.jar);
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Object[] objectArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                a.arrayStore((Object[])objectArray, (int)n, (Object)new URL(uRL, string2));
                ++n;
            }
            return objectArray;
        }

        static /* synthetic */ JarFile access$502(JarLoader jarLoader, JarFile jarFile) {
            JarFile jarFile2 = jarFile;
            jarLoader.jar = jarFile2;
            return jarFile2;
        }

        static /* synthetic */ JarIndex access$702(JarLoader jarLoader, JarIndex jarIndex) {
            JarIndex jarIndex2 = jarIndex;
            jarLoader.index = jarIndex2;
            return jarIndex2;
        }

        static /* synthetic */ URLStreamHandler access$1100(JarLoader jarLoader) {
            return jarLoader.handler;
        }

        private static /* synthetic */ void _jr$ip$csu(JarLoader jarLoader, URL uRL) {
            jarLoader.csu = uRL;
        }

        private static /* synthetic */ void _jr$ip$metaIndex(JarLoader jarLoader, MetaIndex metaIndex) {
            jarLoader.metaIndex = metaIndex;
        }

        private static /* synthetic */ void _jr$ip$handler(JarLoader jarLoader, URLStreamHandler uRLStreamHandler) {
            jarLoader.handler = uRLStreamHandler;
        }

        private static /* synthetic */ void _jr$ip$lmap(JarLoader jarLoader, HashMap hashMap) {
            jarLoader.lmap = hashMap;
        }

        protected /* synthetic */ JarLoader(h h2) {
            super(h2);
        }
    }

    private static class Loader
    extends h
    implements Closeable {
        private final URL base;
        private JarFile jarfile;

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL findResource(String string, boolean bl) {
            URL uRL;
            try {
                uRL = new URL(this.base, ParseUtil.encodePath(string, false));
            }
            catch (MalformedURLException malformedURLException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("name"));
            }
            try {
                URLConnection uRLConnection;
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if (g.convertForInstanceOf((Object)((Object)(uRLConnection = uRL.openConnection())), HttpURLConnection.class) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)((Object)g.convertForCast((Object)((Object)uRLConnection), HttpURLConnection.class));
                    httpURLConnection.setRequestMethod("HEAD");
                    if (httpURLConnection.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                return uRL;
            }
            catch (Exception exception) {
                return null;
            }
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, ParseUtil.encodePath(string, false));
            }
            catch (MalformedURLException malformedURLException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("name"));
            }
            try {
                if (bl) {
                    URLClassPath.check(uRL);
                }
                uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                if (g.convertForInstanceOf((Object)((Object)uRLConnection), JarURLConnection.class) instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)((Object)g.convertForCast((Object)((Object)uRLConnection), JarURLConnection.class));
                    this.jarfile = JarLoader.checkJar(jarURLConnection.getJarFile());
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        @Override
        public void close() throws IOException {
            if (this.jarfile != null) {
                this.jarfile.close();
            }
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        static /* synthetic */ URL access$200(Loader loader) {
            return loader.base;
        }

        private static /* synthetic */ void _jr$ip$base(Loader loader, URL uRL) {
            loader.base = uRL;
        }

        protected /* synthetic */ Loader(h h2) {
            super(h2);
        }
    }
}

