/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import sun.security.action.GetIntegerAction;

public final class InetAddressCachePolicy
extends h {
    private static final String cachePolicyProp = "networkaddress.cache.ttl";
    private static final String cachePolicyPropFallback = "sun.net.inetaddr.ttl";
    private static final String negativeCachePolicyProp = "networkaddress.cache.negative.ttl";
    private static final String negativeCachePolicyPropFallback = "sun.net.inetaddr.negative.ttl";
    public static final int FOREVER = -1;
    public static final int NEVER = 0;
    public static final int DEFAULT_POSITIVE = 30;
    private static int cachePolicy = -1;
    private static int negativeCachePolicy = 0;
    private static boolean propertySet;
    private static boolean propertyNegativeSet;

    public static synchronized int get() {
        return cachePolicy;
    }

    public static synchronized int getNegative() {
        return negativeCachePolicy;
    }

    public static synchronized void setIfNotSet(int n2) {
        if (!propertySet) {
            InetAddressCachePolicy.checkValue(n2, cachePolicy);
            cachePolicy = n2;
        }
    }

    public static synchronized void setNegativeIfNotSet(int n2) {
        if (!propertyNegativeSet) {
            negativeCachePolicy = n2;
        }
    }

    private static void checkValue(int n2, int n3) {
        if (n2 == -1) {
            return;
        }
        if (n3 == -1 || n2 < n3 || n2 < -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("can't make InetAddress cache more lax"));
        }
    }

    static {
        Integer n2 = null;
        try {
            n2 = new Integer((String)AccessController.doPrivileged(new PrivilegedAction(){

                public String run() {
                    return Security.getProperty(InetAddressCachePolicy.cachePolicyProp);
                }
            }));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 != null) {
            cachePolicy = n2;
            if (cachePolicy < 0) {
                cachePolicy = -1;
            }
            propertySet = true;
        } else {
            n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction(cachePolicyPropFallback));
            if (n2 != null) {
                cachePolicy = n2;
                if (cachePolicy < 0) {
                    cachePolicy = -1;
                }
                propertySet = true;
            } else if (System.getSecurityManager() == null) {
                cachePolicy = 30;
            }
        }
        try {
            n2 = new Integer((String)AccessController.doPrivileged(new PrivilegedAction(){

                public String run() {
                    return Security.getProperty(InetAddressCachePolicy.negativeCachePolicyProp);
                }
            }));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 != null) {
            negativeCachePolicy = n2;
            if (negativeCachePolicy < 0) {
                negativeCachePolicy = -1;
            }
            propertyNegativeSet = true;
        } else {
            n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction(negativeCachePolicyPropFallback));
            if (n2 != null) {
                negativeCachePolicy = n2;
                if (negativeCachePolicy < 0) {
                    negativeCachePolicy = -1;
                }
                propertyNegativeSet = true;
            }
        }
    }
}

