/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.ProgressSource;
import sun.net.www.http.ChunkedInputStream;

public class MeteredStream
extends FilterInputStream {
    protected boolean closed;
    protected long expected;
    protected long count;
    protected long markedCount;
    protected int markLimit;
    protected ProgressSource pi;

    public MeteredStream(InputStream inputStream, ProgressSource progressSource, long l) {
        super(inputStream);
        this.closed = false;
        this.count = 0L;
        this.markedCount = 0L;
        this.markLimit = -1;
        this.pi = progressSource;
        this.expected = l;
        if (progressSource != null) {
            progressSource.updateProgress(0L, l);
        }
    }

    private final void justRead(long l) throws IOException {
        if (l == -1L) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        MeteredStream meteredStream = this;
        ((MeteredStream)meteredStream).count = ((MeteredStream)meteredStream).count + l;
        if (((MeteredStream)this).count - ((MeteredStream)this).markedCount > (long)((MeteredStream)this).markLimit) {
            ((MeteredStream)this).markLimit = -1;
        }
        if (((MeteredStream)this).pi != null) {
            ((MeteredStream)this).pi.updateProgress(((MeteredStream)this).count, ((MeteredStream)this).expected);
        }
        if (this.isMarked()) {
            return;
        }
        if (((MeteredStream)this).expected > 0L && ((MeteredStream)this).count >= ((MeteredStream)this).expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (((MeteredStream)this).markLimit < 0) {
            return false;
        }
        return ((MeteredStream)this).count - ((MeteredStream)this).markedCount <= (long)((MeteredStream)this).markLimit;
    }

    @Override
    @af(modifiers=33)
    public int read() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((MeteredStream)this).closed) {
                    return -1;
                }
                int n2 = MeteredStream._jr$ig$in(this).read();
                if (n2 != -1) {
                    this.justRead(1L);
                } else {
                    this.justRead(n2);
                }
                return n2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((MeteredStream)this).closed) {
                    return -1;
                }
                int n4 = MeteredStream._jr$ig$in(this).read(byArray, n2, n3);
                this.justRead(n4);
                return n4;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public long skip(long l) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((MeteredStream)this).closed) {
                    return 0L;
                }
                if (g.convertForInstanceOf((Object)MeteredStream._jr$ig$in(this), ChunkedInputStream.class) instanceof ChunkedInputStream) {
                    l = MeteredStream._jr$ig$in(this).skip(l);
                } else {
                    long l2 = l > ((MeteredStream)this).expected - ((MeteredStream)this).count ? ((MeteredStream)this).expected - ((MeteredStream)this).count : l;
                    l = MeteredStream._jr$ig$in(this).skip(l2);
                }
                this.justRead(l);
                return l;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (((MeteredStream)this).closed) {
            return;
        }
        if (((MeteredStream)this).pi != null) {
            ((MeteredStream)this).pi.finishTracking();
        }
        ((MeteredStream)this).closed = true;
        MeteredStream._jr$ig$in(this).close();
    }

    @Override
    @af(modifiers=33)
    public int available() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return ((MeteredStream)this).closed ? 0 : MeteredStream._jr$ig$in(this).available();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void mark(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((MeteredStream)this).closed) {
                    return;
                }
                super.mark(n2);
                ((MeteredStream)this).markedCount = ((MeteredStream)this).count;
                ((MeteredStream)this).markLimit = n2;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void reset() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((MeteredStream)this).closed) {
                    return;
                }
                if (!this.isMarked()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Resetting to an invalid mark"));
                }
                ((MeteredStream)this).count = ((MeteredStream)this).markedCount;
                super.reset();
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public boolean markSupported() {
        if (((MeteredStream)this).closed) {
            return false;
        }
        return super.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (!this._jr$iCur()) {
            return;
        }
        try {
            this.close();
            if (((MeteredStream)this).pi != null) {
                ((MeteredStream)this).pi.close();
            }
        }
        catch (Throwable throwable) {
            super.finalize();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        super.finalize();
    }

    protected static /* synthetic */ void _jr$ip$expected(Object object, long l) {
        ((MeteredStream)object).expected = l;
    }

    protected static /* synthetic */ void _jr$ip$pi(Object object, ProgressSource progressSource) {
        ((MeteredStream)object).pi = progressSource;
    }

    protected /* synthetic */ MeteredStream(h h2) {
        super(h2);
    }
}

