/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.security.Permission;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;

public class FileURLConnection
extends URLConnection {
    static String CONTENT_LENGTH = "content-length";
    static String CONTENT_TYPE = "content-type";
    static String TEXT_PLAIN = "text/plain";
    static String LAST_MODIFIED = "last-modified";
    String contentType;
    InputStream is;
    File file;
    String filename;
    boolean isDirectory;
    boolean exists;
    List<String> files;
    long length;
    long lastModified;
    private boolean initializedHeaders;
    Permission permission;

    protected FileURLConnection(URL uRL, File file) {
        super(uRL);
        this.isDirectory = false;
        this.exists = false;
        this.length = -1L;
        this.lastModified = 0L;
        this.initializedHeaders = false;
        this.file = file;
    }

    @Override
    public void connect() throws IOException {
        if (!FileURLConnection._jr$ig$connected((Object)this)) {
            try {
                ((FileURLConnection)((Object)((Object)this))).filename = ((FileURLConnection)((Object)((Object)this))).file.toString();
                ((FileURLConnection)((Object)((Object)this))).isDirectory = ((FileURLConnection)((Object)((Object)this))).file.isDirectory();
                if (((FileURLConnection)((Object)((Object)this))).isDirectory) {
                    String[] stringArray = ((FileURLConnection)((Object)((Object)this))).file.list();
                    if (stringArray == null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException(((FileURLConnection)((Object)((Object)this))).filename + " exists, but is not accessible"));
                    }
                    ((FileURLConnection)((Object)((Object)this))).files = Arrays.asList(stringArray);
                } else {
                    ((FileURLConnection)((Object)((Object)this))).is = new BufferedInputStream(new FileInputStream(((FileURLConnection)((Object)((Object)this))).filename));
                    boolean bl = ProgressMonitor.getDefault().shouldMeterInput(FileURLConnection._jr$ig$url((Object)this), "GET");
                    if (bl) {
                        ProgressSource progressSource = new ProgressSource(FileURLConnection._jr$ig$url((Object)this), "GET", ((FileURLConnection)((Object)((Object)this))).file.length());
                        ((FileURLConnection)((Object)((Object)this))).is = new MeteredStream(((FileURLConnection)((Object)((Object)this))).is, progressSource, ((FileURLConnection)((Object)((Object)this))).file.length());
                    }
                }
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
            }
            FileURLConnection._jr$ip$connected((Object)this, true);
        }
    }

    private void initializeHeaders() {
        try {
            this.connect();
            ((FileURLConnection)((Object)((Object)this))).exists = ((FileURLConnection)((Object)((Object)this))).file.exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.initializedHeaders || !((FileURLConnection)((Object)((Object)this))).exists) {
            ((FileURLConnection)((Object)((Object)this))).length = ((FileURLConnection)((Object)((Object)this))).file.length();
            ((FileURLConnection)((Object)((Object)this))).lastModified = ((FileURLConnection)((Object)((Object)this))).file.lastModified();
            if (!((FileURLConnection)((Object)((Object)this))).isDirectory) {
                FileNameMap fileNameMap = java.net.URLConnection.getFileNameMap();
                ((FileURLConnection)((Object)((Object)this))).contentType = fileNameMap.getContentTypeFor(((FileURLConnection)((Object)((Object)this))).filename);
                if (((FileURLConnection)((Object)((Object)this))).contentType != null) {
                    FileURLConnection._jr$ig$properties((Object)this).add(CONTENT_TYPE, ((FileURLConnection)((Object)((Object)this))).contentType);
                }
                FileURLConnection._jr$ig$properties((Object)this).add(CONTENT_LENGTH, String.valueOf(((FileURLConnection)((Object)((Object)this))).length));
                if (((FileURLConnection)((Object)((Object)this))).lastModified != 0L) {
                    Date date = new Date(((FileURLConnection)((Object)((Object)this))).lastModified);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    FileURLConnection._jr$ig$properties((Object)this).add(LAST_MODIFIED, simpleDateFormat.format(date));
                }
            } else {
                FileURLConnection._jr$ig$properties((Object)this).add(CONTENT_TYPE, TEXT_PLAIN);
            }
            this.initializedHeaders = true;
        }
    }

    @Override
    public String getHeaderField(String string) {
        this.initializeHeaders();
        return super.getHeaderField(string);
    }

    @Override
    public String getHeaderField(int n2) {
        this.initializeHeaders();
        return super.getHeaderField(n2);
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        if (((FileURLConnection)((Object)((Object)this))).length > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)((FileURLConnection)((Object)((Object)this))).length;
    }

    @Override
    public long getContentLengthLong() {
        this.initializeHeaders();
        return ((FileURLConnection)((Object)((Object)this))).length;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n2);
    }

    @Override
    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    @Override
    public long getLastModified() {
        this.initializeHeaders();
        return ((FileURLConnection)((Object)((Object)this))).lastModified;
    }

    @Override
    @af(modifiers=33)
    public InputStream getInputStream() throws IOException {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.connect();
                if (((FileURLConnection)((Object)((Object)this))).is == null) {
                    if (((FileURLConnection)((Object)((Object)this))).isDirectory) {
                        FileNameMap fileNameMap = java.net.URLConnection.getFileNameMap();
                        StringBuffer stringBuffer = new StringBuffer();
                        if (((FileURLConnection)((Object)((Object)this))).files == null) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException(((FileURLConnection)((Object)((Object)this))).filename));
                        }
                        Collections.sort(((FileURLConnection)((Object)((Object)this))).files, Collator.getInstance());
                        for (int i = 0; i < ((FileURLConnection)((Object)((Object)this))).files.size(); ++i) {
                            String string = (String)((FileURLConnection)((Object)((Object)this))).files.get(i);
                            stringBuffer.append(string);
                            stringBuffer.append("\n");
                        }
                        ((FileURLConnection)((Object)((Object)this))).is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
                    } else {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException(((FileURLConnection)((Object)((Object)this))).filename));
                    }
                }
                return ((FileURLConnection)((Object)((Object)this))).is;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public Permission getPermission() throws IOException {
        if (((FileURLConnection)((Object)((Object)this))).permission == null) {
            String string = ParseUtil.decode(FileURLConnection._jr$ig$url((Object)this).getPath());
            if (File.separatorChar == '/') {
                ((FileURLConnection)((Object)((Object)this))).permission = new FilePermission(string, "read");
            } else {
                ((FileURLConnection)((Object)((Object)this))).permission = new FilePermission(string.replace('/', File.separatorChar), "read");
            }
        }
        return ((FileURLConnection)((Object)((Object)this))).permission;
    }

    static /* synthetic */ void _jr$ip$file(Object object, File file) {
        ((FileURLConnection)((Object)object)).file = file;
    }

    protected /* synthetic */ FileURLConnection(h h2) {
        super(h2);
    }
}

