/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarFileFactory;

public class JarURLConnection
extends java.net.JarURLConnection {
    private static final boolean debug = false;
    private static final JarFileFactory factory = JarFileFactory.getInstance();
    private URL jarFileURL;
    private Permission permission;
    private URLConnection jarFileURLConnection;
    private String entryName;
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;

    public JarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL);
        this.jarFileURL = this.getJarFileURL();
        this.jarFileURLConnection = this.jarFileURL.openConnection();
        this.entryName = this.getEntryName();
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    @Override
    public void connect() throws IOException {
        if (!JarURLConnection._jr$ig$connected((Object)this)) {
            this.jarFile = JarURLConnection.factory.get(this.getJarFileURL(), this.getUseCaches());
            if (this.getUseCaches()) {
                this.jarFileURLConnection = JarURLConnection.factory.getConnection(this.jarFile);
            }
            if (this.entryName != null) {
                this.jarEntry = (JarEntry)g.convertForCast((Object)this.jarFile.getEntry(this.entryName), JarEntry.class);
                if (this.jarEntry == null) {
                    try {
                        if (!this.getUseCaches()) {
                            this.jarFile.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName()));
                }
            }
            JarURLConnection._jr$ip$connected((Object)this, true);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        JarURLInputStream jarURLInputStream = null;
        if (this.entryName == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("no entry name specified"));
        }
        if (this.jarEntry == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName()));
        }
        jarURLInputStream = new JarURLInputStream(this, this.jarFile.getInputStream(this.jarEntry));
        return jarURLInputStream;
    }

    @Override
    public int getContentLength() {
        long l2 = this.getContentLengthLong();
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    @Override
    public long getContentLengthLong() {
        long l2 = -1L;
        try {
            this.connect();
            l2 = this.jarEntry == null ? this.jarFileURLConnection.getContentLengthLong() : this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l2;
    }

    @Override
    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        object = this.entryName == null ? this.jarFile : super.getContent();
        return object;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream inputStream = this.jarFile.getInputStream(this.jarEntry);
                    this.contentType = JarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = JarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    @Override
    public String getHeaderField(String string) {
        return this.jarFileURLConnection.getHeaderField(string);
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.jarFileURLConnection.setRequestProperty(string, string2);
    }

    @Override
    public String getRequestProperty(String string) {
        return this.jarFileURLConnection.getRequestProperty(string);
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.jarFileURLConnection.addRequestProperty(string, string2);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.jarFileURLConnection.getRequestProperties();
    }

    @Override
    public void setAllowUserInteraction(boolean bl) {
        this.jarFileURLConnection.setAllowUserInteraction(bl);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean bl) {
        this.jarFileURLConnection.setUseCaches(bl);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long l2) {
        this.jarFileURLConnection.setIfModifiedSince(l2);
    }

    @Override
    public void setDefaultUseCaches(boolean bl) {
        this.jarFileURLConnection.setDefaultUseCaches(bl);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    private static /* synthetic */ URL _jr$ig$jarFileURL(JarURLConnection jarURLConnection) {
        return jarURLConnection.jarFileURL;
    }

    private static /* synthetic */ void _jr$ip$jarFileURL(JarURLConnection jarURLConnection, URL uRL) {
        jarURLConnection.jarFileURL = uRL;
    }

    private static /* synthetic */ Permission _jr$ig$permission(JarURLConnection jarURLConnection) {
        return jarURLConnection.permission;
    }

    private static /* synthetic */ void _jr$ip$permission(JarURLConnection jarURLConnection, Permission permission) {
        jarURLConnection.permission = permission;
    }

    private static /* synthetic */ void _jr$ip$entryName(JarURLConnection jarURLConnection, String string) {
        jarURLConnection.entryName = string;
    }

    protected /* synthetic */ JarURLConnection(h h2) {
        super(h2);
    }

    class JarURLInputStream
    extends FilterInputStream {
        final /* synthetic */ JarURLConnection this$0;

        JarURLInputStream(JarURLConnection jarURLConnection, InputStream inputStream) {
            this.this$0 = jarURLConnection;
            super(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
                if (((JarURLInputStream)this).this$0.getUseCaches()) return;
            }
            catch (Throwable throwable) {
                if (((JarURLInputStream)this).this$0.getUseCaches()) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                ((JarURLInputStream)this).this$0.jarFile.close();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            ((JarURLInputStream)this).this$0.jarFile.close();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, JarURLConnection jarURLConnection) {
            ((JarURLInputStream)object).this$0 = jarURLConnection;
        }

        protected /* synthetic */ JarURLInputStream(h h2) {
            super(h2);
        }
    }
}

