/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class URLJarFile
extends JarFile {
    private static URLJarFileCallBack callback = null;
    private URLJarFileCloseController closeController;
    private static int BUF_SIZE = 2048;
    private Manifest superMan;
    private Attributes superAttr;
    private Map<String, Attributes> superEntries;

    static JarFile getJarFile(URL uRL) throws IOException {
        return URLJarFile.getJarFile(uRL, null);
    }

    static JarFile getJarFile(URL uRL, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        if (URLJarFile.isFileURL(uRL)) {
            return new URLJarFile(uRL, uRLJarFileCloseController);
        }
        return URLJarFile.retrieve(uRL, uRLJarFileCloseController);
    }

    public URLJarFile(File file) throws IOException {
        this(file, (URLJarFileCloseController)null);
    }

    public URLJarFile(File file, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        super(file, true, 5);
        this.closeController = null;
        this.closeController = uRLJarFileCloseController;
    }

    private URLJarFile(URL uRL, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        super(ParseUtil.decode(uRL.getFile()));
        this.closeController = null;
        this.closeController = uRLJarFileCloseController;
    }

    private static boolean isFileURL(URL uRL) {
        String string;
        return uRL.getProtocol().equalsIgnoreCase("file") && ((string = uRL.getHost()) == null || string.equals("") || string.equals("~") || string.equalsIgnoreCase("localhost"));
    }

    @Override
    protected void finalize() throws IOException {
        if (!this._jr$iCur()) {
            return;
        }
        this.close();
    }

    @Override
    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            if (g.convertForInstanceOf((Object)zipEntry, JarEntry.class) instanceof JarEntry) {
                return new URLJarFileEntry(this, (JarEntry)g.convertForCast((Object)zipEntry, JarEntry.class));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError(super.getClass() + " returned unexpected entry type " + zipEntry.getClass()));
        }
        return null;
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (!this.isSuperMan()) {
            return null;
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putAll((Map<?, ?>)((Map)g.convertForCast((Object)this.superAttr.clone(), Map.class)));
        if (this.superEntries != null) {
            Map<String, Attributes> map = manifest.getEntries();
            for (String string : this.superEntries.keySet()) {
                Attributes attributes2 = (Attributes)g.convertForCast(this.superEntries.get(string), Attributes.class);
                map.put(string, (Attributes)g.convertForCast((Object)attributes2.clone(), Attributes.class));
            }
        }
        return manifest;
    }

    @Override
    public void close() throws IOException {
        if (this.closeController != null) {
            this.closeController.close(this);
        }
        super.close();
    }

    @af(modifiers=34)
    private boolean isSuperMan() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.superMan == null) {
                    this.superMan = super.getManifest();
                }
                if (this.superMan != null) {
                    this.superAttr = this.superMan.getMainAttributes();
                    this.superEntries = this.superMan.getEntries();
                    return true;
                }
                return false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private static JarFile retrieve(URL uRL) throws IOException {
        return URLJarFile.retrieve(uRL, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JarFile retrieve(URL uRL, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        if (callback != null) {
            return callback.retrieve(uRL);
        }
        JarFile jarFile = null;
        try {
            InputStream inputStream;
            block12: {
                inputStream = uRL.openConnection().getInputStream();
                Throwable throwable = null;
                try {
                    jarFile = (JarFile)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(inputStream, uRLJarFileCloseController){
                        final /* synthetic */ InputStream val$in;
                        final /* synthetic */ URLJarFileCloseController val$closeController;
                        final /* synthetic */ Runtime.Version val$version;
                        {
                            this.val$in = inputStream;
                            this.val$closeController = uRLJarFileCloseController;
                            this.val$version = version;
                        }

                        @Override
                        public JarFile run() throws IOException {
                            Path tmpFile = Files.createTempFile("jar_cache", null, new FileAttribute[0]);
                            try {
                                Files.copy(this.val$in, tmpFile, StandardCopyOption.REPLACE_EXISTING);
                                URLJarFile jarFile = new URLJarFile(tmpFile.toFile(), this.val$closeController, this.val$version);
                                tmpFile.toFile().deleteOnExit();
                                return jarFile;
                            }
                            catch (Throwable thr) {
                                try {
                                    Files.delete(tmpFile);
                                }
                                catch (IOException ioe) {
                                    thr.addSuppressed(ioe);
                                }
                                throw thr;
                            }
                        }
                    }), JarFile.class);
                    if (inputStream == null) return jarFile;
                    if (throwable == null) break block12;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                    }
                    catch (Throwable throwable4) {
                        if (inputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                        if (throwable == null) {
                            inputStream.close();
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                        }
                        try {
                            inputStream.close();
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                        }
                    }
                }
                try {
                    inputStream.close();
                    return jarFile;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return jarFile;
                }
            }
            inputStream.close();
            return jarFile;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
        }
    }

    public static void setCallBack(URLJarFileCallBack uRLJarFileCallBack) {
        callback = uRLJarFileCallBack;
    }

    private static /* synthetic */ void _jr$ip$closeController(URLJarFile uRLJarFile, URLJarFileCloseController uRLJarFileCloseController) {
        uRLJarFile.closeController = uRLJarFileCloseController;
    }

    protected /* synthetic */ URLJarFile(h h2) {
        super(h2);
    }

    public static interface URLJarFileCloseController {
        public void close(JarFile var1);
    }

    private class URLJarFileEntry
    extends JarEntry {
        private JarEntry je;
        final /* synthetic */ URLJarFile this$0;

        URLJarFileEntry(URLJarFile uRLJarFile, JarEntry jarEntry) {
            this.this$0 = uRLJarFile;
            super(jarEntry);
            this.je = jarEntry;
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Attributes attributes;
            Map map;
            if (((URLJarFileEntry)this).this$0.isSuperMan() && (map = ((URLJarFileEntry)this).this$0.superEntries) != null && (attributes = (Attributes)g.convertForCast(map.get(this.getName()), Attributes.class)) != null) {
                return (Attributes)g.convertForCast((Object)attributes.clone(), Attributes.class);
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            Certificate[] certificateArray = this.je.getCertificates();
            return certificateArray == null ? null : (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            CodeSigner[] codeSignerArray = this.je.getCodeSigners();
            return codeSignerArray == null ? null : (CodeSigner[])g.convertForCast((Object)a.cloneArray((Object)codeSignerArray), CodeSigner[].class);
        }

        private static /* synthetic */ void _jr$ip$je(URLJarFileEntry uRLJarFileEntry, JarEntry jarEntry) {
            uRLJarFileEntry.je = jarEntry;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, URLJarFile uRLJarFile) {
            ((URLJarFileEntry)object).this$0 = uRLJarFile;
        }

        protected /* synthetic */ URLJarFileEntry(h h2) {
            super(h2);
        }
    }
}

