/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.internal.foreign.MemorySessionImpl;
import sun.misc.Cleaner;
import sun.misc.IoTrace;
import sun.misc.JavaNioAccess;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

public class FileChannelImpl
extends FileChannel {
    private static final long allocationGranularity;
    private final FileDispatcher nd;
    private final FileDescriptor fd;
    private final boolean writable;
    private final boolean readable;
    private final boolean append;
    private final Object parent;
    private final String path;
    private final NativeThreadSet threads;
    private final Object positionLock;
    private static volatile boolean transferSupported;
    private static volatile boolean pipeSupported;
    private static volatile boolean fileSupported;
    private static final long MAPPED_TRANSFER_SIZE = 0x800000L;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private volatile FileLockTable fileLockTable;
    private static boolean isSharedFileLockTable;
    private static volatile boolean propertyChecked;

    private FileChannelImpl(FileDescriptor fileDescriptor, String string, boolean bl, boolean bl2, boolean bl3, Object object) {
        this.threads = new NativeThreadSet(2);
        this.positionLock = new Object();
        this.fd = fileDescriptor;
        this.readable = bl;
        this.writable = bl2;
        this.append = bl3;
        this.parent = object;
        this.path = string;
        this.nd = new FileDispatcherImpl(bl3);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, String string, boolean bl, boolean bl2, Object object) {
        return new FileChannelImpl(fileDescriptor, string, bl, bl2, false, object);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, String string, boolean bl, boolean bl2, boolean bl3, Object object) {
        return new FileChannelImpl(fileDescriptor, string, bl, bl2, bl3, object);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fileLock = (FileLock)g.convertForCast((Object)iterator.next(), FileLock.class);
                Object object = ah.getMonitor((Object)fileLock);
                synchronized (object) {
                    try {
                        if (fileLock.isValid()) {
                            this.nd.release(this.fd, fileLock.position(), fileLock.size());
                            ((FileLockImpl)g.convertForCast((Object)fileLock, FileLockImpl.class)).invalidate();
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
        }
        this.nd.preClose(this.fd);
        this.threads.signalAndWait();
        if (this.parent != null) {
            ((Closeable)g.convertForCast((Object)this.parent, Closeable.class)).close();
        } else {
            this.nd.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
        }
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                int n5;
                Object object2;
                int n2;
                int n3;
                block11: {
                    n3 = 0;
                    n2 = -1;
                    object2 = IoTrace.fileReadBegin((String)this.path);
                    this.begin();
                    n2 = this.threads.add();
                    if (this.isOpen()) break block11;
                    int n4 = 0;
                    this.threads.remove(n2);
                    IoTrace.fileReadEnd((Object)object2, (long)(n3 > 0 ? (long)n3 : 0L));
                    this.end(n3 > 0);
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return n4;
                }
                try {
                    while ((n3 = IOUtil.read(this.fd, byteBuffer, -1L, this.nd)) == -3 && this.isOpen()) {
                    }
                    n5 = IOStatus.normalize(n3);
                    this.threads.remove(n2);
                    IoTrace.fileReadEnd((Object)object2, (long)(n3 > 0 ? (long)n3 : 0L));
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    IoTrace.fileReadEnd((Object)object2, (long)(n3 > 0 ? (long)n3 : 0L));
                    this.end(n3 > 0);
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                this.end(n3 > 0);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return n5;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 > a.arrayLength((Object[])byteBufferArray) - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        this.ensureOpen();
        if (!this.readable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
        }
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                long l3;
                Object object2;
                int n4;
                long l;
                block12: {
                    l = 0L;
                    n4 = -1;
                    object2 = IoTrace.fileReadBegin((String)this.path);
                    this.begin();
                    n4 = this.threads.add();
                    if (this.isOpen()) break block12;
                    long l2 = 0L;
                    this.threads.remove(n4);
                    IoTrace.fileReadEnd((Object)object2, (long)(l > 0L ? l : 0L));
                    this.end(l > 0L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return l2;
                }
                try {
                    while ((l = IOUtil.read(this.fd, byteBufferArray, n2, n3, this.nd)) == -3L && this.isOpen()) {
                    }
                    l3 = IOStatus.normalize(l);
                    this.threads.remove(n4);
                    IoTrace.fileReadEnd((Object)object2, (long)(l > 0L ? l : 0L));
                }
                catch (Throwable throwable) {
                    this.threads.remove(n4);
                    IoTrace.fileReadEnd((Object)object2, (long)(l > 0L ? l : 0L));
                    this.end(l > 0L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                this.end(l > 0L);
                if (!$assertionsDisabled && !IOStatus.check(l)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return l3;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
        }
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                int n5;
                Object object2;
                int n2;
                int n3;
                block11: {
                    n3 = 0;
                    n2 = -1;
                    object2 = IoTrace.fileWriteBegin((String)this.path);
                    this.begin();
                    n2 = this.threads.add();
                    if (this.isOpen()) break block11;
                    int n4 = 0;
                    this.threads.remove(n2);
                    this.end(n3 > 0);
                    IoTrace.fileWriteEnd((Object)object2, (long)(n3 > 0 ? (long)n3 : 0L));
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return n4;
                }
                try {
                    while ((n3 = IOUtil.write(this.fd, byteBuffer, -1L, this.nd)) == -3 && this.isOpen()) {
                    }
                    n5 = IOStatus.normalize(n3);
                    this.threads.remove(n2);
                    this.end(n3 > 0);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    this.end(n3 > 0);
                    IoTrace.fileWriteEnd((Object)object2, (long)(n3 > 0 ? (long)n3 : 0L));
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                IoTrace.fileWriteEnd((Object)object2, (long)(n3 > 0 ? (long)n3 : 0L));
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return n5;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 > a.arrayLength((Object[])byteBufferArray) - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        this.ensureOpen();
        if (!this.writable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
        }
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                long l3;
                Object object2;
                int n4;
                long l;
                block12: {
                    l = 0L;
                    n4 = -1;
                    object2 = IoTrace.fileWriteBegin((String)this.path);
                    this.begin();
                    n4 = this.threads.add();
                    if (this.isOpen()) break block12;
                    long l2 = 0L;
                    this.threads.remove(n4);
                    IoTrace.fileWriteEnd((Object)object2, (long)(l > 0L ? l : 0L));
                    this.end(l > 0L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return l2;
                }
                try {
                    while ((l = IOUtil.write(this.fd, byteBufferArray, n2, n3, this.nd)) == -3L && this.isOpen()) {
                    }
                    l3 = IOStatus.normalize(l);
                    this.threads.remove(n4);
                    IoTrace.fileWriteEnd((Object)object2, (long)(l > 0L ? l : 0L));
                }
                catch (Throwable throwable) {
                    this.threads.remove(n4);
                    IoTrace.fileWriteEnd((Object)object2, (long)(l > 0L ? l : 0L));
                    this.end(l > 0L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                this.end(l > 0L);
                if (!$assertionsDisabled && !IOStatus.check(l)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return l3;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long position() throws IOException {
        this.ensureOpen();
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                long l4;
                int n2;
                long l;
                block10: {
                    l = -1L;
                    n2 = -1;
                    this.begin();
                    n2 = this.threads.add();
                    if (this.isOpen()) break block10;
                    long l2 = 0L;
                    this.threads.remove(n2);
                    this.end(l > -1L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return l2;
                }
                try {
                    do {
                        long l2 = l = this.append ? this.nd.size(this.fd) : this.position0(this.fd, -1L);
                    } while (l == -3L && this.isOpen());
                    l4 = IOStatus.normalize(l);
                    this.threads.remove(n2);
                    this.end(l > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    this.end(l > -1L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                if (!$assertionsDisabled && !IOStatus.check(l)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return l4;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel position(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                FileChannelImpl fileChannelImpl;
                int n2;
                long l2;
                block11: {
                    l2 = -1L;
                    n2 = -1;
                    this.begin();
                    n2 = this.threads.add();
                    if (this.isOpen()) break block11;
                    FileChannel fileChannel = null;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                    if (!$assertionsDisabled && !IOStatus.check(l2)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return fileChannel;
                }
                try {
                    while ((l2 = this.position0(this.fd, l)) == -3L && this.isOpen()) {
                    }
                    fileChannelImpl = this;
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    this.end(l2 > -1L);
                    if (!$assertionsDisabled && !IOStatus.check(l2)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                if (!$assertionsDisabled && !IOStatus.check(l2)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return fileChannelImpl;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() throws IOException {
        this.ensureOpen();
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                long l3;
                int n2;
                long l;
                block10: {
                    l = -1L;
                    n2 = -1;
                    this.begin();
                    n2 = this.threads.add();
                    if (this.isOpen()) break block10;
                    long l2 = -1L;
                    this.threads.remove(n2);
                    this.end(l > -1L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return l2;
                }
                try {
                    while ((l = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                    }
                    l3 = IOStatus.normalize(l);
                    this.threads.remove(n2);
                    this.end(l > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    this.end(l > -1L);
                    if (!$assertionsDisabled && !IOStatus.check(l)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                if (!$assertionsDisabled && !IOStatus.check(l)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return l3;
            }
            catch (Throwable throwable2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel truncate(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (l > this.size()) {
            return this;
        }
        if (!this.writable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
        }
        Object object = ah.getMonitor((Object)this.positionLock);
        synchronized (object) {
            try {
                FileChannelImpl fileChannelImpl;
                int n2;
                long l2;
                int n3;
                block23: {
                    block22: {
                        block21: {
                            n3 = -1;
                            l2 = -1L;
                            n2 = -1;
                            this.begin();
                            n2 = this.threads.add();
                            if (this.isOpen()) break block21;
                            FileChannel fileChannel = null;
                            this.threads.remove(n2);
                            this.end(n3 > -1);
                            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                            }
                            return fileChannel;
                        }
                        while ((l2 = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                        }
                        if (this.isOpen()) break block22;
                        FileChannel fileChannel = null;
                        this.threads.remove(n2);
                        this.end(n3 > -1);
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        return fileChannel;
                    }
                    if (!$assertionsDisabled && l2 < 0L) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    while ((n3 = this.nd.truncate(this.fd, l)) == -3 && this.isOpen()) {
                    }
                    if (this.isOpen()) break block23;
                    FileChannel fileChannel = null;
                    this.threads.remove(n2);
                    this.end(n3 > -1);
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return fileChannel;
                }
                try {
                    if (l2 > l) {
                        l2 = l;
                    }
                    while ((n3 = (int)this.position0(this.fd, l2)) == -3 && this.isOpen()) {
                    }
                    fileChannelImpl = this;
                    this.threads.remove(n2);
                    this.end(n3 > -1);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    this.end(n3 > -1);
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return fileChannelImpl;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean bl) throws IOException {
        int n2;
        int n3;
        block7: {
            this.ensureOpen();
            n3 = -1;
            n2 = -1;
            this.begin();
            n2 = this.threads.add();
            if (this.isOpen()) break block7;
            this.threads.remove(n2);
            this.end(n3 > -1);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return;
        }
        try {
            while ((n3 = this.nd.force(this.fd, bl)) == -3 && this.isOpen()) {
            }
            this.threads.remove(n2);
            this.end(n3 > -1);
        }
        catch (Throwable throwable) {
            this.threads.remove(n2);
            this.end(n3 > -1);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (!$assertionsDisabled && !IOStatus.check(n3)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long l, int n2, WritableByteChannel writableByteChannel) throws IOException {
        int n3;
        long l2;
        block18: {
            block17: {
                long l3;
                int n4;
                int n5;
                block16: {
                    if (!transferSupported) {
                        return -4L;
                    }
                    FileDescriptor fileDescriptor = null;
                    if (g.convertForInstanceOf((Object)writableByteChannel, FileChannelImpl.class) instanceof FileChannelImpl) {
                        if (!fileSupported) {
                            return -6L;
                        }
                        fileDescriptor = ((FileChannelImpl)g.convertForCast((Object)writableByteChannel, FileChannelImpl.class)).fd;
                    } else if (g.convertForInstanceOf((Object)writableByteChannel, SelChImpl.class) instanceof SelChImpl) {
                        if (g.convertForInstanceOf((Object)writableByteChannel, SinkChannelImpl.class) instanceof SinkChannelImpl && !pipeSupported) {
                            return -6L;
                        }
                        fileDescriptor = ((SelChImpl)g.convertForCast((Object)writableByteChannel, SelChImpl.class)).getFD();
                    }
                    if (fileDescriptor == null) {
                        return -4L;
                    }
                    n5 = IOUtil.fdVal(this.fd);
                    if (n5 == (n4 = IOUtil.fdVal(fileDescriptor))) {
                        return -4L;
                    }
                    l2 = -1L;
                    n3 = -1;
                    this.begin();
                    n3 = this.threads.add();
                    if (this.isOpen()) break block16;
                    long l4 = -1L;
                    this.threads.remove(n3);
                    this.end(l2 > -1L);
                    return l4;
                }
                try {
                    while ((l2 = this.transferTo0(n5, l, n2, n4)) == -3L && this.isOpen()) {
                    }
                    if (l2 != -6L) break block17;
                    if (g.convertForInstanceOf((Object)writableByteChannel, SinkChannelImpl.class) instanceof SinkChannelImpl) {
                        pipeSupported = false;
                    }
                    if (g.convertForInstanceOf((Object)writableByteChannel, FileChannelImpl.class) instanceof FileChannelImpl) {
                        fileSupported = false;
                    }
                    l3 = -6L;
                    this.threads.remove(n3);
                    this.end(l2 > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(n3);
                    this.end(l2 > -1L);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                return l3;
            }
            if (l2 != -4L) break block18;
            transferSupported = false;
            long l5 = -4L;
            this.threads.remove(n3);
            this.end(l2 > -1L);
            return l5;
        }
        long l6 = IOStatus.normalize(l2);
        this.threads.remove(n3);
        this.end(l2 > -1L);
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        boolean bl = g.convertForInstanceOf((Object)writableByteChannel, SelChImpl.class) instanceof SelChImpl;
        if (!(g.convertForInstanceOf((Object)writableByteChannel, FileChannelImpl.class) instanceof FileChannelImpl) && !bl) {
            return -4L;
        }
        long l3 = l2;
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x800000L);
            try {
                int n2;
                MappedByteBuffer mappedByteBuffer;
                block13: {
                    mappedByteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l, l4);
                    try {
                        n2 = writableByteChannel.write(mappedByteBuffer);
                        if (!$assertionsDisabled && n2 < 0) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        l3 -= (long)n2;
                        if (!bl) break block13;
                    }
                    catch (Throwable throwable) {
                        FileChannelImpl.unmap(mappedByteBuffer);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                    FileChannelImpl.unmap(mappedByteBuffer);
                    break;
                }
                if (!$assertionsDisabled && n2 <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                l += (long)n2;
                FileChannelImpl.unmap(mappedByteBuffer);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                if (!$assertionsDisabled && writableByteChannel.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    closedByInterruptException.addSuppressed(throwable);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)closedByInterruptException);
            }
            catch (IOException iOException) {
                if (l3 != l2) break;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
            }
        }
        return l2 - l3;
    }

    private long transferToArbitraryChannel(long l, int n2, WritableByteChannel writableByteChannel) throws IOException {
        long l2;
        int n3 = Math.min(n2, 8192);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n3);
        long l3 = 0L;
        long l4 = l;
        try {
            Util.erase(byteBuffer);
            while (l3 < (long)n2) {
                byteBuffer.limit(Math.min((int)((long)n2 - l3), 8192));
                int n4 = this.read(byteBuffer, l4);
                if (n4 <= 0) break;
                byteBuffer.flip();
                int n5 = writableByteChannel.write(byteBuffer);
                l3 += (long)n5;
                if (n5 != n4) break;
                l4 += (long)n5;
                byteBuffer.clear();
            }
            l2 = l3;
        }
        catch (IOException iOException) {
            block6: {
                long l5;
                try {
                    if (l3 <= 0L) break block6;
                    l5 = l3;
                }
                catch (Throwable throwable) {
                    Util.releaseTemporaryDirectBuffer(byteBuffer);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                Util.releaseTemporaryDirectBuffer(byteBuffer);
                return l5;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer);
        return l2;
    }

    @Override
    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        long l3;
        this.ensureOpen();
        if (!writableByteChannel.isOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
        }
        if (!this.readable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
        }
        if (g.convertForInstanceOf((Object)writableByteChannel, FileChannelImpl.class) instanceof FileChannelImpl && !((FileChannelImpl)g.convertForCast((Object)writableByteChannel, FileChannelImpl.class)).writable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
        }
        if (l < 0L || l2 < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        long l4 = this.size();
        if (l > l4) {
            return 0L;
        }
        int n2 = (int)Math.min(l2, Integer.MAX_VALUE);
        if (l4 - l < (long)n2) {
            n2 = (int)(l4 - l);
        }
        if ((l3 = this.transferToDirectly(l, n2, writableByteChannel)) >= 0L) {
            return l3;
        }
        l3 = this.transferToTrustedChannel(l, n2, writableByteChannel);
        if (l3 >= 0L) {
            return l3;
        }
        return this.transferToArbitraryChannel(l, n2, writableByteChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferFromFileChannel(FileChannelImpl fileChannelImpl, long l, long l2) throws IOException {
        if (!fileChannelImpl.readable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
        }
        Object object = ah.getMonitor((Object)fileChannelImpl.positionLock);
        synchronized (object) {
            try {
                long l3;
                long l4;
                long l5;
                long l6;
                long l7 = fileChannelImpl.position();
                long l8 = l7;
                for (l5 = l4 = Math.min(l2, fileChannelImpl.size() - l7); l5 > 0L; l5 -= l6) {
                    l3 = Math.min(l5, 0x800000L);
                    MappedByteBuffer mappedByteBuffer = fileChannelImpl.map(FileChannel.MapMode.READ_ONLY, l8, l3);
                    try {
                        l6 = this.write(mappedByteBuffer, l);
                        if (!$assertionsDisabled && l6 <= 0L) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        l8 += l6;
                        l += l6;
                    }
                    catch (IOException iOException) {
                        block10: {
                            try {
                                if (l5 != l4) break block10;
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                            }
                            catch (Throwable throwable) {
                                FileChannelImpl.unmap(mappedByteBuffer);
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                        FileChannelImpl.unmap(mappedByteBuffer);
                        break;
                    }
                    FileChannelImpl.unmap(mappedByteBuffer);
                    continue;
                }
                l3 = l4 - l5;
                fileChannelImpl.position(l7 + l3);
                return l3;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private long transferFromArbitraryChannel(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        long l3;
        int n2 = (int)Math.min(l2, 8192L);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n2);
        long l4 = 0L;
        long l5 = l;
        try {
            Util.erase(byteBuffer);
            while (l4 < l2) {
                byteBuffer.limit((int)Math.min(l2 - l4, 8192L));
                int n3 = readableByteChannel.read(byteBuffer);
                if (n3 <= 0) break;
                byteBuffer.flip();
                int n4 = this.write(byteBuffer, l5);
                l4 += (long)n4;
                if (n4 != n3) break;
                l5 += (long)n4;
                byteBuffer.clear();
            }
            l3 = l4;
        }
        catch (IOException iOException) {
            block6: {
                long l6;
                try {
                    if (l4 <= 0L) break block6;
                    l6 = l4;
                }
                catch (Throwable throwable) {
                    Util.releaseTemporaryDirectBuffer(byteBuffer);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                Util.releaseTemporaryDirectBuffer(byteBuffer);
                return l6;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer);
        return l3;
    }

    @Override
    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        this.ensureOpen();
        if (!readableByteChannel.isOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
        }
        if (!this.writable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
        }
        if (l < 0L || l2 < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (l > this.size()) {
            return 0L;
        }
        if (g.convertForInstanceOf((Object)readableByteChannel, FileChannelImpl.class) instanceof FileChannelImpl) {
            return this.transferFromFileChannel((FileChannelImpl)g.convertForCast((Object)readableByteChannel, FileChannelImpl.class), l, l2);
        }
        return this.transferFromArbitraryChannel(readableByteChannel, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (byteBuffer == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position"));
        }
        if (!this.readable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
        }
        this.ensureOpen();
        if (this.nd.needsPositionLock()) {
            Object object = ah.getMonitor((Object)this.positionLock);
            synchronized (object) {
                try {
                    return this.readInternal(byteBuffer, l);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return this.readInternal(byteBuffer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInternal(ByteBuffer byteBuffer, long l) throws IOException {
        int n2;
        Object object;
        int n3;
        int n4;
        block8: {
            if (!$assertionsDisabled && this.nd.needsPositionLock() && !Thread.holdsLock(ah.getMonitor((Object)this.positionLock))) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            n4 = 0;
            n3 = -1;
            object = IoTrace.fileReadBegin((String)this.path);
            this.begin();
            n3 = this.threads.add();
            if (this.isOpen()) break block8;
            int n5 = -1;
            this.threads.remove(n3);
            IoTrace.fileReadEnd((Object)object, (long)(n4 > 0 ? (long)n4 : 0L));
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return n5;
        }
        try {
            while ((n4 = IOUtil.read(this.fd, byteBuffer, l, this.nd)) == -3 && this.isOpen()) {
            }
            n2 = IOStatus.normalize(n4);
            this.threads.remove(n3);
            IoTrace.fileReadEnd((Object)object, (long)(n4 > 0 ? (long)n4 : 0L));
        }
        catch (Throwable throwable) {
            this.threads.remove(n3);
            IoTrace.fileReadEnd((Object)object, (long)(n4 > 0 ? (long)n4 : 0L));
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.end(n4 > 0);
        if (!$assertionsDisabled && !IOStatus.check(n4)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (byteBuffer == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position"));
        }
        if (!this.writable) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
        }
        this.ensureOpen();
        if (this.nd.needsPositionLock()) {
            Object object = ah.getMonitor((Object)this.positionLock);
            synchronized (object) {
                try {
                    return this.writeInternal(byteBuffer, l);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return this.writeInternal(byteBuffer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeInternal(ByteBuffer byteBuffer, long l) throws IOException {
        int n2;
        Object object;
        int n3;
        int n4;
        block8: {
            if (!$assertionsDisabled && this.nd.needsPositionLock() && !Thread.holdsLock(ah.getMonitor((Object)this.positionLock))) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            n4 = 0;
            n3 = -1;
            object = IoTrace.fileWriteBegin((String)this.path);
            this.begin();
            n3 = this.threads.add();
            if (this.isOpen()) break block8;
            int n5 = -1;
            this.threads.remove(n3);
            this.end(n4 > 0);
            IoTrace.fileWriteEnd((Object)object, (long)(n4 > 0 ? (long)n4 : 0L));
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return n5;
        }
        try {
            while ((n4 = IOUtil.write(this.fd, byteBuffer, l, this.nd)) == -3 && this.isOpen()) {
            }
            n2 = IOStatus.normalize(n4);
            this.threads.remove(n3);
            this.end(n4 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(n3);
            this.end(n4 > 0);
            IoTrace.fileWriteEnd((Object)object, (long)(n4 > 0 ? (long)n4 : 0L));
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        IoTrace.fileWriteEnd((Object)object, (long)(n4 > 0 ? (long)n4 : 0L));
        if (!$assertionsDisabled && !IOStatus.check(n4)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return n2;
    }

    private static void unmap(MappedByteBuffer mappedByteBuffer) {
        Cleaner cleaner = ((DirectBuffer)g.convertForCast((Object)mappedByteBuffer, DirectBuffer.class)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        Unmapper unmapper;
        int n2;
        FileDescriptor fileDescriptor;
        int n3;
        int n4;
        long l3;
        block34: {
            int n5;
            block32: {
                FileDescriptor fileDescriptor2;
                block33: {
                    MappedByteBuffer mappedByteBuffer;
                    block31: {
                        this.ensureOpen();
                        if (l < 0L) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative position"));
                        }
                        if (l2 < 0L) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative size"));
                        }
                        if (l + l2 < 0L) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Position + size overflow"));
                        }
                        if (l2 > Integer.MAX_VALUE) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Size exceeds Integer.MAX_VALUE"));
                        }
                        n5 = -1;
                        if (!f.ifAcmp((Object)((Object)mapMode), (Object)((Object)FileChannel.MapMode.READ_ONLY))) {
                            n5 = 0;
                        } else if (!f.ifAcmp((Object)((Object)mapMode), (Object)((Object)FileChannel.MapMode.READ_WRITE))) {
                            n5 = 1;
                        } else if (!f.ifAcmp((Object)((Object)mapMode), (Object)((Object)FileChannel.MapMode.PRIVATE))) {
                            n5 = 2;
                        }
                        if (!$assertionsDisabled && n5 < 0) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        if (f.ifAcmp((Object)((Object)mapMode), (Object)((Object)FileChannel.MapMode.READ_ONLY)) && !this.writable) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
                        }
                        if (!this.readable) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
                        }
                        l3 = -1L;
                        n4 = -1;
                        this.begin();
                        n4 = this.threads.add();
                        if (this.isOpen()) break block31;
                        MappedByteBuffer mappedByteBuffer2 = null;
                        this.threads.remove(n4);
                        this.end(IOStatus.checkAll(l3));
                        return mappedByteBuffer2;
                    }
                    try {
                        if (this.size() < l + l2) {
                            if (!this.writable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Channel not open for writing - cannot extend file to required size"));
                            }
                            while ((n3 = this.nd.truncate(this.fd, l + l2)) == -3 && this.isOpen()) {
                            }
                        }
                        if (l2 != 0L) break block32;
                        l3 = 0L;
                        fileDescriptor2 = new FileDescriptor();
                        if (this.writable && n5 != 0) break block33;
                        mappedByteBuffer = Util.newMappedByteBufferR(0, 0L, fileDescriptor2, null);
                        this.threads.remove(n4);
                    }
                    catch (Throwable throwable) {
                        this.threads.remove(n4);
                        this.end(IOStatus.checkAll(l3));
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                    this.end(IOStatus.checkAll(l3));
                    return mappedByteBuffer;
                }
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(0, 0L, fileDescriptor2, null);
                this.threads.remove(n4);
                this.end(IOStatus.checkAll(l3));
                return mappedByteBuffer;
            }
            n3 = (int)(l % allocationGranularity);
            long l4 = l - (long)n3;
            long l5 = l2 + (long)n3;
            try {
                l3 = this.map0(n5, l4, l5);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                try {
                    l3 = this.map0(n5, l4, l5);
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Map failed", outOfMemoryError2));
                }
            }
            try {
                fileDescriptor = this.nd.duplicateForMapping(this.fd);
            }
            catch (IOException iOException) {
                FileChannelImpl.unmap0(l3, l5);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
            }
            if (!$assertionsDisabled && !IOStatus.checkAll(l3)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            if (!$assertionsDisabled && l3 % allocationGranularity != 0L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            n2 = (int)l2;
            unmapper = new Unmapper(l3, l5, n2, fileDescriptor);
            if (this.writable && n5 != 0) break block34;
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(n2, l3 + (long)n3, fileDescriptor, unmapper);
            this.threads.remove(n4);
            this.end(IOStatus.checkAll(l3));
            return mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(n2, l3 + (long)n3, fileDescriptor, unmapper);
        this.threads.remove(n4);
        this.end(IOStatus.checkAll(l3));
        return mappedByteBuffer;
    }

    public static JavaNioAccess.BufferPool getMappedBufferPool() {
        return new MemorySessionImpl.ResourceList.ResourceCleanup(){
            final /* synthetic */ Unmapper val$unmapper;
            {
                this.val$unmapper = unmapper;
            }

            @Override
            public void cleanup() {
                this.val$unmapper.unmap();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSharedFileLockTable() {
        if (!propertyChecked) {
            Object object = ah.getMonitor(FileChannelImpl.class);
            synchronized (object) {
                try {
                    if (!propertyChecked) {
                        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSystemWideOverlappingFileLockCheck"));
                        isSharedFileLockTable = string == null || string.equals("false");
                        propertyChecked = true;
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return isSharedFileLockTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockTable fileLockTable() throws IOException {
        if (this.fileLockTable == null) {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.fileLockTable == null) {
                        if (FileChannelImpl.isSharedFileLockTable()) {
                            int n2 = this.threads.add();
                            try {
                                this.ensureOpen();
                                this.fileLockTable = FileLockTable.newSharedFileLockTable(this, this.fd);
                                this.threads.remove(n2);
                            }
                            catch (Throwable throwable) {
                                this.threads.remove(n2);
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        } else {
                            this.fileLockTable = new SimpleFileLockTable();
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return this.fileLockTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        int n2;
        boolean bl2;
        FileLockTable fileLockTable;
        FileLockImpl fileLockImpl;
        block18: {
            this.ensureOpen();
            if (bl && !this.readable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
            }
            if (!bl && !this.writable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
            }
            fileLockImpl = new FileLockImpl(this, l, l2, bl);
            fileLockTable = this.fileLockTable();
            fileLockTable.add(fileLockImpl);
            bl2 = false;
            n2 = -1;
            this.begin();
            n2 = this.threads.add();
            if (this.isOpen()) break block18;
            FileLock fileLock = null;
            if (!bl2) {
                fileLockTable.remove(fileLockImpl);
            }
            this.threads.remove(n2);
            try {
                this.end(bl2);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileLockInterruptionException());
            }
            return fileLock;
        }
        try {
            int n3;
            while ((n3 = this.nd.lock(this.fd, true, l, l2, bl)) == 2 && this.isOpen()) {
            }
            if (this.isOpen()) {
                if (n3 == 1) {
                    if (!$assertionsDisabled && !bl) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
                    fileLockTable.replace(fileLockImpl, fileLockImpl2);
                    fileLockImpl = fileLockImpl2;
                }
                bl2 = true;
            }
            if (!bl2) {
                fileLockTable.remove(fileLockImpl);
            }
            this.threads.remove(n2);
        }
        catch (Throwable throwable) {
            if (!bl2) {
                fileLockTable.remove(fileLockImpl);
            }
            this.threads.remove(n2);
            try {
                this.end(bl2);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileLockInterruptionException());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        try {
            this.end(bl2);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileLockInterruptionException());
        }
        return fileLockImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        int n2;
        FileLockImpl fileLockImpl;
        block10: {
            int n3;
            FileLockTable fileLockTable;
            block9: {
                this.ensureOpen();
                if (bl && !this.readable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonReadableChannelException());
                }
                if (!bl && !this.writable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NonWritableChannelException());
                }
                fileLockImpl = new FileLockImpl(this, l, l2, bl);
                fileLockTable = this.fileLockTable();
                fileLockTable.add(fileLockImpl);
                n2 = this.threads.add();
                try {
                    try {
                        this.ensureOpen();
                        n3 = this.nd.lock(this.fd, false, l, l2, bl);
                    }
                    catch (IOException iOException) {
                        fileLockTable.remove(fileLockImpl);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                    }
                    if (n3 != -1) break block9;
                    fileLockTable.remove(fileLockImpl);
                    FileLock fileLock = null;
                    this.threads.remove(n2);
                    return fileLock;
                }
                catch (Throwable throwable) {
                    this.threads.remove(n2);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            if (n3 != 1) break block10;
            if (!$assertionsDisabled && !bl) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
            fileLockTable.replace(fileLockImpl, fileLockImpl2);
            FileLockImpl fileLockImpl3 = fileLockImpl2;
            this.threads.remove(n2);
            return fileLockImpl3;
        }
        FileLockImpl fileLockImpl4 = fileLockImpl;
        this.threads.remove(n2);
        return fileLockImpl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(FileLockImpl fileLockImpl) throws IOException {
        int n2 = this.threads.add();
        try {
            this.ensureOpen();
            this.nd.release(this.fd, fileLockImpl.position(), fileLockImpl.size());
            this.threads.remove(n2);
        }
        catch (Throwable throwable) {
            this.threads.remove(n2);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (!$assertionsDisabled && this.fileLockTable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        this.fileLockTable.remove(fileLockImpl);
    }

    private native long map0(int var1, long var2, long var4) throws IOException;

    private static native int unmap0(long var0, long var2);

    private native long transferTo0(int var1, long var2, long var4, int var6);

    private native long position0(FileDescriptor var1, long var2);

    private static native long initIDs();

    static {
        transferSupported = true;
        pipeSupported = true;
        fileSupported = true;
        Util.load();
        allocationGranularity = FileChannelImpl.initIDs();
    }

    private static /* synthetic */ void _jr$ip$nd(FileChannelImpl fileChannelImpl, FileDispatcher fileDispatcher) {
        fileChannelImpl.nd = fileDispatcher;
    }

    private static /* synthetic */ void _jr$ip$fd(FileChannelImpl fileChannelImpl, FileDescriptor fileDescriptor) {
        fileChannelImpl.fd = fileDescriptor;
    }

    private static /* synthetic */ void _jr$ip$writable(FileChannelImpl fileChannelImpl, boolean bl) {
        fileChannelImpl.writable = bl;
    }

    private static /* synthetic */ void _jr$ip$readable(FileChannelImpl fileChannelImpl, boolean bl) {
        fileChannelImpl.readable = bl;
    }

    private static /* synthetic */ void _jr$ip$append(FileChannelImpl fileChannelImpl, boolean bl) {
        fileChannelImpl.append = bl;
    }

    private static /* synthetic */ void _jr$ip$parent(FileChannelImpl fileChannelImpl, Object object) {
        fileChannelImpl.parent = object;
    }

    private static /* synthetic */ void _jr$ip$path(FileChannelImpl fileChannelImpl, String string) {
        fileChannelImpl.path = string;
    }

    private static /* synthetic */ void _jr$ip$threads(FileChannelImpl fileChannelImpl, NativeThreadSet nativeThreadSet) {
        fileChannelImpl.threads = nativeThreadSet;
    }

    private static /* synthetic */ void _jr$ip$positionLock(FileChannelImpl fileChannelImpl, Object object) {
        fileChannelImpl.positionLock = object;
    }

    protected /* synthetic */ FileChannelImpl(h h2) {
        super(h2);
    }

    private static class SimpleFileLockTable
    extends FileLockTable {
        private final List<FileLock> lockList;

        public SimpleFileLockTable() {
            this.lockList = new ArrayList<FileLock>(2);
        }

        private void checkList(long l, long l2) throws OverlappingFileLockException {
            if (!$assertionsDisabled && !Thread.holdsLock(ah.getMonitor((Object)this.lockList))) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            Iterator iterator = this.lockList.iterator();
            while (iterator.hasNext()) {
                FileLock fileLock = (FileLock)g.convertForCast(iterator.next(), FileLock.class);
                if (!fileLock.overlaps(l, l2)) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new OverlappingFileLockException());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(FileLock fileLock) throws OverlappingFileLockException {
            Object object = ah.getMonitor((Object)this.lockList);
            synchronized (object) {
                try {
                    this.checkList(fileLock.position(), fileLock.size());
                    this.lockList.add(fileLock);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(FileLock fileLock) {
            Object object = ah.getMonitor((Object)this.lockList);
            synchronized (object) {
                try {
                    this.lockList.remove(fileLock);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileLock> removeAll() {
            Object object = ah.getMonitor((Object)this.lockList);
            synchronized (object) {
                try {
                    ArrayList<FileLock> arrayList = new ArrayList<FileLock>(this.lockList);
                    this.lockList.clear();
                    return arrayList;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(FileLock fileLock, FileLock fileLock2) {
            Object object = ah.getMonitor((Object)this.lockList);
            synchronized (object) {
                try {
                    this.lockList.remove(fileLock);
                    this.lockList.add(fileLock2);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$lockList(SimpleFileLockTable simpleFileLockTable, List list) {
            simpleFileLockTable.lockList = list;
        }

        protected /* synthetic */ SimpleFileLockTable(h h2) {
            super(h2);
        }
    }

    private static class Unmapper
    extends h
    implements Runnable {
        private static final NativeDispatcher nd = new FileDispatcherImpl();
        static volatile int count;
        static volatile long totalSize;
        static volatile long totalCapacity;
        private volatile long address;
        private final long size;
        private final int cap;
        private final FileDescriptor fd;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Unmapper(long l, long l2, int n2, FileDescriptor fileDescriptor) {
            if (!$assertionsDisabled && l == 0L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            this.address = l;
            this.size = l2;
            this.cap = n2;
            this.fd = fileDescriptor;
            Object object = ah.getMonitor(Unmapper.class);
            synchronized (object) {
                try {
                    ++count;
                    totalSize += l2;
                    totalCapacity += (long)n2;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
            if (this.fd.valid()) {
                try {
                    nd.close(this.fd);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Object object = ah.getMonitor(Unmapper.class);
            synchronized (object) {
                try {
                    --count;
                    totalSize -= this.size;
                    totalCapacity -= (long)this.cap;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$size(Unmapper unmapper, long l) {
            unmapper.size = l;
        }

        private static /* synthetic */ void _jr$ip$cap(Unmapper unmapper, int n2) {
            unmapper.cap = n2;
        }

        private static /* synthetic */ void _jr$ip$fd(Unmapper unmapper, FileDescriptor fileDescriptor) {
            unmapper.fd = fileDescriptor;
        }

        protected /* synthetic */ Unmapper(h h2) {
            super(h2);
        }
    }
}

