/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.h;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

class NativeObject
extends h {
    protected static final Unsafe unsafe = Unsafe.getUnsafe();
    protected long allocationAddress;
    private final long address;
    private static ByteOrder byteOrder = null;
    private static int pageSize = -1;

    NativeObject(long l2) {
        this.allocationAddress = l2;
        this.address = l2;
    }

    NativeObject(long l2, long l3) {
        this.allocationAddress = l2;
        this.address = l2 + l3;
    }

    protected NativeObject(int n2, boolean bl) {
        if (!bl) {
            this.address = this.allocationAddress = unsafe.allocateMemory(n2);
        } else {
            long l2;
            int n3 = NativeObject.pageSize();
            this.allocationAddress = l2 = unsafe.allocateMemory(n2 + n3);
            this.address = l2 + (long)n3 - (l2 & (long)(n3 - 1));
        }
    }

    long address() {
        return this.address;
    }

    long allocationAddress() {
        return ((NativeObject)((Object)((Object)this))).allocationAddress;
    }

    NativeObject subObject(int n2) {
        return new NativeObject((long)n2 + this.address);
    }

    NativeObject getObject(int n2) {
        long l2 = 0L;
        switch (NativeObject.addressSize()) {
            case 8: {
                l2 = unsafe.getLong((long)n2 + this.address);
                break;
            }
            case 4: {
                l2 = unsafe.getInt((long)n2 + this.address) & 0xFFFFFFFF;
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Address size not supported"));
            }
        }
        return new NativeObject(l2);
    }

    void putObject(int n2, NativeObject nativeObject) {
        switch (NativeObject.addressSize()) {
            case 8: {
                this.putLong(n2, nativeObject.address);
                break;
            }
            case 4: {
                this.putInt(n2, (int)(nativeObject.address & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Address size not supported"));
            }
        }
    }

    final byte getByte(int n2) {
        return unsafe.getByte((long)n2 + this.address);
    }

    final void putByte(int n2, byte by) {
        unsafe.putByte((long)n2 + this.address, by);
    }

    final short getShort(int n2) {
        return unsafe.getShort((long)n2 + this.address);
    }

    final void putShort(int n2, short s) {
        unsafe.putShort((long)n2 + this.address, s);
    }

    final char getChar(int n2) {
        return unsafe.getChar((long)n2 + this.address);
    }

    final void putChar(int n2, char c2) {
        unsafe.putChar((long)n2 + this.address, c2);
    }

    final int getInt(int n2) {
        return unsafe.getInt((long)n2 + this.address);
    }

    final void putInt(int n2, int n3) {
        unsafe.putInt((long)n2 + this.address, n3);
    }

    final long getLong(int n2) {
        return unsafe.getLong((long)n2 + this.address);
    }

    final void putLong(int n2, long l2) {
        unsafe.putLong((long)n2 + this.address, l2);
    }

    final float getFloat(int n2) {
        return unsafe.getFloat((long)n2 + this.address);
    }

    final void putFloat(int n2, float f2) {
        unsafe.putFloat((long)n2 + this.address, f2);
    }

    final double getDouble(int n2) {
        return unsafe.getDouble((long)n2 + this.address);
    }

    final void putDouble(int n2, double d) {
        unsafe.putDouble((long)n2 + this.address, d);
    }

    static int addressSize() {
        return unsafe.addressSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteOrder byteOrder() {
        if (byteOrder != null) {
            return byteOrder;
        }
        long l2 = unsafe.allocateMemory(8L);
        try {
            unsafe.putLong(l2, 72623859790382856L);
            byte by = unsafe.getByte(l2);
            switch (by) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            }
            unsafe.freeMemory(l2);
        }
        catch (Throwable throwable) {
            unsafe.freeMemory(l2);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        return byteOrder;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = unsafe.pageSize();
        }
        return pageSize;
    }

    protected static /* synthetic */ void _jr$ip$allocationAddress(Object object, long l2) {
        ((NativeObject)((Object)object)).allocationAddress = l2;
    }

    private static /* synthetic */ void _jr$ip$address(NativeObject nativeObject, long l2) {
        nativeObject.address = l2;
    }

    protected /* synthetic */ NativeObject(h h2) {
        super(h2);
    }
}

