/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.IOUtil;
import sun.nio.ch.OptionKey;
import sun.nio.ch.SocketOptionRegistry;
import sun.nio.ch.Util;

class Net
extends h {
    static final ProtocolFamily UNSPEC;
    private static boolean revealLocalAddress;
    private static volatile boolean propRevealLocalAddress;
    private static final boolean exclusiveBind;
    private static volatile boolean checkedIPv6;
    private static volatile boolean isIPv6Available;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;

    private Net() {
    }

    static boolean isIPv6Available() {
        if (!checkedIPv6) {
            isIPv6Available = Net.isIPv6Available0();
            checkedIPv6 = true;
        }
        return isIPv6Available;
    }

    static boolean useExclusiveBind() {
        return exclusiveBind;
    }

    static boolean canIPv6SocketJoinIPv4Group() {
        return Net.canIPv6SocketJoinIPv4Group0();
    }

    static boolean canJoin6WithIPv4Group() {
        return Net.canJoin6WithIPv4Group0();
    }

    static InetSocketAddress checkAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)socketAddress, InetSocketAddress.class) instanceof InetSocketAddress)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedAddressTypeException());
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class);
        if (inetSocketAddress.isUnresolved()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnresolvedAddressException());
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (!(g.convertForInstanceOf((Object)inetAddress, Inet4Address.class) instanceof Inet4Address) && !(g.convertForInstanceOf((Object)inetAddress, Inet6Address.class) instanceof Inet6Address)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid address type"));
        }
        return inetSocketAddress;
    }

    static InetSocketAddress asInetSocketAddress(SocketAddress socketAddress) {
        if (!(g.convertForInstanceOf((Object)socketAddress, InetSocketAddress.class) instanceof InetSocketAddress)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedAddressTypeException());
        }
        return (InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class);
    }

    static void translateToSocketException(Exception exception) throws SocketException {
        if (g.convertForInstanceOf((Object)exception, SocketException.class) instanceof SocketException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((SocketException)g.convertForCast((Object)exception, SocketException.class)));
        }
        Exception exception2 = exception;
        if (g.convertForInstanceOf((Object)exception, ClosedChannelException.class) instanceof ClosedChannelException) {
            exception2 = new SocketException("Socket is closed");
        } else if (g.convertForInstanceOf((Object)exception, NotYetConnectedException.class) instanceof NotYetConnectedException) {
            exception2 = new SocketException("Socket is not connected");
        } else if (g.convertForInstanceOf((Object)exception, AlreadyBoundException.class) instanceof AlreadyBoundException) {
            exception2 = new SocketException("Already bound");
        } else if (g.convertForInstanceOf((Object)exception, NotYetBoundException.class) instanceof NotYetBoundException) {
            exception2 = new SocketException("Socket is not bound yet");
        } else if (g.convertForInstanceOf((Object)exception, UnsupportedAddressTypeException.class) instanceof UnsupportedAddressTypeException) {
            exception2 = new SocketException("Unsupported address type");
        } else if (g.convertForInstanceOf((Object)exception, UnresolvedAddressException.class) instanceof UnresolvedAddressException) {
            exception2 = new SocketException("Unresolved address");
        }
        if (f.ifAcmp((Object)exception2, (Object)exception)) {
            exception2.initCause(exception);
        }
        if (g.convertForInstanceOf((Object)exception2, SocketException.class) instanceof SocketException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((SocketException)g.convertForCast((Object)exception2, SocketException.class)));
        }
        if (g.convertForInstanceOf((Object)exception2, RuntimeException.class) instanceof RuntimeException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)exception2, RuntimeException.class)));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Untranslated exception", exception2));
    }

    static void translateException(Exception exception, boolean bl) throws IOException {
        if (g.convertForInstanceOf((Object)exception, IOException.class) instanceof IOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)exception, IOException.class)));
        }
        if (bl && g.convertForInstanceOf((Object)exception, UnresolvedAddressException.class) instanceof UnresolvedAddressException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException());
        }
        Net.translateToSocketException(exception);
    }

    static void translateException(Exception exception) throws IOException {
        Net.translateException(exception, false);
    }

    static InetSocketAddress getRevealedLocalAddress(InetSocketAddress inetSocketAddress) {
        SecurityManager securityManager = System.getSecurityManager();
        if (inetSocketAddress == null || securityManager == null) {
            return inetSocketAddress;
        }
        if (!Net.getRevealLocalAddress()) {
            try {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            catch (SecurityException securityException) {
                inetSocketAddress = Net.getLoopbackAddress(inetSocketAddress.getPort());
            }
        }
        return inetSocketAddress;
    }

    static String getRevealedLocalAddressAsString(InetSocketAddress inetSocketAddress) {
        if (!Net.getRevealLocalAddress() && System.getSecurityManager() != null) {
            inetSocketAddress = Net.getLoopbackAddress(inetSocketAddress.getPort());
        }
        return inetSocketAddress.toString();
    }

    private static boolean getRevealLocalAddress() {
        if (!propRevealLocalAddress) {
            try {
                revealLocalAddress = Boolean.parseBoolean((String)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */));
            }
            catch (Exception exception) {
                // empty catch block
            }
            propRevealLocalAddress = true;
        }
        return revealLocalAddress;
    }

    private static InetSocketAddress getLoopbackAddress(int n2) {
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), n2);
    }

    static Inet4Address anyInet4Address(NetworkInterface networkInterface) {
        return (Inet4Address)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), Inet4Address.class);
    }

    static int inet4AsInt(InetAddress inetAddress) {
        if (g.convertForInstanceOf((Object)inetAddress, Inet4Address.class) instanceof Inet4Address) {
            byte[] byArray = inetAddress.getAddress();
            int n2 = byArray[3] & 0xFF;
            n2 |= byArray[2] << 8 & 0xFF00;
            n2 |= byArray[1] << 16 & 0xFF0000;
            return n2 |= byArray[0] << 24 & 0xFF000000;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not reach here"));
    }

    static InetAddress inet4FromInt(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not reach here"));
        }
    }

    static byte[] inet6AsByteArray(InetAddress inetAddress) {
        if (g.convertForInstanceOf((Object)inetAddress, Inet6Address.class) instanceof Inet6Address) {
            return inetAddress.getAddress();
        }
        if (g.convertForInstanceOf((Object)inetAddress, Inet4Address.class) instanceof Inet4Address) {
            byte[] byArray = inetAddress.getAddress();
            byte[] byArray2 = new byte[16];
            byArray2[10] = -1;
            byArray2[11] = -1;
            byArray2[12] = byArray[0];
            byArray2[13] = byArray[1];
            byArray2[14] = byArray[2];
            byArray2[15] = byArray[3];
            return byArray2;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not reach here"));
    }

    static void setSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption, Object object) throws IOException {
        boolean bl;
        int n2;
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid option value"));
        }
        Class<?> clazz = socketOption.type();
        if (f.ifAcmp(clazz, Integer.class) && f.ifAcmp(clazz, Boolean.class)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not reach here"));
        }
        if (!(f.ifAcmp(socketOption, StandardSocketOptions.SO_RCVBUF) && f.ifAcmp(socketOption, StandardSocketOptions.SO_SNDBUF) || (n2 = ((Integer)object).intValue()) >= 0)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid send/receive buffer size"));
        }
        if (!f.ifAcmp(socketOption, StandardSocketOptions.SO_LINGER)) {
            n2 = (Integer)object;
            if (n2 < 0) {
                object = -1;
            }
            if (n2 > 65535) {
                object = 65535;
            }
        }
        if (!(f.ifAcmp(socketOption, StandardSocketOptions.IP_TOS) || (n2 = ((Integer)object).intValue()) >= 0 && n2 <= 255)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid IP_TOS value"));
        }
        if (!(f.ifAcmp(socketOption, StandardSocketOptions.IP_MULTICAST_TTL) || (n2 = ((Integer)object).intValue()) >= 0 && n2 <= 255)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid TTL/hop value"));
        }
        OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, protocolFamily);
        if (optionKey == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Option not found"));
        }
        int n3 = !f.ifAcmp(clazz, Integer.class) ? (Integer)object : ((bl = ((Boolean)g.convertForCast((Object)object, Boolean.class)).booleanValue()) ? 1 : 0);
        bl = !f.ifAcmp((Object)protocolFamily, (Object)UNSPEC);
        Net.setIntOption0(fileDescriptor, bl, optionKey.level(), optionKey.name(), n3);
    }

    static Object getSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption) throws IOException {
        Class<?> clazz = socketOption.type();
        if (f.ifAcmp(clazz, Integer.class) && f.ifAcmp(clazz, Boolean.class)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not reach here"));
        }
        OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, protocolFamily);
        if (optionKey == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Option not found"));
        }
        boolean bl = !f.ifAcmp((Object)protocolFamily, (Object)UNSPEC);
        int n2 = Net.getIntOption0(fileDescriptor, bl, optionKey.level(), optionKey.name());
        if (!f.ifAcmp(clazz, Integer.class)) {
            return n2;
        }
        return n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private static native boolean isIPv6Available0();

    private static native int isExclusiveBindAvailable();

    private static native boolean canIPv6SocketJoinIPv4Group0();

    private static native boolean canJoin6WithIPv4Group0();

    static FileDescriptor socket(boolean bl) throws IOException {
        return Net.socket(UNSPEC, bl);
    }

    static FileDescriptor socket(ProtocolFamily protocolFamily, boolean bl) throws IOException {
        boolean bl2 = Net.isIPv6Available() && f.ifAcmp((Object)protocolFamily, (Object)StandardProtocolFamily.INET);
        return IOUtil.newFD(Net.socket0(bl2, bl, false));
    }

    static FileDescriptor serverSocket(boolean bl) {
        return IOUtil.newFD(Net.socket0(Net.isIPv6Available(), bl, true));
    }

    private static native int socket0(boolean var0, boolean var1, boolean var2);

    static void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n2) throws IOException {
        Net.bind(UNSPEC, fileDescriptor, inetAddress, n2);
    }

    static void bind(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n2) throws IOException {
        boolean bl = Net.isIPv6Available() && f.ifAcmp((Object)protocolFamily, (Object)StandardProtocolFamily.INET);
        Net.bind0(fileDescriptor, bl, exclusiveBind, inetAddress, n2);
    }

    private static native void bind0(FileDescriptor var0, boolean var1, boolean var2, InetAddress var3, int var4) throws IOException;

    static native void listen(FileDescriptor var0, int var1) throws IOException;

    static int connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n2) throws IOException {
        return Net.connect(UNSPEC, fileDescriptor, inetAddress, n2);
    }

    static int connect(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n2) throws IOException {
        boolean bl = Net.isIPv6Available() && f.ifAcmp((Object)protocolFamily, (Object)StandardProtocolFamily.INET);
        return Net.connect0(bl, fileDescriptor, inetAddress, n2);
    }

    private static native int connect0(boolean var0, FileDescriptor var1, InetAddress var2, int var3) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    private static native int localPort(FileDescriptor var0) throws IOException;

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress localAddress(FileDescriptor fileDescriptor) throws IOException {
        return new InetSocketAddress(Net.localInetAddress(fileDescriptor), Net.localPort(fileDescriptor));
    }

    private static native int remotePort(FileDescriptor var0) throws IOException;

    private static native InetAddress remoteInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress remoteAddress(FileDescriptor fileDescriptor) throws IOException {
        return new InetSocketAddress(Net.remoteInetAddress(fileDescriptor), Net.remotePort(fileDescriptor));
    }

    private static native int getIntOption0(FileDescriptor var0, boolean var1, int var2, int var3) throws IOException;

    private static native void setIntOption0(FileDescriptor var0, boolean var1, int var2, int var3, int var4) throws IOException;

    static int join4(FileDescriptor fileDescriptor, int n2, int n3, int n4) throws IOException {
        return Net.joinOrDrop4(true, fileDescriptor, n2, n3, n4);
    }

    static void drop4(FileDescriptor fileDescriptor, int n2, int n3, int n4) throws IOException {
        Net.joinOrDrop4(false, fileDescriptor, n2, n3, n4);
    }

    private static native int joinOrDrop4(boolean var0, FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    static int block4(FileDescriptor fileDescriptor, int n2, int n3, int n4) throws IOException {
        return Net.blockOrUnblock4(true, fileDescriptor, n2, n3, n4);
    }

    static void unblock4(FileDescriptor fileDescriptor, int n2, int n3, int n4) throws IOException {
        Net.blockOrUnblock4(false, fileDescriptor, n2, n3, n4);
    }

    private static native int blockOrUnblock4(boolean var0, FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    static int join6(FileDescriptor fileDescriptor, byte[] byArray, int n2, byte[] byArray2) throws IOException {
        return Net.joinOrDrop6(true, fileDescriptor, byArray, n2, byArray2);
    }

    static void drop6(FileDescriptor fileDescriptor, byte[] byArray, int n2, byte[] byArray2) throws IOException {
        Net.joinOrDrop6(false, fileDescriptor, byArray, n2, byArray2);
    }

    private static native int joinOrDrop6(boolean var0, FileDescriptor var1, byte[] var2, int var3, byte[] var4) throws IOException;

    static int block6(FileDescriptor fileDescriptor, byte[] byArray, int n2, byte[] byArray2) throws IOException {
        return Net.blockOrUnblock6(true, fileDescriptor, byArray, n2, byArray2);
    }

    static void unblock6(FileDescriptor fileDescriptor, byte[] byArray, int n2, byte[] byArray2) throws IOException {
        Net.blockOrUnblock6(false, fileDescriptor, byArray, n2, byArray2);
    }

    static native int blockOrUnblock6(boolean var0, FileDescriptor var1, byte[] var2, int var3, byte[] var4) throws IOException;

    static native void setInterface4(FileDescriptor var0, int var1) throws IOException;

    static native int getInterface4(FileDescriptor var0) throws IOException;

    static native void setInterface6(FileDescriptor var0, int var1) throws IOException;

    static native int getInterface6(FileDescriptor var0) throws IOException;

    private static native void initIDs();

    static {
        String string;
        UNSPEC = new ProtocolFamily(){

            @Override
            public String name() {
                return "UNSPEC";
            }
        };
        int n2 = Net.isExclusiveBindAvailable();
        exclusiveBind = n2 >= 0 ? ((string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public String run() {
                return System.getProperty("sun.net.useExclusiveBind");
            }
        })) != null ? (string.length() == 0 ? true : Boolean.parseBoolean(string)) : n2 == 1) : false;
        checkedIPv6 = false;
        Util.load();
        Net.initIDs();
    }

    protected /* synthetic */ Net(h h2) {
        super(h2);
    }
}

