/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.h;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.SelectionKeyImpl;

class PollArrayWrapper
extends h {
    private AllocatedNativeObject pollArray;
    long pollArrayAddress;
    private static final short FD_OFFSET = 0;
    private static final short EVENT_OFFSET = 4;
    static short SIZE_POLLFD = (short)8;
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 2;
    private int size;

    PollArrayWrapper(int n2) {
        int n3 = n2 * SIZE_POLLFD;
        this.pollArray = new AllocatedNativeObject(n3, true);
        this.pollArrayAddress = this.pollArray.address();
        this.size = n2;
    }

    void addEntry(int n2, SelectionKeyImpl selectionKeyImpl) {
        this.putDescriptor(n2, SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).getFDVal());
    }

    void replaceEntry(PollArrayWrapper pollArrayWrapper, int n2, PollArrayWrapper pollArrayWrapper2, int n3) {
        pollArrayWrapper2.putDescriptor(n3, pollArrayWrapper.getDescriptor(n2));
        pollArrayWrapper2.putEventOps(n3, pollArrayWrapper.getEventOps(n2));
    }

    void grow(int n2) {
        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n2);
        for (int i = 0; i < this.size; ++i) {
            this.replaceEntry(this, i, pollArrayWrapper, i);
        }
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.size = pollArrayWrapper.size;
        ((PollArrayWrapper)((Object)((Object)this))).pollArrayAddress = this.pollArray.address();
    }

    void free() {
        this.pollArray.free();
    }

    void putDescriptor(int n2, int n3) {
        this.pollArray.putInt(SIZE_POLLFD * n2 + 0, n3);
    }

    void putEventOps(int n2, int n3) {
        this.pollArray.putShort(SIZE_POLLFD * n2 + 4, (short)n3);
    }

    int getEventOps(int n2) {
        return this.pollArray.getShort(SIZE_POLLFD * n2 + 4);
    }

    int getDescriptor(int n2) {
        return this.pollArray.getInt(SIZE_POLLFD * n2 + 0);
    }

    void addWakeupSocket(int n2, int n3) {
        this.putDescriptor(n3, n2);
        this.putEventOps(n3, 1);
    }

    static /* synthetic */ long _jr$ig$pollArrayAddress(Object object) {
        return ((PollArrayWrapper)((Object)object)).pollArrayAddress;
    }

    protected /* synthetic */ PollArrayWrapper(h h2) {
        super(h2);
    }
}

