/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

abstract class SelectorImpl
extends AbstractSelector {
    protected Set<SelectionKey> selectedKeys;
    protected HashSet<SelectionKey> keys;
    private Set<SelectionKey> publicKeys;
    private Set<SelectionKey> publicSelectedKeys;

    protected SelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.keys = new HashSet();
        this.selectedKeys = new HashSet<SelectionKey>();
        if (Util.atBugLevel("1.4")) {
            this.publicKeys = this.keys;
            this.publicSelectedKeys = this.selectedKeys;
        } else {
            this.publicKeys = Collections.unmodifiableSet(this.keys);
            this.publicSelectedKeys = Util.ungrowableSet(this.selectedKeys);
        }
    }

    @Override
    public Set<SelectionKey> keys() {
        if (!this.isOpen() && !Util.atBugLevel("1.4")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedSelectorException());
        }
        return this.publicKeys;
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        if (!this.isOpen() && !Util.atBugLevel("1.4")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedSelectorException());
        }
        return this.publicSelectedKeys;
    }

    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockAndDoSelect(long l) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedSelectorException());
                }
                Object object2 = ah.getMonitor((Object)this.publicKeys);
                synchronized (object2) {
                    try {
                        Object object3 = ah.getMonitor((Object)this.publicSelectedKeys);
                        synchronized (object3) {
                            try {
                                return this.doSelect(l);
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public int select(long l) throws IOException {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative timeout"));
        }
        return this.lockAndDoSelect(l == 0L ? -1L : l);
    }

    @Override
    public int select() throws IOException {
        return this.select(0L);
    }

    @Override
    public int selectNow() throws IOException {
        return this.lockAndDoSelect(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelector() throws IOException {
        this.wakeup();
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object object2 = ah.getMonitor((Object)this.publicKeys);
                synchronized (object2) {
                    try {
                        Object object3 = ah.getMonitor((Object)this.publicSelectedKeys);
                        synchronized (object3) {
                            try {
                                this.implClose();
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected abstract void implClose() throws IOException;

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        if (!(g.convertForInstanceOf((Object)abstractSelectableChannel, SelChImpl.class) instanceof SelChImpl)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalSelectorException());
        }
        SelectionKeyImpl selectionKeyImpl = new SelectionKeyImpl((SelChImpl)g.convertForCast((Object)abstractSelectableChannel, SelChImpl.class), this);
        selectionKeyImpl.attach(object);
        Object object2 = ah.getMonitor((Object)this.publicKeys);
        synchronized (object2) {
            try {
                this.implRegister(selectionKeyImpl);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        selectionKeyImpl.interestOps(n);
        return selectionKeyImpl;
    }

    protected abstract void implRegister(SelectionKeyImpl var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDeregisterQueue() throws IOException {
        Set<SelectionKey> set = this.cancelledKeys();
        Object object = ah.getMonitor(set);
        synchronized (object) {
            try {
                if (!set.isEmpty()) {
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)((Object)g.convertForCast((Object)((Object)iterator.next()), SelectionKeyImpl.class));
                        try {
                            this.implDereg(selectionKeyImpl);
                            iterator.remove();
                        }
                        catch (SocketException socketException) {
                            try {
                                IOException iOException = new IOException("Error deregistering key");
                                iOException.initCause(socketException);
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                            }
                            catch (Throwable throwable) {
                                iterator.remove();
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected abstract void implDereg(SelectionKeyImpl var1) throws IOException;

    @Override
    public abstract Selector wakeup();

    protected static /* synthetic */ Set _jr$ig$selectedKeys(Object object) {
        return ((SelectorImpl)object).selectedKeys;
    }

    protected static /* synthetic */ void _jr$ip$selectedKeys(Object object, Set set) {
        ((SelectorImpl)object).selectedKeys = set;
    }

    protected static /* synthetic */ HashSet _jr$ig$keys(Object object) {
        return ((SelectorImpl)object).keys;
    }

    protected static /* synthetic */ void _jr$ip$keys(Object object, HashSet hashSet) {
        ((SelectorImpl)object).keys = hashSet;
    }

    private static /* synthetic */ void _jr$ip$publicKeys(SelectorImpl selectorImpl, Set set) {
        selectorImpl.publicKeys = set;
    }

    private static /* synthetic */ void _jr$ip$publicSelectedKeys(SelectorImpl selectorImpl, Set set) {
        selectorImpl.publicSelectedKeys = set;
    }

    protected /* synthetic */ SelectorImpl(h h2) {
        super(h2);
    }
}

