/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.net.NetHooks;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.ServerSocketAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.Util;

class ServerSocketChannelImpl
extends ServerSocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private int fdVal;
    private volatile long thread;
    private final Object lock;
    private final Object stateLock;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private int state;
    private InetSocketAddress localAddress;
    private boolean isReuseAddress;
    ServerSocket socket;

    ServerSocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.thread = 0L;
        this.lock = new Object();
        this.stateLock = new Object();
        this.state = -1;
        this.fd = Net.serverSocket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    ServerSocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, boolean bl) throws IOException {
        super(selectorProvider);
        this.thread = 0L;
        this.lock = new Object();
        this.stateLock = new Object();
        this.state = -1;
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        if (bl) {
            this.localAddress = Net.localAddress(fileDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocket socket() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (((ServerSocketChannelImpl)this).socket == null) {
                    ((ServerSocketChannelImpl)this).socket = ServerSocketAdaptor.create(this);
                }
                return ((ServerSocketChannelImpl)this).socket;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                return this.localAddress == null ? this.localAddress : Net.getRevealedLocalAddress(Net.asInetSocketAddress(this.localAddress));
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServerSocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("'" + socketOption + "' not supported"));
        }
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!f.ifAcmp(socketOption, StandardSocketOptions.SO_REUSEADDR) && Net.useExclusiveBind()) {
                    this.isReuseAddress = (Boolean)g.convertForCast(t, Boolean.class);
                } else {
                    Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
                }
                return this;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("'" + socketOption + "' not supported"));
        }
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!f.ifAcmp(socketOption, StandardSocketOptions.SO_REUSEADDR) && Net.useExclusiveBind()) {
                    return (T)Boolean.valueOf(this.isReuseAddress);
                }
                return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.localAddress != null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress localAddress() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.localAddress;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocketChannel bind(SocketAddress socketAddress, int n2) throws IOException {
        Object object = ah.getMonitor((Object)this.lock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (this.isBound()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AlreadyBoundException());
                }
                InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkListen(inetSocketAddress.getPort());
                }
                NetHooks.beforeTcpBind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                Net.listen(this.fd, n2 < 1 ? 50 : n2);
                Object object2 = ah.getMonitor((Object)this.stateLock);
                synchronized (object2) {
                    try {
                        this.localAddress = Net.localAddress(this.fd);
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketChannel accept() throws IOException {
        Object object = ah.getMonitor((Object)this.lock);
        synchronized (object) {
            try {
                InetSocketAddress[] inetSocketAddressArray;
                FileDescriptor fileDescriptor;
                int n2;
                SocketChannelImpl socketChannelImpl;
                block16: {
                    if (!this.isOpen()) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                    }
                    if (!this.isBound()) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotYetBoundException());
                    }
                    socketChannelImpl = null;
                    n2 = 0;
                    fileDescriptor = new FileDescriptor();
                    inetSocketAddressArray = new InetSocketAddress[1];
                    this.begin();
                    if (this.isOpen()) break block16;
                    SocketChannel socketChannel = null;
                    this.thread = 0L;
                    this.end(n2 > 0);
                    if (!$assertionsDisabled && !IOStatus.check(n2)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    return socketChannel;
                }
                try {
                    this.thread = NativeThread.current();
                    while ((n2 = this.accept0(this.fd, fileDescriptor, inetSocketAddressArray)) == -3 && this.isOpen()) {
                    }
                }
                catch (Throwable throwable) {
                    this.thread = 0L;
                    this.end(n2 > 0);
                    if (!$assertionsDisabled && !IOStatus.check(n2)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                this.thread = 0L;
                this.end(n2 > 0);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                if (n2 < 1) {
                    return null;
                }
                IOUtil.configureBlocking(fileDescriptor, true);
                InetSocketAddress inetSocketAddress = inetSocketAddressArray[0];
                socketChannelImpl = new SocketChannelImpl(this.provider(), fileDescriptor, inetSocketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    catch (SecurityException securityException) {
                        socketChannelImpl.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
                    }
                }
                return socketChannelImpl;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                long l;
                if (this.state != 1) {
                    nd.preClose(this.fd);
                }
                if ((l = this.thread) != 0L) {
                    NativeThread.signal(l);
                }
                if (!this.isRegistered()) {
                    this.kill();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (this.state == 1) {
                    return;
                }
                if (this.state == -1) {
                    this.state = 1;
                    return;
                }
                if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                nd.close(this.fd);
                this.state = 1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean translateReadyOps(int n2, int n3, SelectionKeyImpl selectionKeyImpl) {
        int n4 = selectionKeyImpl.nioInterestOps();
        int n5 = selectionKeyImpl.nioReadyOps();
        int n6 = n3;
        if ((n2 & 0x20) != 0) {
            return false;
        }
        if ((n2 & 0x18) != 0) {
            n6 = n4;
            selectionKeyImpl.nioReadyOps(n6);
            return (n6 & ~n5) != 0;
        }
        if ((n2 & 1) != 0 && (n4 & 0x10) != 0) {
            n6 |= 0x10;
        }
        selectionKeyImpl.nioReadyOps(n6);
        return (n6 & ~n5) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, 0, selectionKeyImpl);
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x10) != 0) {
            n3 |= 1;
        }
        SelectionKeyImpl._jr$ig$selector((Object)selectionKeyImpl).putEventOps(selectionKeyImpl, n3);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(x.getName(this.getClass()));
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = ah.getMonitor((Object)this.stateLock);
            synchronized (object) {
                try {
                    InetSocketAddress inetSocketAddress = this.localAddress();
                    if (inetSocketAddress == null) {
                        stringBuffer.append("unbound");
                    } else {
                        stringBuffer.append(Net.getRevealedLocalAddressAsString(inetSocketAddress));
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    private static native void initIDs();

    static {
        Util.load();
        ServerSocketChannelImpl.initIDs();
        nd = new SocketDispatcher();
    }

    private static /* synthetic */ void _jr$ip$fd(ServerSocketChannelImpl serverSocketChannelImpl, FileDescriptor fileDescriptor) {
        serverSocketChannelImpl.fd = fileDescriptor;
    }

    private static /* synthetic */ void _jr$ip$fdVal(ServerSocketChannelImpl serverSocketChannelImpl, int n2) {
        serverSocketChannelImpl.fdVal = n2;
    }

    private static /* synthetic */ void _jr$ip$lock(ServerSocketChannelImpl serverSocketChannelImpl, Object object) {
        serverSocketChannelImpl.lock = object;
    }

    private static /* synthetic */ void _jr$ip$stateLock(ServerSocketChannelImpl serverSocketChannelImpl, Object object) {
        serverSocketChannelImpl.stateLock = object;
    }

    protected /* synthetic */ ServerSocketChannelImpl(h h2) {
        super(h2);
    }

    private static class DefaultOptionsHolder
    extends h {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<h>> hashSet = new HashSet<SocketOption<h>>(2);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            return Collections.unmodifiableSet(hashSet);
        }

        protected /* synthetic */ DefaultOptionsHolder(h h2) {
            super(h2);
        }
    }
}

