/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.nio.ch.FileKey;
import sun.nio.ch.FileLockTable;

class SharedFileLockTable
extends FileLockTable {
    private static ConcurrentHashMap<FileKey, List<FileLockReference>> lockMap = new ConcurrentHashMap();
    private static ReferenceQueue<FileLock> queue = new ReferenceQueue();
    private final Channel channel;
    private final FileKey fileKey;

    SharedFileLockTable(Channel channel, FileDescriptor fileDescriptor) throws IOException {
        this.channel = channel;
        this.fileKey = FileKey.create(fileDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(FileLock fileLock) throws OverlappingFileLockException {
        Object object = (ArrayList<FileLockReference>)g.convertForCast(lockMap.get((Object)this.fileKey), List.class);
        while (true) {
            Object object2;
            Object object3;
            if (object == null) {
                object = new ArrayList<FileLockReference>(2);
                object3 = ah.getMonitor(object);
                synchronized (object3) {
                    try {
                        object2 = (List)g.convertForCast(lockMap.putIfAbsent(this.fileKey, (List<FileLockReference>)object), List.class);
                        if (object2 == null) {
                            object.add(new FileLockReference(fileLock, queue, this.fileKey));
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                object = object2;
            }
            object2 = ah.getMonitor((Object)object);
            synchronized (object2) {
                try {
                    object3 = (List)g.convertForCast(lockMap.get((Object)this.fileKey), List.class);
                    if (!f.ifAcmp(object, (Object)object3)) {
                        this.checkList((List<FileLockReference>)object, fileLock.position(), fileLock.size());
                        object.add(new FileLockReference(fileLock, queue, this.fileKey));
                        break;
                    }
                    object = object3;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        this.removeStaleEntries();
    }

    private void removeKeyIfEmpty(FileKey fileKey, List<FileLockReference> list) {
        if (!$assertionsDisabled && !Thread.holdsLock(ah.getMonitor(list))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (!$assertionsDisabled && f.ifAcmp(lockMap.get((Object)fileKey), list)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (list.isEmpty()) {
            lockMap.remove((Object)fileKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(FileLock fileLock) {
        if (!$assertionsDisabled && fileLock == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        List list = (List)g.convertForCast(lockMap.get((Object)this.fileKey), List.class);
        if (list == null) {
            return;
        }
        Object object = ah.getMonitor((Object)list);
        synchronized (object) {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    FileLockReference fileLockReference = (FileLockReference)((Object)g.convertForCast(list.get(i), FileLockReference.class));
                    FileLock fileLock2 = (FileLock)g.convertForCast(fileLockReference.get(), FileLock.class);
                    if (f.ifAcmp((Object)fileLock2, (Object)fileLock)) continue;
                    if (!$assertionsDisabled && (fileLock2 == null || f.ifAcmp((Object)fileLock2.acquiredBy(), (Object)this.channel))) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    fileLockReference.clear();
                    list.remove(i);
                    break;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileLock> removeAll() {
        ArrayList<FileLock> arrayList = new ArrayList<FileLock>();
        List list = (List)g.convertForCast(lockMap.get((Object)this.fileKey), List.class);
        if (list != null) {
            Object object = ah.getMonitor((Object)list);
            synchronized (object) {
                try {
                    int n = 0;
                    while (n < list.size()) {
                        FileLockReference fileLockReference = (FileLockReference)((Object)g.convertForCast(list.get(n), FileLockReference.class));
                        FileLock fileLock = (FileLock)g.convertForCast(fileLockReference.get(), FileLock.class);
                        if (fileLock != null && !f.ifAcmp((Object)fileLock.acquiredBy(), (Object)this.channel)) {
                            fileLockReference.clear();
                            list.remove(n);
                            arrayList.add(fileLock);
                            continue;
                        }
                        ++n;
                    }
                    this.removeKeyIfEmpty(this.fileKey, list);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(FileLock fileLock, FileLock fileLock2) {
        List list = (List)g.convertForCast(lockMap.get((Object)this.fileKey), List.class);
        if (!$assertionsDisabled && list == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        Object object = ah.getMonitor((Object)list);
        synchronized (object) {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    FileLockReference fileLockReference = (FileLockReference)((Object)g.convertForCast(list.get(i), FileLockReference.class));
                    FileLock fileLock3 = (FileLock)g.convertForCast(fileLockReference.get(), FileLock.class);
                    if (f.ifAcmp((Object)fileLock3, (Object)fileLock)) continue;
                    fileLockReference.clear();
                    list.set(i, new FileLockReference(fileLock2, queue, this.fileKey));
                    break;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void checkList(List<FileLockReference> list, long l, long l2) throws OverlappingFileLockException {
        if (!$assertionsDisabled && !Thread.holdsLock(ah.getMonitor(list))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        Iterator<FileLockReference> iterator = list.iterator();
        while (iterator.hasNext()) {
            FileLockReference fileLockReference = (FileLockReference)((Object)g.convertForCast((Object)((Object)iterator.next()), FileLockReference.class));
            FileLock fileLock = (FileLock)g.convertForCast(fileLockReference.get(), FileLock.class);
            if (fileLock == null || !fileLock.overlaps(l, l2)) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new OverlappingFileLockException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleEntries() {
        FileLockReference fileLockReference;
        while ((fileLockReference = (FileLockReference)((Object)g.convertForCast(queue.poll(), FileLockReference.class))) != null) {
            FileKey fileKey = fileLockReference.fileKey();
            List list = (List)g.convertForCast(lockMap.get((Object)fileKey), List.class);
            if (list == null) continue;
            Object object = ah.getMonitor((Object)list);
            synchronized (object) {
                try {
                    list.remove((Object)fileLockReference);
                    this.removeKeyIfEmpty(fileKey, list);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    private static /* synthetic */ void _jr$ip$channel(SharedFileLockTable sharedFileLockTable, Channel channel) {
        sharedFileLockTable.channel = channel;
    }

    private static /* synthetic */ void _jr$ip$fileKey(SharedFileLockTable sharedFileLockTable, FileKey fileKey) {
        sharedFileLockTable.fileKey = fileKey;
    }

    protected /* synthetic */ SharedFileLockTable(h h2) {
        super(h2);
    }

    private static class FileLockReference
    extends WeakReference<FileLock> {
        private FileKey fileKey;

        FileLockReference(FileLock fileLock, ReferenceQueue<FileLock> referenceQueue, FileKey fileKey) {
            super(fileLock, referenceQueue);
            this.fileKey = fileKey;
        }

        FileKey fileKey() {
            return this.fileKey;
        }

        private static /* synthetic */ void _jr$ip$fileKey(FileLockReference fileLockReference, FileKey fileKey) {
            fileLockReference.fileKey = fileKey;
        }

        protected /* synthetic */ FileLockReference(h h2) {
            super(h2);
        }
    }
}

