/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile int timeout;
    private InputStream socketInputStream;

    private SocketAdaptor(SocketChannelImpl socketChannelImpl) throws SocketException {
        super((SocketImpl)g.convertForCast(null, SocketImpl.class));
        this.timeout = 0;
        this.socketInputStream = null;
        this.sc = socketChannelImpl;
    }

    public static Socket create(SocketChannelImpl socketChannelImpl) {
        try {
            return new SocketAdaptor(socketChannelImpl);
        }
        catch (SocketException socketException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Should not reach here"));
        }
    }

    @Override
    public SocketChannel getChannel() {
        return this.sc;
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("connect: The address can't be null"));
        }
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("connect: timeout can't be negative"));
        }
        Object object = ah.getMonitor((Object)this.sc.blockingLock());
        synchronized (object) {
            try {
                if (!this.sc.isBlocking()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalBlockingModeException());
                }
                try {
                    Selector selector;
                    block26: {
                        SelectionKey selectionKey;
                        block23: {
                            block24: {
                                if (n == 0) {
                                    this.sc.connect(socketAddress);
                                    return;
                                }
                                selectionKey = null;
                                selector = null;
                                this.sc.configureBlocking(false);
                                if (!this.sc.connect(socketAddress)) break block23;
                                if (selectionKey == null) break block24;
                                selectionKey.cancel();
                            }
                            if (this.sc.isOpen()) {
                                this.sc.configureBlocking(true);
                            }
                            if (selector != null) {
                                Util.releaseTemporarySelector(selector);
                            }
                            return;
                        }
                        try {
                            block25: {
                                long l;
                                selector = Util.getTemporarySelector(this.sc);
                                selectionKey = this.sc.register(selector, 8);
                                long l2 = n;
                                do {
                                    if (!this.sc.isOpen()) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                                    }
                                    l = System.currentTimeMillis();
                                    int n2 = selector.select(l2);
                                    if (n2 > 0 && selectionKey.isConnectable() && this.sc.finishConnect()) break block25;
                                    selector.selectedKeys().remove((Object)selectionKey);
                                } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                                try {
                                    this.sc.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketTimeoutException());
                            }
                            if (selectionKey == null) break block26;
                            selectionKey.cancel();
                        }
                        catch (Throwable throwable) {
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (this.sc.isOpen()) {
                                this.sc.configureBlocking(true);
                            }
                            if (selector != null) {
                                Util.releaseTemporarySelector(selector);
                            }
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (selector != null) {
                        Util.releaseTemporarySelector(selector);
                    }
                }
                catch (Exception exception) {
                    Net.translateException(exception, true);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        SocketAddress socketAddress = this.sc.remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        return ((InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class)).getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        if (this.sc.isOpen() && (inetSocketAddress = this.sc.localAddress()) != null) {
            return Net.getRevealedLocalAddress(inetSocketAddress).getAddress();
        }
        return new InetSocketAddress(0).getAddress();
    }

    @Override
    public int getPort() {
        SocketAddress socketAddress = this.sc.remoteAddress();
        if (socketAddress == null) {
            return 0;
        }
        return ((InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class)).getPort();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress inetSocketAddress = this.sc.localAddress();
        if (inetSocketAddress == null) {
            return -1;
        }
        return ((InetSocketAddress)g.convertForCast((Object)inetSocketAddress, InetSocketAddress.class)).getPort();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.sc.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not connected"));
        }
        if (!this.sc.isInputOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket input is shutdown"));
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = (InputStream)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), InputStream.class);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
            }
        }
        return this.socketInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.sc.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not connected"));
        }
        if (!this.sc.isOutputOpen()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket output is shutdown"));
        }
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), OutputStream.class);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
        }
        return outputStream;
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.sc.setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.sc.setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return (Boolean)g.convertForCast((Object)this.sc.getOption(socketOption), Boolean.class);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return (Integer)g.convertForCast((Object)this.sc.getOption(socketOption), Integer.class);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.TCP_NODELAY, bl);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.TCP_NODELAY);
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (!bl) {
            n = -1;
        }
        this.setIntOption(StandardSocketOptions.SO_LINGER, n);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_LINGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUrgentData(int n) throws IOException {
        Object object = ah.getMonitor((Object)this.sc.blockingLock());
        synchronized (object) {
            try {
                if (!this.sc.isBlocking()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalBlockingModeException());
                }
                int n2 = this.sc.sendOutOfBandData((byte)n);
                if (!$assertionsDisabled && n2 != 1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        this.setBooleanOption(ExtendedSocketOption.SO_OOBINLINE, bl);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.getBooleanOption(ExtendedSocketOption.SO_OOBINLINE);
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("timeout can't be negative"));
        }
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid send size"));
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid receive size"));
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_KEEPALIVE, bl);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_KEEPALIVE);
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, n);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void close() throws IOException {
        this.sc.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.sc.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.sc.localAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    @Override
    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    static /* synthetic */ int access$100(SocketAdaptor socketAdaptor) {
        return socketAdaptor.timeout;
    }

    private static /* synthetic */ void _jr$ip$sc(SocketAdaptor socketAdaptor, SocketChannelImpl socketChannelImpl) {
        socketAdaptor.sc = socketChannelImpl;
    }

    protected /* synthetic */ SocketAdaptor(h h2) {
        super(h2);
    }

    private class SocketInputStream
    extends ChannelInputStream {
        final /* synthetic */ SocketAdaptor this$0;

        private SocketInputStream(SocketAdaptor socketAdaptor) {
            this.this$0 = socketAdaptor;
            super(socketAdaptor.sc);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected int read(ByteBuffer var1_1) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 9[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static /* synthetic */ SocketAdaptor _jr$ig$this$0(Object object) {
            return ((SocketInputStream)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, SocketAdaptor socketAdaptor) {
            ((SocketInputStream)object).this$0 = socketAdaptor;
        }

        protected /* synthetic */ SocketInputStream(h h2) {
            super(h2);
        }
    }
}

