/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.misc.IoTrace;
import sun.net.NetHooks;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.Util;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread;
    private volatile long writerThread;
    private final Object readLock;
    private final Object writeLock;
    private final Object stateLock;
    private boolean isReuseAddress;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private boolean isInputOpen;
    private boolean isOutputOpen;
    private boolean readyToConnect;
    private Socket socket;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.readerThread = 0L;
        this.writerThread = 0L;
        this.readLock = new Object();
        this.writeLock = new Object();
        this.stateLock = new Object();
        this.state = -1;
        this.isInputOpen = true;
        this.isOutputOpen = true;
        this.readyToConnect = false;
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, boolean bl) throws IOException {
        super(selectorProvider);
        this.readerThread = 0L;
        this.writerThread = 0L;
        this.readLock = new Object();
        this.writeLock = new Object();
        this.stateLock = new Object();
        this.state = -1;
        this.isInputOpen = true;
        this.isOutputOpen = true;
        this.readyToConnect = false;
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        if (bl) {
            this.localAddress = Net.localAddress(fileDescriptor);
        }
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.readerThread = 0L;
        this.writerThread = 0L;
        this.readLock = new Object();
        this.writeLock = new Object();
        this.stateLock = new Object();
        this.state = -1;
        this.isInputOpen = true;
        this.isOutputOpen = true;
        this.readyToConnect = false;
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 2;
        this.localAddress = Net.localAddress(fileDescriptor);
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (this.socket == null) {
                    this.socket = SocketAdaptor.create(this);
                }
                return this.socket;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                return Net.getRevealedLocalAddress(this.localAddress);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                return this.remoteAddress;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("'" + socketOption + "' not supported"));
        }
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!f.ifAcmp(socketOption, StandardSocketOptions.IP_TOS)) {
                    if (!Net.isIPv6Available()) {
                        Net.setSocketOption(this.fd, StandardProtocolFamily.INET, socketOption, t);
                    }
                    return this;
                }
                if (!f.ifAcmp(socketOption, StandardSocketOptions.SO_REUSEADDR) && Net.useExclusiveBind()) {
                    this.isReuseAddress = (Boolean)g.convertForCast(t, Boolean.class);
                    return this;
                }
                Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
                return this;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("'" + socketOption + "' not supported"));
        }
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!f.ifAcmp(socketOption, StandardSocketOptions.SO_REUSEADDR) && Net.useExclusiveBind()) {
                    return (T)Boolean.valueOf(this.isReuseAddress);
                }
                if (!f.ifAcmp(socketOption, StandardSocketOptions.IP_TOS)) {
                    return (T)(Net.isIPv6Available() ? Integer.valueOf(0) : Net.getSocketOption(this.fd, StandardProtocolFamily.INET, socketOption));
                }
                return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!this.isConnected()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotYetConnectedException());
                }
                return this.isInputOpen;
                {
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!this.isOutputOpen) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!this.isConnected()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotYetConnectedException());
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerCleanup() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerCleanup() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                this.writerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer var1_1) throws IOException {
        if (var1_1 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        var2_2 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$readLock(this));
        synchronized (var2_2) {
            try {
                if (!this.ensureReadOpen()) {
                    return -1;
                }
                var3_3 = null;
                if (this.isBlocking()) {
                    var3_3 = IoTrace.socketReadBegin();
                }
                var4_4 = 0;
                this.begin();
                var5_5 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var5_5) {
                    if (this.isOpen()) ** break block32
                    var6_7 = 0;
                }
                this.readerCleanup();
                if (this.isBlocking()) {
                    IoTrace.socketReadEnd((Object)var3_3, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (int)0, (long)(var4_4 > 0 ? (long)var4_4 : 0L));
                }
                this.end(var4_4 > 0 || var4_4 == -2);
                var7_9 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var7_9) {
                    try {
                        if (var4_4 <= 0 && !SocketChannelImpl._jr$ig$isInputOpen(this)) {
                            return -1;
                        }
                    }
                    catch (Throwable var8_10) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var8_10);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var4_4)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var6_7;
                {
                    SocketChannelImpl._jr$ip$readerThread(this, NativeThread.current());
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 8, 9] lbl45 : MonitorExitStatement: MONITOREXIT : var5_5
                    {
                        catch (Throwable var9_11) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var9_11);
                        }
                    }
                    while ((var4_4 = IOUtil.read(SocketChannelImpl._jr$ig$fd(this), var1_1, -1L, SocketChannelImpl.nd)) == -3 && this.isOpen()) {
                    }
                    var5_6 = IOStatus.normalize(var4_4);
                }
                this.readerCleanup();
                if (this.isBlocking()) {
                    IoTrace.socketReadEnd((Object)var3_3, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (int)0, (long)(var4_4 > 0 ? (long)var4_4 : 0L));
                }
                this.end(var4_4 > 0 || var4_4 == -2);
                var6_8 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var6_8) {
                    try {
                        if (var4_4 <= 0 && !SocketChannelImpl._jr$ig$isInputOpen(this)) {
                            return -1;
                        }
                    }
                    catch (Throwable var10_12) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var10_12);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var4_4)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var5_6;
                {
                    catch (Throwable var11_13) {
                        this.readerCleanup();
                        if (this.isBlocking()) {
                            IoTrace.socketReadEnd((Object)var3_3, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (int)0, (long)(var4_4 > 0 ? (long)var4_4 : 0L));
                        }
                        this.end(var4_4 > 0 || var4_4 == -2);
                        var12_14 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                        synchronized (var12_14) {
                            try {
                                if (var4_4 <= 0 && !SocketChannelImpl._jr$ig$isInputOpen(this)) {
                                    return -1;
                                }
                            }
                            catch (Throwable var13_15) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var13_15);
                            }
                        }
                        if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var4_4)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var11_13);
                    }
                }
            }
            catch (Throwable var14_16) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var14_16);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 < 0 || var3_3 < 0 || var2_2 > a.arrayLength((Object[])var1_1) - var3_3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        var4_4 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$readLock(this));
        synchronized (var4_4) {
            try {
                if (!this.ensureReadOpen()) {
                    return -1L;
                }
                var5_5 = 0L;
                var7_6 = null;
                if (this.isBlocking()) {
                    var7_6 = IoTrace.socketReadBegin();
                }
                this.begin();
                var8_7 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var8_7) {
                    if (this.isOpen()) ** break block32
                    var9_9 = 0L;
                }
                this.readerCleanup();
                if (this.isBlocking()) {
                    IoTrace.socketReadEnd((Object)var7_6, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (int)0, (long)(var5_5 > 0L ? var5_5 : 0L));
                }
                this.end(var5_5 > 0L || var5_5 == -2L);
                var11_10 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var11_10) {
                    try {
                        if (var5_5 <= 0L && !SocketChannelImpl._jr$ig$isInputOpen(this)) {
                            return -1L;
                        }
                    }
                    catch (Throwable var12_11) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var12_11);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var5_5)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var9_9;
                {
                    SocketChannelImpl._jr$ip$readerThread(this, NativeThread.current());
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 8, 9] lbl45 : MonitorExitStatement: MONITOREXIT : var8_7
                    {
                        catch (Throwable var13_12) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var13_12);
                        }
                    }
                    while ((var5_5 = IOUtil.read(SocketChannelImpl._jr$ig$fd(this), var1_1, var2_2, var3_3, SocketChannelImpl.nd)) == -3L && this.isOpen()) {
                    }
                    var8_8 = IOStatus.normalize(var5_5);
                }
                this.readerCleanup();
                if (this.isBlocking()) {
                    IoTrace.socketReadEnd((Object)var7_6, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (int)0, (long)(var5_5 > 0L ? var5_5 : 0L));
                }
                this.end(var5_5 > 0L || var5_5 == -2L);
                var10_13 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var10_13) {
                    try {
                        if (var5_5 <= 0L && !SocketChannelImpl._jr$ig$isInputOpen(this)) {
                            return -1L;
                        }
                    }
                    catch (Throwable var14_14) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var14_14);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var5_5)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var8_8;
                {
                    catch (Throwable var15_15) {
                        this.readerCleanup();
                        if (this.isBlocking()) {
                            IoTrace.socketReadEnd((Object)var7_6, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (int)0, (long)(var5_5 > 0L ? var5_5 : 0L));
                        }
                        this.end(var5_5 > 0L || var5_5 == -2L);
                        var16_16 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                        synchronized (var16_16) {
                            try {
                                if (var5_5 <= 0L && !SocketChannelImpl._jr$ig$isInputOpen(this)) {
                                    return -1L;
                                }
                            }
                            catch (Throwable var17_17) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var17_17);
                            }
                        }
                        if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var5_5)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var15_15);
                    }
                }
            }
            catch (Throwable var18_18) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var18_18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer var1_1) throws IOException {
        if (var1_1 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        var2_2 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$writeLock(this));
        synchronized (var2_2) {
            try {
                this.ensureWriteOpen();
                var3_3 = 0;
                var4_4 = IoTrace.socketWriteBegin();
                this.begin();
                var5_5 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var5_5) {
                    if (this.isOpen()) ** break block27
                    var6_7 = 0;
                }
                this.writerCleanup();
                IoTrace.socketWriteEnd((Object)var4_4, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (long)(var3_3 > 0 ? (long)var3_3 : 0L));
                this.end(var3_3 > 0 || var3_3 == -2);
                var7_9 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var7_9) {
                    try {
                        if (var3_3 <= 0 && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                        }
                    }
                    catch (Throwable var8_10) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var8_10);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var6_7;
                {
                    SocketChannelImpl._jr$ip$writerThread(this, NativeThread.current());
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 8, 9] lbl38 : MonitorExitStatement: MONITOREXIT : var5_5
                    {
                        catch (Throwable var9_11) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var9_11);
                        }
                    }
                    while ((var3_3 = IOUtil.write(SocketChannelImpl._jr$ig$fd(this), var1_1, -1L, SocketChannelImpl.nd)) == -3 && this.isOpen()) {
                    }
                    var5_6 = IOStatus.normalize(var3_3);
                }
                this.writerCleanup();
                IoTrace.socketWriteEnd((Object)var4_4, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (long)(var3_3 > 0 ? (long)var3_3 : 0L));
                this.end(var3_3 > 0 || var3_3 == -2);
                var6_8 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var6_8) {
                    try {
                        if (var3_3 <= 0 && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                        }
                    }
                    catch (Throwable var10_12) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var10_12);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var5_6;
                {
                    catch (Throwable var11_13) {
                        this.writerCleanup();
                        IoTrace.socketWriteEnd((Object)var4_4, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (long)(var3_3 > 0 ? (long)var3_3 : 0L));
                        this.end(var3_3 > 0 || var3_3 == -2);
                        var12_14 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                        synchronized (var12_14) {
                            try {
                                if (var3_3 <= 0 && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                                }
                            }
                            catch (Throwable var13_15) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var13_15);
                            }
                        }
                        if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var11_13);
                    }
                }
            }
            catch (Throwable var14_16) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var14_16);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 < 0 || var3_3 < 0 || var2_2 > a.arrayLength((Object[])var1_1) - var3_3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        var4_4 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$writeLock(this));
        synchronized (var4_4) {
            try {
                this.ensureWriteOpen();
                var5_5 = 0L;
                var7_6 = IoTrace.socketWriteBegin();
                this.begin();
                var8_7 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var8_7) {
                    if (this.isOpen()) ** break block27
                    var9_9 = 0L;
                }
                this.writerCleanup();
                IoTrace.socketWriteEnd((Object)var7_6, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (long)(var5_5 > 0L ? var5_5 : 0L));
                this.end(var5_5 > 0L || var5_5 == -2L);
                var11_10 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var11_10) {
                    try {
                        if (var5_5 <= 0L && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                        }
                    }
                    catch (Throwable var12_11) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var12_11);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var5_5)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var9_9;
                {
                    SocketChannelImpl._jr$ip$writerThread(this, NativeThread.current());
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 8, 9] lbl38 : MonitorExitStatement: MONITOREXIT : var8_7
                    {
                        catch (Throwable var13_12) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var13_12);
                        }
                    }
                    while ((var5_5 = IOUtil.write(SocketChannelImpl._jr$ig$fd(this), var1_1, var2_2, var3_3, SocketChannelImpl.nd)) == -3L && this.isOpen()) {
                    }
                    var8_8 = IOStatus.normalize(var5_5);
                }
                this.writerCleanup();
                IoTrace.socketWriteEnd((Object)var7_6, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (long)(var5_5 > 0L ? var5_5 : 0L));
                this.end(var5_5 > 0L || var5_5 == -2L);
                var10_13 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var10_13) {
                    try {
                        if (var5_5 <= 0L && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                        }
                    }
                    catch (Throwable var14_14) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var14_14);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var5_5)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var8_8;
                {
                    catch (Throwable var15_15) {
                        this.writerCleanup();
                        IoTrace.socketWriteEnd((Object)var7_6, (InetAddress)SocketChannelImpl._jr$ig$remoteAddress(this).getAddress(), (int)SocketChannelImpl._jr$ig$remoteAddress(this).getPort(), (long)(var5_5 > 0L ? var5_5 : 0L));
                        this.end(var5_5 > 0L || var5_5 == -2L);
                        var16_16 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                        synchronized (var16_16) {
                            try {
                                if (var5_5 <= 0L && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                                }
                            }
                            catch (Throwable var17_17) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var17_17);
                            }
                        }
                        if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var5_5)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var15_15);
                    }
                }
            }
            catch (Throwable var18_18) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var18_18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    int sendOutOfBandData(byte var1_1) throws IOException {
        var2_2 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$writeLock(this));
        synchronized (var2_2) {
            try {
                this.ensureWriteOpen();
                var3_3 = 0;
                this.begin();
                var4_4 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var4_4) {
                    if (this.isOpen()) ** break block26
                    var5_6 = 0;
                }
                this.writerCleanup();
                this.end(var3_3 > 0 || var3_3 == -2);
                var6_8 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var6_8) {
                    try {
                        if (var3_3 <= 0 && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                        }
                    }
                    catch (Throwable var7_9) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var7_9);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var5_6;
                {
                    SocketChannelImpl._jr$ip$writerThread(this, NativeThread.current());
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 8, 9] lbl34 : MonitorExitStatement: MONITOREXIT : var4_4
                    {
                        catch (Throwable var8_10) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var8_10);
                        }
                    }
                    while ((var3_3 = SocketChannelImpl.sendOutOfBandData(SocketChannelImpl._jr$ig$fd(this), var1_1)) == -3 && this.isOpen()) {
                    }
                    var4_5 = IOStatus.normalize(var3_3);
                }
                this.writerCleanup();
                this.end(var3_3 > 0 || var3_3 == -2);
                var5_7 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                synchronized (var5_7) {
                    try {
                        if (var3_3 <= 0 && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                        }
                    }
                    catch (Throwable var9_11) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var9_11);
                    }
                }
                if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return var4_5;
                {
                    catch (Throwable var10_12) {
                        this.writerCleanup();
                        this.end(var3_3 > 0 || var3_3 == -2);
                        var11_13 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                        synchronized (var11_13) {
                            try {
                                if (var3_3 <= 0 && !SocketChannelImpl._jr$ig$isOutputOpen(this)) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AsynchronousCloseException());
                                }
                            }
                            catch (Throwable var12_14) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var12_14);
                            }
                        }
                        if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var3_3)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var10_12);
                    }
                }
            }
            catch (Throwable var13_15) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var13_15);
            }
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress localAddress() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.localAddress;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.remoteAddress;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = ah.getMonitor((Object)this.readLock);
        synchronized (object) {
            try {
                Object object2 = ah.getMonitor((Object)this.writeLock);
                synchronized (object2) {
                    try {
                        Object object3 = ah.getMonitor((Object)this.stateLock);
                        synchronized (object3) {
                            try {
                                if (!this.isOpen()) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                                }
                                if (this.state == 1) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConnectionPendingException());
                                }
                                if (this.localAddress != null) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AlreadyBoundException());
                                }
                                InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                                NetHooks.beforeTcpBind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                                this.localAddress = Net.localAddress(this.fd);
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.state == 2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.state == 1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (this.state == 2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AlreadyConnectedException());
                }
                if (this.state == 1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConnectionPendingException());
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connect(SocketAddress var1_1) throws IOException {
        var2_2 = false;
        var3_3 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$readLock(this));
        synchronized (var3_3) {
            var4_4 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$writeLock(this));
            synchronized (var4_4) {
                try {
                    this.ensureOpenAndUnconnected();
                    var5_5 = Net.checkAddress(var1_1);
                    var6_6 = System.getSecurityManager();
                    if (var6_6 != null) {
                        var6_6.checkConnect(var5_5.getAddress().getHostAddress(), var5_5.getPort());
                    }
                    var7_7 = ah.getMonitor((Object)this.blockingLock());
                    synchronized (var7_7) {
                        try {
                            block34: {
                                var8_8 = 0;
                                try {
                                    this.begin();
                                    var9_9 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                                    synchronized (var9_9) {
                                        if (this.isOpen()) ** break block33
                                        var10_11 = false;
                                    }
                                    this.readerCleanup();
                                    this.end(var8_8 > 0 || var8_8 == -2);
                                    if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var8_8)) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                                    }
                                    return var10_11;
                                    {
                                        if (SocketChannelImpl._jr$ig$localAddress(this) == null) {
                                            NetHooks.beforeTcpConnect(SocketChannelImpl._jr$ig$fd(this), var5_5.getAddress(), var5_5.getPort());
                                        }
                                        SocketChannelImpl._jr$ip$readerThread(this, NativeThread.current());
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 6, 7, 10, 11, 12, 13] lbl40 : MonitorExitStatement: MONITOREXIT : var9_9
                                        {
                                            catch (Throwable var11_12) {
                                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var11_12);
                                            }
                                        }
                                        do {
                                            if (!(var9_9 = var5_5.getAddress()).isAnyLocalAddress()) continue;
                                            var9_9 = InetAddress.getLocalHost();
                                        } while ((var8_8 = Net.connect(SocketChannelImpl._jr$ig$fd(this), (InetAddress)var9_9, var5_5.getPort())) == -3 && this.isOpen());
                                    }
                                    this.readerCleanup();
                                    this.end(var8_8 > 0 || var8_8 == -2);
                                    if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var8_8)) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                                    }
                                    break block34;
                                    {
                                        catch (Throwable var12_13) {
                                            this.readerCleanup();
                                            this.end(var8_8 > 0 || var8_8 == -2);
                                            if (!SocketChannelImpl.$assertionsDisabled && !IOStatus.check(var8_8)) {
                                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                                            }
                                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var12_13);
                                        }
                                    }
                                }
                                catch (IOException var9_10) {
                                    this.close();
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var9_10);
                                }
                            }
                            var9_9 = ah.getMonitor((Object)SocketChannelImpl._jr$ig$stateLock(this));
                            synchronized (var9_9) {
                                try {
                                    SocketChannelImpl._jr$ip$remoteAddress(this, var5_5);
                                    if (var8_8 > 0) {
                                        SocketChannelImpl._jr$ip$state(this, 2);
                                        if (this.isOpen()) {
                                            SocketChannelImpl._jr$ip$localAddress(this, Net.localAddress(SocketChannelImpl._jr$ig$fd(this)));
                                        }
                                        return true;
                                    }
                                    if (!this.isBlocking()) {
                                        SocketChannelImpl._jr$ip$state(this, 1);
                                    } else if (!SocketChannelImpl.$assertionsDisabled) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                                    }
                                }
                                catch (Throwable var13_14) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var13_14);
                                }
                            }
                        }
                        catch (Throwable var14_15) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var14_15);
                        }
                    }
                    return false;
                }
                catch (Throwable var15_16) {
                    try {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var15_16);
                    }
                    catch (Throwable var16_17) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var16_17);
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean finishConnect() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!this.isConnected()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotYetConnectedException());
                }
                if (this.isInputOpen) {
                    Net.shutdown(this.fd, 0);
                    if (this.readerThread != 0L) {
                        NativeThread.signal(this.readerThread);
                    }
                    this.isInputOpen = false;
                }
                return this;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedChannelException());
                }
                if (!this.isConnected()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotYetConnectedException());
                }
                if (this.isOutputOpen) {
                    Net.shutdown(this.fd, 1);
                    if (this.writerThread != 0L) {
                        NativeThread.signal(this.writerThread);
                    }
                    this.isOutputOpen = false;
                }
                return this;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.isInputOpen;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                return this.isOutputOpen;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                this.isInputOpen = false;
                this.isOutputOpen = false;
                if (this.state != 4) {
                    nd.preClose(this.fd);
                }
                if (this.readerThread != 0L) {
                    NativeThread.signal(this.readerThread);
                }
                if (this.writerThread != 0L) {
                    NativeThread.signal(this.writerThread);
                }
                if (!this.isRegistered()) {
                    this.kill();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = ah.getMonitor((Object)this.stateLock);
        synchronized (object) {
            try {
                if (this.state == 4) {
                    return;
                }
                if (this.state == -1) {
                    this.state = 4;
                    return;
                }
                if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                if (this.readerThread == 0L && this.writerThread == 0L) {
                    nd.close(this.fd);
                    this.state = 4;
                } else {
                    this.state = 3;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean translateReadyOps(int n2, int n3, SelectionKeyImpl selectionKeyImpl) {
        int n4 = selectionKeyImpl.nioInterestOps();
        int n5 = selectionKeyImpl.nioReadyOps();
        int n6 = n3;
        if ((n2 & 0x20) != 0) {
            return false;
        }
        if ((n2 & 0x18) != 0) {
            n6 = n4;
            selectionKeyImpl.nioReadyOps(n6);
            this.readyToConnect = true;
            return (n6 & ~n5) != 0;
        }
        if ((n2 & 1) != 0 && (n4 & 1) != 0 && this.state == 2) {
            n6 |= 1;
        }
        if ((n2 & 2) != 0 && (n4 & 8) != 0 && (this.state == 0 || this.state == 1)) {
            n6 |= 8;
            this.readyToConnect = true;
        }
        if ((n2 & 4) != 0 && (n4 & 4) != 0 && this.state == 2) {
            n6 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n6);
        return (n6 & ~n5) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, 0, selectionKeyImpl);
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 8) != 0) {
            n3 |= 2;
        }
        SelectionKeyImpl._jr$ig$selector((Object)selectionKeyImpl).putEventOps(selectionKeyImpl, n3);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(x.getName((Class)x.getSuperclass(this.getClass())));
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = ah.getMonitor((Object)this.stateLock);
            synchronized (object) {
                try {
                    switch (this.state) {
                        case 0: {
                            stringBuffer.append("unconnected");
                            break;
                        }
                        case 1: {
                            stringBuffer.append("connection-pending");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("connected");
                            if (!this.isInputOpen) {
                                stringBuffer.append(" ishut");
                            }
                            if (this.isOutputOpen) break;
                            stringBuffer.append(" oshut");
                        }
                    }
                    InetSocketAddress inetSocketAddress = this.localAddress();
                    if (inetSocketAddress != null) {
                        stringBuffer.append(" local=");
                        stringBuffer.append(Net.getRevealedLocalAddressAsString(inetSocketAddress));
                    }
                    if (this.remoteAddress() != null) {
                        stringBuffer.append(" remote=");
                        stringBuffer.append(this.remoteAddress().toString());
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native int sendOutOfBandData(FileDescriptor var0, byte var1) throws IOException;

    static {
        Util.load();
        nd = new SocketDispatcher();
    }

    private static /* synthetic */ void _jr$ip$fd(SocketChannelImpl socketChannelImpl, FileDescriptor fileDescriptor) {
        socketChannelImpl.fd = fileDescriptor;
    }

    private static /* synthetic */ void _jr$ip$fdVal(SocketChannelImpl socketChannelImpl, int n2) {
        socketChannelImpl.fdVal = n2;
    }

    private static /* synthetic */ void _jr$ip$readLock(SocketChannelImpl socketChannelImpl, Object object) {
        socketChannelImpl.readLock = object;
    }

    private static /* synthetic */ void _jr$ip$writeLock(SocketChannelImpl socketChannelImpl, Object object) {
        socketChannelImpl.writeLock = object;
    }

    private static /* synthetic */ void _jr$ip$stateLock(SocketChannelImpl socketChannelImpl, Object object) {
        socketChannelImpl.stateLock = object;
    }

    private static /* synthetic */ void _jr$ip$remoteAddress(SocketChannelImpl socketChannelImpl, InetSocketAddress inetSocketAddress) {
        socketChannelImpl.remoteAddress = inetSocketAddress;
    }

    private static /* synthetic */ boolean _jr$ig$readyToConnect(SocketChannelImpl socketChannelImpl) {
        return socketChannelImpl.readyToConnect;
    }

    protected /* synthetic */ SocketChannelImpl(h h2) {
        super(h2);
    }

    private static class DefaultOptionsHolder
    extends h {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Object>> hashSet = new HashSet<SocketOption<Object>>(8);
            hashSet.add(StandardSocketOptions.SO_SNDBUF);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_KEEPALIVE);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            hashSet.add(StandardSocketOptions.SO_LINGER);
            hashSet.add(StandardSocketOptions.TCP_NODELAY);
            hashSet.add(StandardSocketOptions.IP_TOS);
            hashSet.add(ExtendedSocketOption.SO_OOBINLINE);
            return Collections.unmodifiableSet(hashSet);
        }

        protected /* synthetic */ DefaultOptionsHolder(h h2) {
            super(h2);
        }
    }
}

