/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

class Util
extends h {
    private static final int TEMP_BUF_POOL_SIZE = IOUtil.IOV_MAX;
    private static ThreadLocal<BufferCache> bufferCache = new ThreadLocal<BufferCache>(){

        protected BufferCache initialValue() {
            return new BufferCache();
        }
    };
    private static ThreadLocal<SoftReference<SelectorWrapper>> localSelector = new ThreadLocal();
    private static ThreadLocal<SelectorWrapper> localSelectorWrapper = new ThreadLocal();
    private static Unsafe unsafe = Unsafe.getUnsafe();
    private static int pageSize = -1;
    private static volatile Constructor directByteBufferConstructor = null;
    private static volatile Constructor directByteBufferRConstructor = null;
    private static volatile String bugLevel = null;
    private static boolean loaded = false;

    Util() {
    }

    static ByteBuffer getTemporaryDirectBuffer(int n2) {
        BufferCache bufferCache = (BufferCache)((Object)g.convertForCast(Util.bufferCache.get(), BufferCache.class));
        ByteBuffer byteBuffer = bufferCache.get(n2);
        if (byteBuffer != null) {
            return byteBuffer;
        }
        if (!bufferCache.isEmpty()) {
            byteBuffer = bufferCache.removeFirst();
            Util.free(byteBuffer);
        }
        return ByteBuffer.allocateDirect(n2);
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        Util.offerFirstTemporaryDirectBuffer(byteBuffer);
    }

    static void offerFirstTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        if (!$assertionsDisabled && byteBuffer == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        BufferCache bufferCache = (BufferCache)((Object)g.convertForCast(Util.bufferCache.get(), BufferCache.class));
        if (!bufferCache.offerFirst(byteBuffer)) {
            Util.free(byteBuffer);
        }
    }

    static void offerLastTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        if (!$assertionsDisabled && byteBuffer == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        BufferCache bufferCache = (BufferCache)((Object)g.convertForCast(Util.bufferCache.get(), BufferCache.class));
        if (!bufferCache.offerLast(byteBuffer)) {
            Util.free(byteBuffer);
        }
    }

    private static void free(ByteBuffer byteBuffer) {
        ((DirectBuffer)g.convertForCast((Object)byteBuffer, DirectBuffer.class)).cleaner().clean();
    }

    static Selector getTemporarySelector(SelectableChannel selectableChannel) throws IOException {
        SoftReference softReference = (SoftReference)((Object)g.convertForCast(localSelector.get(), SoftReference.class));
        SelectorWrapper selectorWrapper = null;
        Selector selector = null;
        if (softReference == null || (selectorWrapper = (SelectorWrapper)((Object)g.convertForCast(softReference.get(), SelectorWrapper.class))) == null || (selector = selectorWrapper.get()) == null || f.ifAcmp((Object)((Object)selector.provider()), (Object)((Object)selectableChannel.provider()))) {
            selector = selectableChannel.provider().openSelector();
            selectorWrapper = new SelectorWrapper(selector);
            localSelector.set(new SoftReference<SelectorWrapper>(selectorWrapper));
        }
        localSelectorWrapper.set(selectorWrapper);
        return selector;
    }

    static void releaseTemporarySelector(Selector selector) throws IOException {
        selector.selectNow();
        if (!$assertionsDisabled && !selector.keys().isEmpty()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Temporary selector not empty"));
        }
        localSelectorWrapper.set(null);
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n2, int n3) {
        if (n2 == 0 && n3 == a.arrayLength((Object[])byteBufferArray)) {
            return byteBufferArray;
        }
        int n4 = n3;
        Object[] objectArray = new ByteBuffer[n4];
        for (int i = 0; i < n4; ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)((ByteBuffer)g.convertForCast((Object)a.arrayLoad((Object[])byteBufferArray, (int)(n2 + i)), ByteBuffer.class)));
        }
        return objectArray;
    }

    static <E> Set<E> ungrowableSet(final Set<E> set) {
        return new Set(){

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object);
            }

            @Override
            public Object[] toArray() {
                return set.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return set.toArray(TArray);
            }

            public String toString() {
                return set.toString();
            }

            @Override
            public Iterator<E> iterator() {
                return set.iterator();
            }

            @Override
            public boolean equals(Object object) {
                return set.equals(object);
            }

            @Override
            public int hashCode() {
                return set.hashCode();
            }

            @Override
            public void clear() {
                set.clear();
            }

            @Override
            public boolean remove(Object object) {
                return set.remove(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return set.removeAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return set.retainAll(collection);
            }

            @Override
            public boolean add(E e2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
            }

            static /* synthetic */ Set _jr$ig$val$s(Object object) {
                return (object).set;
            }

            static /* synthetic */ void _jr$ip$val$s(Object object, Set set2) {
                (object).set = set2;
            }
        };
    }

    private static byte _get(long l) {
        return unsafe.getByte(l);
    }

    private static void _put(long l, byte by) {
        unsafe.putByte(l, by);
    }

    static void erase(ByteBuffer byteBuffer) {
        unsafe.setMemory(((DirectBuffer)g.convertForCast((Object)byteBuffer, DirectBuffer.class)).address(), byteBuffer.capacity(), (byte)0);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Class<?> cl = Class.forName("java.nio.DirectByteBuffer");
                    Constructor ctor = cl.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class, Boolean.TYPE, MemorySegment.class});
                    ctor.setAccessible(true);
                    directByteBufferConstructor = ctor;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalArgumentException | NoSuchMethodException x2) {
                    throw new InternalError((Throwable)x2);
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int n2, long l, FileDescriptor fileDescriptor, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            Object[] objectArray = new Object[4];
            a.arrayStore((Object[])objectArray, (int)0, (Object)new Integer(n2));
            a.arrayStore((Object[])objectArray, (int)1, (Object)new Long(l));
            a.arrayStore((Object[])objectArray, (int)2, (Object)((Object)fileDescriptor));
            a.arrayStore((Object[])objectArray, (int)3, (Object)runnable);
            mappedByteBuffer = (MappedByteBuffer)g.convertForCast(directByteBufferConstructor.newInstance(objectArray), MappedByteBuffer.class);
        }
        catch (InstantiationException instantiationException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        return mappedByteBuffer;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Class<?> cl = Class.forName("java.nio.DirectByteBufferR");
                    Constructor ctor = cl.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class, Boolean.TYPE, MemorySegment.class});
                    ctor.setAccessible(true);
                    directByteBufferRConstructor = ctor;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalArgumentException | NoSuchMethodException x2) {
                    throw new InternalError((Throwable)x2);
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int n2, long l, FileDescriptor fileDescriptor, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            Object[] objectArray = new Object[4];
            a.arrayStore((Object[])objectArray, (int)0, (Object)new Integer(n2));
            a.arrayStore((Object[])objectArray, (int)1, (Object)new Long(l));
            a.arrayStore((Object[])objectArray, (int)2, (Object)((Object)fileDescriptor));
            a.arrayStore((Object[])objectArray, (int)3, (Object)runnable);
            mappedByteBuffer = (MappedByteBuffer)g.convertForCast(directByteBufferRConstructor.newInstance(objectArray), MappedByteBuffer.class);
        }
        catch (InstantiationException instantiationException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        return mappedByteBuffer;
    }

    static boolean atBugLevel(String string) {
        if (bugLevel == null) {
            if (!VM.isBooted()) {
                return false;
            }
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.bugLevel"));
            bugLevel = string2 != null ? string2 : "";
        }
        return bugLevel.equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Object object = ah.getMonitor(Util.class);
        synchronized (object) {
            try {
                if (loaded) {
                    return;
                }
                loaded = true;
                AccessController.doPrivileged(new LoadLibraryAction("net"));
                AccessController.doPrivileged(new LoadLibraryAction("nio"));
                IOUtil.initIDs();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    static /* synthetic */ Constructor access$302(Constructor constructor) {
        directByteBufferConstructor = constructor;
        return directByteBufferConstructor;
    }

    static /* synthetic */ Constructor access$402(Constructor constructor) {
        directByteBufferRConstructor = constructor;
        return directByteBufferRConstructor;
    }

    protected /* synthetic */ Util(h h2) {
        super(h2);
    }

    private static class BufferCache
    extends h {
        private ByteBuffer[] buffers;
        private int count;
        private int start;

        private int next(int n2) {
            return (n2 + 1) % TEMP_BUF_POOL_SIZE;
        }

        BufferCache() {
            this.buffers = new ByteBuffer[TEMP_BUF_POOL_SIZE];
        }

        ByteBuffer get(int n2) {
            if (this.count == 0) {
                return null;
            }
            Object[] objectArray = this.buffers;
            ByteBuffer byteBuffer = (ByteBuffer)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)this.start), ByteBuffer.class);
            if (byteBuffer.capacity() < n2) {
                ByteBuffer byteBuffer2;
                byteBuffer = null;
                int n3 = this.start;
                while ((n3 = this.next(n3)) != this.start && (byteBuffer2 = (ByteBuffer)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n3), ByteBuffer.class)) != null) {
                    if (byteBuffer2.capacity() < n2) continue;
                    byteBuffer = byteBuffer2;
                    break;
                }
                if (byteBuffer == null) {
                    return null;
                }
                a.arrayStore((Object[])objectArray, (int)n3, (Object)((ByteBuffer)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)this.start), ByteBuffer.class)));
            }
            a.arrayStore((Object[])objectArray, (int)this.start, null);
            this.start = this.next(this.start);
            BufferCache bufferCache = this;
            bufferCache.count = bufferCache.count - 1;
            byteBuffer.rewind();
            byteBuffer.limit(n2);
            return byteBuffer;
        }

        boolean offerFirst(ByteBuffer byteBuffer) {
            if (this.count >= TEMP_BUF_POOL_SIZE) {
                return false;
            }
            this.start = (this.start + TEMP_BUF_POOL_SIZE - 1) % TEMP_BUF_POOL_SIZE;
            a.arrayStore((Object[])this.buffers, (int)this.start, (Object)byteBuffer);
            BufferCache bufferCache = this;
            bufferCache.count = bufferCache.count + 1;
            return true;
        }

        boolean offerLast(ByteBuffer byteBuffer) {
            if (this.count >= TEMP_BUF_POOL_SIZE) {
                return false;
            }
            int n2 = (this.start + this.count) % TEMP_BUF_POOL_SIZE;
            a.arrayStore((Object[])this.buffers, (int)n2, (Object)byteBuffer);
            BufferCache bufferCache = this;
            bufferCache.count = bufferCache.count + 1;
            return true;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        ByteBuffer removeFirst() {
            if (!$assertionsDisabled && this.count <= 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            ByteBuffer byteBuffer = (ByteBuffer)g.convertForCast((Object)a.arrayLoad((Object[])this.buffers, (int)this.start), ByteBuffer.class);
            a.arrayStore((Object[])this.buffers, (int)this.start, null);
            this.start = this.next(this.start);
            BufferCache bufferCache = this;
            bufferCache.count = bufferCache.count - 1;
            return byteBuffer;
        }

        private static /* synthetic */ void _jr$ip$buffers(BufferCache bufferCache, ByteBuffer[] byteBufferArray) {
            bufferCache.buffers = byteBufferArray;
        }

        protected /* synthetic */ BufferCache(h h2) {
            super(h2);
        }
    }

    private static class SelectorWrapper
    extends h {
        private Selector sel;

        private SelectorWrapper(Selector selector) {
            this.sel = selector;
            Cleaner.create((Object)this, new Closer(selector));
        }

        public Selector get() {
            return this.sel;
        }

        private static /* synthetic */ void _jr$ip$sel(SelectorWrapper selectorWrapper, Selector selector) {
            selectorWrapper.sel = selector;
        }

        protected /* synthetic */ SelectorWrapper(h h2) {
            super(h2);
        }

        private static class Closer
        extends h
        implements Runnable {
            private Selector sel;

            private Closer(Selector selector) {
                this.sel = selector;
            }

            @Override
            public void run() {
                try {
                    this.sel.close();
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(throwable));
                }
            }

            private static /* synthetic */ void _jr$ip$sel(Closer closer, Selector selector) {
                closer.sel = selector;
            }

            protected /* synthetic */ Closer(h h2) {
                super(h2);
            }
        }
    }
}

