/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

final class WindowsSelectorImpl
extends SelectorImpl {
    private final int INIT_CAP = 8;
    private static final int MAX_SELECTABLE_FDS = 1024;
    private SelectionKeyImpl[] channelArray = new SelectionKeyImpl[8];
    private PollArrayWrapper pollWrapper;
    private int totalChannels = 1;
    private int threadsCount = 0;
    private final List<SelectThread> threads = new ArrayList<SelectThread>();
    private final Pipe wakeupPipe;
    private final int wakeupSourceFd;
    private final int wakeupSinkFd;
    private Object closeLock = new Object();
    private final FdMap fdMap = new FdMap();
    private final SubSelector subSelector = new SubSelector();
    private long timeout;
    private final Object interruptLock = new Object();
    private volatile boolean interruptTriggered = false;
    private final StartLock startLock = new StartLock();
    private final FinishLock finishLock = new FinishLock();
    private long updateCount = 0L;

    WindowsSelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.pollWrapper = new PollArrayWrapper(8);
        this.wakeupPipe = Pipe.open();
        this.wakeupSourceFd = ((SelChImpl)g.convertForCast((Object)this.wakeupPipe.source(), SelChImpl.class)).getFDVal();
        SinkChannelImpl sinkChannelImpl = (SinkChannelImpl)g.convertForCast((Object)this.wakeupPipe.sink(), SinkChannelImpl.class);
        sinkChannelImpl.sc.socket().setTcpNoDelay(true);
        this.wakeupSinkFd = sinkChannelImpl.getFDVal();
        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long l2) throws IOException {
        if (this.channelArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedSelectorException());
        }
        this.timeout = l2;
        this.processDeregisterQueue();
        if (this.interruptTriggered) {
            this.resetWakeupSocket();
            return 0;
        }
        this.adjustThreadsCount();
        this.finishLock.reset();
        this.startLock.startThreads();
        try {
            this.begin();
            try {
                this.subSelector.poll();
            }
            catch (IOException iOException) {
                this.finishLock.setException(iOException);
            }
            if (this.threads.size() > 0) {
                this.finishLock.waitForHelperThreads();
            }
        }
        catch (Throwable throwable) {
            this.end();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.end();
        this.finishLock.checkForException();
        this.processDeregisterQueue();
        int n2 = this.updateSelectedKeys();
        this.resetWakeupSocket();
        return n2;
    }

    private void adjustThreadsCount() {
        block3: {
            block2: {
                if (this.threadsCount <= this.threads.size()) break block2;
                for (int i = this.threads.size(); i < this.threadsCount; ++i) {
                    SelectThread selectThread = new SelectThread(i);
                    this.threads.add(selectThread);
                    selectThread.setDaemon(true);
                    selectThread.start();
                }
                break block3;
            }
            if (this.threadsCount >= this.threads.size()) break block3;
            for (int i = this.threads.size() - 1; i >= this.threadsCount; --i) {
                this.threads.remove(i).makeZombie();
            }
        }
    }

    private void setWakeupSocket() {
        this.setWakeupSocket0(this.wakeupSinkFd);
    }

    private native void setWakeupSocket0(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWakeupSocket() {
        Object object = ah.getMonitor((Object)this.interruptLock);
        synchronized (object) {
            try {
                if (!this.interruptTriggered) {
                    return;
                }
                this.resetWakeupSocket0(this.wakeupSourceFd);
                this.interruptTriggered = false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private native void resetWakeupSocket0(int var1);

    private native boolean discardUrgentData(int var1);

    private int updateSelectedKeys() {
        ++this.updateCount;
        int n2 = 0;
        n2 += this.subSelector.processSelectedKeys(this.updateCount);
        for (SelectThread selectThread : this.threads) {
            n2 += selectThread.subSelector.processSelectedKeys(this.updateCount);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (this.channelArray != null && this.pollWrapper != null) {
                    Object object2 = ah.getMonitor((Object)this.interruptLock);
                    synchronized (object2) {
                        try {
                            this.interruptTriggered = true;
                        }
                        catch (Throwable throwable) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                    this.wakeupPipe.sink().close();
                    this.wakeupPipe.source().close();
                    for (int i = 1; i < this.totalChannels; ++i) {
                        if (i % 1024 == 0) continue;
                        this.deregister(this.channelArray[i]);
                        SelectableChannel h2 = this.channelArray[i].channel();
                        if (h2.isOpen() || h2.isRegistered()) continue;
                        ((SelChImpl)g.convertForCast((Object)h2, SelChImpl.class)).kill();
                    }
                    this.pollWrapper.free();
                    this.pollWrapper = null;
                    this.selectedKeys = null;
                    this.channelArray = null;
                    for (SelectThread selectThread : this.threads) {
                        selectThread.makeZombie();
                    }
                    this.startLock.startThreads();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (this.pollWrapper == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedSelectorException());
                }
                this.growIfNeeded();
                a.arrayStore((Object[])this.channelArray, (int)this.totalChannels, (Object)((Object)selectionKeyImpl));
                selectionKeyImpl.setIndex(this.totalChannels);
                this.fdMap.put(selectionKeyImpl);
                this.keys.add(selectionKeyImpl);
                this.pollWrapper.addEntry(this.totalChannels, selectionKeyImpl);
                ++this.totalChannels;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void growIfNeeded() {
        if (a.arrayLength((Object[])this.channelArray) == this.totalChannels) {
            int n2 = this.totalChannels * 2;
            SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n2];
            a.arraycopy((Object)this.channelArray, (int)1, (Object)selectionKeyImplArray, (int)1, (int)(this.totalChannels - 1));
            this.channelArray = selectionKeyImplArray;
            this.pollWrapper.grow(n2);
        }
        if (this.totalChannels % 1024 == 0) {
            this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, this.totalChannels);
            ++this.totalChannels;
            ++this.threadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n2 = selectionKeyImpl.getIndex();
        if (!$assertionsDisabled && n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (n2 != this.totalChannels - 1) {
                    SelectionKeyImpl selectionKeyImpl2;
                    this.channelArray[n2] = selectionKeyImpl2 = this.channelArray[this.totalChannels - 1];
                    selectionKeyImpl2.setIndex(n2);
                    this.pollWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n2);
                }
                selectionKeyImpl.setIndex(-1);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        if (this.totalChannels != 1 && this.totalChannels % 1024 == 1) {
            --this.totalChannels;
            --this.threadsCount;
        }
        this.fdMap.remove(selectionKeyImpl);
        this.keys.remove((Object)selectionKeyImpl);
        this.selectedKeys.remove((Object)selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        object = selectionKeyImpl.channel();
        if (!((AbstractInterruptibleChannel)object).isOpen() && !((SelectableChannel)object).isRegistered()) {
            ((SelChImpl)g.convertForCast((Object)object, SelChImpl.class)).kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n2) {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (this.pollWrapper == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClosedSelectorException());
                }
                int n3 = selectionKeyImpl.getIndex();
                if (n3 == -1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CancelledKeyException());
                }
                this.pollWrapper.putEventOps(n3, n2);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = ah.getMonitor((Object)this.interruptLock);
        synchronized (object) {
            try {
                if (!this.interruptTriggered) {
                    this.setWakeupSocket();
                    this.interruptTriggered = true;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return this;
    }

    static {
        Util.load();
    }

    private static /* synthetic */ int _jr$ig$INIT_CAP(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.INIT_CAP;
    }

    private static /* synthetic */ void _jr$ip$INIT_CAP(WindowsSelectorImpl windowsSelectorImpl, int n2) {
        windowsSelectorImpl.INIT_CAP = n2;
    }

    private static /* synthetic */ SelectionKeyImpl[] _jr$ig$channelArray(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.channelArray;
    }

    private static /* synthetic */ void _jr$ip$channelArray(WindowsSelectorImpl windowsSelectorImpl, SelectionKeyImpl[] selectionKeyImplArray) {
        windowsSelectorImpl.channelArray = selectionKeyImplArray;
    }

    private static /* synthetic */ PollArrayWrapper _jr$ig$pollWrapper(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.pollWrapper;
    }

    private static /* synthetic */ void _jr$ip$pollWrapper(WindowsSelectorImpl windowsSelectorImpl, PollArrayWrapper pollArrayWrapper) {
        windowsSelectorImpl.pollWrapper = pollArrayWrapper;
    }

    private static /* synthetic */ int _jr$ig$totalChannels(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.totalChannels;
    }

    private static /* synthetic */ void _jr$ip$totalChannels(WindowsSelectorImpl windowsSelectorImpl, int n2) {
        windowsSelectorImpl.totalChannels = n2;
    }

    private static /* synthetic */ int _jr$ig$threadsCount(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.threadsCount;
    }

    private static /* synthetic */ void _jr$ip$threadsCount(WindowsSelectorImpl windowsSelectorImpl, int n2) {
        windowsSelectorImpl.threadsCount = n2;
    }

    private static /* synthetic */ List _jr$ig$threads(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.threads;
    }

    private static /* synthetic */ void _jr$ip$threads(WindowsSelectorImpl windowsSelectorImpl, List list) {
        windowsSelectorImpl.threads = list;
    }

    private static /* synthetic */ Pipe _jr$ig$wakeupPipe(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.wakeupPipe;
    }

    private static /* synthetic */ void _jr$ip$wakeupPipe(WindowsSelectorImpl windowsSelectorImpl, Pipe pipe) {
        windowsSelectorImpl.wakeupPipe = pipe;
    }

    private static /* synthetic */ int _jr$ig$wakeupSourceFd(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.wakeupSourceFd;
    }

    private static /* synthetic */ void _jr$ip$wakeupSourceFd(WindowsSelectorImpl windowsSelectorImpl, int n2) {
        windowsSelectorImpl.wakeupSourceFd = n2;
    }

    private static /* synthetic */ int _jr$ig$wakeupSinkFd(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.wakeupSinkFd;
    }

    private static /* synthetic */ void _jr$ip$wakeupSinkFd(WindowsSelectorImpl windowsSelectorImpl, int n2) {
        windowsSelectorImpl.wakeupSinkFd = n2;
    }

    private static /* synthetic */ Object _jr$ig$closeLock(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.closeLock;
    }

    private static /* synthetic */ void _jr$ip$closeLock(WindowsSelectorImpl windowsSelectorImpl, Object object) {
        windowsSelectorImpl.closeLock = object;
    }

    private static /* synthetic */ FdMap _jr$ig$fdMap(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.fdMap;
    }

    private static /* synthetic */ void _jr$ip$fdMap(WindowsSelectorImpl windowsSelectorImpl, FdMap fdMap) {
        windowsSelectorImpl.fdMap = fdMap;
    }

    private static /* synthetic */ SubSelector _jr$ig$subSelector(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.subSelector;
    }

    private static /* synthetic */ void _jr$ip$subSelector(WindowsSelectorImpl windowsSelectorImpl, SubSelector subSelector) {
        windowsSelectorImpl.subSelector = subSelector;
    }

    private static /* synthetic */ long _jr$ig$timeout(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.timeout;
    }

    private static /* synthetic */ void _jr$ip$timeout(WindowsSelectorImpl windowsSelectorImpl, long l2) {
        windowsSelectorImpl.timeout = l2;
    }

    private static /* synthetic */ Object _jr$ig$interruptLock(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.interruptLock;
    }

    private static /* synthetic */ void _jr$ip$interruptLock(WindowsSelectorImpl windowsSelectorImpl, Object object) {
        windowsSelectorImpl.interruptLock = object;
    }

    private static /* synthetic */ boolean _jr$ig$interruptTriggered(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.interruptTriggered;
    }

    private static /* synthetic */ void _jr$ip$interruptTriggered(WindowsSelectorImpl windowsSelectorImpl, boolean bl) {
        windowsSelectorImpl.interruptTriggered = bl;
    }

    private static /* synthetic */ StartLock _jr$ig$startLock(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.startLock;
    }

    private static /* synthetic */ void _jr$ip$startLock(WindowsSelectorImpl windowsSelectorImpl, StartLock startLock) {
        windowsSelectorImpl.startLock = startLock;
    }

    private static /* synthetic */ FinishLock _jr$ig$finishLock(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.finishLock;
    }

    private static /* synthetic */ void _jr$ip$finishLock(WindowsSelectorImpl windowsSelectorImpl, FinishLock finishLock) {
        windowsSelectorImpl.finishLock = finishLock;
    }

    private static /* synthetic */ long _jr$ig$updateCount(WindowsSelectorImpl windowsSelectorImpl) {
        return windowsSelectorImpl.updateCount;
    }

    private static /* synthetic */ void _jr$ip$updateCount(WindowsSelectorImpl windowsSelectorImpl, long l2) {
        windowsSelectorImpl.updateCount = l2;
    }

    private static final class FdMap
    extends HashMap<Integer, MapEntry> {
        static final long serialVersionUID = 0L;

        private FdMap() {
        }

        private MapEntry get(int n2) {
            return (MapEntry)((Object)g.convertForCast(this.get(new Integer(n2)), MapEntry.class));
        }

        private MapEntry put(SelectionKeyImpl selectionKeyImpl) {
            return (MapEntry)((Object)g.convertForCast((Object)((Object)this.put(new Integer(SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).getFDVal()), new MapEntry(selectionKeyImpl))), MapEntry.class));
        }

        private MapEntry remove(SelectionKeyImpl selectionKeyImpl) {
            Integer n2 = new Integer(SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).getFDVal());
            MapEntry mapEntry = (MapEntry)((Object)g.convertForCast(this.get(n2), MapEntry.class));
            if (mapEntry != null && !f.ifAcmp((Object)SelectionKeyImpl._jr$ig$channel((Object)((MapEntry)((Object)((Object)mapEntry))).ski), (Object)SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl))) {
                return (MapEntry)((Object)g.convertForCast(this.remove(n2), MapEntry.class));
            }
            return null;
        }
    }

    private final class FinishLock
    extends h {
        private int threadsToFinish;
        IOException exception = null;

        private FinishLock() {
        }

        private void reset() {
            this.threadsToFinish = WindowsSelectorImpl.this.threads.size();
        }

        private synchronized void threadFinished() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            --this.threadsToFinish;
            if (this.threadsToFinish == 0) {
                ah.getMonitor((Object)((Object)this)).notify();
            }
        }

        private synchronized void waitForHelperThreads() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            while (this.threadsToFinish != 0) {
                try {
                    ah.getMonitor((Object)((Object)WindowsSelectorImpl.this.finishLock)).wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void setException(IOException iOException) {
            this.exception = iOException;
        }

        private void checkForException() throws IOException {
            if (this.exception == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("An exception occured during the execution of select(): \n");
            stringBuffer.append(this.exception);
            stringBuffer.append('\n');
            this.exception = null;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(stringBuffer.toString()));
        }

        private static /* synthetic */ int _jr$ig$threadsToFinish(FinishLock finishLock) {
            return finishLock.threadsToFinish;
        }

        private static /* synthetic */ void _jr$ip$threadsToFinish(FinishLock finishLock, int n2) {
            finishLock.threadsToFinish = n2;
        }

        static /* synthetic */ IOException _jr$ig$exception(Object object) {
            return ((FinishLock)((Object)object)).exception;
        }

        static /* synthetic */ void _jr$ip$exception(Object object, IOException iOException) {
            ((FinishLock)((Object)object)).exception = iOException;
        }

        static /* synthetic */ WindowsSelectorImpl _jr$ig$this$0(Object object) {
            return ((FinishLock)((Object)object)).WindowsSelectorImpl.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WindowsSelectorImpl windowsSelectorImpl) {
            ((FinishLock)((Object)object)).WindowsSelectorImpl.this = windowsSelectorImpl;
        }
    }

    private static final class MapEntry
    extends h {
        SelectionKeyImpl ski;
        long updateCount = 0L;
        long clearedCount = 0L;

        MapEntry(SelectionKeyImpl selectionKeyImpl) {
            this.ski = selectionKeyImpl;
        }

        static /* synthetic */ void _jr$ip$ski(Object object, SelectionKeyImpl selectionKeyImpl) {
            ((MapEntry)((Object)object)).ski = selectionKeyImpl;
        }
    }

    private final class SelectThread
    extends Thread {
        private final int index;
        final SubSelector subSelector;
        private long lastRun = 0L;
        private volatile boolean zombie;

        private SelectThread(int n2) {
            this.index = n2;
            this.subSelector = new SubSelector(n2);
            this.lastRun = WindowsSelectorImpl.this.startLock.runsCounter;
        }

        void makeZombie() {
            this.zombie = true;
        }

        boolean isZombie() {
            return this.zombie;
        }

        @Override
        public void run() {
            while (!WindowsSelectorImpl.this.startLock.waitForStart(this)) {
                try {
                    this.subSelector.poll(this.index);
                }
                catch (IOException iOException) {
                    WindowsSelectorImpl.this.finishLock.setException(iOException);
                }
                WindowsSelectorImpl.this.finishLock.threadFinished();
            }
            return;
        }

        private static /* synthetic */ int _jr$ig$index(SelectThread selectThread) {
            return selectThread.index;
        }

        private static /* synthetic */ void _jr$ip$index(SelectThread selectThread, int n2) {
            selectThread.index = n2;
        }

        static /* synthetic */ SubSelector _jr$ig$subSelector(Object object) {
            return ((SelectThread)object).subSelector;
        }

        static /* synthetic */ void _jr$ip$subSelector(Object object, SubSelector subSelector) {
            ((SelectThread)object).subSelector = subSelector;
        }

        private static /* synthetic */ long _jr$ig$lastRun(SelectThread selectThread) {
            return selectThread.lastRun;
        }

        private static /* synthetic */ void _jr$ip$lastRun(SelectThread selectThread, long l2) {
            selectThread.lastRun = l2;
        }

        private static /* synthetic */ boolean _jr$ig$zombie(SelectThread selectThread) {
            return selectThread.zombie;
        }

        private static /* synthetic */ void _jr$ip$zombie(SelectThread selectThread, boolean bl) {
            selectThread.zombie = bl;
        }

        static /* synthetic */ WindowsSelectorImpl _jr$ig$this$0(Object object) {
            return ((SelectThread)object).WindowsSelectorImpl.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WindowsSelectorImpl windowsSelectorImpl) {
            ((SelectThread)object).WindowsSelectorImpl.this = windowsSelectorImpl;
        }
    }

    private final class StartLock
    extends h {
        private long runsCounter;

        private StartLock() {
        }

        private synchronized void startThreads() {
            ++this.runsCounter;
            ah.getMonitor((Object)((Object)this)).notifyAll();
        }

        private synchronized boolean waitForStart(SelectThread selectThread) {
            while (this.runsCounter == selectThread.lastRun) {
                try {
                    ah.getMonitor((Object)((Object)WindowsSelectorImpl.this.startLock)).wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (selectThread.isZombie()) {
                return true;
            }
            selectThread.lastRun = this.runsCounter;
            return false;
        }

        private static /* synthetic */ long _jr$ig$runsCounter(StartLock startLock) {
            return startLock.runsCounter;
        }

        private static /* synthetic */ void _jr$ip$runsCounter(StartLock startLock, long l2) {
            startLock.runsCounter = l2;
        }

        static /* synthetic */ WindowsSelectorImpl _jr$ig$this$0(Object object) {
            return ((StartLock)((Object)object)).WindowsSelectorImpl.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WindowsSelectorImpl windowsSelectorImpl) {
            ((StartLock)((Object)object)).WindowsSelectorImpl.this = windowsSelectorImpl;
        }
    }

    private final class SubSelector
    extends h {
        private final int pollArrayIndex;
        private final int[] readFds = new int[1025];
        private final int[] writeFds = new int[1025];
        private final int[] exceptFds = new int[1025];

        private SubSelector() {
            this.pollArrayIndex = 0;
        }

        private SubSelector(int n2) {
            this.pollArrayIndex = (n2 + 1) * 1024;
        }

        private int poll() throws IOException {
            return this.poll0(PollArrayWrapper._jr$ig$pollArrayAddress((Object)WindowsSelectorImpl.this.pollWrapper), Math.min(WindowsSelectorImpl.this.totalChannels, 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout);
        }

        private int poll(int n2) throws IOException {
            return this.poll0(PollArrayWrapper._jr$ig$pollArrayAddress((Object)WindowsSelectorImpl.this.pollWrapper) + (long)(this.pollArrayIndex * PollArrayWrapper.SIZE_POLLFD), Math.min(1024, WindowsSelectorImpl.this.totalChannels - (n2 + 1) * 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout);
        }

        private native int poll0(long var1, int var3, int[] var4, int[] var5, int[] var6, long var7);

        private int processSelectedKeys(long l2) {
            int n2 = 0;
            n2 += this.processFDSet(l2, this.readFds, 1, false);
            n2 += this.processFDSet(l2, this.writeFds, 6, false);
            return n2 += this.processFDSet(l2, this.exceptFds, 7, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int processFDSet(long l2, int[] nArray, int n2, boolean bl) {
            int n3 = 0;
            for (int i = 1; i <= nArray[0]; ++i) {
                Object object;
                int n4 = nArray[i];
                if (n4 == WindowsSelectorImpl.this.wakeupSourceFd) {
                    object = ah.getMonitor((Object)WindowsSelectorImpl.this.interruptLock);
                    synchronized (object) {
                        try {
                            WindowsSelectorImpl.this.interruptTriggered = true;
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                }
                object = WindowsSelectorImpl.this.fdMap.get(n4);
                if (object == null) continue;
                SelectionKeyImpl selectionKeyImpl = ((MapEntry)((Object)object)).ski;
                if (bl && g.convertForInstanceOf((Object)selectionKeyImpl.channel(), SocketChannelImpl.class) instanceof SocketChannelImpl && WindowsSelectorImpl.this.discardUrgentData(n4)) continue;
                if (WindowsSelectorImpl._jr$ig$selectedKeys(WindowsSelectorImpl.this).contains((Object)selectionKeyImpl)) {
                    if (((MapEntry)((Object)object)).clearedCount != l2) {
                        if (SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).translateAndSetReadyOps(n2, selectionKeyImpl) && ((MapEntry)((Object)object)).updateCount != l2) {
                            ((MapEntry)((Object)object)).updateCount = l2;
                            ++n3;
                        }
                    } else if (SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).translateAndUpdateReadyOps(n2, selectionKeyImpl) && ((MapEntry)((Object)object)).updateCount != l2) {
                        ((MapEntry)((Object)object)).updateCount = l2;
                        ++n3;
                    }
                    ((MapEntry)((Object)object)).clearedCount = l2;
                    continue;
                }
                if (((MapEntry)((Object)object)).clearedCount != l2) {
                    SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).translateAndSetReadyOps(n2, selectionKeyImpl);
                    if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) != 0) {
                        WindowsSelectorImpl._jr$ig$selectedKeys(WindowsSelectorImpl.this).add(selectionKeyImpl);
                        ((MapEntry)((Object)object)).updateCount = l2;
                        ++n3;
                    }
                } else {
                    SelectionKeyImpl._jr$ig$channel((Object)selectionKeyImpl).translateAndUpdateReadyOps(n2, selectionKeyImpl);
                    if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) != 0) {
                        WindowsSelectorImpl._jr$ig$selectedKeys(WindowsSelectorImpl.this).add(selectionKeyImpl);
                        ((MapEntry)((Object)object)).updateCount = l2;
                        ++n3;
                    }
                }
                ((MapEntry)((Object)object)).clearedCount = l2;
            }
            return n3;
        }

        private static /* synthetic */ int _jr$ig$pollArrayIndex(SubSelector subSelector) {
            return subSelector.pollArrayIndex;
        }

        private static /* synthetic */ void _jr$ip$pollArrayIndex(SubSelector subSelector, int n2) {
            subSelector.pollArrayIndex = n2;
        }

        private static /* synthetic */ int[] _jr$ig$readFds(SubSelector subSelector) {
            return subSelector.readFds;
        }

        private static /* synthetic */ void _jr$ip$readFds(SubSelector subSelector, int[] nArray) {
            subSelector.readFds = nArray;
        }

        private static /* synthetic */ int[] _jr$ig$writeFds(SubSelector subSelector) {
            return subSelector.writeFds;
        }

        private static /* synthetic */ void _jr$ip$writeFds(SubSelector subSelector, int[] nArray) {
            subSelector.writeFds = nArray;
        }

        private static /* synthetic */ int[] _jr$ig$exceptFds(SubSelector subSelector) {
            return subSelector.exceptFds;
        }

        private static /* synthetic */ void _jr$ip$exceptFds(SubSelector subSelector, int[] nArray) {
            subSelector.exceptFds = nArray;
        }

        static /* synthetic */ WindowsSelectorImpl _jr$ig$this$0(Object object) {
            return ((SubSelector)((Object)object)).WindowsSelectorImpl.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WindowsSelectorImpl windowsSelectorImpl) {
            ((SubSelector)((Object)object)).WindowsSelectorImpl.this = windowsSelectorImpl;
        }
    }
}

