/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import sun.nio.cs.HistoricallyNamedCharset;

public class StreamDecoder
extends Reader {
    private static final int MIN_BYTE_BUFFER_SIZE = 32;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    private static volatile boolean channelsAvailable = true;
    private Charset cs;
    private CharsetDecoder decoder;
    private ByteBuffer bb;
    private InputStream in;
    private ReadableByteChannel ch;

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return new StreamDecoder(inputStream, object, Charset.forName(string2));
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string2));
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, Charset charset) {
        return new StreamDecoder(inputStream, object, charset);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        return new StreamDecoder(inputStream, object, charsetDecoder);
    }

    public static StreamDecoder forDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return new StreamDecoder(readableByteChannel, charsetDecoder, n);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        return this.read0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() throws IOException {
        Object object = ah.getMonitor((Object)StreamDecoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                if (this.haveLeftoverChar) {
                    this.haveLeftoverChar = false;
                    return this.leftoverChar;
                }
                char[] cArray = new char[2];
                int n = this.read(cArray, 0, 2);
                switch (n) {
                    case -1: {
                        return -1;
                    }
                    case 2: {
                        this.leftoverChar = cArray[1];
                        this.haveLeftoverChar = true;
                    }
                    case 1: {
                        return cArray[0];
                    }
                }
                if (!$assertionsDisabled) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(n));
                }
                return -1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n2;
        Object object = ah.getMonitor((Object)StreamDecoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (n3 < 0 || n3 > cArray.length || n4 < 0 || n3 + n4 > cArray.length || n3 + n4 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                if (n4 == 0) {
                    return 0;
                }
                int n5 = 0;
                if (this.haveLeftoverChar) {
                    cArray[n3] = this.leftoverChar;
                    ++n3;
                    this.haveLeftoverChar = false;
                    n5 = 1;
                    if (--n4 == 0 || !this.implReady()) {
                        return n5;
                    }
                }
                if (n4 == 1) {
                    int n6 = this.read0();
                    if (n6 == -1) {
                        return n5 == 0 ? -1 : n5;
                    }
                    cArray[n3] = (char)n6;
                    return n5 + 1;
                }
                return n5 + this.implRead(cArray, n3, n3 + n4);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = ah.getMonitor((Object)StreamDecoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                return this.haveLeftoverChar || this.implReady();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)StreamDecoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                if (!this.isOpen) {
                    return;
                }
                this.implClose();
                this.isOpen = false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private static FileChannel getChannel(FileInputStream fileInputStream) {
        if (!channelsAvailable) {
            return null;
        }
        try {
            return fileInputStream.getChannel();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            channelsAvailable = false;
            return null;
        }
    }

    StreamDecoder(InputStream inputStream, Object object, Charset charset) {
        this(inputStream, object, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    StreamDecoder(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        super(object);
        this.isOpen = true;
        this.haveLeftoverChar = false;
        this.cs = charsetDecoder.charset();
        this.decoder = charsetDecoder;
        if (this.ch == null) {
            this.in = inputStream;
            this.ch = null;
            this.bb = ByteBuffer.allocate(8192);
        }
        this.bb.flip();
    }

    StreamDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        this.isOpen = true;
        this.haveLeftoverChar = false;
        this.in = null;
        this.ch = readableByteChannel;
        this.decoder = charsetDecoder;
        this.cs = charsetDecoder.charset();
        this.bb = ByteBuffer.allocate(n < 0 ? 8192 : (n < 32 ? 32 : n));
        this.bb.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int readBytes() throws IOException {
        block10: {
            block11: {
                block9: {
                    StreamDecoder._jr$ig$bb(this).compact();
                    try {
                        if (StreamDecoder._jr$ig$ch(this) == null) ** GOTO lbl18
                        var1_1 = StreamDecoder._jr$ig$ch(this).read(StreamDecoder._jr$ig$bb(this));
                        if (var1_1 >= 0) break block9;
                        var2_2 = var1_1;
                    }
                    catch (Throwable var6_7) {
                        StreamDecoder._jr$ig$bb(this).flip();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var6_7);
                    }
                    StreamDecoder._jr$ig$bb(this).flip();
                    return var2_2;
                }
                break block10;
lbl18:
                // 1 sources

                var1_1 = StreamDecoder._jr$ig$bb(this).limit();
                var2_3 = StreamDecoder._jr$ig$bb(this).position();
                if (!StreamDecoder.$assertionsDisabled && var2_3 > var1_1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                v0 = var3_4 = var2_3 <= var1_1 ? var1_1 - var2_3 : 0;
                if (!StreamDecoder.$assertionsDisabled && var3_4 <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                var4_5 = StreamDecoder._jr$ig$in(this).read(StreamDecoder._jr$ig$bb(this).array(), StreamDecoder._jr$ig$bb(this).arrayOffset() + var2_3, var3_4);
                if (var4_5 >= 0) break block11;
                var5_6 = var4_5;
                StreamDecoder._jr$ig$bb(this).flip();
                return var5_6;
            }
            if (var4_5 == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Underlying input stream returned zero bytes"));
            }
            if (!StreamDecoder.$assertionsDisabled && var4_5 > var3_4) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)("n = " + var4_5 + ", rem = " + var3_4)));
            }
            StreamDecoder._jr$ig$bb(this).position(var2_3 + var4_5);
        }
        StreamDecoder._jr$ig$bb(this).flip();
        var1_1 = StreamDecoder._jr$ig$bb(this).remaining();
        if (!StreamDecoder.$assertionsDisabled && var1_1 == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(var1_1));
        }
        return var1_1;
    }

    int implRead(char[] cArray, int n, int n2) throws IOException {
        if (!$assertionsDisabled && n2 - n <= 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2 - n);
        if (charBuffer.position() != 0) {
            charBuffer = charBuffer.slice();
        }
        boolean bl = false;
        while (true) {
            CoderResult coderResult;
            if ((coderResult = this.decoder.decode(this.bb, charBuffer, bl)).isUnderflow()) {
                if (bl || !charBuffer.hasRemaining() || charBuffer.position() > 0 && !this.inReady()) break;
                int n3 = this.readBytes();
                if (n3 >= 0) continue;
                bl = true;
                if (charBuffer.position() == 0 && !this.bb.hasRemaining()) break;
                this.decoder.reset();
                continue;
            }
            if (coderResult.isOverflow()) {
                if ($assertionsDisabled || charBuffer.position() > 0) break;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            coderResult.throwException();
        }
        if (bl) {
            this.decoder.reset();
        }
        if (charBuffer.position() == 0) {
            if (bl) {
                return -1;
            }
            if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
        }
        return charBuffer.position();
    }

    String encodingName() {
        return g.convertForInstanceOf((Object)this.cs, HistoricallyNamedCharset.class) instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)g.convertForCast((Object)this.cs, HistoricallyNamedCharset.class)).historicalName() : this.cs.name();
    }

    private boolean inReady() {
        try {
            return this.in != null && this.in.available() > 0 || g.convertForInstanceOf((Object)this.ch, FileChannel.class) instanceof FileChannel;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    boolean implReady() {
        return this.bb.hasRemaining() || this.inReady();
    }

    void implClose() throws IOException {
        if (this.ch != null) {
            this.ch.close();
        } else {
            this.in.close();
        }
    }

    private static /* synthetic */ void _jr$ip$cs(StreamDecoder streamDecoder, Charset charset) {
        streamDecoder.cs = charset;
    }

    private static /* synthetic */ void _jr$ip$decoder(StreamDecoder streamDecoder, CharsetDecoder charsetDecoder) {
        streamDecoder.decoder = charsetDecoder;
    }

    private static /* synthetic */ void _jr$ip$bb(StreamDecoder streamDecoder, ByteBuffer byteBuffer) {
        streamDecoder.bb = byteBuffer;
    }

    private static /* synthetic */ void _jr$ip$in(StreamDecoder streamDecoder, InputStream inputStream) {
        streamDecoder.in = inputStream;
    }

    private static /* synthetic */ void _jr$ip$ch(StreamDecoder streamDecoder, ReadableByteChannel readableByteChannel) {
        streamDecoder.ch = readableByteChannel;
    }

    protected /* synthetic */ StreamDecoder(h h2) {
        super(h2);
    }
}

