/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import sun.nio.cs.HistoricallyNamedCharset;

public class StreamEncoder
extends Writer {
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen;
    private Charset cs;
    private CharsetEncoder encoder;
    private ByteBuffer bb;
    private final OutputStream out;
    private WritableByteChannel ch;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    private CharBuffer lcb;

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream outputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return new StreamEncoder(outputStream, object, Charset.forName(string2));
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string2));
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream outputStream, Object object, Charset charset) {
        return new StreamEncoder(outputStream, object, charset);
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream outputStream, Object object, CharsetEncoder charsetEncoder) {
        return new StreamEncoder(outputStream, object, charsetEncoder);
    }

    public static StreamEncoder forEncoder(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        return new StreamEncoder(writableByteChannel, charsetEncoder, n);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = ah.getMonitor((Object)StreamEncoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                if (!this.isOpen()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
                }
                this.implFlushBuffer();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = ah.getMonitor((Object)StreamEncoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                if (n2 == 0) {
                    return;
                }
                this.implWrite(cArray, n, n2);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = ah.getMonitor((Object)StreamEncoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                this.implFlush();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)StreamEncoder._jr$ig$lock(this));
        synchronized (object) {
            try {
                if (!this.isOpen) {
                    return;
                }
                this.implClose();
                this.isOpen = false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private StreamEncoder(OutputStream outputStream, Object object, Charset charset) {
        this(outputStream, object, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    private StreamEncoder(OutputStream outputStream, Object object, CharsetEncoder charsetEncoder) {
        super(object);
        this.isOpen = true;
        this.haveLeftoverChar = false;
        this.lcb = null;
        this.out = outputStream;
        this.ch = null;
        this.cs = charsetEncoder.charset();
        this.encoder = charsetEncoder;
        if (this.ch == null) {
            this.bb = ByteBuffer.allocate(8192);
        }
    }

    private StreamEncoder(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        this.isOpen = true;
        this.haveLeftoverChar = false;
        this.lcb = null;
        this.out = null;
        this.ch = writableByteChannel;
        this.cs = charsetEncoder.charset();
        this.encoder = charsetEncoder;
        this.bb = ByteBuffer.allocate(n < 0 ? 8192 : n);
    }

    private void writeBytes() throws IOException {
        int n;
        this.bb.flip();
        int n2 = this.bb.limit();
        int n3 = this.bb.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n4 = n = n3 <= n2 ? n2 - n3 : 0;
        if (n > 0) {
            if (this.ch != null) {
                if (this.ch.write(this.bb) != n) if (!$assertionsDisabled) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(n));
                }
            } else {
                this.out.write(this.bb.array(), this.bb.arrayOffset() + n3, n);
            }
        }
        this.bb.clear();
    }

    private void flushLeftoverChar(CharBuffer charBuffer, boolean bl) throws IOException {
        if (!this.haveLeftoverChar && !bl) {
            return;
        }
        if (this.lcb == null) {
            this.lcb = CharBuffer.allocate(2);
        } else {
            this.lcb.clear();
        }
        if (this.haveLeftoverChar) {
            this.lcb.put(this.leftoverChar);
        }
        if (charBuffer != null && charBuffer.hasRemaining()) {
            this.lcb.put(charBuffer.get());
        }
        this.lcb.flip();
        while (this.lcb.hasRemaining() || bl) {
            CoderResult coderResult = this.encoder.encode(this.lcb, this.bb, bl);
            if (coderResult.isUnderflow()) {
                if (!this.lcb.hasRemaining()) break;
                this.leftoverChar = this.lcb.get();
                if (charBuffer != null && charBuffer.hasRemaining()) {
                    this.flushLeftoverChar(charBuffer, bl);
                }
                return;
            }
            if (coderResult.isOverflow()) {
                if (!$assertionsDisabled && this.bb.position() <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                this.writeBytes();
                continue;
            }
            coderResult.throwException();
        }
        this.haveLeftoverChar = false;
    }

    void implWrite(char[] cArray, int n, int n2) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        if (this.haveLeftoverChar) {
            this.flushLeftoverChar(charBuffer, false);
        }
        while (charBuffer.hasRemaining()) {
            CoderResult coderResult = this.encoder.encode(charBuffer, this.bb, false);
            if (coderResult.isUnderflow()) {
                if (!$assertionsDisabled && charBuffer.remaining() > 1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError(charBuffer.remaining()));
                }
                if (charBuffer.remaining() != 1) break;
                this.haveLeftoverChar = true;
                this.leftoverChar = charBuffer.get();
                break;
            }
            if (coderResult.isOverflow()) {
                if (!$assertionsDisabled && this.bb.position() <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                this.writeBytes();
                continue;
            }
            coderResult.throwException();
        }
    }

    void implFlushBuffer() throws IOException {
        if (this.bb.position() > 0) {
            this.writeBytes();
        }
    }

    void implFlush() throws IOException {
        this.implFlushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    void implClose() throws IOException {
        this.flushLeftoverChar(null, true);
        try {
            CoderResult coderResult;
            while (!(coderResult = this.encoder.flush(this.bb)).isUnderflow()) {
                if (coderResult.isOverflow()) {
                    if (!$assertionsDisabled && this.bb.position() <= 0) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                    }
                    this.writeBytes();
                    continue;
                }
                coderResult.throwException();
            }
            if (this.bb.position() > 0) {
                this.writeBytes();
            }
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            this.encoder.reset();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    String encodingName() {
        return g.convertForInstanceOf((Object)this.cs, HistoricallyNamedCharset.class) instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)g.convertForCast((Object)this.cs, HistoricallyNamedCharset.class)).historicalName() : this.cs.name();
    }

    private static /* synthetic */ void _jr$ip$cs(StreamEncoder streamEncoder, Charset charset) {
        streamEncoder.cs = charset;
    }

    private static /* synthetic */ void _jr$ip$encoder(StreamEncoder streamEncoder, CharsetEncoder charsetEncoder) {
        streamEncoder.encoder = charsetEncoder;
    }

    private static /* synthetic */ void _jr$ip$bb(StreamEncoder streamEncoder, ByteBuffer byteBuffer) {
        streamEncoder.bb = byteBuffer;
    }

    private static /* synthetic */ void _jr$ip$out(StreamEncoder streamEncoder, OutputStream outputStream) {
        streamEncoder.out = outputStream;
    }

    private static /* synthetic */ void _jr$ip$ch(StreamEncoder streamEncoder, WritableByteChannel writableByteChannel) {
        streamEncoder.ch = writableByteChannel;
    }

    protected /* synthetic */ StreamEncoder(h h2) {
        super(h2);
    }
}

