/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.zeroturnaround.jrebelbase.h;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class Surrogate
extends h {
    public static final char MIN_HIGH = '\ud800';
    public static final char MAX_HIGH = '\udbff';
    public static final char MIN_LOW = '\udc00';
    public static final char MAX_LOW = '\udfff';
    public static final char MIN = '\ud800';
    public static final char MAX = '\udfff';
    public static final int UCS4_MIN = 65536;
    public static final int UCS4_MAX = 0x10FFFF;

    private Surrogate() {
    }

    public static boolean isHigh(int n2) {
        return 55296 <= n2 && n2 <= 56319;
    }

    public static boolean isLow(int n2) {
        return 56320 <= n2 && n2 <= 57343;
    }

    public static boolean is(int n2) {
        return 55296 <= n2 && n2 <= 57343;
    }

    public static boolean neededFor(int n2) {
        return Character.isSupplementaryCodePoint(n2);
    }

    public static char high(int n2) {
        if (!$assertionsDisabled && !Character.isSupplementaryCodePoint(n2)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return Character.highSurrogate(n2);
    }

    public static char low(int n2) {
        if (!$assertionsDisabled && !Character.isSupplementaryCodePoint(n2)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return Character.lowSurrogate(n2);
    }

    public static int toUCS4(char c2, char c3) {
        if (!($assertionsDisabled || Character.isHighSurrogate(c2) && Character.isLowSurrogate(c3))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return Character.toCodePoint(c2, c3);
    }

    protected /* synthetic */ Surrogate(h h2) {
        super(h2);
    }

    public static class Generator
    extends h {
        private CoderResult error;

        public Generator() {
            this.error = CoderResult.OVERFLOW;
        }

        public CoderResult error() {
            if (!$assertionsDisabled && this.error == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return this.error;
        }

        public int generate(int n2, int n3, CharBuffer charBuffer) {
            if (Character.isBmpCodePoint(n2)) {
                char c2 = (char)n2;
                if (Character.isSurrogate(c2)) {
                    this.error = CoderResult.malformedForLength(n3);
                    return -1;
                }
                if (charBuffer.remaining() < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put(c2);
                this.error = null;
                return 1;
            }
            if (Character.isValidCodePoint(n2)) {
                if (charBuffer.remaining() < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put(Character.highSurrogate(n2));
                charBuffer.put(Character.lowSurrogate(n2));
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n3);
            return -1;
        }

        public int generate(int n2, int n3, char[] cArray, int n4, int n5) {
            if (Character.isBmpCodePoint(n2)) {
                char c2 = (char)n2;
                if (Character.isSurrogate(c2)) {
                    this.error = CoderResult.malformedForLength(n3);
                    return -1;
                }
                if (n5 - n4 < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n4] = c2;
                this.error = null;
                return 1;
            }
            if (Character.isValidCodePoint(n2)) {
                if (n5 - n4 < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n4] = Character.highSurrogate(n2);
                cArray[n4 + 1] = Character.lowSurrogate(n2);
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n3);
            return -1;
        }

        protected /* synthetic */ Generator(h h2) {
            super(h2);
        }
    }

    public static class Parser
    extends h {
        private int character;
        private CoderResult error;
        private boolean isPair;

        public Parser() {
            this.error = CoderResult.UNDERFLOW;
        }

        public int character() {
            if (!$assertionsDisabled && this.error != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return this.character;
        }

        public boolean isPair() {
            if (!$assertionsDisabled && this.error != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return this.isPair;
        }

        public int increment() {
            if (!$assertionsDisabled && this.error != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return this.isPair ? 2 : 1;
        }

        public CoderResult error() {
            if (!$assertionsDisabled && this.error == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return this.error;
        }

        public CoderResult unmappableResult() {
            if (!$assertionsDisabled && this.error != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return CoderResult.unmappableForLength(this.isPair ? 2 : 1);
        }

        public int parse(char c2, CharBuffer charBuffer) {
            if (Character.isHighSurrogate(c2)) {
                if (!charBuffer.hasRemaining()) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c3 = charBuffer.get();
                if (Character.isLowSurrogate(c3)) {
                    this.character = Character.toCodePoint(c2, c3);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c2)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c2;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public int parse(char c2, char[] cArray, int n2, int n3) {
            if (!$assertionsDisabled && cArray[n2] != c2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            if (Character.isHighSurrogate(c2)) {
                if (n3 - n2 < 2) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c3 = cArray[n2 + 1];
                if (Character.isLowSurrogate(c3)) {
                    this.character = Character.toCodePoint(c2, c3);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c2)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c2;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        protected /* synthetic */ Parser(h h2) {
            super(h2);
        }
    }
}

