/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    @Override
    public String historicalName() {
        return "UTF8";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static final void updatePositions(Buffer buffer, int n2, Buffer buffer2, int n3) {
        buffer.position(n2 - buffer.arrayOffset());
        buffer2.position(n3 - buffer2.arrayOffset());
    }

    protected /* synthetic */ UTF_8(h h2) {
        super(h2);
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int n2) {
            return (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed2(int n2, int n3) {
            return (n2 & 0x1E) == 0 || (n3 & 0xC0) != 128;
        }

        private static boolean isMalformed3(int n2, int n3, int n4) {
            return n2 == -32 && (n3 & 0xE0) == 128 || (n3 & 0xC0) != 128 || (n4 & 0xC0) != 128;
        }

        private static boolean isMalformed4(int n2, int n3, int n4) {
            return (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128 || (n4 & 0xC0) != 128;
        }

        private static CoderResult lookupN(ByteBuffer byteBuffer, int n2) {
            for (int i = 1; i < n2; ++i) {
                if (!Decoder.isNotContinuation(byteBuffer.get())) continue;
                return CoderResult.malformedForLength(i);
            }
            return CoderResult.malformedForLength(n2);
        }

        private static CoderResult malformedN(ByteBuffer byteBuffer, int n2) {
            switch (n2) {
                case 1: {
                    byte by = byteBuffer.get();
                    if (by >> 2 == -2) {
                        if (byteBuffer.remaining() < 4) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 5);
                    }
                    if (by >> 1 == -2) {
                        if (byteBuffer.remaining() < 5) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 6);
                    }
                    return CoderResult.malformedForLength(1);
                }
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || Decoder.isNotContinuation(by2) ? 1 : 2);
                }
                case 4: {
                    int n3 = byteBuffer.get() & 0xFF;
                    int n4 = byteBuffer.get() & 0xFF;
                    if (n3 > 244 || n3 == 240 && (n4 < 144 || n4 > 191) || n3 == 244 && (n4 & 0xF0) != 128 || Decoder.isNotContinuation(n4)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(byteBuffer.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            if (!$assertionsDisabled) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return null;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n2, CharBuffer charBuffer, int n3, int n4) {
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n4);
            UTF_8.updatePositions(byteBuffer, n2, charBuffer, n3);
            return coderResult;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n2, int n3) {
            byteBuffer.position(n2);
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n3);
            byteBuffer.position(n2);
            return coderResult;
        }

        private static CoderResult xflow(Buffer buffer, int n2, int n3, Buffer buffer2, int n4, int n5) {
            UTF_8.updatePositions(buffer, n2, buffer2, n4);
            return n5 == 0 || n3 - n2 < n5 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer buffer, int n2, int n3) {
            CoderResult coderResult = n3 == 0 || buffer.remaining() < n3 - 1 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
            buffer.position(n2);
            return coderResult;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n4 = charBuffer.arrayOffset() + charBuffer.position();
            int n5 = charBuffer.arrayOffset() + charBuffer.limit();
            int n6 = n4 + Math.min(n3 - n2, n5 - n4);
            while (n4 < n6 && byArray[n2] >= 0) {
                cArray[n4++] = (char)byArray[n2++];
            }
            while (n2 < n3) {
                byte by;
                byte by2;
                byte by3 = byArray[n2];
                if (by3 >= 0) {
                    if (n4 >= n5) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 1);
                    }
                    cArray[n4++] = (char)by3;
                    ++n2;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n3 - n2 < 2 || n4 >= n5) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 2);
                    }
                    by2 = byArray[n2 + 1];
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 2);
                    }
                    cArray[n4++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                    n2 += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n3 - n2 < 3 || n4 >= n5) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 3);
                    }
                    by2 = byArray[n2 + 1];
                    by = byArray[n2 + 2];
                    if (Decoder.isMalformed3(by3, by2, by)) {
                        return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 3);
                    }
                    cArray[n4++] = (char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    n2 += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n3 - n2 < 4 || n5 - n4 < 2) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 4);
                    }
                    by2 = byArray[n2 + 1];
                    by = byArray[n2 + 2];
                    byte by4 = byArray[n2 + 3];
                    int n7 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (by4 ^ 0x381F80);
                    if (Decoder.isMalformed4(by2, by, by4) || !Character.isSupplementaryCodePoint(n7)) {
                        return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 4);
                    }
                    cArray[n4++] = Character.highSurrogate(n7);
                    cArray[n4++] = Character.lowSurrogate(n7);
                    n2 += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 1);
            }
            return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            while (n2 < n3) {
                byte by;
                byte by2;
                byte by3 = byteBuffer.get();
                if (by3 >= 0) {
                    if (charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n2, 1);
                    }
                    charBuffer.put((char)by3);
                    ++n2;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n3 - n2 < 2 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n2, 2);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n2, 2);
                    }
                    charBuffer.put((char)(by3 << 6 ^ by2 ^ 0xF80));
                    n2 += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n3 - n2 < 3 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n2, 3);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed3(by3, by2, by = byteBuffer.get())) {
                        return Decoder.malformed(byteBuffer, n2, 3);
                    }
                    charBuffer.put((char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80)));
                    n2 += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n3 - n2 < 4 || charBuffer.remaining() < 2) {
                        return Decoder.xflow(byteBuffer, n2, 4);
                    }
                    by2 = byteBuffer.get();
                    by = byteBuffer.get();
                    byte by4 = byteBuffer.get();
                    int n4 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (by4 ^ 0x381F80);
                    if (Decoder.isMalformed4(by2, by, by4) || !Character.isSupplementaryCodePoint(n4)) {
                        return Decoder.malformed(byteBuffer, n2, 4);
                    }
                    charBuffer.put(Character.highSurrogate(n4));
                    charBuffer.put(Character.lowSurrogate(n4));
                    n2 += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n2, 1);
            }
            return Decoder.xflow(byteBuffer, n2, 0);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        private static ByteBuffer getByteBuffer(ByteBuffer byteBuffer, byte[] byArray, int n2) {
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.wrap(byArray);
            }
            byteBuffer.position(n2);
            return byteBuffer;
        }

        @Override
        public int decode(byte[] byArray, int n2, int n3, char[] cArray) {
            int n4 = n2 + n3;
            int n5 = 0;
            int n6 = Math.min(n3, cArray.length);
            ByteBuffer byteBuffer = null;
            while (n5 < n6 && byArray[n2] >= 0) {
                cArray[n5++] = (char)byArray[n2++];
            }
            while (n2 < n4) {
                CoderResult coderResult;
                byte by;
                byte by2;
                if ((by2 = byArray[n2++]) >= 0) {
                    cArray[n5++] = (char)by2;
                    continue;
                }
                if (by2 >> 5 == -2) {
                    if (n2 < n4) {
                        byte by3;
                        if (Decoder.isMalformed2(by2, by3 = byArray[n2++])) {
                            if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                                return -1;
                            }
                            cArray[n5++] = this.replacement().charAt(0);
                            --n2;
                            continue;
                        }
                        cArray[n5++] = (char)(by2 << 6 ^ by3 ^ 0xF80);
                        continue;
                    }
                    if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                        return -1;
                    }
                    cArray[n5++] = this.replacement().charAt(0);
                    return n5;
                }
                if (by2 >> 4 == -2) {
                    if (n2 + 1 < n4) {
                        byte by4;
                        if (Decoder.isMalformed3(by2, by4 = byArray[n2++], by = byArray[n2++])) {
                            if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                                return -1;
                            }
                            cArray[n5++] = this.replacement().charAt(0);
                            byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, n2 -= 3);
                            n2 += Decoder.malformedN(byteBuffer, 3).length();
                            continue;
                        }
                        cArray[n5++] = (char)(by2 << 12 ^ by4 << 6 ^ (by ^ 0xFFFE1F80));
                        continue;
                    }
                    if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                        return -1;
                    }
                    cArray[n5++] = this.replacement().charAt(0);
                    return n5;
                }
                if (by2 >> 3 == -2) {
                    if (n2 + 2 < n4) {
                        byte by5 = byArray[n2++];
                        by = byArray[n2++];
                        byte by6 = byArray[n2++];
                        int n7 = by2 << 18 ^ by5 << 12 ^ by << 6 ^ (by6 ^ 0x381F80);
                        if (Decoder.isMalformed4(by5, by, by6) || !Character.isSupplementaryCodePoint(n7)) {
                            if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                                return -1;
                            }
                            cArray[n5++] = this.replacement().charAt(0);
                            byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, n2 -= 4);
                            n2 += Decoder.malformedN(byteBuffer, 4).length();
                            continue;
                        }
                        cArray[n5++] = Character.highSurrogate(n7);
                        cArray[n5++] = Character.lowSurrogate(n7);
                        continue;
                    }
                    if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                        return -1;
                    }
                    cArray[n5++] = this.replacement().charAt(0);
                    return n5;
                }
                if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                    return -1;
                }
                cArray[n5++] = this.replacement().charAt(0);
                if (!(coderResult = Decoder.malformedN(byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, --n2), 1)).isError()) {
                    return n5;
                }
                n2 += coderResult.length();
            }
            return n5;
        }

        protected /* synthetic */ Decoder(h h2) {
            super(h2);
        }
    }

    private static class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private Surrogate.Parser sgp;

        private Encoder(Charset charset) {
            super(charset, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return !Character.isSurrogate(c);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n2, ByteBuffer byteBuffer, int n3) {
            UTF_8.updatePositions(charBuffer, n2, byteBuffer, n3);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n2) {
            charBuffer.position(n2);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.position();
            int n3 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
            int n6 = n4 + Math.min(n3 - n2, n5 - n4);
            while (n4 < n6 && cArray[n2] < '\u0080') {
                byArray[n4++] = (byte)cArray[n2++];
            }
            while (n2 < n3) {
                char c = cArray[n2];
                if (c < '\u0080') {
                    if (n4 >= n5) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)c;
                } else if (c < '\u0800') {
                    if (n5 - n4 < 2) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)(0xC0 | c >> 6);
                    byArray[n4++] = (byte)(0x80 | c & 0x3F);
                } else if (Character.isSurrogate(c)) {
                    int n7;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n7 = this.sgp.parse(c, cArray, n2, n3)) < 0) {
                        UTF_8.updatePositions(charBuffer, n2, byteBuffer, n4);
                        return this.sgp.error();
                    }
                    if (n5 - n4 < 4) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)(0xF0 | n7 >> 18);
                    byArray[n4++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n7 & 0x3F);
                    ++n2;
                } else {
                    if (n5 - n4 < 3) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)(0xE0 | c >> 12);
                    byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | c & 0x3F);
                }
                ++n2;
            }
            UTF_8.updatePositions(charBuffer, n2, byteBuffer, n4);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n2 = charBuffer.position();
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)c);
                } else if (c < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)(0xC0 | c >> 6));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate(c)) {
                    int n3;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n3 = this.sgp.parse(c, charBuffer)) < 0) {
                        charBuffer.position(n2);
                        return this.sgp.error();
                    }
                    if (byteBuffer.remaining() < 4) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)(0xF0 | n3 >> 18));
                    byteBuffer.put((byte)(0x80 | n3 >> 12 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n3 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n3 & 0x3F));
                    ++n2;
                } else {
                    if (byteBuffer.remaining() < 3) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)(0xE0 | c >> 12));
                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                }
                ++n2;
            }
            charBuffer.position(n2);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        public int encode(char[] cArray, int n2, int n3, byte[] byArray) {
            int n4 = n2 + n3;
            int n5 = 0;
            int n6 = n5 + Math.min(n3, byArray.length);
            while (n5 < n6 && cArray[n2] < '\u0080') {
                byArray[n5++] = (byte)cArray[n2++];
            }
            while (n2 < n4) {
                char c;
                if ((c = cArray[n2++]) < '\u0080') {
                    byArray[n5++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    byArray[n5++] = (byte)(0xC0 | c >> 6);
                    byArray[n5++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    int n7;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n7 = this.sgp.parse(c, cArray, n2 - 1, n4)) < 0) {
                        if (f.ifAcmp((Object)((Object)this.malformedInputAction()), (Object)((Object)CodingErrorAction.REPLACE))) {
                            return -1;
                        }
                        byArray[n5++] = this.replacement()[0];
                        continue;
                    }
                    byArray[n5++] = (byte)(0xF0 | n7 >> 18);
                    byArray[n5++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                    byArray[n5++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                    byArray[n5++] = (byte)(0x80 | n7 & 0x3F);
                    ++n2;
                    continue;
                }
                byArray[n5++] = (byte)(0xE0 | c >> 12);
                byArray[n5++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | c & 0x3F);
            }
            return n5;
        }

        protected /* synthetic */ Encoder(h h2) {
            super(h2);
        }
    }
}

