/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022_JP;
import sun.nio.cs.ext.SJIS;
import sun.security.action.GetPropertyAction;

public class JISAutoDetect
extends Charset
implements HistoricallyNamedCharset {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;

    public JISAutoDetect() {
        super("x-JISAutoDetect", ExtendedCharsets.aliasesFor("x-JISAutoDetect"));
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || g.convertForInstanceOf((Object)charset, SJIS.class) instanceof SJIS || g.convertForInstanceOf((Object)charset, EUC_JP.class) instanceof EUC_JP || g.convertForInstanceOf((Object)charset, ISO2022_JP.class) instanceof ISO2022_JP;
    }

    @Override
    public boolean canEncode() {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public String historicalName() {
        return "JISAutoDetect";
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public static byte[] getByteMask1() {
        return Decoder.maskTable1;
    }

    public static byte[] getByteMask2() {
        return Decoder.maskTable2;
    }

    public static final boolean canBeSJIS1B(int n2) {
        return (n2 & 4) != 0;
    }

    public static final boolean canBeEUCJP(int n2) {
        return (n2 & 1) != 0;
    }

    public static final boolean canBeEUCKana(int n2, int n3) {
        return (n2 & 8) != 0 && (n3 & 0x10) != 0;
    }

    private static boolean looksLikeJapanese(CharBuffer charBuffer) {
        int n2 = 0;
        int n3 = 0;
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            if ('\u3040' <= c && c <= '\u309f' && ++n2 > 1) {
                return true;
            }
            if ('\uff65' > c || c > '\uff9f' || ++n3 <= 1) continue;
            return true;
        }
        return false;
    }

    protected /* synthetic */ JISAutoDetect(h h2) {
        super(h2);
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final String SJISName = Decoder.getSJISName();
        private static final String EUCJPName = Decoder.getEUCJPName();
        private DelegatableDecoder detectedDecoder;
        private static final byte[] maskTable1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 5, 5, 5, 13, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};
        private static final byte[] maskTable2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};

        public Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
            this.detectedDecoder = null;
        }

        private static boolean isPlainASCII(byte by) {
            return by >= 0 && by != 27;
        }

        private static void copyLeadingASCII(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte by;
            int n2;
            int n3 = byteBuffer.position();
            int n4 = n3 + Math.min(byteBuffer.remaining(), charBuffer.remaining());
            for (n2 = n3; n2 < n4 && Decoder.isPlainASCII(by = byteBuffer.get(n2)); ++n2) {
                charBuffer.put((char)(by & 0xFF));
            }
            byteBuffer.position(n2);
        }

        private CoderResult decodeLoop(Charset charset, ByteBuffer byteBuffer, CharBuffer charBuffer) {
            this.detectedDecoder = (DelegatableDecoder)g.convertForCast((Object)((Object)charset.newDecoder()), DelegatableDecoder.class);
            return this.detectedDecoder.decodeLoop(byteBuffer, charBuffer);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (this.detectedDecoder == null) {
                CharBuffer charBuffer2;
                ByteBuffer byteBuffer2;
                ByteBuffer byteBuffer3;
                Decoder.copyLeadingASCII(byteBuffer, charBuffer);
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                int n2 = (int)((double)byteBuffer.limit() * (double)this.maxCharsPerByte());
                CharBuffer charBuffer3 = CharBuffer.allocate(n2);
                Charset charset = Charset.forName("ISO-2022-JP");
                DelegatableDecoder delegatableDecoder = (DelegatableDecoder)g.convertForCast((Object)((Object)charset.newDecoder()), DelegatableDecoder.class);
                CoderResult coderResult = delegatableDecoder.decodeLoop(byteBuffer3 = byteBuffer.asReadOnlyBuffer(), charBuffer3);
                if (!coderResult.isError()) {
                    return this.decodeLoop(charset, byteBuffer, charBuffer);
                }
                Charset charset2 = Charset.forName(EUCJPName);
                Charset charset3 = Charset.forName(SJISName);
                DelegatableDecoder delegatableDecoder2 = (DelegatableDecoder)g.convertForCast((Object)((Object)charset2.newDecoder()), DelegatableDecoder.class);
                ByteBuffer byteBuffer4 = byteBuffer.asReadOnlyBuffer();
                charBuffer3.clear();
                CoderResult coderResult2 = delegatableDecoder2.decodeLoop(byteBuffer4, charBuffer3);
                if (coderResult2.isError()) {
                    return this.decodeLoop(charset3, byteBuffer, charBuffer);
                }
                DelegatableDecoder delegatableDecoder3 = (DelegatableDecoder)g.convertForCast((Object)((Object)charset3.newDecoder()), DelegatableDecoder.class);
                CoderResult coderResult3 = delegatableDecoder3.decodeLoop(byteBuffer2 = byteBuffer.asReadOnlyBuffer(), charBuffer2 = CharBuffer.allocate(n2));
                if (coderResult3.isError()) {
                    return this.decodeLoop(charset2, byteBuffer, charBuffer);
                }
                if (byteBuffer4.position() > byteBuffer2.position()) {
                    return this.decodeLoop(charset2, byteBuffer, charBuffer);
                }
                if (byteBuffer4.position() < byteBuffer2.position()) {
                    return this.decodeLoop(charset3, byteBuffer, charBuffer);
                }
                if (byteBuffer.position() == byteBuffer4.position()) {
                    return CoderResult.UNDERFLOW;
                }
                charBuffer3.flip();
                Charset charset4 = JISAutoDetect.looksLikeJapanese(charBuffer3) ? charset2 : charset3;
                return this.decodeLoop(charset4, byteBuffer, charBuffer);
            }
            return this.detectedDecoder.decodeLoop(byteBuffer, charBuffer);
        }

        @Override
        protected void implReset() {
            this.detectedDecoder = null;
        }

        @Override
        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.detectedDecoder != null) {
                return this.detectedDecoder.implFlush(charBuffer);
            }
            return super.implFlush(charBuffer);
        }

        @Override
        public boolean isAutoDetecting() {
            return true;
        }

        @Override
        public boolean isCharsetDetected() {
            return this.detectedDecoder != null;
        }

        @Override
        public Charset detectedCharset() {
            if (this.detectedDecoder == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("charset not yet detected"));
            }
            return ((CharsetDecoder)((Object)g.convertForCast((Object)this.detectedDecoder, CharsetDecoder.class))).charset();
        }

        private static String getSJISName() {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "PCK";
            }
            if (string.startsWith("Windows")) {
                return "windows-31J";
            }
            return "Shift_JIS";
        }

        private static String getEUCJPName() {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "x-eucjp-open";
            }
            return "EUC_JP";
        }

        protected /* synthetic */ Decoder(h h2) {
            super(h2);
        }
    }
}

