/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class SJIS
extends Charset
implements HistoricallyNamedCharset {
    public SJIS() {
        super("Shift_JIS", ExtendedCharsets.aliasesFor("Shift_JIS"));
    }

    @Override
    public String historicalName() {
        return "SJIS";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || g.convertForInstanceOf((Object)charset, JIS_X_0201.class) instanceof JIS_X_0201 || g.convertForInstanceOf((Object)charset, SJIS.class) instanceof SJIS || g.convertForInstanceOf((Object)charset, JIS_X_0208.class) instanceof JIS_X_0208;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{63};
        return new Encoder(this).replaceWith(byArray);
    }

    protected /* synthetic */ SJIS(h h2) {
        super(h2);
    }

    static class Decoder
    extends JIS_X_0208_Decoder
    implements DelegatableDecoder {
        JIS_X_0201.Decoder jis0201;

        protected Decoder(Charset charset) {
            super(charset);
            this.jis0201 = new JIS_X_0201.Decoder(charset);
        }

        @Override
        protected char decodeSingle(int n) {
            if ((n & 0xFF80) == 0) {
                return (char)n;
            }
            return ((Decoder)((Object)((Object)this))).jis0201.decode(n);
        }

        @Override
        protected char decodeDouble(int n, int n2) {
            int n3;
            int n4 = n2 < 159 ? 1 : 0;
            int n5 = n3 = n < 160 ? 112 : 176;
            int n6 = n4 == 1 ? (n2 > 127 ? 32 : 31) : 126;
            int n7 = (n - n3 << 1) - n4;
            int n8 = n2 - n6;
            return super.decodeDouble(n7, n8);
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            return super.decodeLoop(byteBuffer, charBuffer);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }

        static /* synthetic */ void _jr$ip$jis0201(Object object, JIS_X_0201.Decoder decoder) {
            ((Decoder)((Object)object)).jis0201 = decoder;
        }

        protected /* synthetic */ Decoder(h h2) {
            super(h2);
        }
    }

    static class Encoder
    extends JIS_X_0208_Encoder {
        private JIS_X_0201.Encoder jis0201;
        private static final short[] j0208Index1 = JIS_X_0208_Encoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Encoder.getIndex2();

        protected Encoder(Charset charset) {
            super(charset);
            this.jis0201 = new JIS_X_0201.Encoder(charset);
        }

        @Override
        protected int encodeSingle(char c) {
            if ((c & 0xFF80) == 0) {
                return (byte)c;
            }
            byte by = this.jis0201.encode(c);
            if (by == 0) {
                return -1;
            }
            return by;
        }

        @Override
        protected int encodeDouble(char c) {
            int n;
            int n2 = j0208Index1[c >> 8] << 8;
            char c2 = j0208Index2[n2 >> 12].charAt((n2 & 0xFFF) + (c & 0xFF));
            if (c2 == '\u0000') {
                return 0;
            }
            int n3 = c2 >> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = n = n3 < 95 ? 112 : 176;
            int n6 = n3 % 2 == 1 ? (n4 > 95 ? 32 : 31) : 126;
            return (n3 + 1 >> 1) + n << 8 | n4 + n6;
        }

        private static /* synthetic */ void _jr$ip$jis0201(Encoder encoder, JIS_X_0201.Encoder encoder2) {
            encoder.jis0201 = encoder2;
        }

        protected /* synthetic */ Encoder(h h2) {
            super(h2);
        }
    }
}

