/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;

class NativeBuffers
extends h {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal<NativeBuffer[]> threadLocal = new ThreadLocal();

    private NativeBuffers() {
    }

    static NativeBuffer allocNativeBuffer(int n) {
        if (n < 2048) {
            n = 2048;
        }
        return new NativeBuffer(n);
    }

    static NativeBuffer getNativeBufferFromCache(int n) {
        NativeBuffer[] nativeBufferArray = (NativeBuffer[])g.convertForCast(threadLocal.get(), NativeBuffer[].class);
        if (nativeBufferArray != null) {
            for (int i = 0; i < 3; ++i) {
                NativeBuffer nativeBuffer = nativeBufferArray[i];
                if (nativeBuffer == null || nativeBuffer.size() < n) continue;
                nativeBufferArray[i] = null;
                return nativeBuffer;
            }
        }
        return null;
    }

    static NativeBuffer getNativeBuffer(int n) {
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBufferFromCache(n);
        if (nativeBuffer != null) {
            nativeBuffer.setOwner(null);
            return nativeBuffer;
        }
        return NativeBuffers.allocNativeBuffer(n);
    }

    static void releaseNativeBuffer(NativeBuffer nativeBuffer) {
        int n;
        NativeBuffer[] nativeBufferArray = (NativeBuffer[])g.convertForCast(threadLocal.get(), NativeBuffer[].class);
        if (nativeBufferArray == null) {
            nativeBufferArray = new NativeBuffer[3];
            a.arrayStore((Object[])nativeBufferArray, (int)0, (Object)((Object)nativeBuffer));
            threadLocal.set(nativeBufferArray);
            return;
        }
        for (n = 0; n < 3; ++n) {
            if ((NativeBuffer)((Object)g.convertForCast((Object)a.arrayLoad((Object[])nativeBufferArray, (int)n), NativeBuffer.class)) != null) continue;
            a.arrayStore((Object[])nativeBufferArray, (int)n, (Object)((Object)nativeBuffer));
            return;
        }
        for (n = 0; n < 3; ++n) {
            NativeBuffer nativeBuffer2 = (NativeBuffer)((Object)g.convertForCast((Object)a.arrayLoad((Object[])nativeBufferArray, (int)n), NativeBuffer.class));
            if (nativeBuffer2.size() >= nativeBuffer.size()) continue;
            nativeBuffer2.cleaner().clean();
            a.arrayStore((Object[])nativeBufferArray, (int)n, (Object)((Object)nativeBuffer));
            return;
        }
        nativeBuffer.cleaner().clean();
    }

    static void copyCStringToNativeBuffer(byte[] byArray, NativeBuffer nativeBuffer) {
        long l = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        long l2 = byArray.length;
        if (!$assertionsDisabled && (long)nativeBuffer.size() < l2 + 1L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        unsafe.copyMemory(byArray, l, null, nativeBuffer.address(), l2);
        unsafe.putByte(nativeBuffer.address() + l2, (byte)0);
    }

    static NativeBuffer asNativeBuffer(byte[] byArray) {
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(byArray.length + 1);
        NativeBuffers.copyCStringToNativeBuffer(byArray, nativeBuffer);
        return nativeBuffer;
    }

    protected /* synthetic */ NativeBuffers(h h2) {
        super(h2);
    }
}

