/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
class WindowsDirectoryStream
extends h
implements DirectoryStream {
    private final WindowsPath dir;
    private final DirectoryStream.Filter<? super Path> filter;
    private final long handle;
    private final String firstName;
    private final NativeBuffer findDataBuffer;
    private final Object closeLock;
    private boolean isOpen;
    private Iterator<Path> iterator;

    WindowsDirectoryStream(WindowsPath windowsPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.closeLock = new Object();
        this.isOpen = true;
        this.dir = windowsPath;
        this.filter = filter;
        try {
            String string = windowsPath.getPathForWin32Calls();
            char c2 = string.charAt(string.length() - 1);
            string = c2 == ':' || c2 == '\\' ? string + "*" : string + "\\*";
            WindowsNativeDispatcher.FirstFile firstFile = WindowsNativeDispatcher.FindFirstFile(string);
            this.handle = firstFile.handle();
            this.firstName = firstFile.name();
            this.findDataBuffer = WindowsFileAttributes.getBufferForFindData();
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() == 267) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotDirectoryException(windowsPath.getPathForExceptionMessage()));
            }
            windowsException.rethrowAsIOException(windowsPath);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (!this.isOpen) {
                    return;
                }
                this.isOpen = false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        this.findDataBuffer.release();
        try {
            WindowsNativeDispatcher.FindClose(this.handle);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Path> iterator() {
        if (!this.isOpen) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Directory stream is closed"));
        }
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.iterator != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Iterator already obtained"));
                }
                this.iterator = new WindowsDirectoryIterator(this, this.firstName);
                return this.iterator;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private static /* synthetic */ void _jr$ip$dir(WindowsDirectoryStream windowsDirectoryStream, WindowsPath windowsPath) {
        windowsDirectoryStream.dir = windowsPath;
    }

    private static /* synthetic */ void _jr$ip$filter(WindowsDirectoryStream windowsDirectoryStream, DirectoryStream.Filter filter) {
        windowsDirectoryStream.filter = filter;
    }

    private static /* synthetic */ void _jr$ip$handle(WindowsDirectoryStream windowsDirectoryStream, long l2) {
        windowsDirectoryStream.handle = l2;
    }

    private static /* synthetic */ void _jr$ip$firstName(WindowsDirectoryStream windowsDirectoryStream, String string) {
        windowsDirectoryStream.firstName = string;
    }

    private static /* synthetic */ void _jr$ip$findDataBuffer(WindowsDirectoryStream windowsDirectoryStream, NativeBuffer nativeBuffer) {
        windowsDirectoryStream.findDataBuffer = nativeBuffer;
    }

    private static /* synthetic */ void _jr$ip$closeLock(WindowsDirectoryStream windowsDirectoryStream, Object object) {
        windowsDirectoryStream.closeLock = object;
    }

    protected /* synthetic */ WindowsDirectoryStream(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class WindowsDirectoryIterator
    extends h
    implements Iterator {
        private boolean atEof;
        private String first;
        private Path nextEntry;
        private String prefix;
        final /* synthetic */ WindowsDirectoryStream this$0;

        WindowsDirectoryIterator(WindowsDirectoryStream windowsDirectoryStream, String string) {
            this.this$0 = windowsDirectoryStream;
            this.atEof = false;
            this.first = string;
            this.prefix = windowsDirectoryStream.dir.needsSlashWhenResolving() ? windowsDirectoryStream.dir.toString() + "\\" : windowsDirectoryStream.dir.toString();
        }

        private boolean isSelfOrParent(String string) {
            return string.equals(".") || string.equals("..");
        }

        private Path acceptEntry(String string, BasicFileAttributes basicFileAttributes) {
            WindowsPath windowsPath = WindowsPath.createFromNormalizedPath(((WindowsDirectoryIterator)this).this$0.dir.getFileSystem(), this.prefix + string, basicFileAttributes);
            try {
                if (((WindowsDirectoryIterator)this).this$0.filter.accept(windowsPath)) {
                    return windowsPath;
                }
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DirectoryIteratorException(iOException));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path readNextEntry() {
            Object object;
            if (this.first != null) {
                this.nextEntry = this.isSelfOrParent(this.first) ? null : this.acceptEntry(this.first, null);
                this.first = null;
                if (this.nextEntry != null) {
                    return this.nextEntry;
                }
            }
            while (true) {
                WindowsFileAttributes windowsFileAttributes;
                String string = null;
                object = ah.getMonitor((Object)((WindowsDirectoryIterator)this).this$0.closeLock);
                synchronized (object) {
                    try {
                        try {
                            if (((WindowsDirectoryIterator)this).this$0.isOpen) {
                                string = WindowsNativeDispatcher.FindNextFile(((WindowsDirectoryIterator)this).this$0.handle, ((WindowsDirectoryIterator)this).this$0.findDataBuffer.address());
                            }
                        }
                        catch (WindowsException windowsException) {
                            IOException iOException = windowsException.asIOException(((WindowsDirectoryIterator)this).this$0.dir);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DirectoryIteratorException(iOException));
                        }
                        if (string == null) {
                            this.atEof = true;
                            return null;
                        }
                        if (this.isSelfOrParent(string)) {
                            continue;
                        }
                        windowsFileAttributes = WindowsFileAttributes.fromFindData(((WindowsDirectoryIterator)this).this$0.findDataBuffer.address());
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                object = this.acceptEntry(string, windowsFileAttributes);
                if (object != null) break;
            }
            return object;
        }

        @Override
        @af(modifiers=33)
        public boolean hasNext() {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.nextEntry == null && !this.atEof) {
                        this.nextEntry = this.readNextEntry();
                    }
                    return this.nextEntry != null;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=33)
        public Path next() {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    Path path = null;
                    if (this.nextEntry == null && !this.atEof) {
                        path = this.readNextEntry();
                    } else {
                        path = this.nextEntry;
                        this.nextEntry = null;
                    }
                    if (path == null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                    }
                    return path;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @Override
        public void remove() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        private static /* synthetic */ void _jr$ip$prefix(WindowsDirectoryIterator windowsDirectoryIterator, String string) {
            windowsDirectoryIterator.prefix = string;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WindowsDirectoryStream windowsDirectoryStream) {
            ((WindowsDirectoryIterator)object).this$0 = windowsDirectoryStream;
        }

        protected /* synthetic */ WindowsDirectoryIterator(h h2) {
            super(h2);
        }
    }
}

