/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import sun.nio.fs.Globs;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsFileSystemProvider;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsPathParser;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsWatchService;
import sun.security.action.GetPropertyAction;

class WindowsFileSystem
extends FileSystem {
    private final WindowsFileSystemProvider provider;
    private final String defaultDirectory;
    private final String defaultRoot;
    private final boolean supportsLinks;
    private final boolean supportsStreamEnumeration;
    private static final Set<String> supportedFileAttributeViews;
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";

    WindowsFileSystem(WindowsFileSystemProvider windowsFileSystemProvider, String string) {
        this.provider = windowsFileSystemProvider;
        WindowsPathParser.Result result = WindowsPathParser.parse(string);
        if (f.ifAcmp((Object)((Object)result.type()), (Object)((Object)WindowsPathType.ABSOLUTE)) && f.ifAcmp((Object)((Object)result.type()), (Object)((Object)WindowsPathType.UNC))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Default directory is not an absolute path"));
        }
        this.defaultDirectory = result.path();
        this.defaultRoot = result.root();
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.version");
        String string2 = (String)AccessController.doPrivileged(getPropertyAction);
        Object[] objectArray = Util.split(string2, '.');
        int n2 = Integer.parseInt((String)a.arrayLoad((Object[])objectArray, (int)0));
        int n3 = Integer.parseInt((String)a.arrayLoad((Object[])objectArray, (int)1));
        this.supportsLinks = n2 >= 6;
        this.supportsStreamEnumeration = n2 >= 6 || n2 == 5 && n3 >= 2;
    }

    String defaultDirectory() {
        return this.defaultDirectory;
    }

    String defaultRoot() {
        return this.defaultRoot;
    }

    boolean supportsLinks() {
        return this.supportsLinks;
    }

    boolean supportsStreamEnumeration() {
        return this.supportsStreamEnumeration;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public String getSeparator() {
        return "\\";
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void close() throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        int n2 = 0;
        try {
            n2 = WindowsNativeDispatcher.GetLogicalDrives();
        }
        catch (WindowsException windowsException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)windowsException.getMessage()));
        }
        ArrayList<WindowsPath> arrayList = new ArrayList<WindowsPath>();
        SecurityManager securityManager = System.getSecurityManager();
        for (int i = 0; i <= 25; ++i) {
            if ((n2 & 1 << i) == 0) continue;
            StringBuilder stringBuilder = new StringBuilder(3);
            stringBuilder.append((char)(65 + i));
            stringBuilder.append(":\\");
            String string = stringBuilder.toString();
            if (securityManager != null) {
                try {
                    securityManager.checkRead(string);
                }
                catch (SecurityException securityException) {
                    continue;
                }
            }
            arrayList.add(WindowsPath.createFromNormalizedPath(this, string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            }
            catch (SecurityException securityException) {
                return Collections.emptyList();
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    @Override
    public final Path getPath(String string, String ... stringArray) {
        String string2;
        if (a.arrayLength((Object[])stringArray) == 0) {
            string2 = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            Object[] objectArray = stringArray;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                String string3 = (String)a.arrayLoad((Object[])objectArray, (int)i);
                if (string3.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        return WindowsPath.parse(this, string2);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return LookupService.instance;
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        String string2;
        int n2 = string.indexOf(58);
        if (n2 <= 0 || n2 == string.length()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        if (string3.equals(GLOB_SYNTAX)) {
            string2 = Globs.toWindowsRegexPattern(string4);
        } else if (string3.equals(REGEX_SYNTAX)) {
            string2 = string4;
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("Syntax '" + string3 + "' not recognized"));
        }
        Pattern pattern = Pattern.compile(string2, 66);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new WindowsWatchService(this);
    }

    static {
        Object[] objectArray = new String[5];
        a.arrayStore((Object[])objectArray, (int)0, (Object)"basic");
        a.arrayStore((Object[])objectArray, (int)1, (Object)"dos");
        a.arrayStore((Object[])objectArray, (int)2, (Object)"acl");
        a.arrayStore((Object[])objectArray, (int)3, (Object)"owner");
        a.arrayStore((Object[])objectArray, (int)4, (Object)"user");
        supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(objectArray)));
    }

    private static /* synthetic */ void _jr$ip$provider(WindowsFileSystem windowsFileSystem, WindowsFileSystemProvider windowsFileSystemProvider) {
        windowsFileSystem.provider = windowsFileSystemProvider;
    }

    private static /* synthetic */ void _jr$ip$defaultDirectory(WindowsFileSystem windowsFileSystem, String string) {
        windowsFileSystem.defaultDirectory = string;
    }

    private static /* synthetic */ void _jr$ip$defaultRoot(WindowsFileSystem windowsFileSystem, String string) {
        windowsFileSystem.defaultRoot = string;
    }

    private static /* synthetic */ void _jr$ip$supportsLinks(WindowsFileSystem windowsFileSystem, boolean bl) {
        windowsFileSystem.supportsLinks = bl;
    }

    private static /* synthetic */ void _jr$ip$supportsStreamEnumeration(WindowsFileSystem windowsFileSystem, boolean bl) {
        windowsFileSystem.supportsStreamEnumeration = bl;
    }

    protected /* synthetic */ WindowsFileSystem(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class FileStoreIterator
    extends h
    implements Iterator {
        private final Iterator<Path> roots;
        private FileStore next;
        final /* synthetic */ WindowsFileSystem this$0;

        FileStoreIterator(WindowsFileSystem windowsFileSystem) {
            this.this$0 = windowsFileSystem;
            this.roots = windowsFileSystem.getRootDirectories().iterator();
        }

        private FileStore readNext() {
            if (!$assertionsDisabled && !Thread.holdsLock(ah.getMonitor((Object)this))) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            while (this.roots.hasNext()) {
                WindowsPath windowsPath = (WindowsPath)g.convertForCast(this.roots.next(), WindowsPath.class);
                try {
                    windowsPath.checkRead();
                }
                catch (SecurityException securityException) {
                    continue;
                }
                try {
                    WindowsFileStore windowsFileStore = WindowsFileStore.create((String)windowsPath.toString(), (boolean)true);
                    if (windowsFileStore == null) continue;
                    return windowsFileStore;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        @af(modifiers=33)
        public boolean hasNext() {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.next != null) {
                        return true;
                    }
                    this.next = this.readNext();
                    return this.next != null;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=33)
        public FileStore next() {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.next == null) {
                        this.next = this.readNext();
                    }
                    if (this.next == null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                    }
                    FileStore fileStore = this.next;
                    this.next = null;
                    return fileStore;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @Override
        public void remove() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        private static /* synthetic */ void _jr$ip$roots(FileStoreIterator fileStoreIterator, Iterator iterator) {
            fileStoreIterator.roots = iterator;
        }

        static /* synthetic */ WindowsFileSystem _jr$ig$this$0(Object object) {
            return ((FileStoreIterator)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WindowsFileSystem windowsFileSystem) {
            ((FileStoreIterator)object).this$0 = windowsFileSystem;
        }

        protected /* synthetic */ FileStoreIterator(h h2) {
            super(h2);
        }
    }

    private static class LookupService
    extends h {
        static final UserPrincipalLookupService instance = new /* Unavailable Anonymous Inner Class!! */;

        private LookupService() {
        }

        protected /* synthetic */ LookupService(h h2) {
            super(h2);
        }
    }
}

