/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.j;
import com.zeroturnaround.jrebelbase.h;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import sun.misc.Unsafe;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.AbstractFileSystemProvider;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.FileOwnerAttributeViewImpl;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsAclFileAttributeView;
import sun.nio.fs.WindowsChannelFactory;
import sun.nio.fs.WindowsDirectoryStream;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributeViews;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileCopy;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsSecurity;
import sun.nio.fs.WindowsSecurityDescriptor;
import sun.nio.fs.WindowsUriSupport;
import sun.nio.fs.WindowsUserDefinedFileAttributeView;

public class WindowsFileSystemProvider
extends AbstractFileSystemProvider {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String USER_DIR = "user.dir";
    private final WindowsFileSystem theFileSystem;

    public WindowsFileSystemProvider() {
        this.theFileSystem = new WindowsFileSystem(this, System.getProperty(USER_DIR));
    }

    @Override
    public String getScheme() {
        return "file";
    }

    private void checkUri(URI uRI) {
        if (!uRI.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("URI does not match this provider"));
        }
        if (uRI.getAuthority() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Authority component present"));
        }
        if (uRI.getPath() == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Path component is undefined"));
        }
        if (!uRI.getPath().equals("/")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Path component should be '/'"));
        }
        if (uRI.getQuery() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Query component present"));
        }
        if (uRI.getFragment() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Fragment component present"));
        }
    }

    @Override
    public FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        this.checkUri(uRI);
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileSystemAlreadyExistsException());
    }

    @Override
    public final FileSystem getFileSystem(URI uRI) {
        this.checkUri(uRI);
        return this.theFileSystem;
    }

    @Override
    public Path getPath(URI uRI) {
        return WindowsUriSupport.fromUri((WindowsFileSystem)this.theFileSystem, (URI)uRI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        FileChannel fileChannel;
        block7: {
            if (path == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            if (!(g.convertForInstanceOf((Object)path, WindowsPath.class) instanceof WindowsPath)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderMismatchException());
            }
            WindowsPath windowsPath = (WindowsPath)g.convertForCast((Object)path, WindowsPath.class);
            WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute((FileAttribute[])fileAttributeArray);
            try {
                fileChannel = WindowsChannelFactory.newFileChannel((String)windowsPath.getPathForWin32Calls(), (String)windowsPath.getPathForPermissionCheck(), set, (long)windowsSecurityDescriptor.address());
                if (windowsSecurityDescriptor == null) break block7;
            }
            catch (WindowsException windowsException) {
                FileChannel fileChannel2;
                block8: {
                    try {
                        windowsException.rethrowAsIOException(windowsPath);
                        fileChannel2 = null;
                        if (windowsSecurityDescriptor == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (windowsSecurityDescriptor != null) {
                            windowsSecurityDescriptor.release();
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                    windowsSecurityDescriptor.release();
                }
                return fileChannel2;
            }
            windowsSecurityDescriptor.release();
        }
        return fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        AsynchronousFileChannel asynchronousFileChannel;
        block7: {
            if (path == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            if (!(g.convertForInstanceOf((Object)path, WindowsPath.class) instanceof WindowsPath)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderMismatchException());
            }
            WindowsPath windowsPath = (WindowsPath)g.convertForCast((Object)path, WindowsPath.class);
            ThreadPool threadPool = executorService == null ? null : ThreadPool.wrap(executorService, 0);
            WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute((FileAttribute[])fileAttributeArray);
            try {
                asynchronousFileChannel = WindowsChannelFactory.newAsynchronousFileChannel((String)windowsPath.getPathForWin32Calls(), (String)windowsPath.getPathForPermissionCheck(), set, (long)windowsSecurityDescriptor.address(), (ThreadPool)threadPool);
                if (windowsSecurityDescriptor == null) break block7;
            }
            catch (WindowsException windowsException) {
                AsynchronousFileChannel asynchronousFileChannel2;
                block8: {
                    try {
                        windowsException.rethrowAsIOException(windowsPath);
                        asynchronousFileChannel2 = null;
                        if (windowsSecurityDescriptor == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (windowsSecurityDescriptor != null) {
                            windowsSecurityDescriptor.release();
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                    windowsSecurityDescriptor.release();
                }
                return asynchronousFileChannel2;
            }
            windowsSecurityDescriptor.release();
        }
        return asynchronousFileChannel;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (clazz == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        boolean bl = Util.followLinks(linkOptionArray);
        if (!f.ifAcmp(clazz, BasicFileAttributeView.class)) {
            return (V)WindowsFileAttributeViews.createBasicView((WindowsPath)windowsPath, (boolean)bl);
        }
        if (!f.ifAcmp(clazz, DosFileAttributeView.class)) {
            return (V)WindowsFileAttributeViews.createDosView((WindowsPath)windowsPath, (boolean)bl);
        }
        if (!f.ifAcmp(clazz, AclFileAttributeView.class)) {
            return (V)new WindowsAclFileAttributeView(windowsPath, bl);
        }
        if (!f.ifAcmp(clazz, FileOwnerAttributeView.class)) {
            return (V)new FileOwnerAttributeViewImpl((AclFileAttributeView)new WindowsAclFileAttributeView(windowsPath, bl));
        }
        if (!f.ifAcmp(clazz, UserDefinedFileAttributeView.class)) {
            return (V)new WindowsUserDefinedFileAttributeView(windowsPath, bl);
        }
        return (V)((FileAttributeView)g.convertForCast(null, FileAttributeView.class));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        Class<BasicFileAttributeView> clazz2;
        if (!f.ifAcmp(clazz, BasicFileAttributes.class)) {
            clazz2 = BasicFileAttributeView.class;
        } else if (!f.ifAcmp(clazz, DosFileAttributes.class)) {
            clazz2 = DosFileAttributeView.class;
        } else {
            if (clazz == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        return (A)((BasicFileAttributeView)g.convertForCast((Object)this.getFileAttributeView(path, clazz2, linkOptionArray), BasicFileAttributeView.class)).readAttributes();
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path path, String string, LinkOption ... linkOptionArray) {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        boolean bl = Util.followLinks(linkOptionArray);
        if (string.equals("basic")) {
            return WindowsFileAttributeViews.createBasicView((WindowsPath)windowsPath, (boolean)bl);
        }
        if (string.equals("dos")) {
            return WindowsFileAttributeViews.createDosView((WindowsPath)windowsPath, (boolean)bl);
        }
        if (string.equals("acl")) {
            return new WindowsAclFileAttributeView(windowsPath, bl);
        }
        if (string.equals("owner")) {
            return new FileOwnerAttributeViewImpl((AclFileAttributeView)new WindowsAclFileAttributeView(windowsPath, bl));
        }
        if (string.equals("user")) {
            return new WindowsUserDefinedFileAttributeView(windowsPath, bl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        FileChannel fileChannel;
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute((FileAttribute[])fileAttributeArray);
        try {
            fileChannel = WindowsChannelFactory.newFileChannel((String)windowsPath.getPathForWin32Calls(), (String)windowsPath.getPathForPermissionCheck(), set, (long)windowsSecurityDescriptor.address());
        }
        catch (WindowsException windowsException) {
            SeekableByteChannel seekableByteChannel;
            try {
                windowsException.rethrowAsIOException(windowsPath);
                seekableByteChannel = null;
            }
            catch (Throwable throwable) {
                windowsSecurityDescriptor.release();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            windowsSecurityDescriptor.release();
            return seekableByteChannel;
        }
        windowsSecurityDescriptor.release();
        return fileChannel;
    }

    @Override
    boolean implDelete(Path path, boolean bl) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkDelete();
        WindowsFileAttributes windowsFileAttributes = null;
        try {
            windowsFileAttributes = WindowsFileAttributes.get(windowsPath, false);
            if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                WindowsNativeDispatcher.RemoveDirectory(windowsPath.getPathForWin32Calls());
            } else {
                WindowsNativeDispatcher.DeleteFile(windowsPath.getPathForWin32Calls());
            }
            return true;
        }
        catch (WindowsException windowsException) {
            if (!(bl || windowsException.lastError() != 2 && windowsException.lastError() != 3)) {
                return false;
            }
            if (windowsFileAttributes != null && windowsFileAttributes.isDirectory() && (windowsException.lastError() == 145 || windowsException.lastError() == 183)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DirectoryNotEmptyException(windowsPath.getPathForExceptionMessage()));
            }
            windowsException.rethrowAsIOException(windowsPath);
            return false;
        }
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        WindowsFileCopy.copy((WindowsPath)WindowsPath.toWindowsPath(path), (WindowsPath)WindowsPath.toWindowsPath(path2), (CopyOption[])copyOptionArray);
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        WindowsFileCopy.move((WindowsPath)WindowsPath.toWindowsPath(path), (WindowsPath)WindowsPath.toWindowsPath(path2), (CopyOption[])copyOptionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasDesiredAccess(WindowsPath windowsPath, int n2) throws IOException {
        boolean bl = false;
        String string = WindowsLinkSupport.getFinalPath(windowsPath, true);
        NativeBuffer nativeBuffer = WindowsAclFileAttributeView.getFileSecurity((String)string, (int)7);
        try {
            bl = WindowsSecurity.checkAccessMask((long)nativeBuffer.address(), (int)n2, (int)1179785, (int)1179926, (int)1179808, (int)0x1F01FF);
            nativeBuffer.release();
        }
        catch (WindowsException windowsException) {
            try {
                windowsException.rethrowAsIOException(windowsPath);
                nativeBuffer.release();
            }
            catch (Throwable throwable) {
                nativeBuffer.release();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return bl;
    }

    private void checkReadAccess(WindowsPath windowsPath) throws IOException {
        try {
            Set set = Collections.emptySet();
            FileChannel fileChannel = WindowsChannelFactory.newFileChannel((String)windowsPath.getPathForWin32Calls(), (String)windowsPath.getPathForPermissionCheck(), set, (long)0L);
            fileChannel.close();
        }
        catch (WindowsException windowsException) {
            try {
                new WindowsDirectoryStream(windowsPath, null).close();
            }
            catch (IOException iOException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
        }
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        AccessMode[] accessModeArray2 = accessModeArray;
        int n2 = a.arrayLength((Object[])accessModeArray2);
        block7: for (int i = 0; i < n2; ++i) {
            AccessMode accessMode = (AccessMode)((Object)g.convertForCast((Object)a.arrayLoad((Object[])accessModeArray2, (int)i), AccessMode.class));
            switch (1.$SwitchMap$java$nio$file$AccessMode[accessMode.ordinal() + 1]) {
                case 1: {
                    bl = true;
                    continue block7;
                }
                case 2: {
                    bl2 = true;
                    continue block7;
                }
                case 3: {
                    bl3 = true;
                    continue block7;
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should not get here"));
                }
            }
        }
        if (!bl2 && !bl3) {
            this.checkReadAccess(windowsPath);
            return;
        }
        int n3 = 0;
        if (bl) {
            windowsPath.checkRead();
            n3 |= 1;
        }
        if (bl2) {
            windowsPath.checkWrite();
            n3 |= 2;
        }
        if (bl3) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkExec(windowsPath.getPathForPermissionCheck());
            }
            n3 |= 0x20;
        }
        if (!WindowsFileSystemProvider.hasDesiredAccess(windowsPath, n3)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AccessDeniedException(windowsPath.getPathForExceptionMessage(), null, "Permissions does not allow requested access"));
        }
        if (bl2) {
            try {
                WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.get(windowsPath, true);
                if (!windowsFileAttributes.isDirectory() && windowsFileAttributes.isReadOnly()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AccessDeniedException(windowsPath.getPathForExceptionMessage(), null, "DOS readonly attribute is set"));
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            if (WindowsFileStore.create((WindowsPath)windowsPath).isReadOnly()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AccessDeniedException(windowsPath.getPathForExceptionMessage(), null, "Read-only file system"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (windowsPath.equals(path2)) {
            return true;
        }
        if (path2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)path2, WindowsPath.class) instanceof WindowsPath)) {
            return false;
        }
        WindowsPath windowsPath2 = (WindowsPath)g.convertForCast((Object)path2, WindowsPath.class);
        windowsPath.checkRead();
        windowsPath2.checkRead();
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        WindowsFileAttributes windowsFileAttributes = null;
        try {
            windowsFileAttributes = WindowsFileAttributes.readAttributes(l);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        long l2 = 0L;
        try {
            l2 = windowsPath2.openForReadAttributeAccess(true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath2);
        }
        WindowsFileAttributes windowsFileAttributes2 = null;
        try {
            windowsFileAttributes2 = WindowsFileAttributes.readAttributes(l2);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath2);
        }
        boolean bl = WindowsFileAttributes.isSameFile(windowsFileAttributes, windowsFileAttributes2);
        WindowsNativeDispatcher.CloseHandle(l2);
        WindowsNativeDispatcher.CloseHandle(l);
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    WindowsNativeDispatcher.CloseHandle(l2);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                catch (Throwable throwable2) {
                    WindowsNativeDispatcher.CloseHandle(l);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                }
            }
        }
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkRead();
        WindowsFileAttributes windowsFileAttributes = null;
        try {
            windowsFileAttributes = WindowsFileAttributes.get(windowsPath, true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        if (windowsFileAttributes.isDirectory()) {
            return false;
        }
        return windowsFileAttributes.isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            windowsPath.checkRead();
        }
        return WindowsFileStore.create((WindowsPath)windowsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkWrite();
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute((FileAttribute[])fileAttributeArray);
        try {
            WindowsNativeDispatcher.CreateDirectory(windowsPath.getPathForWin32Calls(), windowsSecurityDescriptor.address());
        }
        catch (WindowsException windowsException) {
            try {
                windowsException.rethrowAsIOException(windowsPath);
            }
            catch (Throwable throwable) {
                windowsSecurityDescriptor.release();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            windowsSecurityDescriptor.release();
        }
        windowsSecurityDescriptor.release();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkRead();
        if (filter == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new WindowsDirectoryStream(windowsPath, filter);
    }

    @Override
    public void createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        WindowsPath windowsPath;
        WindowsPath windowsPath2 = WindowsPath.toWindowsPath(path);
        WindowsPath windowsPath3 = WindowsPath.toWindowsPath(path2);
        if (!windowsPath2.getFileSystem().supportsLinks()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("Symbolic links not supported on this operating system"));
        }
        if (a.arrayLength((Object[])fileAttributeArray) > 0) {
            WindowsSecurityDescriptor.fromAttribute((FileAttribute[])fileAttributeArray);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("Initial file attributesnot supported when creating symbolic link"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("symbolic"));
            windowsPath2.checkWrite();
        }
        if (!f.ifAcmp((Object)((Object)windowsPath3.type()), (Object)((Object)WindowsPathType.DRIVE_RELATIVE))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Cannot create symbolic link to working directory relative target"));
        }
        WindowsPath windowsPath4 = !f.ifAcmp((Object)((Object)windowsPath3.type()), (Object)((Object)WindowsPathType.RELATIVE)) ? ((windowsPath = windowsPath2.getParent()) == null ? windowsPath3 : windowsPath.resolve(windowsPath3)) : windowsPath2.resolve(windowsPath3);
        int n2 = 0;
        try {
            WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.get(windowsPath4, false);
            if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                n2 |= 1;
            }
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
        try {
            WindowsNativeDispatcher.CreateSymbolicLink(windowsPath2.getPathForWin32Calls(), WindowsPath.addPrefixIfNeeded(windowsPath3.toString()), n2);
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() == 4392) {
                windowsException.rethrowAsIOException(windowsPath2, windowsPath3);
            }
            windowsException.rethrowAsIOException(windowsPath2);
        }
    }

    @Override
    public void createLink(Path path, Path path2) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        WindowsPath windowsPath2 = WindowsPath.toWindowsPath(path2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("hard"));
            windowsPath.checkWrite();
            windowsPath2.checkWrite();
        }
        try {
            WindowsNativeDispatcher.CreateHardLink(windowsPath.getPathForWin32Calls(), windowsPath2.getPathForWin32Calls());
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath, windowsPath2);
        }
    }

    @Override
    public Path readSymbolicLink(Path path) throws IOException {
        Object object;
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        if (!windowsFileSystem.supportsLinks()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("symbolic links not supported"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new FilePermission(windowsPath.getPathForPermissionCheck(), "readlink");
            AccessController.checkPermission((Permission)object);
        }
        object = WindowsLinkSupport.readLink(windowsPath);
        return WindowsPath.createFromNormalizedPath(windowsFileSystem, (String)object);
    }

    private static /* synthetic */ void _jr$ip$theFileSystem(WindowsFileSystemProvider windowsFileSystemProvider, WindowsFileSystem windowsFileSystem) {
        windowsFileSystemProvider.theFileSystem = windowsFileSystem;
    }

    protected /* synthetic */ WindowsFileSystemProvider(h h2) {
        super(h2);
    }

    static class 1
    extends h {
        static final /* synthetic */ int[] $SwitchMap$java$nio$file$AccessMode;

        static {
            AccessMode[] accessModeArray = AccessMode.values();
            j.registerSwitchClass(1.class, AccessMode.class, null);
            int[] nArray = new int[a.arrayLength((Object[])accessModeArray) + 1];
            nArray[0] = -1;
            $SwitchMap$java$nio$file$AccessMode = nArray;
            try {
                1.$SwitchMap$java$nio$file$AccessMode[AccessMode.READ.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$nio$file$AccessMode[AccessMode.WRITE.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$nio$file$AccessMode[AccessMode.EXECUTE.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        public static /* synthetic */ void _jr$$rebel_clinit() {
            AccessMode[] accessModeArray = AccessMode.values();
            j.registerSwitchClass(1.class, AccessMode.class, null);
            int[] nArray = new int[a.arrayLength((Object[])accessModeArray) + 1];
            nArray[0] = -1;
            j.updateSwitchMap((int[])nArray, 1.class, (String)"$SwitchMap$java$nio$file$AccessMode");
            try {
                1.$SwitchMap$java$nio$file$AccessMode[AccessMode.READ.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$nio$file$AccessMode[AccessMode.WRITE.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$nio$file$AccessMode[AccessMode.EXECUTE.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        protected /* synthetic */ 1(h h2) {
            super(h2);
        }
    }
}

