/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsLinkSupport
extends h {
    private static final Unsafe unsafe = Unsafe.getUnsafe();

    private WindowsLinkSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readLink(WindowsPath windowsPath) throws IOException {
        String string;
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(false);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        try {
            string = WindowsLinkSupport.readLinkImpl(l);
        }
        catch (Throwable throwable) {
            WindowsNativeDispatcher.CloseHandle(l);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        WindowsNativeDispatcher.CloseHandle(l);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFinalPath(WindowsPath windowsPath) throws IOException {
        String string;
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        try {
            string = WindowsLinkSupport.stripPrefix(WindowsNativeDispatcher.GetFinalPathNameByHandle(l));
        }
        catch (WindowsException windowsException) {
            block6: {
                try {
                    if (windowsException.lastError() == 124) break block6;
                    windowsException.rethrowAsIOException(windowsPath);
                }
                catch (Throwable throwable) {
                    WindowsNativeDispatcher.CloseHandle(l);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            WindowsNativeDispatcher.CloseHandle(l);
            return null;
        }
        WindowsNativeDispatcher.CloseHandle(l);
        return string;
    }

    static String getFinalPath(WindowsPath windowsPath, boolean bl) throws IOException {
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        try {
            if (!bl || !windowsFileSystem.supportsLinks()) {
                return windowsPath.getPathForWin32Calls();
            }
            if (!WindowsFileAttributes.get(windowsPath, false).isSymbolicLink()) {
                return windowsPath.getPathForWin32Calls();
            }
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        String string = WindowsLinkSupport.getFinalPath(windowsPath);
        if (string != null) {
            return string;
        }
        WindowsPath windowsPath2 = windowsPath;
        int n2 = 0;
        do {
            h h2;
            try {
                h2 = WindowsFileAttributes.get(windowsPath2, false);
                if (!h2.isSymbolicLink()) {
                    return windowsPath2.getPathForWin32Calls();
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            h2 = WindowsPath.createFromNormalizedPath(windowsFileSystem, WindowsLinkSupport.readLink(windowsPath2));
            WindowsPath windowsPath3 = windowsPath2.getParent();
            if (windowsPath3 == null) {
                WindowsPath windowsPath4 = windowsPath2;
                windowsPath2 = (WindowsPath)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), WindowsPath.class);
                windowsPath3 = windowsPath2.getParent();
            }
            windowsPath2 = windowsPath3.resolve((Path)h2);
        } while (++n2 < 32);
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileSystemException(windowsPath.getPathForExceptionMessage(), null, "Too many links"));
    }

    static String getRealPath(WindowsPath windowsPath, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        if (bl && !windowsFileSystem.supportsLinks()) {
            bl = false;
        }
        String string = null;
        try {
            string = windowsPath.toAbsolutePath().toString();
        }
        catch (IOError iOError) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)((IOException)g.convertForCast((Object)iOError.getCause(), IOException.class)), IOException.class)));
        }
        if (string.indexOf(46) >= 0) {
            try {
                string = WindowsNativeDispatcher.GetFullPathName(string);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        if ((c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A') && c2 == ':' && string.charAt(2) == '\\') {
            stringBuilder.append(Character.toUpperCase(c));
            stringBuilder.append(":\\");
            n4 = 3;
        } else if (c == '\\' && c2 == '\\') {
            n3 = string.length() - 1;
            n2 = string.indexOf(92, 2);
            if (n2 == -1 || n2 == n3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileSystemException(windowsPath.getPathForExceptionMessage(), null, "UNC has invalid share"));
            }
            if ((n2 = string.indexOf(92, n2 + 1)) < 0) {
                n2 = n3;
                stringBuilder.append(string).append("\\");
            } else {
                stringBuilder.append(string, 0, n2 + 1);
            }
            n4 = n2 + 1;
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"path type not recognized"));
        }
        if (n4 >= string.length()) {
            String string2 = stringBuilder.toString();
            try {
                WindowsNativeDispatcher.GetFileAttributes(string2);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(string);
            }
            return string2;
        }
        n3 = n4;
        while (n3 < string.length()) {
            n2 = string.indexOf(92, n3);
            int n5 = n2 == -1 ? string.length() : n2;
            String string3 = stringBuilder.toString() + string.substring(n3, n5);
            try {
                WindowsNativeDispatcher.FirstFile firstFile = WindowsNativeDispatcher.FindFirstFile(WindowsPath.addPrefixIfNeeded(string3));
                WindowsNativeDispatcher.FindClose(firstFile.handle());
                if (bl && WindowsFileAttributes.isReparsePoint(firstFile.attributes())) {
                    String string4 = WindowsLinkSupport.getFinalPath(windowsPath);
                    if (string4 == null) {
                        WindowsPath windowsPath2 = WindowsLinkSupport.resolveAllLinks(WindowsPath.createFromNormalizedPath(windowsFileSystem, string));
                        string4 = WindowsLinkSupport.getRealPath(windowsPath2, false);
                    }
                    return string4;
                }
                stringBuilder.append(firstFile.name());
                if (n2 != -1) {
                    stringBuilder.append('\\');
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(string);
            }
            n3 = n5 + 1;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLinkImpl(long l) throws IOException {
        int n2 = 16384;
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n2);
        try {
            try {
                WindowsNativeDispatcher.DeviceIoControlGetReparsePoint(l, nativeBuffer.address(), n2);
            }
            catch (WindowsException windowsException) {
                if (windowsException.lastError() == 4390) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotLinkException(null, null, windowsException.errorString()));
                }
                windowsException.rethrowAsIOException((String)null);
            }
            int n3 = (int)unsafe.getLong(nativeBuffer.address() + 0L);
            if (n3 != -1610612724) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotLinkException(null, null, "Reparse point is not a symbolic link"));
            }
            short s = unsafe.getShort(nativeBuffer.address() + 8L);
            short s2 = unsafe.getShort(nativeBuffer.address() + 10L);
            if (s2 % 2 != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileSystemException(null, null, "Symbolic link corrupted"));
            }
            char[] cArray = new char[s2 / 2];
            unsafe.copyMemory(null, nativeBuffer.address() + 20L + (long)s, cArray, Unsafe.ARRAY_CHAR_BASE_OFFSET, s2);
            String string = WindowsLinkSupport.stripPrefix(new String(cArray));
            if (string.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Symbolic link target is invalid"));
            }
            String string2 = string;
            nativeBuffer.release();
            return string2;
        }
        catch (Throwable throwable) {
            nativeBuffer.release();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private static WindowsPath resolveAllLinks(WindowsPath windowsPath) throws IOException {
        if (!$assertionsDisabled && !windowsPath.isAbsolute()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        int n2 = 0;
        int n3 = 0;
        while (n3 < windowsPath.getNameCount()) {
            WindowsPath windowsPath2 = windowsPath.getRoot().resolve(windowsPath.subpath(0, n3 + 1));
            WindowsFileAttributes windowsFileAttributes = null;
            try {
                windowsFileAttributes = WindowsFileAttributes.get(windowsPath2, false);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            if (windowsFileAttributes.isSymbolicLink()) {
                if (++n2 > 32) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Too many links"));
                }
                WindowsPath windowsPath3 = WindowsPath.createFromNormalizedPath(windowsFileSystem, WindowsLinkSupport.readLink(windowsPath2));
                WindowsPath windowsPath4 = null;
                int n4 = windowsPath.getNameCount();
                if (n3 + 1 < n4) {
                    windowsPath4 = windowsPath.subpath(n3 + 1, n4);
                }
                windowsPath = windowsPath2.getParent().resolve(windowsPath3);
                try {
                    String string = WindowsNativeDispatcher.GetFullPathName(windowsPath.toString());
                    if (!string.equals(windowsPath.toString())) {
                        windowsPath = WindowsPath.createFromNormalizedPath(windowsFileSystem, string);
                    }
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath);
                }
                if (windowsPath4 != null) {
                    windowsPath = windowsPath.resolve(windowsPath4);
                }
                n3 = 0;
                continue;
            }
            ++n3;
        }
        return windowsPath;
    }

    private static String stripPrefix(String string) {
        if (string.startsWith("\\\\?\\")) {
            string = string.startsWith("\\\\?\\UNC\\") ? "\\" + string.substring(7) : string.substring(4);
            return string;
        }
        if (string.startsWith("\\??\\")) {
            string = string.startsWith("\\??\\UNC\\") ? "\\" + string.substring(7) : string.substring(4);
            return string;
        }
        return string;
    }

    protected /* synthetic */ WindowsLinkSupport(h h2) {
        super(h2);
    }
}

