/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedWatchEventModifier;
import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import sun.nio.fs.AbstractPath;
import sun.nio.fs.BasicFileAttributesHolder;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPathParser;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsUriSupport;
import sun.nio.fs.WindowsWatchService;

class WindowsPath
extends AbstractPath {
    private static final int MAX_PATH = 247;
    private static final int MAX_LONG_PATH = 32000;
    private final WindowsFileSystem fs;
    private final WindowsPathType type;
    private final String root;
    private final String path;
    private volatile WeakReference<String> pathForWin32Calls;
    private volatile Integer[] offsets;
    private int hash;

    private WindowsPath(WindowsFileSystem windowsFileSystem, WindowsPathType windowsPathType, String string, String string2) {
        this.fs = windowsFileSystem;
        this.type = windowsPathType;
        this.root = string;
        this.path = string2;
    }

    static WindowsPath parse(WindowsFileSystem windowsFileSystem, String string) {
        WindowsPathParser.Result result = WindowsPathParser.parse(string);
        return new WindowsPath(windowsFileSystem, result.type(), result.root(), result.path());
    }

    static WindowsPath createFromNormalizedPath(WindowsFileSystem windowsFileSystem, String string, BasicFileAttributes basicFileAttributes) {
        try {
            WindowsPathParser.Result result = WindowsPathParser.parseNormalizedPath(string);
            if (basicFileAttributes == null) {
                return new WindowsPath(windowsFileSystem, result.type(), result.root(), result.path());
            }
            return new WindowsPathWithAttributes(windowsFileSystem, result.type(), result.root(), result.path(), basicFileAttributes);
        }
        catch (InvalidPathException invalidPathException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)invalidPathException.getMessage()));
        }
    }

    static WindowsPath createFromNormalizedPath(WindowsFileSystem windowsFileSystem, String string) {
        return WindowsPath.createFromNormalizedPath(windowsFileSystem, string, null);
    }

    String getPathForExceptionMessage() {
        return this.path;
    }

    String getPathForPermissionCheck() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPathForWin32Calls() throws WindowsException {
        String string;
        if (this.isAbsolute() && this.path.length() <= 247) {
            return this.path;
        }
        WeakReference weakReference = this.pathForWin32Calls;
        String string2 = string = weakReference != null ? (String)weakReference.get() : null;
        if (string != null) {
            return string;
        }
        string = this.getAbsolutePath();
        if (string.length() > 247) {
            if (string.length() > 32000) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new WindowsException("Cannot access file with path exceeding 32000 characters"));
            }
            string = WindowsPath.addPrefixIfNeeded(WindowsNativeDispatcher.GetFullPathName(string));
        }
        if (f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.DRIVE_RELATIVE))) {
            Object object = ah.getMonitor((Object)this.path);
            synchronized (object) {
                try {
                    this.pathForWin32Calls = new WeakReference<String>(string);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return string;
    }

    private String getAbsolutePath() throws WindowsException {
        String string;
        if (this.isAbsolute()) {
            return this.path;
        }
        if (!f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.RELATIVE))) {
            String string2 = this.getFileSystem().defaultDirectory();
            if (this.isEmpty()) {
                return string2;
            }
            if (string2.endsWith("\\")) {
                return string2 + this.path;
            }
            StringBuilder stringBuilder = new StringBuilder(string2.length() + this.path.length() + 1);
            return stringBuilder.append(string2).append('\\').append(this.path).toString();
        }
        if (!f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.DIRECTORY_RELATIVE))) {
            String string3 = this.getFileSystem().defaultRoot();
            return string3 + this.path.substring(1);
        }
        if (WindowsPath.isSameDrive(this.root, this.getFileSystem().defaultRoot())) {
            String string4 = this.path.substring(this.root.length());
            String string5 = this.getFileSystem().defaultDirectory();
            String string6 = string5.endsWith("\\") ? string5 + string4 : string5 + "\\" + string4;
            return string6;
        }
        try {
            int n = WindowsNativeDispatcher.GetDriveType(this.root + "\\");
            if (n == 0 || n == 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new WindowsException(""));
            }
            string = WindowsNativeDispatcher.GetFullPathName(this.root + ".");
        }
        catch (WindowsException windowsException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new WindowsException("Unable to get working directory of drive '" + Character.toUpperCase(this.root.charAt(0)) + "'"));
        }
        String string7 = string;
        if (string.endsWith("\\")) {
            string7 = string7 + this.path.substring(this.root.length());
        } else if (this.path.length() > this.root.length()) {
            string7 = string7 + "\\" + this.path.substring(this.root.length());
        }
        return string7;
    }

    private static boolean isSameDrive(String string, String string2) {
        return Character.toUpperCase(string.charAt(0)) == Character.toUpperCase(string2.charAt(0));
    }

    static String addPrefixIfNeeded(String string) {
        if (string.length() > 247) {
            string = string.startsWith("\\\\") ? "\\\\?\\UNC" + string.substring(1, string.length()) : "\\\\?\\" + string;
        }
        return string;
    }

    @Override
    public WindowsFileSystem getFileSystem() {
        return this.fs;
    }

    private boolean isEmpty() {
        return this.path.length() == 0;
    }

    private WindowsPath emptyPath() {
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", "");
    }

    @Override
    public Path getFileName() {
        int n = this.path.length();
        if (n == 0) {
            return this;
        }
        if (this.root.length() == n) {
            return null;
        }
        int n2 = this.path.lastIndexOf(92);
        n2 = n2 < this.root.length() ? this.root.length() : ++n2;
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", this.path.substring(n2));
    }

    @Override
    public WindowsPath getParent() {
        if (this.root.length() == this.path.length()) {
            return null;
        }
        int n = this.path.lastIndexOf(92);
        if (n < this.root.length()) {
            return this.getRoot();
        }
        return new WindowsPath(this.getFileSystem(), this.type, this.root, this.path.substring(0, n));
    }

    @Override
    public WindowsPath getRoot() {
        if (this.root.length() == 0) {
            return null;
        }
        return new WindowsPath(this.getFileSystem(), this.type, this.root, this.root);
    }

    WindowsPathType type() {
        return this.type;
    }

    boolean isUnc() {
        return !f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.UNC));
    }

    boolean needsSlashWhenResolving() {
        if (this.path.endsWith("\\")) {
            return false;
        }
        return this.path.length() > this.root.length();
    }

    @Override
    public boolean isAbsolute() {
        return !f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.ABSOLUTE)) || !f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.UNC));
    }

    static WindowsPath toWindowsPath(Path path) {
        if (path == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)path, WindowsPath.class) instanceof WindowsPath)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderMismatchException());
        }
        return (WindowsPath)g.convertForCast((Object)path, WindowsPath.class);
    }

    @Override
    public WindowsPath relativize(Path path) {
        int n;
        int n2;
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (this.equals(windowsPath)) {
            return this.emptyPath();
        }
        if (f.ifAcmp((Object)((Object)this.type), (Object)((Object)windowsPath.type))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("'other' is different type of Path"));
        }
        if (!this.root.equalsIgnoreCase(windowsPath.root)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("'other' has different root"));
        }
        int n3 = this.getNameCount();
        int n4 = n3 > (n2 = windowsPath.getNameCount()) ? n2 : n3;
        for (int i = 0; i < n4 && this.getName(i).equals(windowsPath.getName(i)); ++i) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = i; n < n3; ++n) {
            stringBuilder.append("..\\");
        }
        for (n = i; n < n2; ++n) {
            stringBuilder.append(windowsPath.getName(n).toString());
            stringBuilder.append("\\");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return WindowsPath.createFromNormalizedPath(this.getFileSystem(), stringBuilder.toString());
    }

    @Override
    public Path normalize() {
        int n;
        int n2;
        int n3 = this.getNameCount();
        if (n3 == 0 || this.isEmpty()) {
            return this;
        }
        boolean[] blArray = new boolean[n3];
        int n4 = n3;
        do {
            n2 = n4;
            int n5 = -1;
            for (n = 0; n < n3; ++n) {
                if (blArray[n]) continue;
                String string = this.elementAsString(n);
                if (string.length() > 2) {
                    n5 = n;
                    continue;
                }
                if (string.length() == 1) {
                    if (string.charAt(0) == '.') {
                        blArray[n] = true;
                        --n4;
                        continue;
                    }
                    n5 = n;
                    continue;
                }
                if (string.charAt(0) != '.' || string.charAt(1) != '.') {
                    n5 = n;
                    continue;
                }
                if (n5 >= 0) {
                    blArray[n5] = true;
                    blArray[n] = true;
                    n4 -= 2;
                    n5 = -1;
                    continue;
                }
                if (!this.isAbsolute() && f.ifAcmp((Object)((Object)this.type), (Object)((Object)WindowsPathType.DIRECTORY_RELATIVE))) continue;
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    if (blArray[i]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                blArray[n] = true;
                --n4;
            }
        } while (n2 > n4);
        if (n4 == n3) {
            return this;
        }
        if (n4 == 0) {
            return this.root.length() == 0 ? this.emptyPath() : this.getRoot();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.root != null) {
            stringBuilder.append(this.root);
        }
        for (n = 0; n < n3; ++n) {
            if (blArray[n]) continue;
            stringBuilder.append(this.getName(n));
            stringBuilder.append("\\");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return WindowsPath.createFromNormalizedPath(this.getFileSystem(), stringBuilder.toString());
    }

    @Override
    public WindowsPath resolve(Path path) {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (windowsPath.isEmpty()) {
            return this;
        }
        if (windowsPath.isAbsolute()) {
            return windowsPath;
        }
        switch (1.$SwitchMap$sun$nio$fs$WindowsPathType[windowsPath.type.ordinal() + 1]) {
            case 1: {
                String string = this.path.endsWith("\\") || this.root.length() == this.path.length() ? this.path + windowsPath.path : this.path + "\\" + windowsPath.path;
                return new WindowsPath(this.getFileSystem(), this.type, this.root, string);
            }
            case 2: {
                String string = this.root.endsWith("\\") ? this.root + windowsPath.path.substring(1) : this.root + windowsPath.path;
                return WindowsPath.createFromNormalizedPath(this.getFileSystem(), string);
            }
            case 3: {
                if (!this.root.endsWith("\\")) {
                    return windowsPath;
                }
                String string = this.root.substring(0, this.root.length() - 1);
                if (!string.equalsIgnoreCase(windowsPath.root)) {
                    return windowsPath;
                }
                String string2 = windowsPath.path.substring(windowsPath.root.length());
                String string3 = this.path.endsWith("\\") ? this.path + string2 : this.path + "\\" + string2;
                return WindowsPath.createFromNormalizedPath(this.getFileSystem(), string3);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (this.isEmpty()) {
                arrayList.add(0);
            } else {
                int n = this.root.length();
                int n2 = this.root.length();
                while (n2 < this.path.length()) {
                    if (this.path.charAt(n2) != '\\') {
                        ++n2;
                        continue;
                    }
                    arrayList.add(n);
                    n = ++n2;
                }
                if (n != n2) {
                    arrayList.add(n);
                }
            }
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.offsets == null) {
                        this.offsets = (Integer[])g.convertForCast((Object)arrayList.toArray(new Integer[arrayList.size()]), Integer[].class);
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return a.arrayLength((Object[])this.offsets);
    }

    private String elementAsString(int n) {
        this.initOffsets();
        if (n == a.arrayLength((Object[])this.offsets) - 1) {
            return this.path.substring((Integer)g.convertForCast((Object)a.arrayLoad((Object[])this.offsets, (int)n), Integer.class));
        }
        return this.path.substring((Integer)g.convertForCast((Object)a.arrayLoad((Object[])this.offsets, (int)n), Integer.class), (Integer)g.convertForCast((Object)a.arrayLoad((Object[])this.offsets, (int)(n + 1)), Integer.class) - 1);
    }

    @Override
    public WindowsPath getName(int n) {
        this.initOffsets();
        if (n < 0 || n >= a.arrayLength((Object[])this.offsets)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", this.elementAsString(n));
    }

    @Override
    public WindowsPath subpath(int n, int n2) {
        this.initOffsets();
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n >= a.arrayLength((Object[])this.offsets)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n2 > a.arrayLength((Object[])this.offsets)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n >= n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Integer[n2 - n];
        for (int i = n; i < n2; ++i) {
            a.arrayStore((Object[])objectArray, (int)(i - n), (Object)stringBuilder.length());
            stringBuilder.append(this.elementAsString(i));
            if (i == n2 - 1) continue;
            stringBuilder.append("\\");
        }
        return new WindowsPath(this.getFileSystem(), WindowsPathType.RELATIVE, "", stringBuilder.toString());
    }

    @Override
    public boolean startsWith(Path path) {
        if (!(g.convertForInstanceOf((Object)Objects.requireNonNull(path), WindowsPath.class) instanceof WindowsPath)) {
            return false;
        }
        WindowsPath windowsPath = (WindowsPath)g.convertForCast((Object)path, WindowsPath.class);
        if (!this.root.equalsIgnoreCase(windowsPath.root)) {
            return false;
        }
        if (windowsPath.isEmpty()) {
            return this.isEmpty();
        }
        int n = this.getNameCount();
        int n2 = windowsPath.getNameCount();
        if (n2 <= n) {
            while (--n2 >= 0) {
                String string;
                String string2 = this.elementAsString(n2);
                if (string2.equalsIgnoreCase(string = windowsPath.elementAsString(n2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(Path path) {
        if (!(g.convertForInstanceOf((Object)Objects.requireNonNull(path), WindowsPath.class) instanceof WindowsPath)) {
            return false;
        }
        WindowsPath windowsPath = (WindowsPath)g.convertForCast((Object)path, WindowsPath.class);
        if (windowsPath.path.length() > this.path.length()) {
            return false;
        }
        if (windowsPath.isEmpty()) {
            return this.isEmpty();
        }
        int n = this.getNameCount();
        int n2 = windowsPath.getNameCount();
        if (n2 > n) {
            return false;
        }
        if (windowsPath.root.length() > 0) {
            if (n2 < n) {
                return false;
            }
            if (!this.root.equalsIgnoreCase(windowsPath.root)) {
                return false;
            }
        }
        int n3 = n - n2;
        while (--n2 >= 0) {
            String string;
            String string2 = this.elementAsString(n3 + n2);
            if (string2.equalsIgnoreCase(string = windowsPath.elementAsString(n2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Path path) {
        if (path == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        String string = this.path;
        String string2 = ((WindowsPath)g.convertForCast((Object)path, WindowsPath.class)).path;
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && g.convertForInstanceOf((Object)object, WindowsPath.class) instanceof WindowsPath) {
            return this.compareTo((Path)g.convertForCast((Object)object, Path.class)) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            for (int i = 0; i < this.path.length(); ++i) {
                n = 31 * n + Character.toUpperCase(this.path.charAt(i));
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public String toString() {
        return this.path;
    }

    long openForReadAttributeAccess(boolean bl) throws WindowsException {
        int n = 0x2000000;
        if (!bl && this.getFileSystem().supportsLinks()) {
            n |= 0x200000;
        }
        return WindowsNativeDispatcher.CreateFile(this.getPathForWin32Calls(), 128, 7, 0L, 3, n);
    }

    void checkRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.getPathForPermissionCheck());
        }
    }

    void checkWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.getPathForPermissionCheck());
        }
    }

    void checkDelete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.getPathForPermissionCheck());
        }
    }

    @Override
    public URI toUri() {
        return WindowsUriSupport.toUri((WindowsPath)this);
    }

    @Override
    public WindowsPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.dir");
        }
        try {
            return WindowsPath.createFromNormalizedPath(this.getFileSystem(), this.getAbsolutePath());
        }
        catch (WindowsException windowsException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOError(new IOException(windowsException.getMessage())));
        }
    }

    @Override
    public WindowsPath toRealPath(LinkOption ... linkOptionArray) throws IOException {
        this.checkRead();
        String string = WindowsLinkSupport.getRealPath(this, Util.followLinks(linkOptionArray));
        return WindowsPath.createFromNormalizedPath(this.getFileSystem(), string);
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        if (watchService == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)watchService, WindowsWatchService.class) instanceof WindowsWatchService)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderMismatchException());
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            boolean bl = false;
            int n = a.arrayLength((Object[])modifierArray);
            if (n > 0) {
                modifierArray = (WatchEvent.Modifier[])g.convertForCast((Object)Arrays.copyOf(modifierArray, n), WatchEvent.Modifier[].class);
                int n2 = 0;
                while (n2 < n) {
                    if (f.ifAcmp((Object)((WatchEvent.Modifier)g.convertForCast((Object)a.arrayLoad((Object[])modifierArray, (int)n2++), WatchEvent.Modifier.class)), (Object)ExtendedWatchEventModifier.FILE_TREE)) continue;
                    bl = true;
                    break;
                }
            }
            String string = this.getPathForPermissionCheck();
            securityManager.checkRead(string);
            if (bl) {
                securityManager.checkRead(string + "\\-");
            }
        }
        return ((WindowsWatchService)g.convertForCast((Object)watchService, WindowsWatchService.class)).register((Path)this, (WatchEvent.Kind[])kindArray, modifierArray);
    }

    private static /* synthetic */ void _jr$ip$fs(WindowsPath windowsPath, WindowsFileSystem windowsFileSystem) {
        windowsPath.fs = windowsFileSystem;
    }

    private static /* synthetic */ void _jr$ip$type(WindowsPath windowsPath, WindowsPathType windowsPathType) {
        windowsPath.type = windowsPathType;
    }

    private static /* synthetic */ void _jr$ip$root(WindowsPath windowsPath, String string) {
        windowsPath.root = string;
    }

    private static /* synthetic */ void _jr$ip$path(WindowsPath windowsPath, String string) {
        windowsPath.path = string;
    }

    protected /* synthetic */ WindowsPath(h h2) {
        super(h2);
    }

    private static class WindowsPathWithAttributes
    extends WindowsPath
    implements BasicFileAttributesHolder {
        final WeakReference<BasicFileAttributes> ref;

        WindowsPathWithAttributes(WindowsFileSystem windowsFileSystem, WindowsPathType windowsPathType, String string, String string2, BasicFileAttributes basicFileAttributes) {
            super(windowsFileSystem, windowsPathType, string, string2);
            this.ref = new WeakReference<BasicFileAttributes>(basicFileAttributes);
        }

        @Override
        public BasicFileAttributes get() {
            return (BasicFileAttributes)g.convertForCast(((WindowsPathWithAttributes)this).ref.get(), BasicFileAttributes.class);
        }

        @Override
        public void invalidate() {
            ((WindowsPathWithAttributes)this).ref.clear();
        }

        static /* synthetic */ void _jr$ip$ref(Object object, WeakReference weakReference) {
            ((WindowsPathWithAttributes)object).ref = weakReference;
        }

        protected /* synthetic */ WindowsPathWithAttributes(h h2) {
            super(h2);
        }
    }
}

