/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.zeroturnaround.jrebelbase.h;
import java.nio.file.InvalidPathException;
import sun.nio.fs.WindowsPathType;

class WindowsPathParser
extends h {
    private static final String reservedChars = "<>:\"|?*";

    private WindowsPathParser() {
    }

    static Result parse(String string) {
        return WindowsPathParser.parse(string, true);
    }

    static Result parseNormalizedPath(String string) {
        return WindowsPathParser.parse(string, false);
    }

    private static Result parse(String string, boolean bl) {
        String string2 = "";
        WindowsPathType windowsPathType = null;
        int n2 = string.length();
        int n3 = 0;
        if (n2 > 1) {
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            boolean bl2 = false;
            int n4 = 2;
            if (WindowsPathParser.isSlash(c2) && WindowsPathParser.isSlash(c3)) {
                windowsPathType = WindowsPathType.UNC;
                n3 = WindowsPathParser.nextNonSlash(string, n4, n2);
                if (n3 == (n4 = WindowsPathParser.nextSlash(string, n3, n2))) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidPathException(string, "UNC path is missing hostname"));
                }
                String string3 = string.substring(n3, n4);
                n3 = WindowsPathParser.nextNonSlash(string, n4, n2);
                if (n3 == (n4 = WindowsPathParser.nextSlash(string, n3, n2))) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidPathException(string, "UNC path is missing sharename"));
                }
                string2 = "\\\\" + string3 + "\\" + string.substring(n3, n4) + "\\";
                n3 = n4;
            } else if (WindowsPathParser.isLetter(c2) && c3 == ':') {
                char c4;
                if (n2 > 2 && WindowsPathParser.isSlash(c4 = string.charAt(2))) {
                    string2 = c4 == '\\' ? string.substring(0, 3) : string.substring(0, 2) + '\\';
                    n3 = 3;
                    windowsPathType = WindowsPathType.ABSOLUTE;
                } else {
                    string2 = string.substring(0, 2);
                    n3 = 2;
                    windowsPathType = WindowsPathType.DRIVE_RELATIVE;
                }
            }
        }
        if (n3 == 0) {
            if (n2 > 0 && WindowsPathParser.isSlash(string.charAt(0))) {
                windowsPathType = WindowsPathType.DIRECTORY_RELATIVE;
                string2 = "\\";
            } else {
                windowsPathType = WindowsPathType.RELATIVE;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            stringBuilder.append(string2);
            return new Result(windowsPathType, string2, WindowsPathParser.normalize(stringBuilder, string, n3));
        }
        return new Result(windowsPathType, string2, string);
    }

    private static String normalize(StringBuilder stringBuilder, String string, int n2) {
        int n3 = string.length();
        int n4 = n2 = WindowsPathParser.nextNonSlash(string, n2, n3);
        char c2 = '\u0000';
        while (n2 < n3) {
            char c3 = string.charAt(n2);
            if (WindowsPathParser.isSlash(c3)) {
                if (c2 == ' ') {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidPathException(string, "Trailing char <" + c2 + ">", n2 - 1));
                }
                stringBuilder.append(string, n4, n2);
                n2 = WindowsPathParser.nextNonSlash(string, n2, n3);
                if (n2 != n3) {
                    stringBuilder.append('\\');
                }
                n4 = n2;
                continue;
            }
            if (WindowsPathParser.isInvalidPathChar(c3)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidPathException(string, "Illegal char <" + c3 + ">", n2));
            }
            c2 = c3;
            ++n2;
        }
        if (n4 != n2) {
            if (c2 == ' ') {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidPathException(string, "Trailing char <" + c2 + ">", n2 - 1));
            }
            stringBuilder.append(string, n4, n2);
        }
        return stringBuilder.toString();
    }

    private static final boolean isSlash(char c2) {
        return c2 == '\\' || c2 == '/';
    }

    private static final int nextNonSlash(String string, int n2, int n3) {
        while (n2 < n3 && WindowsPathParser.isSlash(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    private static final int nextSlash(String string, int n2, int n3) {
        char c2;
        while (n2 < n3 && !WindowsPathParser.isSlash(c2 = string.charAt(n2))) {
            if (WindowsPathParser.isInvalidPathChar(c2)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidPathException(string, "Illegal character [" + c2 + "] in path", n2));
            }
            ++n2;
        }
        return n2;
    }

    private static final boolean isLetter(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }

    private static final boolean isInvalidPathChar(char c2) {
        return c2 < ' ' || reservedChars.indexOf(c2) != -1;
    }

    protected /* synthetic */ WindowsPathParser(h h2) {
        super(h2);
    }

    static class Result
    extends h {
        private final WindowsPathType type;
        private final String root;
        private final String path;

        Result(WindowsPathType windowsPathType, String string, String string2) {
            this.type = windowsPathType;
            this.root = string;
            this.path = string2;
        }

        WindowsPathType type() {
            return this.type;
        }

        String root() {
            return this.root;
        }

        String path() {
            return this.path;
        }

        private static /* synthetic */ void _jr$ip$type(Result result, WindowsPathType windowsPathType) {
            result.type = windowsPathType;
        }

        private static /* synthetic */ void _jr$ip$root(Result result, String string) {
            result.root = string;
        }

        private static /* synthetic */ void _jr$ip$path(Result result, String string) {
            result.path = string;
        }

        protected /* synthetic */ Result(h h2) {
            super(h2);
        }
    }
}

