/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;

public final class ECKeyFactory
extends KeyFactorySpi {
    public static final KeyFactory INSTANCE;
    public static final Provider ecInternalProvider;

    public static ECKey toECKey(Key key) throws InvalidKeyException {
        if (g.convertForInstanceOf((Object)key, ECKey.class) instanceof ECKey) {
            ECKey eCKey = (ECKey)g.convertForCast((Object)key, ECKey.class);
            ECKeyFactory.checkKey(eCKey);
            return eCKey;
        }
        return (ECKey)g.convertForCast((Object)INSTANCE.translateKey(key), ECKey.class);
    }

    private static void checkKey(ECKey eCKey) throws InvalidKeyException {
        String string;
        if (g.convertForInstanceOf((Object)eCKey, ECPublicKey.class) instanceof ECPublicKey) {
            if (eCKey instanceof ECPublicKeyImpl) {
                return;
            }
        } else if (g.convertForInstanceOf((Object)eCKey, ECPrivateKey.class) instanceof ECPrivateKey) {
            if (g.convertForInstanceOf((Object)eCKey, ECPrivateKeyImpl.class) instanceof ECPrivateKeyImpl) {
                return;
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Neither a public nor a private key"));
        }
        if (!(string = ((Key)g.convertForCast((Object)eCKey, Key.class)).getAlgorithm()).equals("EC")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Not an EC key: " + string));
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Key must not be null"));
        }
        String string = key.getAlgorithm();
        if (!string.equals("EC")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Not an EC key: " + string));
        }
        if (g.convertForInstanceOf((Object)key, PublicKey.class) instanceof PublicKey) {
            return this.implTranslatePublicKey((PublicKey)g.convertForCast((Object)key, PublicKey.class));
        }
        if (g.convertForInstanceOf((Object)key, PrivateKey.class) instanceof PrivateKey) {
            return this.implTranslatePrivateKey((PrivateKey)g.convertForCast((Object)key, PrivateKey.class));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Neither a public nor a private key"));
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.implGeneratePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)invalidKeySpecException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException(generalSecurityException));
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.implGeneratePrivate(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)invalidKeySpecException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException(generalSecurityException));
        }
    }

    private PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (g.convertForInstanceOf((Object)publicKey, ECPublicKey.class) instanceof ECPublicKey) {
            if (publicKey instanceof ECPublicKeyImpl) {
                return publicKey;
            }
            ECPublicKey eCPublicKey = (ECPublicKey)g.convertForCast((Object)publicKey, ECPublicKey.class);
            return new ECPublicKeyImpl(eCPublicKey.getW(), eCPublicKey.getParams());
        }
        if ("X.509".equals(publicKey.getFormat())) {
            byte[] byArray = publicKey.getEncoded();
            return new ECPublicKeyImpl(byArray);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Public keys must be instance of ECPublicKey or have X.509 encoding"));
    }

    private PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (g.convertForInstanceOf((Object)privateKey, ECPrivateKey.class) instanceof ECPrivateKey) {
            if (g.convertForInstanceOf((Object)privateKey, ECPrivateKeyImpl.class) instanceof ECPrivateKeyImpl) {
                return privateKey;
            }
            ECPrivateKey eCPrivateKey = (ECPrivateKey)g.convertForCast((Object)privateKey, ECPrivateKey.class);
            return new ECPrivateKeyImpl(eCPrivateKey.getS(), eCPrivateKey.getParams());
        }
        if ("PKCS#8".equals(privateKey.getFormat())) {
            return new ECPrivateKeyImpl(privateKey.getEncoded());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Private keys must be instance of ECPrivateKey or have PKCS#8 encoding"));
    }

    private PublicKey implGeneratePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (g.convertForInstanceOf((Object)keySpec, X509EncodedKeySpec.class) instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)g.convertForCast((Object)keySpec, X509EncodedKeySpec.class);
            return new ECPublicKeyImpl(x509EncodedKeySpec.getEncoded());
        }
        if (g.convertForInstanceOf((Object)keySpec, ECPublicKeySpec.class) instanceof ECPublicKeySpec) {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)g.convertForCast((Object)keySpec, ECPublicKeySpec.class);
            return new ECPublicKeyImpl(eCPublicKeySpec.getW(), eCPublicKeySpec.getParams());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys"));
    }

    private PrivateKey implGeneratePrivate(KeySpec keySpec) throws GeneralSecurityException {
        if (g.convertForInstanceOf((Object)keySpec, PKCS8EncodedKeySpec.class) instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)g.convertForCast((Object)keySpec, PKCS8EncodedKeySpec.class);
            return new ECPrivateKeyImpl(pKCS8EncodedKeySpec.getEncoded());
        }
        if (g.convertForInstanceOf((Object)keySpec, ECPrivateKeySpec.class) instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)g.convertForCast((Object)keySpec, ECPrivateKeySpec.class);
            return new ECPrivateKeyImpl(eCPrivateKeySpec.getS(), eCPrivateKeySpec.getParams());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys"));
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException(invalidKeyException));
        }
        if (g.convertForInstanceOf((Object)key, ECPublicKey.class) instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)g.convertForCast((Object)key, ECPublicKey.class);
            if (x.isAssignableFrom(ECPublicKeySpec.class, clazz)) {
                return (T)new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
            }
            if (x.isAssignableFrom(X509EncodedKeySpec.class, clazz)) {
                return (T)new X509EncodedKeySpec(key.getEncoded());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("KeySpec must be ECPublicKeySpec or X509EncodedKeySpec for EC public keys"));
        }
        if (g.convertForInstanceOf((Object)key, ECPrivateKey.class) instanceof ECPrivateKey) {
            if (x.isAssignableFrom(PKCS8EncodedKeySpec.class, clazz)) {
                return (T)new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (x.isAssignableFrom(ECPrivateKeySpec.class, clazz)) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)g.convertForCast((Object)key, ECPrivateKey.class);
                return (T)new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("KeySpec must be ECPrivateKeySpec or PKCS8EncodedKeySpec for EC private keys"));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Neither public nor private key"));
    }

    static {
        final Provider provider = new Provider("SunEC-Internal", 1.0, null){};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Void run() {
                provider.put("KeyFactory.EC", "sun.security.ec.ECKeyFactory");
                provider.put("AlgorithmParameters.EC", "sun.security.ec.ECParameters");
                provider.put("Alg.Alias.AlgorithmParameters.1.2.840.10045.2.1", "EC");
                return null;
            }

            static /* synthetic */ Provider _jr$ig$val$p(Object object) {
                return (object).provider;
            }

            static /* synthetic */ void _jr$ip$val$p(Object object, Provider provider2) {
                (object).provider = provider2;
            }
        });
        try {
            INSTANCE = KeyFactory.getInstance("EC", provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(noSuchAlgorithmException));
        }
        ecInternalProvider = provider;
    }
}

