/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import sun.security.ec.ECParameters;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509Key;

public final class ECPublicKeyImpl
extends X509Key
implements ECPublicKey {
    private static final long serialVersionUID = -2462037275160462289L;
    private ECPoint w;
    private ECParameterSpec params;

    public ECPublicKeyImpl(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        this.w = eCPoint;
        this.params = eCParameterSpec;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(eCParameterSpec));
        this.key = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
    }

    public ECPublicKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public byte[] getEncodedPublicValue() {
        return (byte[])this.key.clone();
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getParameters();
            this.params = (ECParameterSpec)g.convertForCast((Object)algorithmParameters.getParameterSpec(ECParameterSpec.class), ECParameterSpec.class);
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid EC key", iOException));
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid EC key", invalidParameterSpecException));
        }
    }

    @Override
    public String toString() {
        return "Sun EC public key, " + this.params.getCurve().getField().getFieldSize() + " bits\n  public x coord: " + this.w.getAffineX() + "\n  public y coord: " + this.w.getAffineY() + "\n  parameters: " + this.params;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private static /* synthetic */ ECPoint _jr$ig$w(ECPublicKeyImpl eCPublicKeyImpl) {
        return eCPublicKeyImpl.w;
    }

    private static /* synthetic */ void _jr$ip$w(ECPublicKeyImpl eCPublicKeyImpl, ECPoint eCPoint) {
        eCPublicKeyImpl.w = eCPoint;
    }

    private static /* synthetic */ ECParameterSpec _jr$ig$params(ECPublicKeyImpl eCPublicKeyImpl) {
        return eCPublicKeyImpl.params;
    }

    private static /* synthetic */ void _jr$ip$params(ECPublicKeyImpl eCPublicKeyImpl, ECParameterSpec eCParameterSpec) {
        eCPublicKeyImpl.params = eCParameterSpec;
    }
}

