/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.jca.ProviderConfig;
import sun.security.util.Debug;

final class ProviderConfig
extends h {
    private static final Debug debug = Debug.getInstance("jca", "ProviderConfig");
    private static final String P11_SOL_NAME = "sun.security.pkcs11.SunPKCS11";
    private static final String P11_SOL_ARG = "${java.home}/lib/security/sunpkcs11-solaris.cfg";
    private static final int MAX_LOAD_TRIES = 30;
    private static final Class[] CL_STRING = new Class[]{String.class};
    private final String className;
    private final String argument;
    private int tries;
    private volatile Provider provider;
    private boolean isLoading;

    ProviderConfig(String string, String string2) {
        if (string.equals(P11_SOL_NAME) && string2.equals(P11_SOL_ARG)) {
            this.checkSunPKCS11Solaris();
        }
        this.className = string;
        this.argument = ProviderConfig.expand(string2);
    }

    ProviderConfig(String string) {
        this(string, "");
    }

    ProviderConfig(Provider provider) {
        this.className = x.getName(provider.getClass());
        this.argument = "";
        this.provider = provider;
    }

    private void checkSunPKCS11Solaris() {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(this){

            @Override
            public Boolean run() {
                File file = new File("/usr/lib/libpkcs11.so");
                if (!file.exists()) {
                    return Boolean.FALSE;
                }
                if ("false".equalsIgnoreCase(System.getProperty("sun.security.pkcs11.enable-solaris"))) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        if (!f.ifAcmp((Object)bl, (Object)Boolean.FALSE)) {
            this.tries = 30;
        }
    }

    private boolean hasArgument() {
        return this.argument.length() != 0;
    }

    private boolean shouldLoad() {
        return this.tries < 30;
    }

    private void disableLoad() {
        this.tries = 30;
    }

    boolean isLoaded() {
        return this.provider != null;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
            return true;
        }
        if (!(object instanceof ProviderConfig)) {
            return false;
        }
        ProviderConfig providerConfig = (ProviderConfig)((Object)object);
        return this.className.equals(providerConfig.className) && this.argument.equals(providerConfig.argument);
    }

    public int hashCode() {
        return this.className.hashCode() + this.argument.hashCode();
    }

    public String toString() {
        if (this.hasArgument()) {
            return this.className + "('" + this.argument + "')";
        }
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Provider getProvider() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider;
        }
        if (!this.shouldLoad()) {
            return null;
        }
        if (this.isLoading) {
            if (debug != null) {
                debug.println("Recursion loading provider: " + (Object)((Object)this));
                new Exception("Call trace").printStackTrace();
            }
            return null;
        }
        try {
            this.isLoading = true;
            ++this.tries;
            provider = this.doLoadProvider();
            this.isLoading = false;
        }
        catch (Throwable throwable) {
            this.isLoading = false;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.provider = provider;
        return provider;
    }

    private Provider doLoadProvider() {
        return (Provider)g.convertForCast(AccessController.doPrivileged(new PrivilegedAction(this){
            final /* synthetic */ ProviderConfig this$0;
            {
                this.this$0 = providerConfig;
            }

            public Provider run() {
                if (debug != null) {
                    debug.println("Loading provider: " + (Object)((Object)this.this$0));
                }
                try {
                    Object t;
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(this.this$0.className) : Class.forName(this.this$0.className);
                    if (!this.this$0.hasArgument()) {
                        t = ai.getCurrentClass(clazz).newInstance();
                    } else {
                        aj aj2 = ai.convertArgs(clazz, (Class[])CL_STRING);
                        Constructor constructor = aj2.clazz.getConstructor(aj2.args);
                        Object[] objectArray = new Object[1];
                        a.arrayStore((Object[])objectArray, (int)0, (Object)this.this$0.argument);
                        t = constructor.newInstance(objectArray);
                    }
                    if (g.convertForInstanceOf(t, Provider.class) instanceof Provider) {
                        if (debug != null) {
                            debug.println("Loaded provider " + t);
                        }
                        return (Provider)g.convertForCast(t, Provider.class);
                    }
                    if (debug != null) {
                        debug.println(this.this$0.className + " is not a provider");
                    }
                    this.this$0.disableLoad();
                    return null;
                }
                catch (Exception exception) {
                    Throwable throwable = g.convertForInstanceOf((Object)exception, InvocationTargetException.class) instanceof InvocationTargetException ? ((InvocationTargetException)g.convertForCast((Object)exception, InvocationTargetException.class)).getCause() : exception;
                    if (debug != null) {
                        debug.println("Error loading provider " + (Object)((Object)this.this$0));
                        throwable.printStackTrace();
                    }
                    if (g.convertForInstanceOf((Object)throwable, ProviderException.class) instanceof ProviderException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((ProviderException)g.convertForCast((Object)throwable, ProviderException.class)));
                    }
                    if (g.convertForInstanceOf((Object)throwable, UnsupportedOperationException.class) instanceof UnsupportedOperationException) {
                        this.this$0.disableLoad();
                    }
                    return null;
                }
            }

            static /* synthetic */ ProviderConfig _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, ProviderConfig providerConfig) {
                (object).this$0 = providerConfig;
            }
        }), Provider.class);
    }

    private static String expand(String string) {
        if (!string.contains("${")) {
            return string;
        }
        return (String)((Object)AccessController.doPrivileged(new PrivilegedAction<Provider>(string){

            @Override
            public Provider run() {
                if (debug != null) {
                    debug.println("Loading provider " + (Object)((Object)ProviderConfig.this));
                }
                try {
                    Provider p = ProviderLoader.INSTANCE.load(ProviderConfig.this.provName);
                    if (p != null) {
                        if (ProviderConfig.this.hasArgument()) {
                            p = p.configure(ProviderConfig.this.argument);
                        }
                        if (debug != null) {
                            debug.println("Loaded provider " + p.getName());
                        }
                    } else {
                        if (debug != null) {
                            debug.println("Error loading provider " + (Object)((Object)ProviderConfig.this));
                        }
                        ProviderConfig.this.disableLoad();
                    }
                    return p;
                }
                catch (Exception e2) {
                    if (e2 instanceof ProviderException) {
                        throw e2;
                    }
                    if (debug != null) {
                        debug.println("Error loading provider " + (Object)((Object)ProviderConfig.this));
                        e2.printStackTrace();
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
                catch (ExceptionInInitializerError err) {
                    if (debug != null) {
                        debug.println("Error loading provider " + (Object)((Object)ProviderConfig.this));
                        err.printStackTrace();
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
            }
        }));
    }

    private static /* synthetic */ String _jr$ig$className(ProviderConfig providerConfig) {
        return providerConfig.className;
    }

    private static /* synthetic */ void _jr$ip$className(ProviderConfig providerConfig, String string) {
        providerConfig.className = string;
    }

    private static /* synthetic */ String _jr$ig$argument(ProviderConfig providerConfig) {
        return providerConfig.argument;
    }

    private static /* synthetic */ void _jr$ip$argument(ProviderConfig providerConfig, String string) {
        providerConfig.argument = string;
    }

    private static /* synthetic */ int _jr$ig$tries(ProviderConfig providerConfig) {
        return providerConfig.tries;
    }

    private static /* synthetic */ void _jr$ip$tries(ProviderConfig providerConfig, int n2) {
        providerConfig.tries = n2;
    }

    private static /* synthetic */ Provider _jr$ig$provider(ProviderConfig providerConfig) {
        return providerConfig.provider;
    }

    private static /* synthetic */ void _jr$ip$provider(ProviderConfig providerConfig, Provider provider) {
        providerConfig.provider = provider;
    }

    private static /* synthetic */ boolean _jr$ig$isLoading(ProviderConfig providerConfig) {
        return providerConfig.isLoading;
    }

    private static /* synthetic */ void _jr$ip$isLoading(ProviderConfig providerConfig, boolean bl) {
        providerConfig.isLoading = bl;
    }
}

