/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import sun.security.jca.ProviderConfig;
import sun.security.jca.ServiceId;
import sun.security.util.Debug;

public final class ProviderList
extends h {
    static final Debug debug = Debug.getInstance("jca", "ProviderList");
    private static final ProviderConfig[] PC0 = new ProviderConfig[0];
    private static final Provider[] P0 = new Provider[0];
    static final ProviderList EMPTY = new ProviderList(PC0, true);
    private static final Provider EMPTY_PROVIDER = new Provider("##Empty##", 1.0, "initialization in progress"){

        @Override
        public Provider.Service getService(String string, String string2) {
            return null;
        }
    };
    private final ProviderConfig[] configs;
    private volatile boolean allLoaded;
    private final List<Provider> userList = new AbstractList<Provider>(this){
        final /* synthetic */ ProviderList this$0;
        {
            this.this$0 = providerList;
        }

        @Override
        public int size() {
            return a.arrayLength((Object[])(this).this$0.configs);
        }

        @Override
        public Provider get(int n2) {
            return (this).this$0.getProvider(n2);
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ProviderList providerList) {
            (object).this$0 = providerList;
        }
    };

    static ProviderList fromSecurityProperties() {
        return (ProviderList)((Object)AccessController.doPrivileged(new PrivilegedAction(){

            public ProviderList run() {
                return new ProviderList();
            }
        }));
    }

    public static ProviderList add(ProviderList providerList, Provider provider) {
        return ProviderList.insertAt(providerList, provider, -1);
    }

    public static ProviderList insertAt(ProviderList providerList, Provider provider, int n2) {
        if (providerList.getProvider(provider.getName()) != null) {
            return providerList;
        }
        ArrayList<ProviderConfig> arrayList = new ArrayList<ProviderConfig>(Arrays.asList(providerList.configs));
        int n3 = arrayList.size();
        if (n2 < 0 || n2 > n3) {
            n2 = n3;
        }
        arrayList.add(n2, new ProviderConfig(provider));
        return new ProviderList((ProviderConfig[])g.convertForCast((Object)arrayList.toArray(PC0), ProviderConfig[].class), true);
    }

    public static ProviderList remove(ProviderList providerList, String string) {
        if (providerList.getProvider(string) == null) {
            return providerList;
        }
        ProviderConfig[] providerConfigArray = new ProviderConfig[providerList.size() - 1];
        int n2 = 0;
        ProviderConfig[] providerConfigArray2 = providerList.configs;
        int n3 = a.arrayLength((Object[])providerConfigArray2);
        for (int i = 0; i < n3; ++i) {
            ProviderConfig providerConfig = (ProviderConfig)((Object)g.convertForCast((Object)a.arrayLoad((Object[])providerConfigArray2, (int)i), ProviderConfig.class));
            if (providerConfig.getProvider().getName().equals(string)) continue;
            a.arrayStore((Object[])providerConfigArray, (int)n2++, (Object)((Object)providerConfig));
        }
        return new ProviderList(providerConfigArray, true);
    }

    public static ProviderList newList(Provider ... providerArray) {
        ProviderConfig[] providerConfigArray = new ProviderConfig[a.arrayLength((Object[])providerArray)];
        for (int i = 0; i < a.arrayLength((Object[])providerArray); ++i) {
            providerConfigArray[i] = new ProviderConfig((Provider)g.convertForCast((Object)a.arrayLoad((Object[])providerArray, (int)i), Provider.class));
        }
        return new ProviderList(providerConfigArray, true);
    }

    private ProviderList(ProviderConfig[] providerConfigArray, boolean bl) {
        this.configs = providerConfigArray;
        this.allLoaded = bl;
    }

    private ProviderList() {
        String string;
        ArrayList<ProviderConfig> arrayList = new ArrayList<ProviderConfig>();
        int n2 = 1;
        while ((string = Security.getProperty("security.provider." + n2)) != null) {
            ProviderConfig providerConfig;
            if ((string = string.trim()).length() == 0) {
                System.err.println("invalid entry for security.provider." + n2);
                break;
            }
            int n3 = string.indexOf(32);
            if (n3 == -1) {
                providerConfig = new ProviderConfig(string);
            } else {
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 1).trim();
                providerConfig = new ProviderConfig(string2, string3);
            }
            if (!arrayList.contains((Object)providerConfig)) {
                arrayList.add(providerConfig);
            }
            ++n2;
        }
        this.configs = (ProviderConfig[])g.convertForCast((Object)arrayList.toArray(PC0), ProviderConfig[].class);
        if (debug != null) {
            debug.println("provider configuration: " + arrayList);
        }
    }

    ProviderList getJarList(String[] stringArray) {
        ArrayList<ProviderConfig> arrayList = new ArrayList<ProviderConfig>();
        for (String string : stringArray) {
            ProviderConfig providerConfig = new ProviderConfig(string);
            for (ProviderConfig providerConfig2 : this.configs) {
                if (!providerConfig2.equals((Object)providerConfig)) continue;
                providerConfig = providerConfig2;
                break;
            }
            arrayList.add(providerConfig);
        }
        ProviderConfig[] providerConfigArray = (ProviderConfig[])g.convertForCast((Object)arrayList.toArray(PC0), ProviderConfig[].class);
        return new ProviderList(providerConfigArray, false);
    }

    public int size() {
        return a.arrayLength((Object[])this.configs);
    }

    Provider getProvider(int n2) {
        Provider provider = ((ProviderConfig)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.configs, (int)n2), ProviderConfig.class))).getProvider();
        return provider != null ? provider : EMPTY_PROVIDER;
    }

    public List<Provider> providers() {
        return this.userList;
    }

    private ProviderConfig getProviderConfig(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.configs[n2] : null;
    }

    public Provider getProvider(String string) {
        ProviderConfig providerConfig = this.getProviderConfig(string);
        return providerConfig == null ? null : providerConfig.getProvider();
    }

    public int getIndex(String string) {
        for (int i = 0; i < a.arrayLength((Object[])this.configs); ++i) {
            Provider provider = this.getProvider(i);
            if (!provider.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int loadAll() {
        if (this.allLoaded) {
            return a.arrayLength((Object[])this.configs);
        }
        if (debug != null) {
            debug.println("Loading all providers");
            new Exception("Call trace").printStackTrace();
        }
        int n2 = 0;
        for (int i = 0; i < a.arrayLength((Object[])this.configs); ++i) {
            Provider provider = ((ProviderConfig)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.configs, (int)i), ProviderConfig.class))).getProvider();
            if (provider == null) continue;
            ++n2;
        }
        if (n2 == a.arrayLength((Object[])this.configs)) {
            this.allLoaded = true;
        }
        return n2;
    }

    ProviderList removeInvalid() {
        int n2 = this.loadAll();
        if (n2 == a.arrayLength((Object[])this.configs)) {
            return this;
        }
        ProviderConfig[] providerConfigArray = new ProviderConfig[n2];
        int n3 = 0;
        for (int i = 0; i < a.arrayLength((Object[])this.configs); ++i) {
            ProviderConfig providerConfig = (ProviderConfig)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.configs, (int)i), ProviderConfig.class));
            if (!providerConfig.isLoaded()) continue;
            a.arrayStore((Object[])providerConfigArray, (int)n3++, (Object)((Object)providerConfig));
        }
        return new ProviderList(providerConfigArray, true);
    }

    public Provider[] toArray() {
        return (Provider[])g.convertForCast((Object)this.providers().toArray(P0), Provider[].class);
    }

    public String toString() {
        return Arrays.asList(this.configs).toString();
    }

    public Provider.Service getService(String string, String string2) {
        for (int i = 0; i < this.configs.length; ++i) {
            Provider provider = this.getProvider(i);
            Provider.Service service = provider.getService(string, string2);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public List<Provider.Service> getServices(String string, String string2) {
        return new ServiceList(string, string2);
    }

    @Deprecated
    public List<Provider.Service> getServices(String string, List<String> list) {
        ArrayList<ServiceId> arrayList = new ArrayList<ServiceId>();
        for (String string2 : list) {
            arrayList.add(new ServiceId(string, string2));
        }
        return this.getServices(arrayList);
    }

    public List<Provider.Service> getServices(List<ServiceId> list) {
        return new ServiceList(list);
    }

    private static /* synthetic */ ProviderConfig[] _jr$ig$configs(ProviderList providerList) {
        return providerList.configs;
    }

    private static /* synthetic */ void _jr$ip$configs(ProviderList providerList, ProviderConfig[] providerConfigArray) {
        providerList.configs = providerConfigArray;
    }

    private static /* synthetic */ boolean _jr$ig$allLoaded(ProviderList providerList) {
        return providerList.allLoaded;
    }

    private static /* synthetic */ void _jr$ip$allLoaded(ProviderList providerList, boolean bl) {
        providerList.allLoaded = bl;
    }

    private static /* synthetic */ List _jr$ig$userList(ProviderList providerList) {
        return providerList.userList;
    }

    private static /* synthetic */ void _jr$ip$userList(ProviderList providerList, List list) {
        providerList.userList = list;
    }

    private final class ServiceList
    extends AbstractList<Provider.Service> {
        private final String type;
        private final String algorithm;
        private final List<ServiceId> ids;
        private Provider.Service firstService;
        private List<Provider.Service> services;
        private int providerIndex;

        ServiceList(String string, String string2) {
            this.type = string;
            this.algorithm = string2;
            this.ids = null;
        }

        ServiceList(List<ServiceId> list) {
            this.type = null;
            this.algorithm = null;
            this.ids = list;
        }

        private void addService(Provider.Service service) {
            if (this.firstService == null) {
                this.firstService = service;
            } else {
                if (this.services == null) {
                    this.services = new ArrayList<Provider.Service>(4);
                    this.services.add(this.firstService);
                }
                this.services.add(service);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private Provider.Service tryGet(int var1_1) {
            block0: while (true) {
                if (var1_1 == 0 && this.firstService != null) {
                    return this.firstService;
                }
                if (this.services != null && this.services.size() > var1_1) {
                    return (Provider.Service)g.convertForCast((Object)this.services.get(var1_1), Provider.Service.class);
                }
                if (this.providerIndex >= ProviderList.access$100(ProviderList.this).length) {
                    return null;
                }
                var2_2 = ProviderList.this.getProvider(this.providerIndex++);
                if (this.type != null) {
                    var3_3 /* !! */  = var2_2.getService(this.type, this.algorithm);
                    if (var3_3 /* !! */  == null) continue;
                    this.addService((Provider.Service)var3_3 /* !! */ );
                    continue;
                }
                var3_3 /* !! */  = this.ids.iterator();
                while (true) {
                    if (var3_3 /* !! */ .hasNext()) ** break;
                    continue block0;
                    var4_4 = (ServiceId)var3_3 /* !! */ .next();
                    var5_5 = var2_2.getService(var4_4.type, var4_4.algorithm);
                    if (var5_5 == null) continue;
                    this.addService(var5_5);
                }
                break;
            }
        }

        @Override
        public Provider.Service get(int n2) {
            Provider.Service service = this.tryGet(n2);
            if (service == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
            }
            return service;
        }

        @Override
        public int size() {
            int n2;
            if (this.services != null) {
                n2 = this.services.size();
            } else {
                int n3 = n2 = this.firstService != null ? 1 : 0;
            }
            while (this.tryGet(n2) != null) {
                ++n2;
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            return this.tryGet(0) == null;
        }

        @Override
        public Iterator<Provider.Service> iterator() {
            return new Iterator(this){
                int index;
                final /* synthetic */ ServiceList this$1;
                {
                    this.this$1 = serviceList;
                }

                @Override
                public boolean hasNext() {
                    return this.this$1.tryGet((this).index) != null;
                }

                public Provider.Service next() {
                    Provider.Service service = this.this$1.tryGet((this).index);
                    if (service == null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                    }
                    1 v0 = this;
                    (v0).index = (v0).index + 1;
                    return service;
                }

                @Override
                public void remove() {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
                }

                static /* synthetic */ ServiceList _jr$ig$this$1(Object object) {
                    return (object).this$1;
                }

                static /* synthetic */ void _jr$ip$this$1(Object object, ServiceList serviceList) {
                    (object).this$1 = serviceList;
                }
            };
        }

        private static /* synthetic */ String _jr$ig$type(ServiceList serviceList) {
            return serviceList.type;
        }

        private static /* synthetic */ void _jr$ip$type(ServiceList serviceList, String string) {
            serviceList.type = string;
        }

        private static /* synthetic */ String _jr$ig$algorithm(ServiceList serviceList) {
            return serviceList.algorithm;
        }

        private static /* synthetic */ void _jr$ip$algorithm(ServiceList serviceList, String string) {
            serviceList.algorithm = string;
        }

        private static /* synthetic */ List _jr$ig$ids(ServiceList serviceList) {
            return serviceList.ids;
        }

        private static /* synthetic */ void _jr$ip$ids(ServiceList serviceList, List list) {
            serviceList.ids = list;
        }

        private static /* synthetic */ Provider.Service _jr$ig$firstService(ServiceList serviceList) {
            return serviceList.firstService;
        }

        private static /* synthetic */ void _jr$ip$firstService(ServiceList serviceList, Provider.Service service) {
            serviceList.firstService = service;
        }

        private static /* synthetic */ List _jr$ig$services(ServiceList serviceList) {
            return serviceList.services;
        }

        private static /* synthetic */ void _jr$ip$services(ServiceList serviceList, List list) {
            serviceList.services = list;
        }

        private static /* synthetic */ int _jr$ig$providerIndex(ServiceList serviceList) {
            return serviceList.providerIndex;
        }

        private static /* synthetic */ void _jr$ip$providerIndex(ServiceList serviceList, int n2) {
            serviceList.providerIndex = n2;
        }

        static /* synthetic */ ProviderList _jr$ig$this$0(Object object) {
            return ((ServiceList)object).ProviderList.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ProviderList providerList) {
            ((ServiceList)object).ProviderList.this = providerList;
        }
    }
}

