/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.Provider;
import sun.security.jca.ProviderList;

public class Providers
extends h {
    private static final ThreadLocal<ProviderList> threadLists = new InheritableThreadLocal<ProviderList>();
    private static volatile int threadListsUsed;
    private static volatile ProviderList providerList;
    private static final String BACKUP_PROVIDER_CLASSNAME = "sun.security.provider.VerificationProvider";
    private static final String[] jarVerificationProviders;

    private Providers() {
    }

    public static Provider getSunProvider() {
        try {
            Class<?> clazz = Class.forName(jarVerificationProviders[0]);
            return (Provider)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), Provider.class);
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName(BACKUP_PROVIDER_CLASSNAME);
                return (Provider)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), Provider.class);
            }
            catch (Exception exception2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("Sun provider not found", exception));
            }
        }
    }

    public static Object startJarVerification() {
        ProviderList providerList = Providers.getProviderList();
        ProviderList providerList2 = providerList.getJarList(jarVerificationProviders);
        return Providers.beginThreadProviderList(providerList2);
    }

    public static void stopJarVerification(Object object) {
        Providers.endThreadProviderList((ProviderList)((Object)g.convertForCast((Object)object, ProviderList.class)));
    }

    public static ProviderList getProviderList() {
        ProviderList providerList = Providers.getThreadProviderList();
        if (providerList == null) {
            providerList = Providers.getSystemProviderList();
        }
        return providerList;
    }

    public static void setProviderList(ProviderList providerList) {
        if (Providers.getThreadProviderList() == null) {
            Providers.setSystemProviderList(providerList);
        } else {
            Providers.changeThreadProviderList(providerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderList getFullProviderList() {
        Object object;
        Object object2 = ah.getMonitor(Providers.class);
        synchronized (object2) {
            try {
                object = Providers.getThreadProviderList();
                if (object != null) {
                    ProviderList providerList = object.removeInvalid();
                    if (f.ifAcmp((Object)((Object)providerList), (Object)object)) {
                        Providers.changeThreadProviderList(providerList);
                        object = providerList;
                    }
                    return object;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        object = Providers.getSystemProviderList();
        object2 = object.removeInvalid();
        if (f.ifAcmp((Object)object2, (Object)object)) {
            Providers.setSystemProviderList((ProviderList)((Object)object2));
            object = object2;
        }
        return object;
    }

    private static ProviderList getSystemProviderList() {
        return providerList;
    }

    private static void setSystemProviderList(ProviderList providerList) {
        Providers.providerList = providerList;
    }

    public static ProviderList getThreadProviderList() {
        if (threadListsUsed == 0) {
            return null;
        }
        return (ProviderList)((Object)g.convertForCast(threadLists.get(), ProviderList.class));
    }

    private static void changeThreadProviderList(ProviderList providerList) {
        threadLists.set(providerList);
    }

    public static synchronized ProviderList beginThreadProviderList(ProviderList providerList) {
        if (ProviderList.debug != null) {
            ProviderList.debug.println("ThreadLocal providers: " + (Object)((Object)providerList));
        }
        ProviderList providerList2 = (ProviderList)((Object)g.convertForCast(threadLists.get(), ProviderList.class));
        ++threadListsUsed;
        threadLists.set(providerList);
        return providerList2;
    }

    public static synchronized void endThreadProviderList(ProviderList providerList) {
        if (providerList == null) {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Disabling ThreadLocal providers");
            }
            threadLists.remove();
        } else {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Restoring previous ThreadLocal providers: " + (Object)((Object)providerList));
            }
            threadLists.set(providerList);
        }
        --threadListsUsed;
    }

    static {
        providerList = ProviderList.EMPTY;
        providerList = ProviderList.fromSecurityProperties();
        jarVerificationProviders = new String[]{"sun.security.provider.Sun", "sun.security.rsa.SunRsaSign", "sun.security.ec.SunEC", BACKUP_PROVIDER_CLASSNAME};
    }

    protected /* synthetic */ Providers(h h2) {
        super(h2);
    }
}

