/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PrincipalName
extends h
implements Cloneable {
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final String TGS_DEFAULT_SRV_NAME = "krbtgt";
    public static final int TGS_DEFAULT_NT = 2;
    public static final char NAME_COMPONENT_SEPARATOR = '/';
    public static final char NAME_REALM_SEPARATOR = '@';
    public static final char REALM_COMPONENT_SEPARATOR = '.';
    public static final String NAME_COMPONENT_SEPARATOR_STR = "/";
    public static final String NAME_REALM_SEPARATOR_STR = "@";
    public static final String REALM_COMPONENT_SEPARATOR_STR = ".";
    private int nameType;
    private String[] nameStrings;
    private Realm nameRealm;
    private String salt;

    protected PrincipalName() {
        this.salt = null;
    }

    public PrincipalName(String[] stringArray, int n) throws IllegalArgumentException, IOException {
        this.salt = null;
        if (stringArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null input not allowed"));
        }
        this.nameStrings = new String[a.arrayLength((Object[])stringArray)];
        a.arraycopy((Object)stringArray, (int)0, (Object)this.nameStrings, (int)0, (int)a.arrayLength((Object[])stringArray));
        this.nameType = n;
        this.nameRealm = null;
    }

    public PrincipalName(String[] stringArray) throws IOException {
        this(stringArray, 0);
    }

    public Object clone() {
        try {
            PrincipalName principalName = (PrincipalName)g.convertForCast((Object)super.clone(), PrincipalName.class);
            if (this.nameStrings != null) {
                principalName.nameStrings = (String[])a.cloneArray((Object)this.nameStrings);
            }
            if (this.nameRealm != null) {
                principalName.nameRealm = (Realm)g.convertForCast((Object)this.nameRealm.clone(), Realm.class);
            }
            return principalName;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"Should never happen"));
        }
    }

    public boolean equals(Object object) {
        if (g.convertForInstanceOf((Object)object, PrincipalName.class) instanceof PrincipalName) {
            return this.equals((PrincipalName)g.convertForCast((Object)object, PrincipalName.class));
        }
        return false;
    }

    public boolean equals(PrincipalName principalName) {
        if (!this.equalsWithoutRealm(principalName)) {
            return false;
        }
        if (this.nameRealm != null && principalName.nameRealm == null || this.nameRealm == null && principalName.nameRealm != null) {
            return false;
        }
        return this.nameRealm == null || principalName.nameRealm == null || this.nameRealm.equals(principalName.nameRealm);
    }

    boolean equalsWithoutRealm(PrincipalName principalName) {
        if (this.nameStrings != null && principalName.nameStrings == null || this.nameStrings == null && principalName.nameStrings != null) {
            return false;
        }
        if (this.nameStrings != null && principalName.nameStrings != null) {
            if (a.arrayLength((Object[])this.nameStrings) != a.arrayLength((Object[])principalName.nameStrings)) {
                return false;
            }
            for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
                if (((String)a.arrayLoad((Object[])this.nameStrings, (int)i)).equals((String)a.arrayLoad((Object[])principalName.nameStrings, (int)i))) continue;
                return false;
            }
        }
        return true;
    }

    public PrincipalName(DerValue derValue) throws Asn1Exception, IOException {
        this.salt = null;
        this.nameRealm = null;
        if (derValue == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null input not allowed"));
        }
        if (derValue.getTag() != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Asn1Exception(906));
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Asn1Exception(906));
        }
        h h2 = derValue2.getData().getBigInteger();
        this.nameType = h2.intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 1) {
            h2 = derValue2.getData().getDerValue();
            if (h2.getTag() != 48) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Asn1Exception(906));
            }
            Vector<String> vector = new Vector<String>();
            while (h2.getData().available() > 0) {
                DerValue derValue3 = h2.getData().getDerValue();
                vector.addElement(new KerberosString(derValue3).toString());
            }
            if (vector.size() > 0) {
                this.nameStrings = new String[vector.size()];
                vector.copyInto(this.nameStrings);
            } else {
                Object[] objectArray = new String[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)"");
                this.nameStrings = objectArray;
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Asn1Exception(906));
        }
    }

    public static PrincipalName parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Asn1Exception(906));
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new PrincipalName(derValue2);
    }

    protected static String[] parseName(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        String string3 = string;
        int n = 0;
        int n2 = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) == '/') {
                if (n > 0 && string3.charAt(n - 1) == '\\') {
                    string3 = string3.substring(0, n - 1) + string3.substring(n, string3.length());
                    continue;
                }
                if (n2 < n) {
                    string2 = string3.substring(n2, n);
                    vector.addElement(string2);
                }
                n2 = n + 1;
            } else if (string3.charAt(n) == '@') {
                if (n > 0 && string3.charAt(n - 1) == '\\') {
                    string3 = string3.substring(0, n - 1) + string3.substring(n, string3.length());
                    continue;
                }
                if (n2 < n) {
                    string2 = string3.substring(n2, n);
                    vector.addElement(string2);
                }
                n2 = n + 1;
                break;
            }
            ++n;
        }
        if (n == string3.length() && n2 < n) {
            string2 = string3.substring(n2, n);
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PrincipalName(String string, int n) throws RealmException {
        Object object;
        this.salt = null;
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Null name not allowed"));
        }
        Object[] objectArray = PrincipalName.parseName(string);
        Realm realm = null;
        String string2 = Realm.parseRealmAtSeparator(string);
        if (string2 == null) {
            try {
                object = Config.getInstance();
                string2 = ((Config)object).getDefaultRealm();
            }
            catch (KrbException krbException) {
                RealmException realmException = new RealmException(krbException.getMessage());
                realmException.initCause(krbException);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)realmException);
            }
        }
        if (string2 != null) {
            realm = new Realm(string2);
        }
        switch (n) {
            case 3: {
                if (a.arrayLength((Object[])objectArray) >= 2) {
                    object = (String)a.arrayLoad((Object[])objectArray, (int)1);
                    try {
                        String string3 = InetAddress.getByName((String)object).getCanonicalHostName();
                        if (string3.toLowerCase().startsWith(((String)object).toLowerCase() + REALM_COMPONENT_SEPARATOR_STR)) {
                            object = string3;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    a.arrayStore((Object[])objectArray, (int)1, (Object)((String)object).toLowerCase());
                }
                this.nameStrings = objectArray;
                this.nameType = n;
                object = PrincipalName.mapHostToRealm((String)a.arrayLoad((Object[])objectArray, (int)1));
                if (object != null) {
                    this.nameRealm = new Realm((String)object);
                    break;
                }
                this.nameRealm = realm;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.nameStrings = objectArray;
                this.nameType = n;
                this.nameRealm = realm;
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal name type"));
            }
        }
    }

    public PrincipalName(String string) throws RealmException {
        this(string, 0);
    }

    public PrincipalName(String string, String string2) throws RealmException {
        this(string, 0);
        this.nameRealm = new Realm(string2);
    }

    public String getRealmAsString() {
        return this.getRealmString();
    }

    public String getPrincipalNameAsString() {
        StringBuffer stringBuffer = new StringBuffer((String)a.arrayLoad((Object[])this.nameStrings, (int)0));
        for (int i = 1; i < a.arrayLength((Object[])this.nameStrings); ++i) {
            stringBuffer.append((String)a.arrayLoad((Object[])this.nameStrings, (int)i));
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.toString();
    }

    public int getNameType() {
        return this.nameType;
    }

    public String[] getNameStrings() {
        return (String[])a.cloneArray((Object)this.nameStrings);
    }

    public byte[][] toByteArray() {
        byte[][] byArrayArray = new byte[a.arrayLength((Object[])this.nameStrings)][];
        for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
            byArrayArray[i] = new byte[((String)a.arrayLoad((Object[])this.nameStrings, (int)i)).length()];
            byArrayArray[i] = ((String)a.arrayLoad((Object[])this.nameStrings, (int)i)).getBytes();
        }
        return byArrayArray;
    }

    public String getRealmString() {
        if (this.nameRealm != null) {
            return this.nameRealm.toString();
        }
        return null;
    }

    public Realm getRealm() {
        return this.nameRealm;
    }

    public void setRealm(Realm realm) throws RealmException {
        this.nameRealm = realm;
    }

    public void setRealm(String string) throws RealmException {
        this.nameRealm = new Realm(string);
    }

    public String getSalt() {
        if (this.salt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.nameRealm != null) {
                stringBuffer.append(this.nameRealm.toString());
            }
            for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
                stringBuffer.append((String)a.arrayLoad((Object[])this.nameStrings, (int)i));
            }
            return stringBuffer.toString();
        }
        return this.salt;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
            if (i > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append((String)a.arrayLoad((Object[])this.nameStrings, (int)i));
        }
        if (this.nameRealm != null) {
            stringBuffer.append(NAME_REALM_SEPARATOR_STR);
            stringBuffer.append(this.nameRealm.toString());
        }
        return stringBuffer.toString();
    }

    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
            if (i > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append((String)a.arrayLoad((Object[])this.nameStrings, (int)i));
        }
        return stringBuffer.toString();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        BigInteger bigInteger = BigInteger.valueOf(this.nameType);
        derOutputStream2.putInteger(bigInteger);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[a.arrayLength((Object[])this.nameStrings)];
        for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
            derValueArray[i] = new KerberosString((String)a.arrayLoad((Object[])this.nameStrings, (int)i)).toDerValue();
        }
        derOutputStream2.putSequence(derValueArray);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public boolean match(PrincipalName principalName) {
        boolean bl = true;
        if (this.nameRealm != null && principalName.nameRealm != null && !this.nameRealm.toString().equalsIgnoreCase(principalName.nameRealm.toString())) {
            bl = false;
        }
        if (a.arrayLength((Object[])this.nameStrings) != a.arrayLength((Object[])principalName.nameStrings)) {
            bl = false;
        } else {
            for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
                if (((String)a.arrayLoad((Object[])this.nameStrings, (int)i)).equalsIgnoreCase((String)a.arrayLoad((Object[])principalName.nameStrings, (int)i))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void writePrincipal(CCacheOutputStream cCacheOutputStream) throws IOException {
        byte[] byArray;
        cCacheOutputStream.write32(this.nameType);
        cCacheOutputStream.write32(a.arrayLength((Object[])this.nameStrings));
        if (this.nameRealm != null) {
            byArray = null;
            byArray = this.nameRealm.toString().getBytes();
            cCacheOutputStream.write32(byArray.length);
            cCacheOutputStream.write(byArray, 0, byArray.length);
        }
        byArray = null;
        for (int i = 0; i < a.arrayLength((Object[])this.nameStrings); ++i) {
            byArray = ((String)a.arrayLoad((Object[])this.nameStrings, (int)i)).getBytes();
            cCacheOutputStream.write32(byArray.length);
            cCacheOutputStream.write(byArray, 0, byArray.length);
        }
    }

    protected PrincipalName(String string, String string2, String string3, int n) throws KrbException {
        this.salt = null;
        if (n != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KrbException(60, "Bad name type"));
        }
        Object[] objectArray = new String[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string);
        a.arrayStore((Object[])objectArray, (int)1, (Object)string2);
        this.nameStrings = objectArray;
        this.nameRealm = new Realm(string3);
        this.nameType = n;
    }

    public String getInstanceComponent() {
        if (this.nameStrings != null && a.arrayLength((Object[])this.nameStrings) >= 2) {
            return new String((String)a.arrayLoad((Object[])this.nameStrings, (int)1));
        }
        return null;
    }

    static String mapHostToRealm(String string) {
        String string2 = null;
        try {
            String string3 = null;
            Config config = Config.getInstance();
            string2 = config.getDefault(string, "domain_realm");
            if (string2 != null) {
                return string2;
            }
            for (int i = 1; i < string.length() && (string.charAt(i) != '.' || i == string.length() - 1 || (string2 = config.getDefault(string3 = string.substring(i), "domain_realm")) == null && (string2 = config.getDefault(string3 = string.substring(i + 1), "domain_realm")) == null); ++i) {
            }
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return string2;
    }

    private static /* synthetic */ void _jr$ip$nameType(PrincipalName principalName, int n) {
        principalName.nameType = n;
    }

    private static /* synthetic */ void _jr$ip$salt(PrincipalName principalName, String string) {
        principalName.salt = string;
    }

    protected /* synthetic */ PrincipalName(h h2) {
        super(h2);
    }
}

