/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKCS7
extends h {
    private ObjectIdentifier contentType;
    private BigInteger version;
    private AlgorithmId[] digestAlgorithmIds;
    private ContentInfo contentInfo;
    private X509Certificate[] certificates;
    private X509CRL[] crls;
    private SignerInfo[] signerInfos;
    private boolean oldStyle;
    private Principal[] certIssuerNames;

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        this.version = null;
        this.digestAlgorithmIds = null;
        this.contentInfo = null;
        this.certificates = null;
        this.crls = null;
        this.signerInfos = null;
        this.oldStyle = false;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(new DerInputStream(byArray));
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.version = null;
        this.digestAlgorithmIds = null;
        this.contentInfo = null;
        this.certificates = null;
        this.crls = null;
        this.signerInfos = null;
        this.oldStyle = false;
        this.parse(derInputStream);
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        this.version = null;
        this.digestAlgorithmIds = null;
        this.contentInfo = null;
        this.certificates = null;
        this.crls = null;
        this.signerInfos = null;
        this.oldStyle = false;
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            this.parse(derInputStream);
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Unable to parse the encoded bytes");
            parsingException.initCause(iOException);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException);
        }
    }

    private void parse(DerInputStream derInputStream) throws ParsingException {
        try {
            derInputStream.mark(derInputStream.available());
            this.parse(derInputStream, false);
        }
        catch (IOException iOException) {
            try {
                derInputStream.reset();
                this.parse(derInputStream, true);
                this.oldStyle = true;
            }
            catch (IOException iOException2) {
                ParsingException parsingException = new ParsingException(iOException2.getMessage());
                parsingException.initCause(iOException);
                parsingException.addSuppressed(iOException2);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException);
            }
        }
    }

    private void parse(DerInputStream derInputStream, boolean bl) throws IOException {
        this.contentInfo = new ContentInfo(derInputStream, bl);
        this.contentType = ContentInfo._jr$ig$contentType((Object)this.contentInfo);
        DerValue derValue = this.contentInfo.getContent();
        if (this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(derValue);
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException("content type " + this.contentType + " not supported."));
        }
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, SignerInfo[] signerInfoArray) {
        this.version = null;
        this.digestAlgorithmIds = null;
        this.contentInfo = null;
        this.certificates = null;
        this.crls = null;
        this.signerInfos = null;
        this.oldStyle = false;
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertificateArray;
        this.crls = x509CRLArray;
        this.signerInfos = signerInfoArray;
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, SignerInfo[] signerInfoArray) {
        this(algorithmIdArray, contentInfo, x509CertificateArray, null, signerInfoArray);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNetscapeCertChain(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        this.certificates = new X509Certificate[derValueArray.length];
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        int n = 0;
        while (true) {
            block12: {
                if (n >= derValueArray.length) {
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    if (certificateFactory == null) {
                        a.arrayStore((Object[])this.certificates, (int)n, (Object)new X509CertImpl(derValueArray[n]));
                    } else {
                        byte[] byArray = derValueArray[n].toByteArray();
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        a.arrayStore((Object[])this.certificates, (int)n, (Object)((X509Certificate)g.convertForCast((Object)certificateFactory.generateCertificate(byteArrayInputStream), X509Certificate.class)));
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    if (byteArrayInputStream == null) break block12;
                }
                catch (CertificateException certificateException) {
                    try {
                        ParsingException parsingException = new ParsingException(certificateException.getMessage());
                        parsingException.initCause(certificateException);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException);
                        catch (IOException iOException) {
                            ParsingException parsingException2 = new ParsingException(iOException.getMessage());
                            parsingException2.initCause(iOException);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                byteArrayInputStream.close();
            }
            ++n;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        int n;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n2 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                derValueArray = derValueArray2[i];
                ((PKCS7)this).digestAlgorithmIds[i] = AlgorithmId.parse((DerValue)derValueArray);
            }
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Error parsing digest AlgorithmId IDs: " + iOException.getMessage());
            parsingException.initCause(iOException);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException);
        }
        this.contentInfo = new ContentInfo(derInputStream);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if ((byte)derInputStream.peekByte() == -96) {
            derValueArray = derInputStream.getSet(2, true);
            n2 = derValueArray.length;
            this.certificates = new X509Certificate[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                Object object2;
                object = null;
                try {
                    byte by = derValueArray[i].getTag();
                    if (by == 48) {
                        if (certificateFactory == null) {
                            a.arrayStore((Object[])this.certificates, (int)n, (Object)new X509CertImpl(derValueArray[i]));
                        } else {
                            object2 = derValueArray[i].toByteArray();
                            object = new ByteArrayInputStream((byte[])object2);
                            a.arrayStore((Object[])this.certificates, (int)n, (Object)((X509Certificate)g.convertForCast((Object)certificateFactory.generateCertificate((InputStream)object), X509Certificate.class)));
                            ((ByteArrayInputStream)object).close();
                            object = null;
                        }
                        ++n;
                    }
                    if (object == null) continue;
                }
                catch (CertificateException certificateException) {
                    try {
                        object2 = new ParsingException(certificateException.getMessage());
                        ((Throwable)object2).initCause(certificateException);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)object2);
                        catch (IOException iOException) {
                            object2 = new ParsingException(iOException.getMessage());
                            ((Throwable)object2).initCause(iOException);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)object2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            ((ByteArrayInputStream)object).close();
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                ((ByteArrayInputStream)object).close();
            }
            if (n != n2) {
                this.certificates = (X509Certificate[])g.convertForCast((Object)Arrays.copyOf(this.certificates, n), X509Certificate[].class);
            }
        }
        if ((byte)derInputStream.peekByte() == -95) {
            derValueArray = derInputStream.getSet(1, true);
            n2 = derValueArray.length;
            this.crls = new X509CRL[n2];
            for (n = 0; n < n2; ++n) {
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    if (certificateFactory == null) {
                        a.arrayStore((Object[])this.crls, (int)n, (Object)new X509CRLImpl(derValueArray[n]));
                    } else {
                        object = derValueArray[n].toByteArray();
                        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        a.arrayStore((Object[])this.crls, (int)n, (Object)((X509CRL)g.convertForCast((Object)certificateFactory.generateCRL(byteArrayInputStream), X509CRL.class)));
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    if (byteArrayInputStream == null) continue;
                }
                catch (CRLException cRLException) {
                    try {
                        ParsingException parsingException = new ParsingException(cRLException.getMessage());
                        parsingException.initCause(cRLException);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException);
                    }
                    catch (Throwable throwable) {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                byteArrayInputStream.close();
            }
        }
        derValueArray = derInputStream.getSet(1);
        n2 = derValueArray.length;
        this.signerInfos = new SignerInfo[n2];
        n = 0;
        while (n < n2) {
            DerInputStream derInputStream2 = derValueArray[n].toDerInputStream();
            ((PKCS7)this).signerInfos[n] = new SignerInfo(derInputStream2);
            ++n;
        }
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseOldSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n];
        try {
            for (int i = 0; i < n; ++i) {
                derValueArray = derValueArray2[i];
                ((PKCS7)this).digestAlgorithmIds[i] = AlgorithmId.parse((DerValue)derValueArray);
            }
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException("Error parsing digest AlgorithmId IDs"));
        }
        this.contentInfo = new ContentInfo(derInputStream, true);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        derValueArray = derInputStream.getSet(2);
        n = derValueArray.length;
        this.certificates = new X509Certificate[n];
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                if (certificateFactory == null) {
                    a.arrayStore((Object[])this.certificates, (int)i, (Object)new X509CertImpl(derValueArray[i]));
                } else {
                    object = derValueArray[i].toByteArray();
                    byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    a.arrayStore((Object[])this.certificates, (int)i, (Object)((X509Certificate)g.convertForCast((Object)certificateFactory.generateCertificate(byteArrayInputStream), X509Certificate.class)));
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
                if (byteArrayInputStream == null) continue;
            }
            catch (CertificateException certificateException) {
                try {
                    ParsingException parsingException = new ParsingException(certificateException.getMessage());
                    parsingException.initCause(certificateException);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException);
                    catch (IOException iOException) {
                        ParsingException parsingException2 = new ParsingException(iOException.getMessage());
                        parsingException2.initCause(iOException);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)parsingException2);
                    }
                }
                catch (Throwable throwable) {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            byteArrayInputStream.close();
        }
        derInputStream.getSet(0);
        DerValue[] derValueArray3 = derInputStream.getSet(1);
        n = derValueArray3.length;
        this.signerInfos = new SignerInfo[n];
        int n2 = 0;
        while (n2 < n) {
            object = (Object)derValueArray3[n2].toDerInputStream();
            ((PKCS7)this).signerInfos[n2] = new SignerInfo((DerInputStream)((Object)object), true);
            ++n2;
        }
        return;
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        derOutputStream2.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(derOutputStream2);
        if (this.certificates != null && a.arrayLength((Object[])this.certificates) != 0) {
            derEncoderArray = new X509CertImpl[a.arrayLength((Object[])this.certificates)];
            for (int i = 0; i < a.arrayLength((Object[])this.certificates); ++i) {
                if (g.convertForInstanceOf((Object)((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certificates, (int)i), X509Certificate.class)), X509CertImpl.class) instanceof X509CertImpl) {
                    derEncoderArray[i] = (X509CertImpl)g.convertForCast((Object)((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certificates, (int)i), X509Certificate.class)), X509CertImpl.class);
                    continue;
                }
                try {
                    byte[] byArray = ((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certificates, (int)i), X509Certificate.class)).getEncoded();
                    derEncoderArray[i] = new X509CertImpl(byArray);
                    continue;
                }
                catch (CertificateException certificateException) {
                    IOException iOException = new IOException(certificateException.getMessage());
                    iOException.initCause(certificateException);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                }
            }
            derOutputStream2.putOrderedSetOf((byte)-96, derEncoderArray);
        }
        if (this.crls != null && a.arrayLength((Object[])this.crls) != 0) {
            derEncoderArray = new HashSet(a.arrayLength((Object[])this.crls));
            Object[] objectArray = this.crls;
            int n = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n; ++i) {
                X509CRL x509CRL = (X509CRL)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509CRL.class);
                if (g.convertForInstanceOf((Object)x509CRL, X509CRLImpl.class) instanceof X509CRLImpl) {
                    derEncoderArray.add((X509CRLImpl)g.convertForCast((Object)x509CRL, X509CRLImpl.class));
                    continue;
                }
                try {
                    byte[] byArray = x509CRL.getEncoded();
                    derEncoderArray.add(new X509CRLImpl(byArray));
                    continue;
                }
                catch (CRLException cRLException) {
                    IOException iOException = new IOException(cRLException.getMessage());
                    iOException.initCause(cRLException);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                }
            }
            derOutputStream2.putOrderedSetOf((byte)-95, (DerEncoder[])g.convertForCast((Object)derEncoderArray.toArray(new X509CRLImpl[derEncoderArray.size()]), DerEncoder[].class));
        }
        derOutputStream2.putOrderedSetOf((byte)49, this.signerInfos);
        derEncoderArray = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(ContentInfo.SIGNED_DATA_OID, (DerValue)derEncoderArray);
        contentInfo.encode(derOutputStream);
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        for (int i = 0; i < this.signerInfos.length; ++i) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i], byArray);
            if (signerInfo == null) continue;
            vector.addElement(signerInfo);
        }
        if (vector.size() != 0) {
            Object[] objectArray = new SignerInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])g.convertForCast((Object)a.cloneArray((Object)this.certificates), X509Certificate[].class);
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])g.convertForCast((Object)a.cloneArray((Object)this.crls), X509CRL[].class);
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger bigInteger, X500Name x500Name) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            for (int i = 0; i < a.arrayLength((Object[])this.certificates); ++i) {
                X509Certificate x509Certificate = (X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certificates, (int)i), X509Certificate.class);
                BigInteger bigInteger2 = x509Certificate.getSerialNumber();
                if (!bigInteger.equals(bigInteger2) || !x500Name.equals((Principal)g.convertForCast((Object)a.arrayLoad((Object[])this.certIssuerNames, (int)i), Principal.class))) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[a.arrayLength((Object[])this.certificates)];
        for (int i = 0; i < a.arrayLength((Object[])this.certificates); ++i) {
            X509Certificate x509Certificate = (X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certificates, (int)i), X509Certificate.class);
            Principal principal = x509Certificate.getIssuerDN();
            if (!(g.convertForInstanceOf((Object)principal, X500Name.class) instanceof X500Name)) {
                try {
                    X509CertInfo x509CertInfo = new X509CertInfo(x509Certificate.getTBSCertificate());
                    principal = (Principal)g.convertForCast((Object)x509CertInfo.get("issuer.dname"), Principal.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            a.arrayStore((Object[])this.certIssuerNames, (int)i, (Object)principal);
        }
    }

    public String toString() {
        int n;
        String string = "";
        string = string + (Object)((Object)this.contentInfo) + "\n";
        if (this.version != null) {
            string = string + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            string = string + "PKCS7 :: digest AlgorithmIds: \n";
            for (n = 0; n < this.digestAlgorithmIds.length; ++n) {
                string = string + "\t" + this.digestAlgorithmIds[n] + "\n";
            }
        }
        if (this.certificates != null) {
            string = string + "PKCS7 :: certificates: \n";
            for (n = 0; n < a.arrayLength((Object[])this.certificates); ++n) {
                string = string + "\t" + n + ".   " + (X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certificates, (int)n), X509Certificate.class) + "\n";
            }
        }
        if (this.crls != null) {
            string = string + "PKCS7 :: crls: \n";
            for (n = 0; n < a.arrayLength((Object[])this.crls); ++n) {
                string = string + "\t" + n + ".   " + (X509CRL)g.convertForCast((Object)a.arrayLoad((Object[])this.crls, (int)n), X509CRL.class) + "\n";
            }
        }
        if (this.signerInfos != null) {
            string = string + "PKCS7 :: signer infos: \n";
            for (n = 0; n < this.signerInfos.length; ++n) {
                string = string + "\t" + n + ".  " + this.signerInfos[n] + "\n";
            }
        }
        return string;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    protected /* synthetic */ PKCS7(h h2) {
        super(h2);
    }
}

