/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class PKCS8Key
extends h
implements PrivateKey {
    private static final long serialVersionUID = -3836890099307167124L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;
    public static final BigInteger version = BigInteger.ZERO;

    public PKCS8Key() {
    }

    private PKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
    }

    public static PKCS8Key parse(DerValue derValue) throws IOException {
        PrivateKey privateKey = PKCS8Key.parseKey(derValue);
        if (g.convertForInstanceOf((Object)privateKey, PKCS8Key.class) instanceof PKCS8Key) {
            return (PKCS8Key)g.convertForCast((Object)privateKey, PKCS8Key.class);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Provider did not return PKCS8Key"));
    }

    public static PrivateKey parseKey(DerValue derValue) throws IOException {
        PrivateKey privateKey;
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("corrupt private key"));
        }
        BigInteger bigInteger = DerValue._jr$ig$data((Object)derValue).getBigInteger();
        if (!version.equals(bigInteger)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("version mismatch: (supported: " + Debug.toHexString(version) + ", parsed: " + Debug.toHexString(bigInteger)));
        }
        AlgorithmId algorithmId = AlgorithmId.parse(DerValue._jr$ig$data((Object)derValue).getDerValue());
        try {
            privateKey = PKCS8Key.buildPKCS8Key(algorithmId, DerValue._jr$ig$data((Object)derValue).getOctetString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("corrupt private key"));
        }
        if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("excess private key"));
        }
        return privateKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PrivateKey buildPKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        DerOutputStream derOutputStream = new DerOutputStream();
        PKCS8Key.encode(derOutputStream, algorithmId, byArray);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        String string = "";
        try {
            h h2;
            Class<?> clazz;
            block13: {
                Provider provider = Security.getProvider("SUN");
                if (provider == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InstantiationException());
                }
                string = provider.getProperty("PrivateKey.PKCS#8." + algorithmId.getName());
                if (string == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InstantiationException());
                }
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    h2 = ClassLoader.getSystemClassLoader();
                    if (h2 == null) break block13;
                    clazz = h2.loadClass(string);
                }
            }
            Object var9_11 = null;
            if (clazz != null) {
                var9_11 = ai.getCurrentClass(clazz).newInstance();
            }
            if (g.convertForInstanceOf(var9_11, PKCS8Key.class) instanceof PKCS8Key) {
                h2 = (PKCS8Key)g.convertForCast(var9_11, PKCS8Key.class);
                ((PKCS8Key)h2).algid = algorithmId;
                ((PKCS8Key)h2).key = byArray;
                h2.parseKeyBits();
                return h2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(string + " [internal error]"));
        }
        PKCS8Key pKCS8Key = new PKCS8Key();
        ((PKCS8Key)pKCS8Key).algid = algorithmId;
        ((PKCS8Key)pKCS8Key).key = byArray;
        return pKCS8Key;
    }

    @Override
    public String getAlgorithm() {
        return ((PKCS8Key)this).algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return ((PKCS8Key)this).algid;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        PKCS8Key.encode(derOutputStream, ((PKCS8Key)this).algid, ((PKCS8Key)this).key);
    }

    @Override
    @af(modifiers=33)
    public byte[] getEncoded() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                byte[] byArray = null;
                try {
                    byArray = this.encode();
                }
                catch (InvalidKeyException invalidKeyException) {
                    // empty catch block
                }
                return byArray;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (((PKCS8Key)this).encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                ((PKCS8Key)this).encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("IOException : " + iOException.getMessage()));
            }
        }
        return (byte[])((PKCS8Key)this).encodedKey.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (DerValue._jr$ig$tag((Object)derValue) != 48) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("invalid key format"));
            }
            BigInteger bigInteger = DerValue._jr$ig$data((Object)derValue).getBigInteger();
            if (!bigInteger.equals(version)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("version mismatch: (supported: " + Debug.toHexString(version) + ", parsed: " + Debug.toHexString(bigInteger)));
            }
            ((PKCS8Key)this).algid = AlgorithmId.parse(DerValue._jr$ig$data((Object)derValue).getDerValue());
            ((PKCS8Key)this).key = DerValue._jr$ig$data((Object)derValue).getOctetString();
            this.parseKeyBits();
            if (DerValue._jr$ig$data((Object)derValue).available() == 0) return;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("IOException : " + iOException.getMessage()));
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("deserialized key is invalid: " + invalidKeyException.getMessage()));
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(version);
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putOctetString(byArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (g.convertForInstanceOf((Object)object, Key.class) instanceof Key) {
            byte[] byArray;
            byte[] byArray2 = ((PKCS8Key)this).encodedKey != null ? ((PKCS8Key)this).encodedKey : this.getEncoded();
            if (byArray2.length != (byArray = ((Key)g.convertForCast((Object)object, Key.class)).getEncoded()).length) {
                return false;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i = 1; i < byArray.length; ++i) {
            n2 += byArray[i] * i;
        }
        return n2;
    }

    protected /* synthetic */ PKCS8Key(h h2) {
        super(h2);
    }
}

