/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.X500Name;

public class SignerInfo
extends h
implements DerEncoder {
    BigInteger version;
    X500Name issuerName;
    BigInteger certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;
    PKCS9Attributes authenticatedAttributes;
    PKCS9Attributes unauthenticatedAttributes;

    public SignerInfo(X500Name x500Name, BigInteger bigInteger, AlgorithmId algorithmId, AlgorithmId algorithmId2, byte[] byArray) {
        this.version = BigInteger.ONE;
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInteger;
        this.digestAlgorithmId = algorithmId;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
    }

    public SignerInfo(X500Name x500Name, BigInteger bigInteger, AlgorithmId algorithmId, PKCS9Attributes pKCS9Attributes, AlgorithmId algorithmId2, byte[] byArray, PKCS9Attributes pKCS9Attributes2) {
        this.version = BigInteger.ONE;
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInteger;
        this.digestAlgorithmId = algorithmId;
        this.authenticatedAttributes = pKCS9Attributes;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
        this.unauthenticatedAttributes = pKCS9Attributes2;
    }

    public SignerInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public SignerInfo(DerInputStream derInputStream, boolean bl) throws IOException, ParsingException {
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray = derInputStream.getSequence(2);
        byte[] byArray = derValueArray[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, byArray));
        this.certificateSerialNumber = derValueArray[1].getBigInteger();
        DerValue derValue = derInputStream.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(derValue);
        if (bl) {
            derInputStream.getSet(0);
        } else if ((byte)derInputStream.peekByte() == -96) {
            this.authenticatedAttributes = new PKCS9Attributes(derInputStream);
        }
        derValue = derInputStream.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(derValue);
        this.encryptedDigest = derInputStream.getOctetString();
        if (bl) {
            derInputStream.getSet(0);
        } else if (derInputStream.available() != 0 && (byte)derInputStream.peekByte() == -95) {
            this.unauthenticatedAttributes = new PKCS9Attributes(derInputStream, true);
        }
        if (derInputStream.available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException("extra data at the end"));
        }
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(((SignerInfo)this).version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        ((SignerInfo)this).issuerName.encode(derOutputStream2);
        derOutputStream2.putInteger(((SignerInfo)this).certificateSerialNumber);
        derOutputStream.write((byte)48, derOutputStream2);
        ((SignerInfo)this).digestAlgorithmId.encode(derOutputStream);
        if (((SignerInfo)this).authenticatedAttributes != null) {
            ((SignerInfo)this).authenticatedAttributes.encode((byte)-96, derOutputStream);
        }
        ((SignerInfo)this).digestEncryptionAlgorithmId.encode(derOutputStream);
        derOutputStream.putOctetString(((SignerInfo)this).encryptedDigest);
        if (((SignerInfo)this).unauthenticatedAttributes != null) {
            ((SignerInfo)this).unauthenticatedAttributes.encode((byte)-95, derOutputStream);
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public X509Certificate getCertificate(PKCS7 pKCS7) throws IOException {
        return pKCS7.getCertificate(((SignerInfo)this).certificateSerialNumber, ((SignerInfo)this).issuerName);
    }

    public ArrayList<X509Certificate> getCertificateChain(PKCS7 pKCS7) throws IOException {
        boolean bl;
        X509Certificate x509Certificate = pKCS7.getCertificate(((SignerInfo)this).certificateSerialNumber, ((SignerInfo)this).issuerName);
        if (x509Certificate == null) {
            return null;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        Object[] objectArray = pKCS7.getCertificates();
        if (objectArray == null || x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            return arrayList;
        }
        Principal principal = x509Certificate.getIssuerDN();
        int n2 = 0;
        block0: do {
            bl = false;
            for (int i = n2; i < a.arrayLength((Object[])objectArray); ++i) {
                if (!principal.equals(((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509Certificate.class)).getSubjectDN())) continue;
                arrayList.add((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509Certificate.class));
                if (((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509Certificate.class)).getSubjectDN().equals(((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509Certificate.class)).getIssuerDN())) {
                    n2 = a.arrayLength((Object[])objectArray);
                } else {
                    principal = ((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509Certificate.class)).getIssuerDN();
                    X509Certificate x509Certificate2 = (X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), X509Certificate.class);
                    a.arrayStore((Object[])objectArray, (int)n2, (Object)((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), X509Certificate.class)));
                    a.arrayStore((Object[])objectArray, (int)i, (Object)x509Certificate2);
                    ++n2;
                }
                bl = true;
                continue block0;
            }
        } while (bl);
        return arrayList;
    }

    private static String convertToStandardName(String string) {
        if (string.equals("SHA")) {
            return "SHA-1";
        }
        if (string.equals("SHA224")) {
            return "SHA-224";
        }
        if (string.equals("SHA256")) {
            return "SHA-256";
        }
        if (string.equals("SHA384")) {
            return "SHA-384";
        }
        if (string.equals("SHA512")) {
            return "SHA-512";
        }
        return string;
    }

    SignerInfo verify(PKCS7 pKCS7, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            byte[] byArray2;
            ContentInfo contentInfo = pKCS7.getContentInfo();
            if (byArray == null) {
                byArray = contentInfo.getContentBytes();
            }
            String string = this.getDigestAlgorithmId().getName();
            if (((SignerInfo)this).authenticatedAttributes == null) {
                byArray2 = byArray;
            } else {
                object5 = (ObjectIdentifier)g.convertForCast((Object)((SignerInfo)this).authenticatedAttributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID), ObjectIdentifier.class);
                if (object5 == null || !((ObjectIdentifier)object5).equals(ContentInfo._jr$ig$contentType((Object)contentInfo))) {
                    return null;
                }
                object4 = (byte[])((SignerInfo)this).authenticatedAttributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
                if (object4 == null) {
                    return null;
                }
                object3 = MessageDigest.getInstance(SignerInfo.convertToStandardName(string));
                object2 = ((MessageDigest)((Object)object3)).digest(byArray);
                if (((Object)object4).length != ((Signature)object2).length) {
                    return null;
                }
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    if (object4[i] == object2[i]) continue;
                    return null;
                }
                byArray2 = ((SignerInfo)this).authenticatedAttributes.getDerEncoding();
            }
            object5 = this.getDigestEncryptionAlgorithmId().getName();
            object4 = AlgorithmId.getEncAlgFromSigAlg((String)object5);
            if (object4 != null) {
                object5 = object4;
            }
            object3 = AlgorithmId.makeSigAlg(string, (String)object5);
            object2 = Signature.getInstance(object3);
            X509Certificate x509Certificate = this.getCertificate(pKCS7);
            if (x509Certificate == null) {
                return null;
            }
            if (x509Certificate.hasUnsupportedCriticalExtension()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Certificate has unsupported critical extension(s)"));
            }
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (blArray != null) {
                try {
                    object = new KeyUsageExtension(blArray);
                }
                catch (IOException iOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Failed to parse keyUsage extension"));
                }
                boolean bl = (Boolean)g.convertForCast((Object)((KeyUsageExtension)object).get("digital_signature"), Boolean.class);
                boolean bl2 = (Boolean)g.convertForCast((Object)((KeyUsageExtension)object).get("non_repudiation"), Boolean.class);
                if (!bl && !bl2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Key usage restricted: cannot be used for digital signatures"));
                }
            }
            object = x509Certificate.getPublicKey();
            ((Signature)((Object)object2)).initVerify((PublicKey)object);
            ((Signature)((Object)object2)).update(byArray2);
            if (((Signature)((Object)object2)).verify(((SignerInfo)this).encryptedDigest)) {
                return this;
            }
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("IO error verifying signature:\n" + iOException.getMessage()));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("InvalidKey: " + invalidKeyException.getMessage()));
        }
        return null;
    }

    SignerInfo verify(PKCS7 pKCS7) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(pKCS7, null);
    }

    public BigInteger getVersion() {
        return ((SignerInfo)this).version;
    }

    public X500Name getIssuerName() {
        return ((SignerInfo)this).issuerName;
    }

    public BigInteger getCertificateSerialNumber() {
        return ((SignerInfo)this).certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return ((SignerInfo)this).digestAlgorithmId;
    }

    public PKCS9Attributes getAuthenticatedAttributes() {
        return ((SignerInfo)this).authenticatedAttributes;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return ((SignerInfo)this).digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return ((SignerInfo)this).encryptedDigest;
    }

    public PKCS9Attributes getUnauthenticatedAttributes() {
        return ((SignerInfo)this).unauthenticatedAttributes;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = string + "Signer Info for (issuer): " + ((SignerInfo)this).issuerName + "\n";
        string = string + "\tversion: " + Debug.toHexString(((SignerInfo)this).version) + "\n";
        string = string + "\tcertificateSerialNumber: " + Debug.toHexString(((SignerInfo)this).certificateSerialNumber) + "\n";
        string = string + "\tdigestAlgorithmId: " + ((SignerInfo)this).digestAlgorithmId + "\n";
        if (((SignerInfo)this).authenticatedAttributes != null) {
            string = string + "\tauthenticatedAttributes: " + ((SignerInfo)this).authenticatedAttributes + "\n";
        }
        string = string + "\tdigestEncryptionAlgorithmId: " + ((SignerInfo)this).digestEncryptionAlgorithmId + "\n";
        string = string + "\tencryptedDigest: \n" + hexDumpEncoder.encodeBuffer(((SignerInfo)this).encryptedDigest) + "\n";
        if (((SignerInfo)this).unauthenticatedAttributes != null) {
            string = string + "\tunauthenticatedAttributes: " + ((SignerInfo)this).unauthenticatedAttributes + "\n";
        }
        return string;
    }

    static /* synthetic */ void _jr$ip$version(Object object, BigInteger bigInteger) {
        ((SignerInfo)object).version = bigInteger;
    }

    static /* synthetic */ void _jr$ip$issuerName(Object object, X500Name x500Name) {
        ((SignerInfo)object).issuerName = x500Name;
    }

    static /* synthetic */ void _jr$ip$certificateSerialNumber(Object object, BigInteger bigInteger) {
        ((SignerInfo)object).certificateSerialNumber = bigInteger;
    }

    static /* synthetic */ void _jr$ip$digestAlgorithmId(Object object, AlgorithmId algorithmId) {
        ((SignerInfo)object).digestAlgorithmId = algorithmId;
    }

    static /* synthetic */ void _jr$ip$digestEncryptionAlgorithmId(Object object, AlgorithmId algorithmId) {
        ((SignerInfo)object).digestEncryptionAlgorithmId = algorithmId;
    }

    static /* synthetic */ void _jr$ip$encryptedDigest(Object object, byte[] byArray) {
        ((SignerInfo)object).encryptedDigest = byArray;
    }

    static /* synthetic */ void _jr$ip$authenticatedAttributes(Object object, PKCS9Attributes pKCS9Attributes) {
        ((SignerInfo)object).authenticatedAttributes = pKCS9Attributes;
    }

    static /* synthetic */ void _jr$ip$unauthenticatedAttributes(Object object, PKCS9Attributes pKCS9Attributes) {
        ((SignerInfo)object).unauthenticatedAttributes = pKCS9Attributes;
    }

    protected /* synthetic */ SignerInfo(h h2) {
        super(h2);
    }
}

