/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;

public class DSAKeyFactory
extends KeyFactorySpi {
    static final boolean SERIAL_INTEROP;
    private static final String SERIAL_PROP = "sun.security.key.serial.interop";

    public DSAKeyFactory() {
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (g.convertForInstanceOf((Object)keySpec, DSAPublicKeySpec.class) instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)g.convertForCast((Object)keySpec, DSAPublicKeySpec.class);
                if (SERIAL_INTEROP) {
                    return new DSAPublicKey(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
                }
                return new DSAPublicKeyImpl(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
            }
            if (g.convertForInstanceOf((Object)keySpec, X509EncodedKeySpec.class) instanceof X509EncodedKeySpec) {
                if (SERIAL_INTEROP) {
                    return new DSAPublicKey(((X509EncodedKeySpec)g.convertForCast((Object)keySpec, X509EncodedKeySpec.class)).getEncoded());
                }
                return new DSAPublicKeyImpl(((X509EncodedKeySpec)g.convertForCast((Object)keySpec, X509EncodedKeySpec.class)).getEncoded());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key specification"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage()));
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (g.convertForInstanceOf((Object)keySpec, DSAPrivateKeySpec.class) instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)g.convertForCast((Object)keySpec, DSAPrivateKeySpec.class);
                return new DSAPrivateKey(dSAPrivateKeySpec.getX(), dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
            }
            if (g.convertForInstanceOf((Object)keySpec, PKCS8EncodedKeySpec.class) instanceof PKCS8EncodedKeySpec) {
                return new DSAPrivateKey(((PKCS8EncodedKeySpec)g.convertForCast((Object)keySpec, PKCS8EncodedKeySpec.class)).getEncoded());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key specification"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage()));
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            if (g.convertForInstanceOf((Object)key, java.security.interfaces.DSAPublicKey.class) instanceof java.security.interfaces.DSAPublicKey) {
                Class<?> clazz2 = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (x.isAssignableFrom(clazz2, clazz)) {
                    java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)g.convertForCast((Object)key, java.security.interfaces.DSAPublicKey.class);
                    DSAParams dSAParams = dSAPublicKey.getParams();
                    return (T)new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (x.isAssignableFrom(clazz3, clazz)) {
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key specification"));
            }
            if (g.convertForInstanceOf((Object)key, java.security.interfaces.DSAPrivateKey.class) instanceof java.security.interfaces.DSAPrivateKey) {
                Class<?> clazz4 = Class.forName("java.security.spec.DSAPrivateKeySpec");
                Class<?> clazz5 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (x.isAssignableFrom(clazz4, clazz)) {
                    java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)g.convertForCast((Object)key, java.security.interfaces.DSAPrivateKey.class);
                    DSAParams dSAParams = dSAPrivateKey.getParams();
                    return (T)new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (x.isAssignableFrom(clazz5, clazz)) {
                    return (T)new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key specification"));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Inappropriate key type"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage()));
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (g.convertForInstanceOf((Object)key, java.security.interfaces.DSAPublicKey.class) instanceof java.security.interfaces.DSAPublicKey) {
                if (g.convertForInstanceOf((Object)key, DSAPublicKey.class) instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)g.convertForCast((Object)this.engineGetKeySpec(key, DSAPublicKeySpec.class), DSAPublicKeySpec.class);
                return this.engineGeneratePublic(dSAPublicKeySpec);
            }
            if (g.convertForInstanceOf((Object)key, java.security.interfaces.DSAPrivateKey.class) instanceof java.security.interfaces.DSAPrivateKey) {
                if (g.convertForInstanceOf((Object)key, DSAPrivateKey.class) instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)g.convertForCast((Object)this.engineGetKeySpec(key, DSAPrivateKeySpec.class), DSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(dSAPrivateKeySpec);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Wrong algorithm type"));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage()));
        }
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction(SERIAL_PROP, null));
        SERIAL_INTEROP = "true".equalsIgnoreCase(string);
    }

    protected /* synthetic */ DSAKeyFactory(h h2) {
        super(h2);
    }
}

