/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;
import sun.security.x509.X509Key;

public class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    private static final long serialVersionUID = -2994193307391104133L;
    private BigInteger y;

    public DSAPublicKey() {
    }

    public DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.y = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("could not DER encode y: " + iOException.getMessage()));
        }
    }

    public DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    @Override
    public DSAParams getParams() {
        try {
            if (g.convertForInstanceOf((Object)DSAPublicKey._jr$ig$algid(this), DSAParams.class) instanceof DSAParams) {
                return (DSAParams)g.convertForCast((Object)DSAPublicKey._jr$ig$algid(this), DSAParams.class);
            }
            AlgorithmParameters algorithmParameters = DSAPublicKey._jr$ig$algid(this).getParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)g.convertForCast((Object)algorithmParameters.getParameterSpec(DSAParameterSpec.class), DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public String toString() {
        return "Sun DSA Public Key\n    Parameters:" + DSAPublicKey._jr$ig$algid(this) + "\n  y:\n" + Debug.toHexString(this.y) + "\n";
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(DSAPublicKey._jr$ig$key(this));
            this.y = derInputStream.getBigInteger();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid key: y value\n" + iOException.getMessage()));
        }
    }

    protected /* synthetic */ DSAPublicKey(h h2) {
        super(h2);
    }
}

