/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;

abstract class DigestBase
extends MessageDigestSpi
implements Cloneable {
    private byte[] oneByte;
    private final String algorithm;
    private final int digestLength;
    private final int blockSize;
    final byte[] buffer;
    private int bufOfs;
    long bytesProcessed;
    static final byte[] padding = new byte[136];

    DigestBase(String string, int n2, int n3) {
        this.algorithm = string;
        this.digestLength = n2;
        this.blockSize = n3;
        this.buffer = new byte[n3];
    }

    DigestBase(DigestBase digestBase) {
        this.algorithm = digestBase.algorithm;
        this.digestLength = digestBase.digestLength;
        this.blockSize = digestBase.blockSize;
        this.buffer = (byte[])digestBase.buffer.clone();
        this.bufOfs = digestBase.bufOfs;
        this.bytesProcessed = digestBase.bytesProcessed;
    }

    @Override
    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    @Override
    protected final void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        ((DigestBase)this).oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException());
        }
        if (((DigestBase)this).bytesProcessed < 0L) {
            this.engineReset();
        }
        DigestBase digestBase = this;
        ((DigestBase)digestBase).bytesProcessed = ((DigestBase)digestBase).bytesProcessed + (long)n3;
        if (this.bufOfs != 0) {
            int n4 = Math.min(n3, this.blockSize - this.bufOfs);
            a.arraycopy((Object)byArray, (int)n2, (Object)((DigestBase)this).buffer, (int)this.bufOfs, (int)n4);
            DigestBase digestBase2 = this;
            digestBase2.bufOfs = digestBase2.bufOfs + n4;
            n2 += n4;
            n3 -= n4;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(((DigestBase)this).buffer, 0);
                this.bufOfs = 0;
            }
        }
        while (n3 >= this.blockSize) {
            this.implCompress(byArray, n2);
            n3 -= this.blockSize;
            n2 += this.blockSize;
        }
        if (n3 > 0) {
            a.arraycopy((Object)byArray, (int)n2, (Object)((DigestBase)this).buffer, (int)0, (int)n3);
            this.bufOfs = n3;
        }
    }

    @Override
    protected final void engineReset() {
        if (((DigestBase)this).bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        ((DigestBase)this).bytesProcessed = 0L;
    }

    @Override
    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((ProviderException)g.convertForCast((Object)new ProviderException("Internal error").initCause(digestException), ProviderException.class)));
        }
        return byArray;
    }

    @Override
    protected final int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < this.digestLength) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests"));
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DigestException("Buffer too short to store digest"));
        }
        if (((DigestBase)this).bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(byArray, n2);
        ((DigestBase)this).bytesProcessed = -1L;
        return this.digestLength;
    }

    abstract void implCompress(byte[] var1, int var2);

    abstract void implDigest(byte[] var1, int var2);

    abstract void implReset();

    @Override
    public abstract Object clone();

    static {
        DigestBase.padding[0] = -128;
    }

    private static /* synthetic */ void _jr$ip$algorithm(DigestBase digestBase, String string) {
        digestBase.algorithm = string;
    }

    private static /* synthetic */ void _jr$ip$digestLength(DigestBase digestBase, int n2) {
        digestBase.digestLength = n2;
    }

    private static /* synthetic */ void _jr$ip$blockSize(DigestBase digestBase, int n2) {
        digestBase.blockSize = n2;
    }

    static /* synthetic */ void _jr$ip$buffer(Object object, byte[] byArray) {
        ((DigestBase)object).buffer = byArray;
    }

    protected /* synthetic */ DigestBase(h h2) {
        super(h2);
    }
}

