/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.misc.IOUtils;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.provider.KeyProtector;

abstract class JavaKeyStore
extends KeyStoreSpi {
    private static final int MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private final Hashtable<String, Object> entries;

    JavaKeyStore() {
        this.entries = new Hashtable();
    }

    abstract String convertAlias(String var1);

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object v = this.entries.get(this.convertAlias(string));
        if (v == null || !(g.convertForInstanceOf(v, KeyEntry.class) instanceof KeyEntry)) {
            return null;
        }
        if (cArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnrecoverableKeyException("Password must not be null"));
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        byte[] byArray = ((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).protectedPrivKey;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo"));
        }
        return keyProtector.recover(encryptedPrivateKeyInfo);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.entries.get(this.convertAlias(string));
        if (v != null && g.convertForInstanceOf(v, KeyEntry.class) instanceof KeyEntry) {
            if (((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain == null) {
                return null;
            }
            return (Certificate[])g.convertForCast((Object)a.cloneArray((Object)((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain), Certificate[].class);
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        Object v = this.entries.get(this.convertAlias(string));
        if (v != null) {
            if (g.convertForInstanceOf(v, TrustedCertEntry.class) instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)((Object)((Object)((TrustedCertEntry)((Object)g.convertForCast(v, TrustedCertEntry.class)))))).cert;
            }
            if (((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain == null) {
                return null;
            }
            return (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain, (int)0), Certificate.class);
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        Object v = this.entries.get(this.convertAlias(string));
        if (v != null) {
            if (g.convertForInstanceOf(v, TrustedCertEntry.class) instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)((Object)((Object)((TrustedCertEntry)((Object)g.convertForCast(v, TrustedCertEntry.class)))))).date.getTime());
            }
            return new Date(((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyProtector keyProtector = null;
        if (!(g.convertForInstanceOf((Object)key, PrivateKey.class) instanceof PrivateKey)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Cannot store non-PrivateKeys"));
        }
        try {
            Object object = ah.getMonitor((Object)this.entries);
            synchronized (object) {
                try {
                    KeyEntry keyEntry = new KeyEntry();
                    ((KeyEntry)((Object)((Object)keyEntry))).date = new Date();
                    keyProtector = new KeyProtector(cArray);
                    ((KeyEntry)((Object)((Object)keyEntry))).protectedPrivKey = keyProtector.protect(key);
                    if (certificateArray != null && a.arrayLength((Object[])certificateArray) != 0) {
                        ((KeyEntry)((Object)((Object)keyEntry))).chain = (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
                    } else {
                        ((KeyEntry)((Object)((Object)keyEntry))).chain = null;
                    }
                    this.entries.put(this.convertAlias(string), keyEntry);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            keyProtector = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Key protection algorithm not found"));
            }
            catch (Throwable throwable) {
                keyProtector = null;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Object object = ah.getMonitor((Object)this.entries);
        synchronized (object) {
            try {
                try {
                    new EncryptedPrivateKeyInfo(byArray);
                }
                catch (IOException iOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo"));
                }
                KeyEntry keyEntry = new KeyEntry();
                ((KeyEntry)((Object)((Object)keyEntry))).date = new Date();
                ((KeyEntry)((Object)((Object)keyEntry))).protectedPrivKey = (byte[])byArray.clone();
                if (certificateArray != null && a.arrayLength((Object[])certificateArray) != 0) {
                    ((KeyEntry)((Object)((Object)keyEntry))).chain = (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
                } else {
                    ((KeyEntry)((Object)((Object)keyEntry))).chain = null;
                }
                this.entries.put(this.convertAlias(string), keyEntry);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Object object = ah.getMonitor((Object)this.entries);
        synchronized (object) {
            try {
                Object v = this.entries.get(this.convertAlias(string));
                if (v != null && g.convertForInstanceOf(v, KeyEntry.class) instanceof KeyEntry) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("Cannot overwrite own certificate"));
                }
                TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
                ((TrustedCertEntry)((Object)((Object)trustedCertEntry))).cert = certificate;
                ((TrustedCertEntry)((Object)((Object)trustedCertEntry))).date = new Date();
                this.entries.put(this.convertAlias(string), trustedCertEntry);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Object object = ah.getMonitor((Object)this.entries);
        synchronized (object) {
            try {
                this.entries.remove(this.convertAlias(string));
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(this.convertAlias(string));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        Object v = this.entries.get(this.convertAlias(string));
        return v != null && g.convertForInstanceOf(v, KeyEntry.class) instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        Object v = this.entries.get(this.convertAlias(string));
        return v != null && g.convertForInstanceOf(v, TrustedCertEntry.class) instanceof TrustedCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (g.convertForInstanceOf(v, TrustedCertEntry.class) instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)((Object)((Object)((TrustedCertEntry)((Object)g.convertForCast(v, TrustedCertEntry.class)))))).cert;
            } else {
                if (((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain == null) continue;
                certificate2 = (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain, (int)0), Certificate.class);
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object = ah.getMonitor((Object)this.entries);
        synchronized (object) {
            try {
                if (cArray == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("password can't be null"));
                }
                MessageDigest messageDigest = this.getPreKeyedHash(cArray);
                DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
                dataOutputStream.writeInt(-17957139);
                dataOutputStream.writeInt(2);
                dataOutputStream.writeInt(this.entries.size());
                Object object2 = this.entries.keys();
                while (object2.hasMoreElements()) {
                    byte[] byArray;
                    String string = (String)object2.nextElement();
                    Object v = this.entries.get(string);
                    if (g.convertForInstanceOf(v, KeyEntry.class) instanceof KeyEntry) {
                        dataOutputStream.writeInt(1);
                        dataOutputStream.writeUTF(string);
                        dataOutputStream.writeLong(((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).date.getTime());
                        dataOutputStream.writeInt(((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).protectedPrivKey.length);
                        dataOutputStream.write(((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).protectedPrivKey);
                        int n2 = ((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain == null ? 0 : a.arrayLength((Object[])((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain);
                        dataOutputStream.writeInt(n2);
                        for (int i = 0; i < n2; ++i) {
                            byArray = ((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain, (int)i), Certificate.class)).getEncoded();
                            dataOutputStream.writeUTF(((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])((KeyEntry)((Object)((Object)((KeyEntry)((Object)g.convertForCast(v, KeyEntry.class)))))).chain, (int)i), Certificate.class)).getType());
                            dataOutputStream.writeInt(byArray.length);
                            dataOutputStream.write(byArray);
                        }
                        continue;
                    }
                    dataOutputStream.writeInt(2);
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeLong(((TrustedCertEntry)((Object)((Object)((TrustedCertEntry)((Object)g.convertForCast(v, TrustedCertEntry.class)))))).date.getTime());
                    byArray = ((TrustedCertEntry)((Object)((Object)((TrustedCertEntry)((Object)g.convertForCast(v, TrustedCertEntry.class)))))).cert.getEncoded();
                    dataOutputStream.writeUTF(((TrustedCertEntry)((Object)((Object)((TrustedCertEntry)((Object)g.convertForCast(v, TrustedCertEntry.class)))))).cert.getType());
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                }
                object2 = messageDigest.digest();
                dataOutputStream.write((byte[])object2);
                dataOutputStream.flush();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object = ah.getMonitor((Object)this.entries);
        synchronized (object) {
            try {
                h h2;
                DataInputStream dataInputStream;
                MessageDigest messageDigest = null;
                CertificateFactory certificateFactory = null;
                Hashtable<String, CertificateFactory> hashtable = null;
                ByteArrayInputStream byteArrayInputStream = null;
                byte[] byArray = null;
                if (inputStream == null) {
                    return;
                }
                if (cArray != null) {
                    messageDigest = this.getPreKeyedHash(cArray);
                    dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
                } else {
                    dataInputStream = new DataInputStream(inputStream);
                }
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                if (n2 != -17957139 || n3 != 1 && n3 != 2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid keystore format"));
                }
                if (n3 == 1) {
                    certificateFactory = CertificateFactory.getInstance("X509");
                } else {
                    hashtable = new Hashtable<String, CertificateFactory>(3);
                }
                this.entries.clear();
                int n4 = dataInputStream.readInt();
                for (int i = 0; i < n4; ++i) {
                    String string;
                    int n5 = dataInputStream.readInt();
                    if (n5 == 1) {
                        h2 = new KeyEntry();
                        string = dataInputStream.readUTF();
                        ((KeyEntry)((Object)h2)).date = new Date(dataInputStream.readLong());
                        ((KeyEntry)((Object)h2)).protectedPrivKey = IOUtils.readFully(dataInputStream, dataInputStream.readInt(), true);
                        int n6 = dataInputStream.readInt();
                        if (n6 > 0) {
                            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n6 > 10 ? 10 : n6);
                            for (int k = 0; k < n6; ++k) {
                                if (n3 == 2) {
                                    String string2 = dataInputStream.readUTF();
                                    if (hashtable.containsKey(string2)) {
                                        certificateFactory = (CertificateFactory)((Object)g.convertForCast(hashtable.get(string2), CertificateFactory.class));
                                    } else {
                                        certificateFactory = CertificateFactory.getInstance(string2);
                                        hashtable.put(string2, certificateFactory);
                                    }
                                }
                                byArray = IOUtils.readFully(dataInputStream, dataInputStream.readInt(), true);
                                byteArrayInputStream = new ByteArrayInputStream(byArray);
                                arrayList.add(certificateFactory.generateCertificate(byteArrayInputStream));
                                byteArrayInputStream.close();
                            }
                            ((KeyEntry)((Object)h2)).chain = (Certificate[])g.convertForCast((Object)arrayList.toArray(new Certificate[n6]), Certificate[].class);
                        }
                        this.entries.put(string, h2);
                        continue;
                    }
                    if (n5 == 2) {
                        h2 = new TrustedCertEntry();
                        string = dataInputStream.readUTF();
                        ((TrustedCertEntry)((Object)h2)).date = new Date(dataInputStream.readLong());
                        if (n3 == 2) {
                            String string3 = dataInputStream.readUTF();
                            if (hashtable.containsKey(string3)) {
                                certificateFactory = (CertificateFactory)((Object)g.convertForCast(hashtable.get(string3), CertificateFactory.class));
                            } else {
                                certificateFactory = CertificateFactory.getInstance(string3);
                                hashtable.put(string3, certificateFactory);
                            }
                        }
                        byArray = IOUtils.readFully(dataInputStream, dataInputStream.readInt(), true);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ((TrustedCertEntry)((Object)h2)).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                        byteArrayInputStream.close();
                        this.entries.put(string, h2);
                        continue;
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unrecognized keystore entry"));
                }
                if (cArray != null) {
                    byte[] byArray2 = messageDigest.digest();
                    byte[] byArray3 = new byte[byArray2.length];
                    dataInputStream.readFully(byArray3);
                    for (int i = 0; i < byArray2.length; ++i) {
                        if (byArray2[i] == byArray3[i]) continue;
                        h2 = new UnrecoverableKeyException("Password verification failed");
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new IOException("Keystore was tampered with, or password was incorrect").initCause((Throwable)h2), IOException.class)));
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int n2;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n3 = 0;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            byArray[n3++] = (byte)(cArray[n2] >> 8);
            byArray[n3++] = (byte)cArray[n2];
        }
        messageDigest.update(byArray);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray[n2] = 0;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    private static /* synthetic */ void _jr$ip$entries(JavaKeyStore javaKeyStore, Hashtable hashtable) {
        javaKeyStore.entries = hashtable;
    }

    protected /* synthetic */ JavaKeyStore(h h2) {
        super(h2);
    }

    public static final class CaseExactJKS
    extends JavaKeyStore {
        @Override
        String convertAlias(String string) {
            return string;
        }
    }

    public static final class JKS
    extends JavaKeyStore {
        @Override
        String convertAlias(String string) {
            return string.toLowerCase();
        }
    }

    private static class KeyEntry
    extends h {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;

        private KeyEntry() {
        }

        protected /* synthetic */ KeyEntry(h h2) {
            super(h2);
        }
    }

    private static class TrustedCertEntry
    extends h {
        Date date;
        Certificate cert;

        private TrustedCertEntry() {
        }

        protected /* synthetic */ TrustedCertEntry(h h2) {
            super(h2);
        }
    }
}

